/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.Intellibox;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.swing.SwingUtilities;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetMessageException;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBLnPacketizer
extends LnPacketizer {
    private static final Logger log = LoggerFactory.getLogger(IBLnPacketizer.class);

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Only used during system initialization")
    public IBLnPacketizer() {
        super(new LocoNetSystemConnectionMemo());
        this.echo = true;
    }

    @Override
    public void startThreads() {
        int xmtpriority;
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available = 10 default = 5 min available = 1", (Object)priority);
        int n = xmtpriority = 9 > priority ? 9 : 10;
        if (this.xmtHandler == null) {
            this.xmtHandler = new XmtHandler();
        }
        this.xmtThread = new Thread(this.xmtHandler, "LocoNet Intellibox transmit handler");
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        this.xmtThread.setDaemon(true);
        this.xmtThread.setPriority(9);
        this.xmtThread.start();
        if (this.rcvHandler == null) {
            this.rcvHandler = new RcvHandler(this);
        }
        this.rcvThread = new Thread(this.rcvHandler, "LocoNet Intellibox receive handler");
        this.rcvThread.setDaemon(true);
        this.rcvThread.setPriority(10);
        this.rcvThread.start();
    }

    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        log.debug("check for input");
                        byte[] msg = (byte[])IBLnPacketizer.this.xmtList.take();
                        try {
                            if (IBLnPacketizer.this.ostream != null) {
                                if (!IBLnPacketizer.this.controller.okToSend()) {
                                    log.debug("LocoNet port not ready to receive");
                                }
                                log.debug("start write to stream");
                                for (int i = 0; i < msg.length; ++i) {
                                    while (!IBLnPacketizer.this.controller.okToSend()) {
                                        Thread.yield();
                                    }
                                    IBLnPacketizer.this.ostream.write(msg[i]);
                                    IBLnPacketizer.this.ostream.flush();
                                }
                                log.debug("end write to stream");
                                IBLnPacketizer.this.messageTransmitted(msg);
                                continue block4;
                            }
                            log.warn("sendLocoNetMessage: no connection established");
                            continue block4;
                        }
                        catch (IOException e) {
                            log.warn("sendLocoNetMessage: IOException: {}", (Object)e.toString());
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    class RcvHandler
    implements Runnable {
        LnPacketizer trafficController;

        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="single threaded during init; will eventually be replaced for multi-connection support")
        public RcvHandler(LnPacketizer lt) {
            this.trafficController = lt;
        }

        private byte readNextByteFromUSB() {
            while (true) {
                try {
                    byte inbyte = IBLnPacketizer.this.istream.readByte();
                    return inbyte;
                }
                catch (IOException e) {
                    continue;
                }
                break;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int opCode;
                        if (((opCode = this.readNextByteFromUSB() & 0xFF) & 0x80) == 0) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Skipping: {}", (Object)Integer.toHexString(opCode));
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Start message with opcode: {}", (Object)Integer.toHexString(opCode));
                        }
                        LocoNetMessage msg = null;
                        while (msg == null) {
                            try {
                                int byte2 = this.readNextByteFromUSB() & 0xFF;
                                if ((byte2 & 0x80) != 0) {
                                    log.warn("LocoNet message with opCode: {} ended early. Byte2 is also an opcode: {}", (Object)Integer.toHexString(opCode), (Object)Integer.toHexString(byte2));
                                    opCode = byte2;
                                    throw new LocoNetMessageException();
                                }
                                switch ((opCode & 0x60) >> 5) {
                                    case 0: {
                                        msg = new LocoNetMessage(2);
                                        break;
                                    }
                                    case 1: {
                                        msg = new LocoNetMessage(4);
                                        break;
                                    }
                                    case 2: {
                                        msg = new LocoNetMessage(6);
                                        break;
                                    }
                                    case 3: {
                                        if (byte2 < 2) {
                                            log.error("LocoNet message length invalid: {} opcode: {}", (Object)byte2, (Object)Integer.toHexString(opCode));
                                        }
                                        msg = new LocoNetMessage(byte2);
                                        break;
                                    }
                                    default: {
                                        throw new LocoNetMessageException("decode failure " + byte2);
                                    }
                                }
                                msg.setOpCode(opCode);
                                msg.setElement(1, byte2);
                                int len = msg.getNumDataElements();
                                for (int i = 2; i < len; ++i) {
                                    int b = this.readNextByteFromUSB() & 0xFF;
                                    if ((b & 0x80) != 0) {
                                        log.warn("LocoNet message with opCode: {} ended early. Expected length: {} seen length: {} unexpected byte: {}", new Object[]{Integer.toHexString(opCode), len, i, Integer.toHexString(b)});
                                        opCode = b;
                                        throw new LocoNetMessageException();
                                    }
                                    msg.setElement(i, b);
                                }
                            }
                            catch (LocoNetMessageException e) {
                                msg = null;
                            }
                        }
                        if (!msg.checkParity()) {
                            log.warn("Ignore LocoNet packet with bad checksum: {}", (Object)msg.toString());
                            throw new LocoNetMessageException();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("queue message for notification");
                        }
                        final LocoNetMessage thisMsg = msg;
                        final LnPacketizer thisTc = this.trafficController;
                        Runnable r = new Runnable(){
                            LocoNetMessage msgForLater;
                            LnPacketizer myTc;
                            {
                                this.msgForLater = thisMsg;
                                this.myTc = thisTc;
                            }

                            @Override
                            public void run() {
                                this.myTc.notify(this.msgForLater);
                            }
                        };
                        SwingUtilities.invokeLater(r);
                    }
                }
                catch (LocoNetMessageException e) {
                    log.warn("run: unexpected LocoNetMessageException", (Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    log.warn("run: unexpected Exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

