/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import javax.annotation.Nonnull;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.alm.LnSimple7thGenDeviceRoutes;
import jmri.jmrix.loconet.alm.LnSimple7thGenDevicesRoutes;
import jmri.jmrix.loconet.alm.LnSimple7thGenRoute;
import jmri.jmrix.loconet.alm.LnSimpleRouteEntry;
import jmri.jmrix.loconet.alm.RouteSwitchPositionEnum;
import jmri.jmrix.loconet.configurexml.Digitrax7thGenAccyRoutesXML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ln7gAccyRoutesManager
implements LocoNetListener {
    private static final String DEVICE_DS74 = "DS74";
    private static final String DEVICE_DS78V = "DS78V";
    private static final String DEVICE_PM74 = "PM74";
    private static final String DEVICE_SE74 = "SE74";
    private LocoNetSystemConnectionMemo memo;
    private final LnSimple7thGenDevicesRoutes devicesRoutes = new LnSimple7thGenDevicesRoutes();
    private int activeDeviceType;
    private int activeDeviceSerNum;
    private int activeDeviceBaseAddr;
    private int activeEntrySet;
    private int activeRouteNum;
    private static final Logger log = LoggerFactory.getLogger(Ln7gAccyRoutesManager.class);

    public void initComponents(LocoNetSystemConnectionMemo c) {
        this.memo = c;
        this.memo.getLnTrafficController().addLocoNetListener(-1, this);
        this.deselectAlmRoutesDevice();
    }

    public Ln7gAccyRoutesManager initContext(Object context) {
        if (context instanceof LocoNetSystemConnectionMemo) {
            this.initComponents((LocoNetSystemConnectionMemo)context);
        }
        return this;
    }

    private void deselectAlmRoutesDevice() {
        this.activeDeviceType = 0;
        this.activeDeviceSerNum = 0;
        this.activeDeviceBaseAddr = 0;
        this.activeEntrySet = -1;
        this.activeRouteNum = -1;
    }

    private void selectAlmRoutesDevice(int deviceType, int serNum, int baseAddr) {
        this.activeDeviceType = deviceType;
        this.activeDeviceSerNum = serNum;
        this.activeDeviceBaseAddr = baseAddr;
        this.activeEntrySet = -1;
        this.activeRouteNum = -1;
    }

    public void initializeDeviceRoutes() {
        this.loadTheXML();
    }

    public String showStoredDevicesWithRoutes() {
        if (this.getCountOfDevicesWithRoutes() < 1) {
            return "No Digitrax 7th-gen Accessory devices with stored/storable routes.";
        }
        StringBuilder s = new StringBuilder("Known Digitrax 7th-gen Accessory devices with stored/storable routes:\n");
        for (int i = 0; i < this.getCountOfDevicesWithRoutes(); ++i) {
            LnSimple7thGenDeviceRoutes d = this.devicesRoutes.getDeviceRoutes(i);
            s.append("\tDevice ");
            s.append(d.getDeviceType());
            s.append(", ser. num. ");
            s.append(d.getSerNum());
            s.append(", base addr. ");
            s.append(d.getBaseAddr());
            for (int j = 0; j < d.getRoutes().length; ++j) {
                LnSimple7thGenRoute route = d.getRoutes(j);
                s.append("\n\tRoute ");
                s.append(j);
                s.append(": ");
                for (int l = 0; l < 8; ++l) {
                    s.append(", ");
                    s.append(route.getRouteEntry(l).getNumber());
                    s.append((Object)route.getRouteEntry(l).getPosition());
                }
            }
            s.append(".\n");
        }
        return s.toString();
    }

    @Nonnull
    public LocoNetSystemConnectionMemo getMemo() {
        return this.memo;
    }

    private void checkMessage4Byte(LocoNetMessage m) {
        if (m.getNumDataElements() == 4 && m.getOpCode() == 180 && m.getElement(1) == 110 && m.getElement(2) == 127) {
            log.trace("message: write acknowledge- Ignored.");
        }
    }

    private boolean checkReportAlmCSRoutesCapabilities(LocoNetMessage m) {
        if (m.getNumDataElements() == 16 && m.getOpCode() == 230 && m.getElement(1) == 16 && m.getElement(2) == 1 && m.getElement(3) == 0 && m.getElement(10) == 0 && m.getElement(11) == 0 && m.getElement(12) == 0 && m.getElement(13) == 0 && m.getElement(14) == 0) {
            log.debug("Report ALM CS Routes Capabilities");
            return true;
        }
        return false;
    }

    private boolean checkRequestDeviceRoutes(LocoNetMessage m) {
        if (m.getNumDataElements() == 16 && m.getOpCode() == 238 && m.getElement(1) == 16 && m.getElement(2) == 2 && m.getElement(3) == 14 && m.getElement(4) == 0 && m.getElement(5) == 0 && m.getElement(6) == 0 && m.getElement(7) == 0 && m.getElement(8) == 0) {
            log.debug("request select ALM Device Routes");
            this.deselectAlmRoutesDevice();
            return true;
        }
        return false;
    }

    private boolean checkAlmDeviceIsSelected(LocoNetMessage m) {
        if (m.getNumDataElements() == 16 && m.getOpCode() == 230 && m.getElement(1) == 16 && m.getElement(2) == 2 && m.getElement(3) == 14 && (m.getElement(4) & 0x4F) == 0 && m.getElement(5) == 0 && m.getElement(6) == 0 && m.getElement(7) == 2 && m.getElement(8) == 8) {
            log.debug("response from device: ALM Device Routes selected");
            int dev = m.getElement(9);
            int ser = (m.getElement(12) << 7) + m.getElement(11);
            int base = (m.getElement(14) << 7) + m.getElement(13);
            this.selectAlmRoutesDevice(dev, ser, base);
            return true;
        }
        return false;
    }

    private boolean checkAlmDeviceIsDeselected(LocoNetMessage m) {
        if (m.getNumDataElements() == 16 && m.getOpCode() == 230 && m.getElement(1) == 16 && m.getElement(2) == 2 && m.getElement(3) == 0 && m.getElement(4) == 0 && m.getElement(5) == 0 && m.getElement(7) == 0 && m.getElement(8) == 0 && m.getElement(9) == 0 && m.getElement(10) == 0 && m.getElement(11) == 0 && m.getElement(12) == 0 && m.getElement(13) == 0 && m.getElement(14) == 0) {
            log.debug("message: deselect the ALM routes device at the de-select request");
            this.deselectAlmRoutesDevice();
            return true;
        }
        return false;
    }

    private boolean checkRequestAlmDeviceReadRequest(LocoNetMessage m) {
        if (m.getNumDataElements() == 16 && m.getOpCode() == 238 && m.getElement(1) == 16 && m.getElement(2) == 2 && m.getElement(3) == 2 && m.getElement(7) == 0 && m.getElement(8) == 0 && m.getElement(9) == 0 && m.getElement(10) == 0 && m.getElement(11) == 0 && m.getElement(12) == 0 && m.getElement(13) == 0 && m.getElement(14) == 0) {
            this.activeEntrySet = m.getElement(4) & 1;
            this.activeRouteNum = (m.getElement(4) >> 1) + (m.getElement(5) << 6);
            log.debug("message: read request - ALM 7th gen read - entry {} entrySet {}", (Object)this.activeRouteNum, (Object)this.activeEntrySet);
            return true;
        }
        return false;
    }

    private boolean checkAlmDeviceReadReport(LocoNetMessage m) {
        if (m.getNumDataElements() == 16 && m.getOpCode() == 230 && m.getElement(1) == 16 && m.getElement(2) == 2 && m.getElement(3) == 2 && m.getElement(7) == 0 && m.getElement(8) == 0 && m.getElement(9) == 0 && m.getElement(10) == 0 && m.getElement(11) == 0 && m.getElement(12) == 0 && m.getElement(13) == 0 && m.getElement(14) == 0) {
            this.activeEntrySet = m.getElement(4) & 1;
            this.activeRouteNum = (m.getElement(4) >> 1) + (m.getElement(5) << 6);
            int entrya = m.getElement(6) + (m.getElement(7) << 7);
            int entryb = m.getElement(8) + (m.getElement(8) << 7);
            int entryc = m.getElement(10) + (m.getElement(11) << 7);
            int entryd = m.getElement(12) + (m.getElement(13) << 7);
            log.debug("message: read report - ALM 7th gen read - entry {} entrySet {}: entryA = {}, entryB = {}, entryC = {}, entryD = {}.", new Object[]{this.activeEntrySet, this.activeEntrySet, entrya, entryb, entryc, entryd});
            this.saveData(this.activeDeviceType, this.activeDeviceSerNum, this.activeDeviceBaseAddr, this.activeEntrySet, this.activeRouteNum, entrya, entryb, entryc, entryd);
            return true;
        }
        return false;
    }

    private boolean checkAlmDeviceWriteRequest(LocoNetMessage m) {
        if (m.getNumDataElements() == 16 && m.getOpCode() == 238 && m.getElement(1) == 16 && m.getElement(2) == 2 && m.getElement(3) == 3) {
            this.activeEntrySet = m.getElement(4) & 1;
            this.activeRouteNum = (m.getElement(4) >> 1) + (m.getElement(5) << 6);
            int entrya = m.getElement(7) + (m.getElement(8) << 7);
            int entryb = m.getElement(9) + (m.getElement(10) << 7);
            int entryc = m.getElement(11) + (m.getElement(12) << 7);
            int entryd = m.getElement(13) + (m.getElement(14) << 7);
            log.debug("message: write request - ALM 7th gen write - entry {} entrySet {}: entryA = {}, entryB = {}, entryC = {}, entryD = {}.\n", new Object[]{this.activeEntrySet, this.activeEntrySet, entrya, entryb, entryc, entryd});
            this.saveData(this.activeDeviceType, this.activeDeviceSerNum, this.activeDeviceBaseAddr, this.activeEntrySet, this.activeRouteNum, entrya, entryb, entryc, entryd);
            return true;
        }
        return false;
    }

    @Override
    public void message(LocoNetMessage m) {
        log.trace("RtsMgr:message - length {}", (Object)m.getNumDataElements());
        if (!(this.checkReportAlmCSRoutesCapabilities(m) || this.checkRequestDeviceRoutes(m) || this.checkAlmDeviceIsSelected(m) || this.checkAlmDeviceIsDeselected(m) || this.checkRequestAlmDeviceReadRequest(m) || this.checkAlmDeviceReadReport(m) || this.checkAlmDeviceWriteRequest(m))) {
            this.checkMessage4Byte(m);
        }
    }

    public void saveData(int deviceType, int deviceSerNum, int deviceBaseAddr, int entrySet, int routeNum, int entrya, int entryb, int entryc, int entryd) {
        log.debug("saveData: updating 4 entries for device {} serNum {} routeNum {} entries {} to {}, \n\twith entrya = {}, entryb = {}, entryc = {}, entryd = {}.", new Object[]{deviceType, deviceSerNum, routeNum, entrySet * 4, entrySet * 4 + 3, entrya, entryb, entryc, entryd});
        LnSimple7thGenDeviceRoutes device = this.devicesRoutes.getDeviceRoutes(deviceType, deviceSerNum);
        if (device == null) {
            this.addDevice(new LnSimple7thGenDeviceRoutes(deviceType, deviceSerNum));
            device = this.devicesRoutes.getDeviceRoutes(deviceType, deviceSerNum);
            device.setBaseAddr(deviceBaseAddr);
            log.debug("saveData: New device's type = {}, serNum = {}, baseAddr = {}", new Object[]{device.getDeviceType(), device.getSerNum(), device.getBaseAddr()});
        }
        device.setFourEntries(routeNum, entrySet, entrya, entryb, entryc, entryd);
        LnSimple7thGenDeviceRoutes d = this.devicesRoutes.getDeviceRoutes(deviceType, deviceSerNum);
        LnSimpleRouteEntry ea = d.getRoutes(routeNum).getRouteEntry(4 * entrySet);
        LnSimpleRouteEntry eb = d.getRoutes(routeNum).getRouteEntry(4 * entrySet + 1);
        LnSimpleRouteEntry ec = d.getRoutes(routeNum).getRouteEntry(4 * entrySet + 2);
        LnSimpleRouteEntry ed = d.getRoutes(routeNum).getRouteEntry(4 * entrySet + 3);
        log.debug("saveData: device {} serNum {} route {}. entrySet {}, a {}, b {}, c {}, d {}", new Object[]{d.getDeviceType(), d.getSerNum(), routeNum, entrySet, Integer.toString(ea.getNumber()) + ea.getPosition().toString(), Integer.toString(eb.getNumber()) + eb.getPosition().toString(), Integer.toString(ec.getNumber()) + ec.getPosition().toString(), Integer.toString(ed.getNumber()) + ed.getPosition().toString()});
    }

    public String getDevName(int devType) {
        switch (devType) {
            case 116: {
                return DEVICE_DS74;
            }
            case 124: {
                return DEVICE_DS78V;
            }
            case 74: {
                return DEVICE_PM74;
            }
            case 70: {
                return DEVICE_SE74;
            }
        }
        throw new IllegalArgumentException("Bad Device Type: " + Integer.toString(devType) + ".");
    }

    public int getDevType(String deviceName) {
        switch (deviceName) {
            case "DS74": {
                return 116;
            }
            case "DS78V": {
                return 124;
            }
            case "PM74": {
                return 74;
            }
            case "SE74": {
                return 70;
            }
        }
        throw new IllegalArgumentException("Wrong device name: " + deviceName + ".");
    }

    public boolean loadTheXML() {
        log.debug("loadXML: starting; current getCountOfDevicesWithRoutes is {}", (Object)this.getCountOfDevicesWithRoutes());
        Digitrax7thGenAccyRoutesXML xmlThingy = new Digitrax7thGenAccyRoutesXML(this);
        xmlThingy.loadXML();
        log.debug("loadTheXML: Finished reading the 'DigitraxRoutes' file.");
        return true;
    }

    public int getCountOfDevicesWithRoutes() {
        return this.devicesRoutes.size();
    }

    public void addDeviceRoutesRoute(String devType, int serNum, int baseNum, int[][] turnouts, RouteSwitchPositionEnum[][] positions) {
        int idevNumber = LnSimple7thGenDeviceRoutes.getDeviceType(devType);
        log.debug("addDeviceRoutesRoute: checking for device already entered - devNumber {}, serNum {}.", (Object)idevNumber, (Object)serNum);
        LnSimple7thGenDeviceRoutes existingDevRts = this.devicesRoutes.getDeviceRoutes(idevNumber, serNum);
        if (existingDevRts != null) {
            this.devicesRoutes.removeExistingDevice(idevNumber, serNum);
            log.debug("removed previous device in favor of the current data");
        }
        LnSimple7thGenDeviceRoutes ls7gdr = new LnSimple7thGenDeviceRoutes(idevNumber, serNum);
        ls7gdr.setBaseAddr(baseNum);
        for (int i = 0; i < (devType.equalsIgnoreCase(DEVICE_DS78V) ? 16 : 8); ++i) {
            for (int j = 0; j < 8; ++j) {
                ls7gdr.setOneEntry(i, j, turnouts[i][j], positions[i][j]);
            }
        }
        this.addDevice(ls7gdr);
    }

    public void addDevice(LnSimple7thGenDeviceRoutes dev) {
        this.devicesRoutes.add(dev);
        log.debug("addDevice: done adding the device!");
    }

    public LnSimple7thGenDeviceRoutes getDevice(int i) {
        return this.devicesRoutes.getDeviceRoutes(i);
    }

    public void dispose() {
        if (this.memo != null) {
            this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
        }
    }
}

