/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.TimebaseRateException;
import jmri.implementation.DefaultClockControl;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.LnPowerManager;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotListener;
import jmri.jmrix.loconet.SlotManager;
import jmri.util.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnClockControl
extends DefaultClockControl
implements SlotListener {
    final SlotManager sm;
    final LnTrafficController tc;
    final LnPowerManager pm;
    Timebase clock = null;
    PropertyChangeListener minuteChangeListener = null;
    private int curDays = 0;
    private int curHours = 0;
    private int curMinutes = 0;
    private int curFractionalMinutes = 900;
    private int curRate = 1;
    private int savedRate = 1;
    private boolean setInternal = false;
    private boolean synchronizeWithInternalClock = false;
    private boolean inSyncWithInternalFastClock = false;
    private boolean timebaseErrorReported = false;
    private boolean correctFastClock = false;
    private boolean readInProgress = false;
    static final long MSECPERHOUR = 3600000L;
    static final long MSECPERMINUTE = 60000L;
    static final double CORRECTION = 915.0;
    private static final Logger log = LoggerFactory.getLogger(LnClockControl.class);

    public LnClockControl(LocoNetSystemConnectionMemo scm) {
        this(scm.getSlotManager(), scm.getLnTrafficController(), scm.getPowerManager());
    }

    public LnClockControl(SlotManager sm, LnTrafficController tc, LnPowerManager pm) {
        this.sm = sm;
        this.tc = tc;
        this.pm = pm;
        if (sm != null) {
            sm.addSlotListener(this);
        } else {
            log.error("No LocoNet connection available, LnClockControl can't function");
        }
        this.clock = InstanceManager.getDefault(Timebase.class);
        this.minuteChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                LnClockControl.this.newMinute();
            }
        };
        this.clock.addMinuteChangeListener(this.minuteChangeListener);
    }

    @Override
    public String getHardwareClockName() {
        return Bundle.getMessage("LocoNetFastClockName");
    }

    @Override
    public boolean canCorrectHardwareClock() {
        return true;
    }

    @Override
    public void setRate(double newRate) {
        this.savedRate = this.curRate == 0 ? (int)newRate : (this.curRate = (int)newRate);
        this.setClock();
    }

    @Override
    public boolean requiresIntegerRate() {
        return true;
    }

    @Override
    public double getRate() {
        return this.curRate;
    }

    @Override
    public void setTime(Date now) {
        this.curDays = now.getDate();
        this.curHours = now.getHours();
        this.curMinutes = now.getMinutes();
        this.setClock();
    }

    @Override
    public Date getTime() {
        Date tem = this.clock.getTime();
        int cHours = tem.getHours();
        long cNumMSec = tem.getTime();
        long nNumMSec = cNumMSec / 3600000L * 3600000L - (long)cHours * 3600000L + (long)this.curHours * 3600000L + (long)this.curMinutes * 60000L;
        return new Date(nNumMSec += (long)((915.0 - (double)this.curFractionalMinutes) / 915.0 * 60000.0));
    }

    @Override
    public void startHardwareClock(Date now) {
        this.curRate = this.savedRate;
        this.setTime(now);
    }

    @Override
    public void stopHardwareClock() {
        this.savedRate = this.curRate;
        this.curRate = 0;
        this.setClock();
    }

    @Override
    public void initializeHardwareClock(double rate, Date now, boolean getTime) {
        this.synchronizeWithInternalClock = this.clock.getSynchronize();
        this.correctFastClock = this.clock.getCorrectHardware();
        boolean bl = this.setInternal = !this.clock.getInternalMaster();
        if (!(this.setInternal || this.synchronizeWithInternalClock || this.correctFastClock)) {
            return;
        }
        if (rate == 0.0) {
            if (this.curRate != 0) {
                this.savedRate = this.curRate;
            }
            this.curRate = 0;
        } else {
            this.savedRate = (int)rate;
            if (this.curRate != 0) {
                this.curRate = this.savedRate;
            }
        }
        this.curDays = now.getDate();
        this.curHours = now.getHours();
        this.curMinutes = now.getMinutes();
        if (!getTime) {
            this.setTime(now);
        }
        if (getTime || this.synchronizeWithInternalClock || this.correctFastClock) {
            this.inSyncWithInternalFastClock = false;
            this.initiateRead();
        }
    }

    public void initiateRead() {
        if (!this.readInProgress) {
            this.sm.sendReadSlot(123);
            this.readInProgress = true;
        }
    }

    public void newMinute() {
        if (!this.inSyncWithInternalFastClock) {
            return;
        }
        if (this.correctFastClock || this.synchronizeWithInternalClock) {
            Date now = this.clock.getTime();
            if (now.getMinutes() != 0) {
                this.curDays = now.getDate();
                this.curHours = now.getHours();
                this.curMinutes = now.getMinutes();
                long millis = now.getTime();
                long elapsedMS = millis % 60000L;
                double frac_min = (double)elapsedMS / 60000.0;
                this.curFractionalMinutes = 915 - (int)(915.0 * frac_min);
                this.setClock();
            }
        } else if (this.setInternal) {
            this.inSyncWithInternalFastClock = false;
            this.initiateRead();
        }
    }

    @Override
    public void notifyChangedSlot(LocoNetSlot s) {
        block11: {
            if (s.getSlot() != 123) {
                return;
            }
            if (!(this.correctFastClock || this.synchronizeWithInternalClock || this.setInternal)) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("slot update {}", (Object)s);
            }
            this.curDays = s.getFcDays();
            this.curHours = s.getFcHours();
            this.curMinutes = s.getFcMinutes();
            int temRate = s.getFcRate();
            if (temRate != this.curRate && !this.setInternal) {
                this.setRate(this.curRate);
            } else if (temRate != this.curRate && this.setInternal) {
                try {
                    this.clock.userSetRate(temRate);
                }
                catch (TimebaseRateException e) {
                    if (this.timebaseErrorReported) break block11;
                    this.timebaseErrorReported = true;
                    log.warn("Time base exception on setting rate from LocoNet");
                }
            }
        }
        this.curFractionalMinutes = s.getFcFracMins();
        Date tem = this.clock.getTime();
        int cHours = tem.getHours();
        long cNumMSec = tem.getTime();
        long nNumMSec = cNumMSec / 3600000L * 3600000L - (long)cHours * 3600000L + (long)this.curHours * 3600000L + (long)this.curMinutes * 60000L;
        if (this.readInProgress && !this.inSyncWithInternalFastClock) {
            this.clock.setTime(new Date(nNumMSec += (long)((915.0 - (double)this.curFractionalMinutes) / 915.0 * 60000.0)));
        } else if (this.setInternal) {
            this.clock.setTime(new Date(nNumMSec));
        }
        this.inSyncWithInternalFastClock = true;
    }

    private void setClock() {
        if (this.setInternal || this.synchronizeWithInternalClock || this.correctFastClock) {
            LocoNetSlot s = this.sm.slot(123);
            s.setFcDays(this.curDays);
            s.setFcHours(this.curHours);
            s.setFcMinutes(this.curMinutes);
            s.setFcRate(this.curRate);
            s.setFcFracMins(this.curFractionalMinutes);
            boolean power = true;
            if (this.pm != null) {
                power = this.pm.getPower() == 2;
            } else {
                LoggingUtil.warnOnce(log, "Can't access power manager for fast clock", new Object[0]);
            }
            s.setTrackStatus(s.getTrackStatus() & 0xFFFFFFFE);
            if (power) {
                s.setTrackStatus(s.getTrackStatus() | 1);
            }
            this.tc.sendLocoNetMessage(s.writeSlot());
        }
    }

    public void dispose() {
        if (this.sm != null) {
            this.sm.removeSlotListener(this);
        }
        if (this.minuteChangeListener != null) {
            this.clock.removeMinuteChangeListener(this.minuteChangeListener);
            this.minuteChangeListener = null;
        }
    }
}

