/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnDeferProgrammer
implements Programmer {
    LocoNetSystemConnectionMemo memo;
    private static final Logger log = LoggerFactory.getLogger(LnDeferProgrammer.class);

    public LnDeferProgrammer(@Nonnull LocoNetSystemConnectionMemo memo) {
        this.memo = memo;
    }

    @Override
    public void writeCV(String CV, int val, ProgListener p) throws ProgrammerException {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            m.writeCV(CV, val, p);
        } else {
            log.warn("writeCV called without a SlotManager");
        }
    }

    @Override
    public void readCV(String CV, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p, 0);
    }

    @Override
    public void readCV(String CV, ProgListener p, int startVal) throws ProgrammerException {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            m.readCV(CV, p, startVal);
        } else {
            log.warn("readCV called without a SlotManager");
        }
    }

    @Override
    public void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            m.confirmCV(CV, val, p);
        } else {
            log.warn("confirmCV called without a SlotManager");
        }
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            return m.getSupportedModes();
        }
        log.warn("getSupportedModes() called without a SlotManager");
        return new ArrayList<ProgrammingMode>();
    }

    @Override
    public void setMode(ProgrammingMode p) {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            m.setMode(p);
        } else {
            log.warn("setMode() called without a SlotManager");
        }
    }

    @Override
    public ProgrammingMode getMode() {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            return m.getMode();
        }
        log.warn("getMode() called without a SlotManager");
        return ProgrammingMode.ADDRESSMODE;
    }

    @Override
    public boolean getCanRead() {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            return m.getCanRead();
        }
        log.warn("getCanRead() called without a SlotManager");
        return true;
    }

    @Override
    public boolean getCanRead(String addr) {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            return m.getCanRead(addr);
        }
        log.warn("getCanRead(String) called without a SlotManager");
        return true;
    }

    @Override
    public boolean getCanWrite() {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            return m.getCanWrite();
        }
        log.warn("getCanWrite() called without a SlotManager");
        return true;
    }

    @Override
    public boolean getCanWrite(String addr) {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            return m.getCanWrite(addr);
        }
        log.warn("getCanWrite(String) called without a SlotManager");
        return true;
    }

    @Override
    @Nonnull
    public Programmer.WriteConfirmMode getWriteConfirmMode(String addr) {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            return m.getWriteConfirmMode(addr);
        }
        log.warn("getWriteConfirmMode() called without a SlotManager");
        return Programmer.WriteConfirmMode.DecoderReply;
    }

    @Override
    public void notifyProgListenerEnd(ProgListener p, int value, int status) {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            m.notifyProgListenerEnd(p, value, status);
        } else {
            log.warn("notifyProgListenerEnd called without a SlotManager");
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener p) {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            m.addPropertyChangeListener(p);
        } else {
            log.warn("addPropertyChangeListener called without a SlotManager");
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener p) {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            m.removePropertyChangeListener(p);
        } else {
            log.warn("removePropertyChangeListener called without a SlotManager");
        }
    }

    @Override
    @Nonnull
    public String decodeErrorCode(int i) {
        SlotManager m = this.memo.getSlotManager();
        if (m != null) {
            return m.decodeErrorCode(i);
        }
        log.warn("decodeErrorCode called without a SlotManager");
        return "<unknown>";
    }
}

