/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.implementation.AbstractLight;
import jmri.jmrix.loconet.LnLightManager;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnLight
extends AbstractLight {
    LnTrafficController tc;
    LnLightManager mgr;
    int mBit = 0;
    private static final Logger log = LoggerFactory.getLogger(LnLight.class);

    public LnLight(String systemName, LnTrafficController tc, LnLightManager mgr) {
        super(systemName);
        this.tc = tc;
        this.mgr = mgr;
        this.initializeLight(systemName);
    }

    public LnLight(String systemName, String userName, LnTrafficController tc, LnLightManager mgr) {
        super(systemName, userName);
        this.tc = tc;
        this.mgr = mgr;
        this.initializeLight(systemName);
    }

    private void initializeLight(String systemName) {
        this.mBit = this.mgr.getBitFromSystemName(systemName);
        this.setState(4);
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        LocoNetMessage l = new LocoNetMessage(4);
        l.setOpCode(176);
        int hiadr = (this.mBit - 1) / 128;
        int loadr = this.mBit - 1 - hiadr * 128;
        if (newState == 2) {
            hiadr |= 0x30;
        } else if (newState == 4) {
            hiadr |= 0x10;
        } else {
            log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
            hiadr |= 0x10;
        }
        l.setElement(1, loadr);
        l.setElement(2, hiadr);
        this.tc.sendLocoNetMessage(l);
    }
}

