/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.swing.Timer;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LnProgrammerManager;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.lnsvf1.Lnsv1MessageContents;
import jmri.jmrix.loconet.uhlenbrock.LncvMessageContents;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnOpsModeProgrammer
extends PropertyChangeSupport
implements AddressedProgrammer,
LocoNetListener {
    LocoNetSystemConnectionMemo memo;
    int mAddress;
    boolean mLongAddr;
    ProgListener p;
    boolean doingWrite;
    boolean boardOpSwWriteVal;
    private int artNum;
    private Timer bdOpSwAccessTimer = null;
    private Timer sv2AccessTimer = null;
    private Timer lncvAccessTimer = null;
    private Timer bd7GenAccyOpSwAccessTimer = null;
    private boolean firstReply;
    private boolean csIsPresent;
    private boolean bd7OpSwModeAccess;
    private boolean enabledDelayedNotify;
    private boolean lnTrafficListenerIsRegistered;
    protected ProgrammingMode mode = ProgrammingMode.OPSBYTEMODE;
    private static final Logger log = LoggerFactory.getLogger(LnOpsModeProgrammer.class);

    public LnOpsModeProgrammer(LocoNetSystemConnectionMemo memo, int pAddress, boolean pLongAddr) {
        this.memo = memo;
        this.mAddress = pAddress;
        this.mLongAddr = pLongAddr;
        this.lnTrafficListenerIsRegistered = false;
        this.expectCsB4();
    }

    private void expectCsB4() {
        this.csIsPresent = this.memo.getSlotManager().getCommandStationType() != LnCommandStationType.COMMAND_STATION_STANDALONE;
    }

    @Override
    public void writeCV(String CV, int val, ProgListener pL) throws ProgrammerException {
        if (this.p != null) {
            log.error("Will try to null an existing programmer!");
        }
        this.p = null;
        this.bd7OpSwModeAccess = false;
        this.enabledDelayedNotify = false;
        if (!this.lnTrafficListenerIsRegistered) {
            this.memo.getLnTrafficController().addLocoNetListener(-1, this);
            this.lnTrafficListenerIsRegistered = true;
        }
        if (this.getMode().equals(LnProgrammerManager.LOCONETCSOPSWMODE)) {
            this.memo.getSlotManager().setMode(LnProgrammerManager.LOCONETCSOPSWMODE);
            this.memo.getSlotManager().writeCV(CV, val, pL);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETBDOPSWMODE)) {
            if (this.bdOpSwAccessTimer == null) {
                this.initializeBdOpsAccessTimer();
            }
            this.p = pL;
            this.doingWrite = true;
            log.debug("write CV \"{}\" to {} addr:{}", new Object[]{CV, val, this.mAddress});
            String[] parts = CV.split("\\.");
            int typeWord = Integer.parseInt(parts[0]);
            int state = Integer.parseInt(parts[parts.length > 1 ? 1 : 0]);
            LocoNetMessage m = new LocoNetMessage(6);
            m.setOpCode(208);
            int element = 114;
            if ((this.mAddress & 0x80) != 0) {
                element |= 1;
            }
            m.setElement(1, element);
            m.setElement(2, this.mAddress - 1 & 0x7F);
            m.setElement(3, typeWord);
            int loc = (state - 1) / 8;
            int bit = state - 1 - loc * 8;
            m.setElement(4, loc * 16 + bit * 2 + (val & 1));
            this.boardOpSwWriteVal = (val & 1) == 1;
            log.debug("  Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.bdOpSwAccessTimer.restart();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETBD7OPSWMODE)) {
            if (this.bd7GenAccyOpSwAccessTimer == null) {
                this.initialize7GenBdOpsAccessTimer();
            }
            this.p = pL;
            this.bd7OpSwModeAccess = true;
            this.doingWrite = true;
            log.debug("write CV \"{}\" to {} addr:{}", new Object[]{CV, val, this.mAddress});
            String[] parts = CV.split("\\.");
            int offset = 0;
            int cv = 0;
            switch (parts.length) {
                case 1: {
                    cv = Integer.parseInt(parts[0]) - 1;
                    break;
                }
                case 2: {
                    offset = Integer.parseInt(parts[0]);
                    cv = Integer.parseInt(parts[1]) - 1;
                    break;
                }
                default: {
                    log.error("unexpected number of parts in CV {}", (Object)CV);
                }
            }
            int address6th = this.mAddress - 1 + offset >> 2 & 0x3F;
            int upper3 = ~(this.mAddress - 1 + offset >> 8 & 7);
            int lower2 = this.mAddress - 1 + offset & 3;
            int address7th = upper3 << 4 & 0x70 | lower2 << 1 | 8;
            LocoNetMessage m = new LocoNetMessage(11);
            m.setOpCode(237);
            m.setElement(1, 11);
            m.setElement(2, 127);
            m.setElement(3, 84);
            m.setElement(4, 7 | (val >> 7 & 1) << 4);
            m.setElement(5, address6th);
            m.setElement(6, address7th);
            m.setElement(7, 0x6C | cv >> 7 & 3);
            m.setElement(8, cv & 0x7F);
            m.setElement(9, val & 0x7F);
            this.boardOpSwWriteVal = (val & 1) == 1;
            log.debug("  Message {}", (Object)m);
            this.firstReply = true;
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.bd7GenAccyOpSwAccessTimer.restart();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETSV1MODE)) {
            this.p = pL;
            this.doingWrite = true;
            log.debug("write CV \"{}\" to {} addr:{}", new Object[]{CV, val, this.mAddress});
            int locoIOAddress = this.mAddress & 0x7F;
            int locoIOSubAddress = (this.mAddress + 256) / 256 & 0x7F;
            LocoNetMessage m = Lnsv1MessageContents.createSv1WriteRequest(locoIOAddress, locoIOSubAddress, this.decodeCvNum(CV), val);
            log.debug(" LNSV1 Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETSV2MODE)) {
            if (this.sv2AccessTimer == null) {
                this.initializeSV2AccessTimer();
            }
            this.p = pL;
            log.debug("write CV \"{}\" to {} addr:{}", new Object[]{CV, val, this.mAddress});
            LocoNetMessage m = new LocoNetMessage(16);
            this.loadSV2MessageFormat(m, this.mAddress, this.decodeCvNum(CV), val);
            m.setElement(3, 1);
            log.debug(" LNSV2 Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.sv2AccessTimer.restart();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETLNCVMODE)) {
            String[] parts;
            if (this.lncvAccessTimer == null) {
                this.initializeLncvAccessTimer();
            }
            if ((parts = CV.split("\\.")).length > 1) {
                this.artNum = Integer.parseInt(parts[0]);
            }
            int cvNum = Integer.parseInt(parts[parts.length > 1 ? 1 : 0]);
            this.p = pL;
            this.doingWrite = true;
            log.debug("write CV \"{}\" to {} addr:{} (art. {})", new Object[]{cvNum, val, this.mAddress, this.artNum});
            LocoNetMessage m = LncvMessageContents.createCvWriteRequest(this.artNum, cvNum, val);
            log.debug(" LNCV Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.lncvAccessTimer.restart();
        } else {
            this.memo.getSlotManager().setAcceptAnyLACK();
            this.memo.getSlotManager().writeCVOpsMode(CV, val, pL, this.mAddress, this.mLongAddr);
        }
    }

    @Override
    public void readCV(String CV, ProgListener pL) throws ProgrammerException {
        if (this.p != null) {
            log.error("Will try to null an existing programmer!");
        }
        this.p = null;
        this.bd7OpSwModeAccess = false;
        this.enabledDelayedNotify = false;
        if (!this.lnTrafficListenerIsRegistered) {
            this.memo.getLnTrafficController().addLocoNetListener(-1, this);
            this.lnTrafficListenerIsRegistered = true;
        }
        if (this.getMode().equals(LnProgrammerManager.LOCONETCSOPSWMODE)) {
            this.memo.getSlotManager().setMode(LnProgrammerManager.LOCONETCSOPSWMODE);
            this.memo.getSlotManager().readCV(CV, pL);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETBDOPSWMODE)) {
            if (this.bdOpSwAccessTimer == null) {
                this.initializeBdOpsAccessTimer();
            }
            this.p = pL;
            this.doingWrite = false;
            log.debug("read CV \"{}\" addr:{}", (Object)CV, (Object)this.mAddress);
            String[] parts = CV.split("\\.");
            int typeWord = Integer.parseInt(parts[0]);
            int state = Integer.parseInt(parts[parts.length > 1 ? 1 : 0]);
            LocoNetMessage m = new LocoNetMessage(6);
            m.setOpCode(208);
            int element = 98;
            if ((this.mAddress & 0x80) != 0) {
                element |= 1;
            }
            m.setElement(1, element);
            m.setElement(2, this.mAddress - 1 & 0x7F);
            m.setElement(3, typeWord);
            int loc = (state - 1) / 8;
            int bit = state - 1 - loc * 8;
            m.setElement(4, loc * 16 + bit * 2);
            log.debug("  Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.bdOpSwAccessTimer.restart();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETBD7OPSWMODE)) {
            this.bd7OpSwModeAccess = true;
            if (this.bd7GenAccyOpSwAccessTimer == null) {
                this.initialize7GenBdOpsAccessTimer();
            }
            this.p = pL;
            this.doingWrite = false;
            log.debug("read CV \"{}\" addr:{}", (Object)CV, (Object)this.mAddress);
            String[] parts = CV.split("\\.");
            int offset = 0;
            int cv = 0;
            switch (parts.length) {
                case 1: {
                    cv = Integer.parseInt(parts[0]) - 1;
                    break;
                }
                case 2: {
                    offset = Integer.parseInt(parts[0]);
                    cv = Integer.parseInt(parts[1]) - 1;
                    break;
                }
                default: {
                    log.error("unexpected number of parts in CV {}", (Object)CV);
                }
            }
            int address6th = this.mAddress - 1 + offset >> 2 & 0x3F;
            int upper3 = ~(this.mAddress - 1 + offset >> 8 & 7);
            int lower2 = this.mAddress - 1 + offset & 3;
            int address7th = upper3 << 4 & 0x70 | lower2 << 1 | 8;
            LocoNetMessage m = new LocoNetMessage(11);
            m.setOpCode(237);
            m.setElement(1, 11);
            m.setElement(2, 127);
            m.setElement(3, 84);
            m.setElement(4, 7);
            m.setElement(5, address6th);
            m.setElement(6, address7th);
            m.setElement(7, 0x64 | cv >> 7 & 3);
            m.setElement(8, cv & 0x7F);
            m.setElement(9, 0);
            log.debug("  Message {}", (Object)m);
            this.firstReply = true;
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.bd7GenAccyOpSwAccessTimer.restart();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETSV1MODE)) {
            this.p = pL;
            this.doingWrite = false;
            log.debug("read CV \"{}\" addr:{}", (Object)CV, (Object)this.mAddress);
            int locoIOAddress = this.mAddress & 0xFF;
            int locoIOSubAddress = (this.mAddress + 256) / 256 & 0x7F;
            LocoNetMessage m = Lnsv1MessageContents.createSv1ReadRequest(locoIOAddress, locoIOSubAddress, this.decodeCvNum(CV));
            log.debug(" LNSV1 Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETSV2MODE)) {
            if (this.sv2AccessTimer == null) {
                this.initializeSV2AccessTimer();
            }
            this.p = pL;
            log.debug("read CV \"{}\" addr:{}", (Object)CV, (Object)this.mAddress);
            LocoNetMessage m = new LocoNetMessage(16);
            this.loadSV2MessageFormat(m, this.mAddress, this.decodeCvNum(CV), 0);
            m.setElement(3, 2);
            log.debug(" LNSV2 Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.sv2AccessTimer.restart();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETLNCVMODE)) {
            String[] parts;
            if (this.lncvAccessTimer == null) {
                this.initializeLncvAccessTimer();
            }
            if ((parts = CV.split("\\.")).length > 1) {
                this.artNum = Integer.parseInt(parts[0]);
            }
            int cvNum = Integer.parseInt(parts[parts.length > 1 ? 1 : 0]);
            this.doingWrite = false;
            this.p = pL;
            log.debug("read LNCV \"{}\" addr:{}", (Object)CV, (Object)this.mAddress);
            LocoNetMessage m = LncvMessageContents.createCvReadRequest(this.artNum, this.mAddress, cvNum);
            log.debug(" LNCV Message {}", (Object)m);
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
            this.lncvAccessTimer.restart();
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETOPSBOARD)) {
            log.trace("LOCONETOPSBOARD start operation");
            this.memo.getSlotManager().setAcceptAnyLACK();
            this.memo.getSlotManager().readCVOpsMode(CV, pL, this.mAddress, this.mLongAddr);
        } else {
            this.memo.getSlotManager().readCVOpsMode(CV, pL, this.mAddress, this.mLongAddr);
        }
    }

    @Override
    public void confirmCV(String CV, int val, ProgListener pL) throws ProgrammerException {
        if (this.p != null) {
            log.error("Will try to null an existing programmer!");
        }
        this.enabledDelayedNotify = false;
        if (!this.lnTrafficListenerIsRegistered) {
            this.memo.getLnTrafficController().addLocoNetListener(-1, this);
            this.lnTrafficListenerIsRegistered = true;
        }
        this.p = null;
        if (this.getMode().equals(LnProgrammerManager.LOCONETCSOPSWMODE)) {
            this.memo.getSlotManager().setMode(LnProgrammerManager.LOCONETCSOPSWMODE);
            this.memo.getSlotManager().readCV(CV, pL);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETBDOPSWMODE)) {
            this.readCV(CV, pL);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETBD7OPSWMODE)) {
            this.readCV(CV, pL);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETSV2MODE)) {
            log.warn("confirm CV \"{}\" addr:{} in SV2 mode not implemented", (Object)CV, (Object)this.mAddress);
            this.notifyProgListenerEnd(pL, 0, 1);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETLNCVMODE)) {
            log.warn("confirm CV \"{}\" addr:{} in LNCV mode not (yet) implemented", (Object)CV, (Object)this.mAddress);
            this.readCV(CV, pL);
        } else if (this.getMode().equals(LnProgrammerManager.LOCONETOPSBOARD)) {
            this.memo.getSlotManager().setAcceptAnyLACK();
            this.memo.getSlotManager().confirmCVOpsMode(CV, val, pL, this.mAddress, this.mLongAddr);
        } else {
            this.memo.getSlotManager().confirmCVOpsMode(CV, val, pL, this.mAddress, this.mLongAddr);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void message(LocoNetMessage m) {
        int code;
        if (this.getMode().equals(LnProgrammerManager.LOCONETBDOPSWMODE)) {
            if (this.p == null) {
                log.warn("received board-program reply message with no reply object: {}", (Object)m);
                return;
            }
            if (m.getOpCode() != 180) return;
            if (m.getElement(1) != 0 && m.getElement(1) != 80) {
                return;
            }
            this.bdOpSwAccessTimer.stop();
            if (this.doingWrite) {
                int code2 = 0;
                int val = this.boardOpSwWriteVal ? 1 : 0;
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, val, code2);
                return;
            }
            int val = 0;
            if ((m.getElement(2) & 0x20) != 0) {
                val = 1;
            }
            int code3 = 0;
            if (m.getElement(2) == 127) {
                code3 = 1;
            }
            ProgListener temp = this.p;
            this.p = null;
            this.notifyProgListenerEnd(temp, val, code3);
            return;
        }
        if (this.getMode().equals(LnProgrammerManager.LOCONETBD7OPSWMODE)) {
            int val;
            int code4;
            block31: {
                if (m.getOpCode() != 180) {
                    return;
                }
                if (this.p == null) {
                    log.warn("7th-gen Accessory board Ops programmer received reply message with no reply object: {}", (Object)m);
                    return;
                }
                if (m.getElement(1) != 110 && m.getElement(1) != 109) {
                    log.debug("Ignoring OPC_LONG_ACK with <LOPC> {}, <ACK1> {}.", (Object)Integer.toHexString(m.getElement(1)), (Object)Integer.toHexString(m.getElement(2)));
                    return;
                }
                if (this.firstReply && this.csIsPresent) {
                    this.firstReply = false;
                    log.debug("Ignoring first OPC_LONG_ACK from 7th gen access. access from cs.");
                    return;
                }
                this.bd7GenAccyOpSwAccessTimer.stop();
                if (this.doingWrite) {
                    if (!(m.getElement(1) != 109 && m.getElement(1) != 110 || m.getElement(2) != 85 && m.getElement(2) != 90)) {
                        code4 = 0;
                        val = this.boardOpSwWriteVal ? 1 : 0;
                        break block31;
                    } else {
                        log.warn("Write of 7th-gen Accessory Decoder returned odd results: {}, {}.  Ignoring.", (Object)m.getElement(1), (Object)m.getElement(2));
                        return;
                    }
                }
                code4 = 0;
                val = m.getElement(2) + ((m.getElement(1) & 1) << 7);
            }
            this.scheduleReplyAfter7GAccyPossibleRepeats(val, code4);
            return;
        }
        if (this.getMode().equals(LnProgrammerManager.LOCONETSV1MODE)) {
            if (m.getOpCode() != 229) return;
            if (m.getElement(1) != 16) return;
            if (m.getElement(4) != 1) return;
            if ((m.getElement(5) & 0x70) != 0) {
                return;
            }
            if ((m.getElement(3) & 0x7F) != 80) {
                return;
            }
            if (this.p == null) {
                log.debug("received SV reply message with no reply object: {}", (Object)m);
                return;
            }
            log.debug("returning SV programming reply: {}", (Object)m);
            int code5 = 0;
            int val = this.doingWrite ? m.getPeerXfrData()[7] : m.getPeerXfrData()[5];
            ProgListener temp = this.p;
            this.p = null;
            this.notifyProgListenerEnd(temp, val, code5);
            return;
        }
        if (this.getMode().equals(LnProgrammerManager.LOCONETSV2MODE)) {
            if ((m.getOpCode() & 0xFF) != 229) return;
            if ((m.getElement(1) & 0xFF) != 16) return;
            if (m.getElement(3) != 65) {
                if (m.getElement(3) != 66) return;
            }
            if ((m.getElement(4) & 0xFF) != 2) return;
            if ((m.getElement(5) & 0x70) != 16) return;
            if ((m.getElement(10) & 0x70) != 16) {
                return;
            }
            if (this.p == null) {
                log.error("received SV reply message with no reply object: {}", (Object)m);
                return;
            }
            log.debug("returning SV programming reply: {}", (Object)m);
            this.sv2AccessTimer.stop();
            int code6 = 0;
            int val = m.getElement(11) & 0x7F | ((m.getElement(10) & 1) != 0 ? 128 : 0);
            ProgListener temp = this.p;
            this.p = null;
            this.notifyProgListenerEnd(temp, val, code6);
            return;
        }
        if (!this.getMode().equals(LnProgrammerManager.LOCONETLNCVMODE)) return;
        if (m.getOpCode() == 180 && m.getElement(1) == 109 && this.doingWrite) {
            switch (m.getElement(2)) {
                case 127: {
                    code = 0;
                    break;
                }
                case 2: 
                case 3: {
                    code = 8;
                    break;
                }
                default: {
                    code = 1;
                }
            }
            if (this.lncvAccessTimer != null) {
                this.lncvAccessTimer.stop();
            }
            ProgListener temp = this.p;
            this.p = null;
            this.notifyProgListenerEnd(temp, 0, code);
        }
        if (LncvMessageContents.extractMessageType(m) != LncvMessageContents.LncvCommand.LNCV_READ_REPLY) {
            if (LncvMessageContents.extractMessageType(m) != LncvMessageContents.LncvCommand.LNCV_READ_REPLY2) return;
        }
        LncvMessageContents contents = new LncvMessageContents(m);
        int artReturned = contents.getLncvArticleNum();
        int valReturned = contents.getCvValue();
        code = 0;
        if (artReturned != this.artNum) {
            log.warn("LNCV read reply received for article {}, expected article {}", (Object)artReturned, (Object)this.artNum);
        }
        if (this.lncvAccessTimer != null) {
            this.lncvAccessTimer.stop();
        }
        ProgListener temp = this.p;
        this.p = null;
        this.notifyProgListenerEnd(temp, valReturned, code);
    }

    private void scheduleReplyAfter7GAccyPossibleRepeats(final int val, final int code) {
        if (this.p != null && this.bd7OpSwModeAccess && !this.enabledDelayedNotify) {
            this.enabledDelayedNotify = true;
            log.debug("   Accepted 7GAccy result. Initiated 7GA timer.");
            TimerUtil.scheduleOnLayoutThread(new TimerTask(){

                @Override
                public void run() {
                    log.debug("Passing result from 7g Accy Ops access: value={}, code={}, p={}.", new Object[]{val, code, LnOpsModeProgrammer.this.p});
                    ProgListener tempProgListener = LnOpsModeProgrammer.this.p;
                    LnOpsModeProgrammer.this.p = null;
                    LnOpsModeProgrammer.this.notifyProgListenerEnd(tempProgListener, val, code);
                }
            }, 200L);
        } else {
            log.debug("   Ignoring 'extra' 7GAccy result.");
        }
    }

    int decodeCvNum(String CV) {
        try {
            return Integer.parseInt(CV);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    void loadSV2MessageFormat(LocoNetMessage m, int mAddress, int cvAddr, int data) {
        m.setElement(0, 229);
        m.setElement(1, 16);
        m.setElement(2, 1);
        m.setElement(4, 2);
        m.setElement(6, mAddress & 0xFF);
        m.setElement(7, mAddress >> 8 & 0xFF);
        m.setElement(8, cvAddr & 0xFF);
        m.setElement(9, cvAddr / 256 & 0xFF);
        int svx1 = 0x10 | ((m.getElement(6) & 0x80) != 0 ? 1 : 0) | ((m.getElement(7) & 0x80) != 0 ? 2 : 0) | ((m.getElement(8) & 0x80) != 0 ? 4 : 0) | ((m.getElement(9) & 0x80) != 0 ? 8 : 0);
        m.setElement(5, svx1);
        m.setElement(6, m.getElement(6) & 0x7F);
        m.setElement(7, m.getElement(7) & 0x7F);
        m.setElement(8, m.getElement(8) & 0x7F);
        m.setElement(9, m.getElement(9) & 0x7F);
        m.setElement(11, data & 0xFF);
        m.setElement(12, data >> 8 & 0xFF);
        m.setElement(13, data >> 16 & 0xFF);
        m.setElement(14, data >> 24 & 0xFF);
        int svx2 = 0x10 | ((m.getElement(11) & 0x80) != 0 ? 1 : 0) | ((m.getElement(12) & 0x80) != 0 ? 2 : 0) | ((m.getElement(13) & 0x80) != 0 ? 4 : 0) | ((m.getElement(14) & 0x80) != 0 ? 8 : 0);
        m.setElement(10, svx2);
        m.setElement(11, m.getElement(11) & 0x7F);
        m.setElement(12, m.getElement(12) & 0x7F);
        m.setElement(13, m.getElement(13) & 0x7F);
        m.setElement(14, m.getElement(14) & 0x7F);
    }

    @Override
    public final void setMode(ProgrammingMode m) {
        if (!this.getSupportedModes().contains(m)) {
            throw new IllegalArgumentException("Invalid requested mode: " + m);
        }
        this.mode = m;
        this.firePropertyChange("Mode", this.mode, m);
    }

    @Override
    public final ProgrammingMode getMode() {
        return this.mode;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>(4);
        ret.add(ProgrammingMode.OPSBYTEMODE);
        ret.add(LnProgrammerManager.LOCONETBD7OPSWMODE);
        ret.add(LnProgrammerManager.LOCONETOPSBOARD);
        ret.add(LnProgrammerManager.LOCONETSV1MODE);
        ret.add(LnProgrammerManager.LOCONETSV2MODE);
        ret.add(LnProgrammerManager.LOCONETLNCVMODE);
        ret.add(LnProgrammerManager.LOCONETBDOPSWMODE);
        ret.add(LnProgrammerManager.LOCONETCSOPSWMODE);
        return ret;
    }

    @Override
    @Nonnull
    public Programmer.WriteConfirmMode getWriteConfirmMode(String addr) {
        if (this.getMode().equals(ProgrammingMode.OPSBYTEMODE)) {
            return Programmer.WriteConfirmMode.NotVerified;
        }
        return Programmer.WriteConfirmMode.DecoderReply;
    }

    @Override
    public boolean getCanRead() {
        if (this.getMode().equals(ProgrammingMode.OPSBYTEMODE)) {
            return this.memo.getSlotManager().getTranspondingAvailable();
        }
        return true;
    }

    @Override
    public boolean getCanRead(String addr) {
        return this.getCanRead();
    }

    @Override
    public boolean getCanWrite() {
        return true;
    }

    @Override
    public boolean getCanWrite(String addr) {
        return this.getCanWrite() && Integer.parseInt(addr) <= 1024;
    }

    @Override
    @Nonnull
    public String decodeErrorCode(int i) {
        return this.memo.getSlotManager().decodeErrorCode(i);
    }

    @Override
    public boolean getLongAddress() {
        return this.mLongAddr;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    void initializeBdOpsAccessTimer() {
        if (this.bdOpSwAccessTimer == null) {
            this.bdOpSwAccessTimer = new Timer(1000, e -> {
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, 0, 128);
            });
            this.bdOpSwAccessTimer.setInitialDelay(1000);
            this.bdOpSwAccessTimer.setRepeats(false);
        }
    }

    void initialize7GenBdOpsAccessTimer() {
        if (this.bd7GenAccyOpSwAccessTimer == null) {
            this.bd7GenAccyOpSwAccessTimer = new Timer(150, e -> {
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, 0, 128);
            });
            this.bd7GenAccyOpSwAccessTimer.setInitialDelay(150);
            this.bd7GenAccyOpSwAccessTimer.setRepeats(false);
        }
    }

    void initializeSV2AccessTimer() {
        if (this.sv2AccessTimer == null) {
            this.sv2AccessTimer = new Timer(1000, e -> {
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, 0, 128);
            });
            this.sv2AccessTimer.setInitialDelay(1000);
            this.sv2AccessTimer.setRepeats(false);
        }
    }

    void initializeLncvAccessTimer() {
        if (this.lncvAccessTimer == null) {
            this.lncvAccessTimer = new Timer(1000, e -> {
                ProgListener temp = this.p;
                this.p = null;
                this.notifyProgListenerEnd(temp, 0, 128);
            });
            this.lncvAccessTimer.setInitialDelay(1000);
            this.lncvAccessTimer.setRepeats(false);
        }
    }

    @Override
    public void dispose() {
        if (this.bdOpSwAccessTimer != null) {
            this.bdOpSwAccessTimer.stop();
        }
        if (this.bd7GenAccyOpSwAccessTimer != null) {
            this.bd7GenAccyOpSwAccessTimer.stop();
        }
        if (this.lncvAccessTimer != null) {
            this.lncvAccessTimer.stop();
        }
        if (this.sv2AccessTimer != null) {
            this.sv2AccessTimer.stop();
        }
        this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
    }
}

