/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.LinkedTransferQueue;
import javax.swing.SwingUtilities;
import jmri.jmrix.loconet.LnPortController;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetMessageException;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnPacketizer
extends LnTrafficController {
    protected boolean echo = false;
    protected LinkedTransferQueue<byte[]> xmtList = new LinkedTransferQueue();
    protected Runnable xmtHandler = null;
    protected Runnable rcvHandler;
    protected LnPortController controller = null;
    public DataInputStream istream = null;
    public OutputStream ostream = null;
    private final byte[] rcvBuffer = new byte[1];
    protected Thread rcvThread;
    protected Thread xmtThread;
    protected volatile boolean threadStopRequest = false;
    private static final Logger log = LoggerFactory.getLogger(LnPacketizer.class);

    public LnPacketizer(LocoNetSystemConnectionMemo m) {
        this.memo = m;
        m.setLnTrafficController(this);
    }

    @Override
    public boolean status() {
        boolean returnVal = this.ostream != null && this.istream != null && this.xmtThread != null && this.xmtThread.isAlive() && this.xmtHandler != null && this.rcvThread != null && this.rcvThread.isAlive() && this.rcvHandler != null;
        return returnVal;
    }

    @Override
    public void sendLocoNetMessage(LocoNetMessage m) {
        ++this.transmittedMsgCount;
        m.setParity();
        int len = m.getNumDataElements();
        byte[] msg = new byte[len];
        for (int i = 0; i < len; ++i) {
            msg[i] = (byte)m.getElement(i);
        }
        log.debug("queue LocoNet packet: {}", (Object)m);
        try {
            this.xmtList.add(msg);
        }
        catch (RuntimeException e) {
            log.warn("passing to xmit: unexpected exception: ", (Throwable)e);
        }
    }

    @Override
    public boolean isXmtBusy() {
        if (this.controller == null) {
            return false;
        }
        return !this.controller.okToSend();
    }

    public void connectPort(LnPortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.controller = p;
    }

    public void disconnectPort(LnPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected LnPortController");
        }
        this.controller = null;
    }

    protected byte readByteProtected(DataInputStream istream) throws IOException {
        int nchars;
        do {
            if ((nchars = istream.read(this.rcvBuffer, 0, 1)) >= 0) continue;
            throw new EOFException(String.format("Stream read returned %d, indicating end-of-file", nchars));
        } while (nchars <= 0);
        return this.rcvBuffer[0];
    }

    protected void messageTransmitted(byte[] msg) {
        log.debug("message transmitted (echo {})", (Object)this.echo);
        if (!this.echo) {
            return;
        }
        SwingUtilities.invokeLater(new Echo(this, new LocoNetMessage(msg)));
    }

    public void startThreads() {
        int xmtpriority;
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available = {} default = {} min available = {}", new Object[]{priority, 10, 5, 1});
        if (this.rcvHandler == null) {
            this.rcvHandler = new RcvHandler(this);
        }
        this.rcvThread = ThreadingUtil.newThread(this.rcvHandler, "LocoNet receive handler");
        this.rcvThread.setDaemon(true);
        this.rcvThread.setPriority(10);
        this.rcvThread.start();
        if (this.xmtHandler == null) {
            this.xmtHandler = new XmtHandler();
        }
        int n = xmtpriority = 9 > priority ? 9 : 10;
        if (this.xmtThread == null) {
            this.xmtThread = ThreadingUtil.newThread(this.xmtHandler, "LocoNet transmit handler");
        }
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        this.xmtThread.setDaemon(true);
        this.xmtThread.setPriority(9);
        this.xmtThread.start();
        log.info("lnPacketizer Started");
    }

    @Override
    public void dispose() {
        this.threadStopRequest = true;
        if (this.xmtThread != null) {
            this.xmtThread.interrupt();
            try {
                this.xmtThread.join(150L);
            }
            catch (InterruptedException e) {
                log.warn("unexpected InterruptedException", (Throwable)e);
            }
        }
        if (this.rcvThread != null) {
            this.rcvThread.interrupt();
            try {
                this.rcvThread.join(150L);
            }
            catch (InterruptedException e) {
                log.warn("unexpected InterruptedException", (Throwable)e);
            }
        }
        super.dispose();
    }

    public void terminateThreads() {
        this.threadStopRequest = true;
        if (this.xmtThread != null) {
            this.xmtThread.interrupt();
            try {
                this.xmtThread.join(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.rcvThread != null) {
            this.rcvThread.interrupt();
            try {
                this.rcvThread.join(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class Echo
    implements Runnable {
        LocoNetMessage msgForLater;
        LnPacketizer myTc;

        Echo(LnPacketizer t, LocoNetMessage m) {
            this.myTc = t;
            this.msgForLater = m;
        }

        @Override
        public void run() {
            this.myTc.notify(this.msgForLater);
        }
    }

    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        @Override
        public void run() {
            while (!LnPacketizer.this.threadStopRequest) {
                try {
                    log.trace("check for input");
                    byte[] msg = LnPacketizer.this.xmtList.take();
                    try {
                        if (LnPacketizer.this.ostream != null) {
                            if (log.isDebugEnabled()) {
                                if (LnPacketizer.this.isXmtBusy()) {
                                    log.debug("LocoNet port not ready to receive");
                                }
                                log.debug("start write to stream: {}", (Object)StringUtil.hexStringFromBytes(msg));
                            }
                            LnPacketizer.this.ostream.write(msg);
                            LnPacketizer.this.ostream.flush();
                            if (log.isTraceEnabled()) {
                                log.trace("end write to stream: {}", (Object)StringUtil.hexStringFromBytes(msg));
                            }
                            LnPacketizer.this.messageTransmitted(msg);
                            continue;
                        }
                        log.warn("sendLocoNetMessage: no connection established");
                    }
                    catch (IOException e) {
                        log.warn("sendLocoNetMessage: IOException: {}", (Object)e.toString());
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (RuntimeException rt) {
                    log.error("Exception on take() call", (Throwable)rt);
                }
            }
        }
    }

    private static class RcvMemo
    implements ThreadingUtil.ThreadAction {
        LocoNetMessage thisMsg;
        LnTrafficController thisTc;

        public RcvMemo(LocoNetMessage msg, LnTrafficController trafficController) {
            this.thisMsg = msg;
            this.thisTc = trafficController;
        }

        @Override
        public void run() {
            this.thisTc.notify(this.thisMsg);
        }
    }

    protected class RcvHandler
    implements Runnable {
        LnTrafficController trafficController;

        public RcvHandler(LnTrafficController lt) {
            this.trafficController = lt;
        }

        @Override
        public void run() {
            while (!LnPacketizer.this.threadStopRequest && !Thread.interrupted()) {
                try {
                    int opCode;
                    while (((opCode = LnPacketizer.this.readByteProtected(LnPacketizer.this.istream) & 0xFF) & 0x80) == 0) {
                        if (!log.isTraceEnabled()) continue;
                        log.trace("Skipping: {}", (Object)Integer.toHexString(opCode));
                    }
                    if (log.isTraceEnabled()) {
                        log.trace(" (RcvHandler) Start message with opcode: {}", (Object)Integer.toHexString(opCode));
                    }
                    LocoNetMessage msg = null;
                    while (msg == null) {
                        try {
                            int byte2 = LnPacketizer.this.readByteProtected(LnPacketizer.this.istream) & 0xFF;
                            if (log.isTraceEnabled()) {
                                log.trace("Byte2: {}", (Object)Integer.toHexString(byte2));
                            }
                            int len = 2;
                            switch ((opCode & 0x60) >> 5) {
                                case 0: {
                                    len = 2;
                                    break;
                                }
                                case 1: {
                                    len = 4;
                                    break;
                                }
                                case 2: {
                                    len = 6;
                                    break;
                                }
                                case 3: {
                                    if (byte2 < 2) {
                                        log.error("LocoNet message length invalid: {} opcode: {}", (Object)byte2, (Object)Integer.toHexString(opCode));
                                    }
                                    len = byte2;
                                    break;
                                }
                                default: {
                                    log.warn("Unhandled code: {}", (Object)((opCode & 0x60) >> 5));
                                }
                            }
                            msg = new LocoNetMessage(len);
                            msg.setOpCode(opCode);
                            msg.setElement(1, byte2);
                            log.trace("len: {}", (Object)len);
                            for (int i = 2; i < len; ++i) {
                                int b = LnPacketizer.this.readByteProtected(LnPacketizer.this.istream) & 0xFF;
                                if (log.isTraceEnabled()) {
                                    log.trace("char {} is: {}", (Object)i, (Object)Integer.toHexString(b));
                                }
                                if ((b & 0x80) != 0) {
                                    log.warn("LocoNet message with opCode: {} ended early. Expected length: {} seen length: {} unexpected byte: {}", new Object[]{Integer.toHexString(opCode), len, i, Integer.toHexString(b)});
                                    opCode = b;
                                    throw new LocoNetMessageException();
                                }
                                msg.setElement(i, b);
                            }
                        }
                        catch (LocoNetMessageException e) {
                            msg = null;
                        }
                    }
                    if (!msg.checkParity()) {
                        log.warn("Ignore LocoNet packet with bad checksum: {}", (Object)msg);
                        throw new LocoNetMessageException();
                    }
                    log.debug("queue message for notification: {}", (Object)msg);
                    ThreadingUtil.runOnLayoutEventually(new RcvMemo(msg, this.trafficController));
                }
                catch (LocoNetMessageException e) {
                    log.warn("run: unexpected LocoNetMessageException", (Throwable)e);
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    log.info("End of file", (Throwable)e);
                    LnPacketizer.this.dispose();
                    LnPacketizer.this.disconnectPort(LnPacketizer.this.controller);
                    return;
                }
                catch (RuntimeException e) {
                    log.warn("run: unexpected Exception", (Throwable)e);
                }
            }
        }
    }
}

