/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetMessageException;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnPacketizerStrict
extends LnPacketizer {
    private LocoNetMessage waitForMsg;
    private boolean waitingOnLack;
    private int waitBusy;
    private boolean reTryRequired;
    public static int maxWaitCount = 150;
    private static final Logger log = LoggerFactory.getLogger(LnPacketizerStrict.class);

    public LnPacketizerStrict(LocoNetSystemConnectionMemo m) {
        super(m);
    }

    @Override
    public void startThreads() {
        int xmtpriority;
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available = {} default = {} min available = {}", new Object[]{priority, 10, 5, 1});
        int n = xmtpriority = 9 > priority ? 9 : 10;
        if (this.xmtHandler == null) {
            this.xmtHandler = new XmtHandlerStrict();
        }
        this.xmtThread = ThreadingUtil.newThread(this.xmtHandler, "LocoNet transmit handler");
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        this.xmtThread.setDaemon(true);
        this.xmtThread.setPriority(9);
        this.xmtThread.start();
        if (this.rcvHandler == null) {
            this.rcvHandler = new RcvHandlerStrict(this);
        }
        this.rcvThread = ThreadingUtil.newThread(this.rcvHandler, "LocoNet receive handler");
        this.rcvThread.setDaemon(true);
        this.rcvThread.setPriority(10);
        this.rcvThread.start();
        log.info("Strict Packetizer in use");
    }

    class XmtHandlerStrict
    implements Runnable {
        XmtHandlerStrict() {
        }

        @Override
        public void run() {
            block12: while (true) {
                try {
                    while (true) {
                        log.trace("check for input");
                        byte[] msg = (byte[])LnPacketizerStrict.this.xmtList.take();
                        try {
                            if (LnPacketizerStrict.this.ostream != null) {
                                if (!LnPacketizerStrict.this.controller.okToSend()) {
                                    log.debug("LocoNet port not ready to receive");
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug("start write to stream: {}", (Object)StringUtil.hexStringFromBytes(msg));
                                }
                                LnPacketizerStrict.this.reTryRequired = true;
                                int reTryCount = 0;
                                while (LnPacketizerStrict.this.reTryRequired) {
                                    int waitCount;
                                    LnPacketizerStrict.this.reTryRequired = false;
                                    LnPacketizerStrict.this.waitForMsg = new LocoNetMessage(msg);
                                    if ((msg[0] & 8) != 0) {
                                        LnPacketizerStrict.this.waitingOnLack = true;
                                    }
                                    while (LnPacketizerStrict.this.waitBusy != 0) {
                                        int waitTime = LnPacketizerStrict.this.waitBusy;
                                        LnPacketizerStrict.this.waitBusy = 0;
                                        log.warn("Waitbusy");
                                        try {
                                            Thread.sleep(waitTime);
                                        }
                                        catch (InterruptedException ee) {
                                            log.warn("waitBusy sleep Interrupted", (Throwable)ee);
                                        }
                                    }
                                    LnPacketizerStrict.this.ostream.write(msg);
                                    LnPacketizerStrict.this.ostream.flush();
                                    if (log.isTraceEnabled()) {
                                        log.trace("end write to stream: {}", (Object)StringUtil.hexStringFromBytes(msg));
                                    }
                                    for (waitCount = 0; LnPacketizerStrict.this.waitForMsg != null && waitCount < maxWaitCount; ++waitCount) {
                                        try {
                                            Thread.sleep(1L);
                                            continue;
                                        }
                                        catch (InterruptedException ee) {
                                            log.error("waitForMsg sleep Interrupted", (Throwable)ee);
                                        }
                                    }
                                    if (waitCount >= maxWaitCount) {
                                        log.warn("Retry Send for Lost Packet [{}] Count[{}]", (Object)LnPacketizerStrict.this.waitForMsg, (Object)reTryCount);
                                        if (reTryCount < 5) {
                                            LnPacketizerStrict.this.reTryRequired = true;
                                            ++reTryCount;
                                            continue;
                                        }
                                        LnPacketizerStrict.this.reTryRequired = false;
                                        reTryCount = 0;
                                        log.warn("Give up on lost packet");
                                        continue;
                                    }
                                    while (LnPacketizerStrict.this.waitingOnLack && waitCount < 3 * maxWaitCount) {
                                        try {
                                            Thread.sleep(1L);
                                        }
                                        catch (InterruptedException ee) {
                                            log.error("waitingOnLack sleep Interrupted", (Throwable)ee);
                                        }
                                        ++waitCount;
                                    }
                                    if (waitCount < 3 * maxWaitCount) continue;
                                    try {
                                        log.warn("Retry Send for Lost Response Count[{}]", (Object)reTryCount);
                                    }
                                    catch (NullPointerException npe) {
                                        log.warn("Retry Send for waitingOnLack null?  Count[{}]", (Object)reTryCount);
                                    }
                                    if (reTryCount < 5) {
                                        LnPacketizerStrict.this.reTryRequired = true;
                                        ++reTryCount;
                                        continue;
                                    }
                                    log.warn("Give up on Lost Response.");
                                    LnPacketizerStrict.this.reTryRequired = false;
                                    reTryCount = 0;
                                }
                                LnPacketizerStrict.this.messageTransmitted(msg);
                                continue block12;
                            }
                            log.warn("sendLocoNetMessage: no connection established");
                            continue block12;
                        }
                        catch (IOException e) {
                            log.warn("sendLocoNetMessage: IOException: {}", (Object)e.toString());
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    private static class RcvMemo
    implements ThreadingUtil.ThreadAction {
        LocoNetMessage thisMsg;
        LnTrafficController thisTc;

        public RcvMemo(LocoNetMessage msg, LnTrafficController trafficController) {
            this.thisMsg = msg;
            this.thisTc = trafficController;
        }

        @Override
        public void run() {
            this.thisTc.notify(this.thisMsg);
        }
    }

    protected class RcvHandlerStrict
    implements Runnable {
        LnTrafficController trafficController;

        public RcvHandlerStrict(LnTrafficController lt) {
            this.trafficController = lt;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int opCode;
                        if (((opCode = LnPacketizerStrict.this.readByteProtected(LnPacketizerStrict.this.istream) & 0xFF) & 0x80) == 0) {
                            log.trace("Skipping: {}", (Object)Integer.toHexString(opCode));
                            continue;
                        }
                        if (log.isTraceEnabled()) {
                            log.trace(" (RcvHandler) Start message with opcode: {}", (Object)Integer.toHexString(opCode));
                        }
                        LocoNetMessage msg = null;
                        while (msg == null) {
                            try {
                                int byte2 = LnPacketizerStrict.this.readByteProtected(LnPacketizerStrict.this.istream) & 0xFF;
                                if (log.isTraceEnabled()) {
                                    log.trace("Byte2: {}", (Object)Integer.toHexString(byte2));
                                }
                                int len = 2;
                                switch ((opCode & 0x60) >> 5) {
                                    case 0: {
                                        len = 2;
                                        break;
                                    }
                                    case 1: {
                                        len = 4;
                                        break;
                                    }
                                    case 2: {
                                        len = 6;
                                        break;
                                    }
                                    case 3: {
                                        if (byte2 < 2) {
                                            log.error("LocoNet message length invalid: {} opcode: {}", (Object)byte2, (Object)Integer.toHexString(opCode));
                                        }
                                        len = byte2;
                                        break;
                                    }
                                    default: {
                                        log.warn("Unhandled code: {}", (Object)((opCode & 0x60) >> 5));
                                    }
                                }
                                msg = new LocoNetMessage(len);
                                msg.setOpCode(opCode);
                                msg.setElement(1, byte2);
                                log.trace("len: {}", (Object)len);
                                for (int i = 2; i < len; ++i) {
                                    int b = LnPacketizerStrict.this.readByteProtected(LnPacketizerStrict.this.istream) & 0xFF;
                                    if (log.isTraceEnabled()) {
                                        log.trace("char {} is: {}", (Object)i, (Object)Integer.toHexString(b));
                                    }
                                    if ((b & 0x80) != 0) {
                                        log.warn("LocoNet message with opCode: {} ended early. Expected length: {} seen length: {} unexpected byte: {}", new Object[]{Integer.toHexString(opCode), len, i, Integer.toHexString(b)});
                                        opCode = b;
                                        throw new LocoNetMessageException();
                                    }
                                    msg.setElement(i, b);
                                }
                            }
                            catch (LocoNetMessageException e) {
                                msg = null;
                            }
                        }
                        if (!msg.checkParity()) {
                            log.warn("Ignore LocoNet packet with bad checksum: [{}]", (Object)msg.toString());
                            throw new LocoNetMessageException();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("queue message for notification: {}", (Object)msg.toString());
                        }
                        if (LnPacketizerStrict.this.waitForMsg != null && LnPacketizerStrict.this.waitForMsg.equals(msg)) {
                            LnPacketizerStrict.this.waitForMsg = null;
                        }
                        if (LnPacketizerStrict.this.waitingOnLack) {
                            if (msg.getOpCode() == 180) {
                                LnPacketizerStrict.this.waitingOnLack = false;
                                if ((msg.getElement(1) & 0xFF) == 109 && (msg.getElement(2) & 0xFF) == 0) {
                                    LnPacketizerStrict.this.reTryRequired = true;
                                    LnPacketizerStrict.this.waitBusy = 100;
                                    log.warn("IMM Back off");
                                } else {
                                    LnPacketizerStrict.this.reTryRequired = false;
                                }
                            } else if (msg.getOpCode() == 231) {
                                LnPacketizerStrict.this.waitingOnLack = false;
                            } else if (msg.getOpCode() == 230) {
                                LnPacketizerStrict.this.waitingOnLack = false;
                            }
                        } else if (msg.getOpCode() == 129) {
                            LnPacketizerStrict.this.waitBusy = 100;
                            log.warn("CS Busy Back off");
                            LnPacketizerStrict.this.reTryRequired = true;
                        }
                        ThreadingUtil.runOnLayoutEventually(new RcvMemo(msg, this.trafficController));
                    }
                }
                catch (LocoNetMessageException e) {
                    log.warn("run: unexpected LocoNetMessageException", (Throwable)e);
                    continue;
                }
                catch (EOFException | InterruptedIOException e) {
                    continue;
                }
                catch (IOException e) {
                    log.debug("IOException, should only happen with HexFile", (Throwable)e);
                    log.info("End of file");
                    LnPacketizerStrict.this.disconnectPort(LnPacketizerStrict.this.controller);
                    return;
                }
                catch (RuntimeException e) {
                    log.warn("run: unexpected Exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

