/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LnPortController
extends AbstractSerialPortController {
    protected LnCommandStationType commandStationType = null;
    protected boolean mTurnoutNoRetry = false;
    protected boolean mTurnoutExtraSpace = false;
    protected boolean mInterrogateAtStart = true;
    protected boolean mTranspondingAvailable = false;
    protected boolean mLoconetProtocolAutoDetect = true;
    protected LnCommandStationType[] commandStationTypes = new LnCommandStationType[]{LnCommandStationType.COMMAND_STATION_DCS100, LnCommandStationType.COMMAND_STATION_DCS240, LnCommandStationType.COMMAND_STATION_DCS240PLUS, LnCommandStationType.COMMAND_STATION_DCS210, LnCommandStationType.COMMAND_STATION_DCS210PLUS, LnCommandStationType.COMMAND_STATION_DCS200, LnCommandStationType.COMMAND_STATION_DCS050, LnCommandStationType.COMMAND_STATION_DCS051, LnCommandStationType.COMMAND_STATION_DCS052, LnCommandStationType.COMMAND_STATION_DB150, LnCommandStationType.COMMAND_STATION_IBX_TYPE_1, LnCommandStationType.COMMAND_STATION_IBX_TYPE_2, LnCommandStationType.COMMAND_STATION_LBPS, LnCommandStationType.COMMAND_STATION_MM};
    protected String[] commandStationNames = new String[this.commandStationTypes.length];
    private static final Logger log = LoggerFactory.getLogger(LnPortController.class);

    protected LnPortController(LocoNetSystemConnectionMemo connectionMemo) {
        super(connectionMemo);
        int i = 0;
        for (LnCommandStationType type : this.commandStationTypes) {
            this.commandStationNames[i++] = type.getName();
        }
        this.setManufacturer("Digitrax");
    }

    @Override
    public abstract boolean status();

    public boolean okToSend() {
        return true;
    }

    public void setCommandStationType(String name) {
        this.setCommandStationType(LnCommandStationType.getByName(name));
    }

    public void setCommandStationType(LnCommandStationType value) {
        if (value == null) {
            return;
        }
        log.debug("setCommandStationType: {}", (Object)value);
        this.commandStationType = value;
    }

    public void setTurnoutHandling(String value) {
        if (value.equals("One Only") || value.equals(Bundle.getMessage("HandleOneOnly")) || value.equals("Both") || value.equals(Bundle.getMessage("HandleBoth"))) {
            this.mTurnoutNoRetry = true;
        }
        log.debug("turnout no retry: {}", (Object)this.mTurnoutNoRetry);
        if (value.equals("Spread") || value.equals(Bundle.getMessage("HandleSpread")) || value.equals("Both") || value.equals(Bundle.getMessage("HandleBoth"))) {
            this.mTurnoutExtraSpace = true;
        }
        log.debug("turnout extra space: {}", (Object)this.mTurnoutExtraSpace);
    }

    public void setTranspondingAvailable(String value) {
        this.mTranspondingAvailable = value.equals("Yes") || value.equals(Bundle.getMessage("ButtonYes"));
        log.debug("transponding available: {}", (Object)this.mTranspondingAvailable);
    }

    public void setLoconetProtocolAutoDetect(String value) {
        this.mLoconetProtocolAutoDetect = value.equals("Yes") || value.equals(Bundle.getMessage("LoconetProtocolAutoDetect"));
        log.debug("Loconet XPSlots: {}", (Object)this.mLoconetProtocolAutoDetect);
    }

    public void setInterrogateOnStart(String value) {
        this.mInterrogateAtStart = !value.equals("No") && !value.equals(Bundle.getMessage("ButtonNo"));
        log.debug("tInterrogate on Start: {}", (Object)this.mInterrogateAtStart);
    }

    @Override
    public LocoNetSystemConnectionMemo getSystemConnectionMemo() {
        return (LocoNetSystemConnectionMemo)super.getSystemConnectionMemo();
    }
}

