/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.HashSet;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Meter;
import jmri.MeterManager;
import jmri.implementation.DefaultMeter;
import jmri.implementation.MeterUpdateTask;
import jmri.jmrix.loconet.LnMeterInitTask;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotManager;
import jmri.jmrix.loconet.duplexgroup.swing.LnIPLImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnPredefinedMeters
implements LocoNetListener {
    private SlotManager sm = null;
    private LnTrafficController tc = null;
    private final MeterUpdateTask updateTask;
    private final LnMeterInitTask initializationTask;
    private static final Logger log = LoggerFactory.getLogger(LnPredefinedMeters.class);

    public LnPredefinedMeters(LocoNetSystemConnectionMemo scm) {
        this.sm = scm.getSlotManager();
        this.tc = scm.getLnTrafficController();
        this.updateTask = new MeterUpdateTask(30000){

            @Override
            public void requestUpdateFromLayout() {
                LnPredefinedMeters.this.sm.sendReadSlot(249);
            }
        };
        this.tc.addLocoNetListener(-1, this);
        this.updateTask.initTimer();
        this.initializationTask = new LnMeterInitTask(this.sm.tc, 85);
        this.initializationTask.initTimer();
        this.initializationTask.enable();
    }

    @Override
    public void message(LocoNetMessage msg) {
        if (msg.getNumDataElements() != 21 || msg.getOpCode() != 230 || msg.getElement(1) != 21 || msg.getElement(2) != 1 || msg.getElement(3) != 121) {
            return;
        }
        int srcDeviceType = msg.getElement(16);
        if (srcDeviceType == 88 || srcDeviceType == 99 || srcDeviceType == 81) {
            return;
        }
        float valAmps = (float)msg.getElement(6) / 10.0f;
        float valVolts = (float)msg.getElement(4) * 2.0f / 10.0f;
        int srcSerNum = msg.getElement(18) + 128 * msg.getElement(19);
        String voltSysName = this.createSystemName(srcDeviceType, srcSerNum, "Voltage");
        Meter m = (Meter)InstanceManager.getDefault(MeterManager.class).getBySystemName(voltSysName);
        this.updateAddMeter(m, voltSysName, valVolts, true);
        String ampsSysName = this.createSystemName(srcDeviceType, srcSerNum, "InputCurrent");
        m = (Meter)InstanceManager.getDefault(MeterManager.class).getBySystemName(ampsSysName);
        this.updateAddMeter(m, ampsSysName, valAmps, false);
    }

    public void dispose() {
        HashSet meters = new HashSet(InstanceManager.getDefault(MeterManager.class).getNamedBeanSet());
        for (Meter m : meters) {
            if (!m.getSystemName().startsWith(this.sm.getSystemPrefix() + "V")) continue;
            this.updateTask.disable(m);
            InstanceManager.getDefault(MeterManager.class).deregister(m);
            this.updateTask.dispose(m);
        }
    }

    public void requestUpdateFromLayout() {
        log.debug("sending request for voltmeter/ammeter information");
        this.sm.sendReadSlot(249);
    }

    private final String createSystemName(int device, int sn, String typeString) {
        Object devName = LnIPLImplementation.getDeviceName(0, device, 0, 0);
        if (devName == null) {
            devName = "[" + device + "]";
        }
        return this.sm.getSystemPrefix() + "V" + (String)devName + "(s/n" + sn + ")" + typeString;
    }

    private void updateAddMeter(Meter m, String sysName, float value, boolean typeVolt) {
        if (m == null) {
            DefaultMeter newMeter = typeVolt ? new DefaultMeter.DefaultVoltageMeter(sysName, Meter.Unit.NoPrefix, 0.0, 25.4, 0.2, this.updateTask) : new DefaultMeter.DefaultCurrentMeter(sysName, Meter.Unit.NoPrefix, 0.0, 12.7, 0.1, this.updateTask);
            try {
                newMeter.setCommandedAnalogValue(value);
            }
            catch (JmriException e) {
                log.debug("Exception setting {}Meter {} to value {}", new Object[]{typeVolt ? "volt" : "current", sysName, Float.valueOf(value), e});
            }
            InstanceManager.getDefault(MeterManager.class).register(newMeter);
            log.debug("Added new {}Meter {} with value {}", new Object[]{typeVolt ? "volt" : "current", sysName, Float.valueOf(value)});
        } else {
            try {
                m.setCommandedAnalogValue(value);
            }
            catch (JmriException e) {
                log.debug("Exception setting {}Meter {} to value {}", new Object[]{typeVolt ? "volt" : "current", sysName, Float.valueOf(value), e});
            }
            log.debug("Updating currentMeter {} with value {}", (Object)sysName, (Object)Float.valueOf(value));
        }
    }
}

