/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.ProgrammingMode;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.LnDeferProgrammer;
import jmri.jmrix.loconet.LnOpsModeProgrammer;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.managers.DefaultProgrammerManager;

public class LnProgrammerManager
extends DefaultProgrammerManager {
    LocoNetSystemConnectionMemo memo;
    public static final ProgrammingMode LOCONETOPSBOARD = new ProgrammingMode("LOCONETOPSBOARD", Bundle.getMessage("LOCONETOPSBOARD"));
    static final ProgrammingMode LOCONETSV1MODE = new ProgrammingMode("LOCONETSV1MODE", Bundle.getMessage("LOCONETSV1MODE"));
    public static final ProgrammingMode LOCONETSV2MODE = new ProgrammingMode("LOCONETSV2MODE", Bundle.getMessage("LOCONETSV2MODE"));
    public static final ProgrammingMode LOCONETLNCVMODE = new ProgrammingMode("LOCONETLNCVMODE", Bundle.getMessage("LOCONETLNCVMODE"));
    static final ProgrammingMode LOCONETBDOPSWMODE = new ProgrammingMode("LOCONETBDOPSWMODE", Bundle.getMessage("LOCONETBDOPSWMODE"));
    static final ProgrammingMode LOCONETCSOPSWMODE = new ProgrammingMode("LOCONETCSOPSWMODE", Bundle.getMessage("LOCONETCSOPSWMODE"));
    static final ProgrammingMode LOCONETBD7OPSWMODE = new ProgrammingMode("LOCONETBD7OPSWMODE", Bundle.getMessage("LOCONETBD7OPSWMODE"));

    public LnProgrammerManager(LocoNetSystemConnectionMemo memo) {
        super(new LnDeferProgrammer(memo), memo);
        this.memo = memo;
    }

    @Override
    public boolean isAddressedModePossible() {
        return true;
    }

    @Override
    public AddressedProgrammer getAddressedProgrammer(boolean pLongAddress, int pAddress) {
        return new LnOpsModeProgrammer(this.memo, pAddress, pLongAddress);
    }

    @Override
    public AddressedProgrammer reserveAddressedProgrammer(boolean pLongAddress, int pAddress) {
        return null;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getDefaultModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.OPSBYTEMODE);
        ret.add(LOCONETBD7OPSWMODE);
        ret.add(LOCONETOPSBOARD);
        ret.add(LOCONETSV2MODE);
        ret.add(LOCONETSV1MODE);
        ret.add(LOCONETLNCVMODE);
        return ret;
    }
}

