/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jmri.CollectingReporter;
import jmri.DccLocoAddress;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.PhysicalLocationReporter;
import jmri.implementation.AbstractIdTagReporter;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.TranspondingTagManager;
import jmri.util.PhysicalLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnReporter
extends AbstractIdTagReporter
implements CollectingReporter {
    int lastLoco = -1;
    private final int _number;
    private final HashSet<Object> entrySet;
    private static final Logger log = LoggerFactory.getLogger(LnReporter.class);

    public LnReporter(int number, LnTrafficController tc, String prefix) {
        super(prefix + "R" + number);
        log.debug("new Reporter {}", (Object)number);
        this._number = number;
        this.entrySet = new HashSet();
    }

    public int getNumber() {
        return this._number;
    }

    public void messageFromManager(LocoNetMessage l) {
        if (this.isTranspondingLocationReport(l) || this.isTranspondingFindReport(l)) {
            this.transpondingReport(l);
        }
        if (l.getOpCode() == 228) {
            if (l.getElement(1) == 8) {
                this.lissyReport(l);
            } else if (l.getElement(2) == 65) {
                this.lissyRfidReport(l);
            }
        }
    }

    public final boolean isTranspondingLocationReport(LocoNetMessage l) {
        return l.getOpCode() == 208 && (l.getElement(1) & 0xC0) == 0;
    }

    public final boolean isTranspondingFindReport(LocoNetMessage l) {
        return l.getOpCode() == 229 && l.getElement(1) == 9 && l.getElement(2) == 0;
    }

    void transpondingReport(LocoNetMessage l) {
        boolean enter = l.getOpCode() == 208 ? (l.getElement(1) & 0x20) != 0 : true;
        int loco = this.getLocoAddrFromTranspondingMsg(l);
        log.debug("Transponding Report at {} for {}", (Object)this._number, (Object)loco);
        this.notify(null);
        IdTag idTag = InstanceManager.getDefault(TranspondingTagManager.class).provideIdTag("" + loco);
        idTag.setProperty("entryexit", "enter");
        if (enter) {
            idTag.setProperty("entryexit", "enter");
            if (!this.entrySet.contains(idTag)) {
                this.entrySet.add(idTag);
            }
        } else {
            idTag.setProperty("entryexit", "exits");
            if (this.entrySet.contains(idTag)) {
                this.entrySet.remove(idTag);
            }
        }
        log.debug("Tag: {} entry {}", (Object)idTag, (Object)enter);
        this.notify(idTag);
        this.setState(enter ? loco : -1);
    }

    public int getLocoAddrFromTranspondingMsg(LocoNetMessage l) {
        if (l.getElement(3) == 125) {
            return l.getElement(4);
        }
        return l.getElement(3) * 128 + l.getElement(4);
    }

    void lissyReport(LocoNetMessage l) {
        if ((l.getElement(3) & 0x40) != 0) {
            int loco = (l.getElement(6) & 0x7F) + 128 * (l.getElement(5) & 0x7F);
            int category = l.getElement(2) + 1;
            boolean north = (l.getElement(3) & 0x20) == 0;
            this.notify(null);
            IdTag idTag = InstanceManager.getDefault(TranspondingTagManager.class).provideIdTag(loco + ":" + category);
            if (north) {
                idTag.setProperty("seen", "seen northbound");
            } else {
                idTag.setProperty("seen", "seen southbound");
            }
            log.debug("Tag: {}", (Object)idTag);
            this.notify(idTag);
            this.setState(loco);
        }
    }

    void lissyRfidReport(LocoNetMessage l) {
        StringBuilder tg = new StringBuilder();
        int max = l.getElement(1) - 2;
        int rfidHi = l.getElement(max);
        for (int j = 5; j < max; ++j) {
            int shift = j - 5;
            int hi = 0;
            if ((rfidHi >> shift & 1) == 1) {
                hi = 128;
            }
            tg.append(String.format("%1$02X", l.getElement(j) + hi));
        }
        String tag = tg.toString();
        int rfidSensorAddress = l.getElement(3) << 7 | l.getElement(4);
        this.notify(null);
        IdTag idTag = InstanceManager.getDefault(TranspondingTagManager.class).provideIdTag(tag);
        idTag.setProperty("rfid", rfidSensorAddress);
        log.debug("Tag: {}", (Object)idTag);
        this.notify(idTag);
    }

    @Override
    public int getState() {
        return this.lastLoco;
    }

    @Override
    public void setState(int s) {
        this.lastLoco = s;
    }

    private Matcher parseReport(String rep) {
        if (rep == null) {
            return null;
        }
        Pattern ln_p = Pattern.compile("(\\d+) (enter|exits|seen)\\s*(northbound|southbound)?");
        Matcher m = ln_p.matcher(rep);
        return m;
    }

    @Override
    public LocoAddress getLocoAddress(String rep) {
        log.debug("report string: {}", (Object)rep);
        Matcher m = this.parseReport(rep);
        if (m != null && m.find()) {
            log.debug("Parsed address: {}", (Object)m.group(1));
            return new DccLocoAddress(Integer.parseInt(m.group(1)), LocoAddress.Protocol.DCC);
        }
        return null;
    }

    @Override
    public PhysicalLocationReporter.Direction getDirection(String rep) {
        log.debug("report string: {}", (Object)rep);
        Matcher m = this.parseReport(rep);
        if (m.find()) {
            log.debug("Parsed direction: {}", (Object)m.group(2));
            switch (m.group(2)) {
                case "enter": 
                case "seen": {
                    return PhysicalLocationReporter.Direction.ENTER;
                }
            }
            return PhysicalLocationReporter.Direction.EXIT;
        }
        return PhysicalLocationReporter.Direction.UNKNOWN;
    }

    @Override
    public PhysicalLocation getPhysicalLocation() {
        return PhysicalLocation.getBeanPhysicalLocation(this);
    }

    @Override
    public PhysicalLocation getPhysicalLocation(String s) {
        return PhysicalLocation.getBeanPhysicalLocation(this);
    }

    @Override
    public Collection<Object> getCollection() {
        return this.entrySet;
    }
}

