/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.JmriException;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.loconet.LnSensorAddress;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnSensor
extends AbstractSensor {
    private LnSensorAddress a;
    LnTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(LnSensor.class);

    public LnSensor(String systemName, String userName, LnTrafficController tc, String prefix) {
        super(systemName, userName);
        this.tc = tc;
        this.init(systemName, prefix);
    }

    public LnSensor(String systemName, LnTrafficController tc, String prefix) {
        super(systemName);
        this.tc = tc;
        this.init(systemName, prefix);
    }

    private void init(String systemName, String prefix) {
        this.a = new LnSensorAddress(systemName, prefix);
        if (log.isDebugEnabled()) {
            log.debug("create address {}", (Object)this.a);
        }
    }

    @Override
    public void requestUpdateFromLayout() {
    }

    @Override
    public void setKnownState(int s) throws JmriException {
        LocoNetMessage l = new LocoNetMessage(4);
        l.setOpCode(178);
        this.a.insertAddress(l);
        if (s == 2 ^ this._inverted) {
            l.setElement(2, l.getElement(2) | 0x10);
        }
        l.setElement(2, l.getElement(2) | 0x40);
        this.tc.sendLocoNetMessage(l);
    }

    public void messageFromManager(LocoNetMessage l) {
        switch (l.getOpCode()) {
            case 178: {
                int sw1 = l.getElement(1);
                int sw2 = l.getElement(2);
                if (this.a.matchAddress(sw1, sw2)) {
                    boolean state = (sw2 & 0x10) != 0 ^ this._inverted;
                    if (log.isDebugEnabled()) {
                        log.debug("INPUT_REP received with valid address, old state {} new packet {}", (Object)this.getRawState(), (Object)state);
                    }
                    if (state && this.getRawState() != 2) {
                        if (log.isDebugEnabled()) {
                            log.debug("Set ACTIVE");
                        }
                        this.setOwnState(2);
                    } else if (!state && this.getRawState() != 4) {
                        if (log.isDebugEnabled()) {
                            log.debug("Set INACTIVE");
                        }
                        this.setOwnState(4);
                    }
                }
                return;
            }
        }
    }
}

