/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.jmrix.loconet.LocoNetMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnSensorAddress {
    int _low;
    int _high;
    int _as;
    String prefix;
    boolean _valid;
    private static final Logger log = LoggerFactory.getLogger(LnSensorAddress.class);

    public LnSensorAddress(int sw1, int sw2, String prefix) {
        this._as = sw2 & 0x20;
        this._high = sw2 & 0xF;
        this._low = sw1 & 0x7F;
        this._valid = true;
        this.prefix = prefix;
    }

    public LnSensorAddress(String s, String prefix) {
        this._valid = false;
        this.prefix = prefix;
        if (s.startsWith(prefix + "S")) {
            if (s.charAt(s.length() - 1) == 'A') {
                this._as = 32;
                int n = Integer.parseInt(s.substring(prefix.length() + 1, s.length() - 1));
                this._high = n / 128;
                this._low = n & 0x7F;
                this._valid = true;
            } else if (s.charAt(s.length() - 1) == 'S') {
                this._as = 0;
                int n = Integer.parseInt(s.substring(prefix.length() + 1, s.length() - 1));
                this._high = n / 128;
                this._low = n & 0x7F;
                this._valid = true;
            } else {
                char c = s.charAt(s.length() - 2);
                if (c >= 'A' && c <= 'D') {
                    int d = 0;
                    switch (c) {
                        case 'A': {
                            d = 0;
                            break;
                        }
                        case 'B': {
                            d = 1;
                            break;
                        }
                        case 'C': {
                            d = 2;
                            break;
                        }
                        case 'D': {
                            d = 3;
                            break;
                        }
                        default: {
                            log.warn("Unhandled addr code: {}", (Object)Character.valueOf(c));
                        }
                    }
                    int n = Integer.parseInt(s.substring(prefix.length() + 1, s.length() - 2)) * 16 + d * 4 + Integer.parseInt(s.substring(s.length() - 1, s.length()));
                    this._high = n / 128;
                    this._low = (n & 0x7F) / 2;
                    this._as = (n & 1) * 32;
                    this._valid = true;
                } else {
                    int n = Integer.parseInt(s.substring(prefix.length() + 1, s.length())) - 1;
                    this._high = n / 256;
                    this._low = (n & 0xFE) / 2;
                    this._as = (n & 1) * 32;
                    this._valid = true;
                }
            }
        } else {
            this.reportParseError(s);
        }
    }

    void reportParseError(String s) {
        log.error("Can't parse sensor address string: {}", (Object)s);
    }

    public void insertAddress(LocoNetMessage m) {
        m.setElement(1, this.getLowBits());
        m.setElement(2, this.getHighBits() | this.getASBit());
    }

    public boolean matchAddress(int a1, int a2) {
        if (this.getHighBits() != (a2 & 0xF)) {
            return false;
        }
        if (this.getLowBits() != (a1 & 0x7F)) {
            return false;
        }
        return this.getASBit() == (a2 & 0x20);
    }

    protected int asInt() {
        return this._high * 256 + this._low * 2 + (this._as != 0 ? 1 : 0);
    }

    public int getLowBits() {
        return this._low;
    }

    public int getHighBits() {
        return this._high;
    }

    public int getASBit() {
        return this._as;
    }

    public boolean isValid() {
        return this._valid;
    }

    public String toString() {
        return this.getNumericAddress() + ":" + this.getDS54Address() + ":" + this.getBDL16Address();
    }

    public String getNumericAddress() {
        return this.prefix + "S" + (this.asInt() + 1);
    }

    public String getDS54Address() {
        if (this._as != 0) {
            return this.prefix + "S" + (this._high * 128 + this._low) + "A";
        }
        return this.prefix + "S" + (this._high * 128 + this._low) + "S";
    }

    public String getBDL16Address() {
        String letter = null;
        String digit = null;
        switch (this.asInt() & 3) {
            case 0: {
                digit = "0";
                break;
            }
            case 1: {
                digit = "1";
                break;
            }
            case 2: {
                digit = "2";
                break;
            }
            case 3: {
                digit = "3";
                break;
            }
            default: {
                digit = "X";
                log.error("Unexpected digit value: {}", (Object)this.asInt());
            }
        }
        switch ((this.asInt() & 0xC) / 4) {
            case 0: {
                letter = "A";
                break;
            }
            case 1: {
                letter = "B";
                break;
            }
            case 2: {
                letter = "C";
                break;
            }
            case 3: {
                letter = "D";
                break;
            }
            default: {
                letter = "X";
                log.error("Unexpected letter value: {}", (Object)this.asInt());
            }
        }
        return this.prefix + "S" + this.asInt() / 16 + letter + digit;
    }
}

