/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetInterface;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnTrafficRouter
extends LnTrafficController
implements LocoNetListener {
    boolean connected = false;
    private LocoNetInterface destination = null;
    private static final Logger log = LoggerFactory.getLogger(LnTrafficRouter.class);

    public LnTrafficRouter(LocoNetSystemConnectionMemo m) {
        this.memo = m;
        m.setLnTrafficController(this);
    }

    @Override
    public boolean status() {
        return this.connected;
    }

    @Override
    public void sendLocoNetMessage(LocoNetMessage m) {
        ++this.transmittedMsgCount;
        this.destination.sendLocoNetMessage(m);
    }

    @Override
    public void message(LocoNetMessage m) {
        this.notify(m);
    }

    public void connect(LocoNetInterface i) {
        this.destination = i;
        this.connected = true;
        i.addLocoNetListener(-1, this);
    }

    public void disconnectPort(LocoNetInterface i) {
        if (this.destination != i) {
            log.warn("disconnectPort: disconnect called from non-connected LnPortController");
        }
        this.destination = null;
        this.connected = false;
    }

    @Override
    public boolean isXmtBusy() {
        return false;
    }
}

