/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jmri.AddressedProgrammer;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.ProgrammingMode;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrix.ProgrammingTool;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.LnProgrammerManager;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.uhlenbrock.LncvDevice;
import jmri.jmrix.loconet.uhlenbrock.LncvDevices;
import jmri.jmrix.loconet.uhlenbrock.LncvMessageContents;
import jmri.managers.DefaultProgrammerManager;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LncvDevicesManager
extends PropertyChangeSupport
implements LocoNetListener,
Disposable {
    private final LocoNetSystemConnectionMemo memo;
    @GuardedBy(value="this")
    private final LncvDevices lncvDevices;
    static final String ROSTER_THREAD_NAME = "rosterMatchingListLncvDM";
    private static final Logger log = LoggerFactory.getLogger(LncvDevicesManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LncvDevicesManager(@Nonnull LocoNetSystemConnectionMemo memo) {
        this.memo = memo;
        if (memo.getLnTrafficController() != null) {
            memo.getLnTrafficController().addLocoNetListener(-1, this);
        } else {
            log.error("No LocoNet connection available, this tool cannot function");
        }
        LncvDevicesManager lncvDevicesManager = this;
        synchronized (lncvDevicesManager) {
            this.lncvDevices = new LncvDevices();
        }
    }

    public synchronized LncvDevices getDeviceList() {
        return this.lncvDevices;
    }

    public synchronized int getDeviceCount() {
        return this.lncvDevices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDevicesList() {
        LncvDevicesManager lncvDevicesManager = this;
        synchronized (lncvDevicesManager) {
            this.lncvDevices.removeAllDevices();
        }
        ThreadingUtil.runOnLayoutEventually(() -> this.firePropertyChange("DeviceListChanged", true, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(LocoNetMessage m) {
        if (LncvMessageContents.isSupportedLncvMessage(m)) {
            if (LncvMessageContents.extractMessageType(m) == LncvMessageContents.LncvCommand.LNCV_READ_REPLY || LncvMessageContents.extractMessageType(m) == LncvMessageContents.LncvCommand.LNCV_READ_REPLY2) {
                LncvMessageContents contents = new LncvMessageContents(m);
                int art = contents.getLncvArticleNum();
                int addr = -1;
                int cv = contents.getCvNum();
                int val = contents.getCvValue();
                log.debug("LncvDevicesManager got read reply: art:{}, address:{} cv:{} val:{}", new Object[]{art, addr, cv, val});
                if (cv == 0) {
                    addr = val;
                    log.debug("LNCV read reply: device address {} of LNCV returns {}", (Object)addr, (Object)val);
                    LncvDevicesManager lncvDevicesManager = this;
                    synchronized (lncvDevicesManager) {
                        if (this.lncvDevices.addDevice(new LncvDevice(art, addr, cv, val, "", "", -1))) {
                            log.debug("new LncvDevice added to table");
                            for (int i = 0; i < this.lncvDevices.size(); ++i) {
                                LncvDevice dev = this.lncvDevices.getDevice(i);
                                if (dev.getProductID() != art || dev.getDestAddr() != addr) continue;
                                if (dev.getRosterName() != null && dev.getRosterName().isEmpty()) {
                                    log.debug("Looking for prodID {}/adr {} in Roster", (Object)dev.getProductID(), (Object)dev.getDestAddr());
                                    log.debug("Looking for adr {} in Roster", (Object)dev.getDestAddr());
                                    ThreadingUtil.newThread(() -> {
                                        try {
                                            List<RosterEntry> rl = Roster.getDefault().getEntriesMatchingCriteria(Integer.toString(dev.getDestAddr()), null, null, Integer.toString(dev.getProductID()), null);
                                            log.debug("LncvDeviceManager found {} matches in Roster", (Object)rl.size());
                                            if (rl.isEmpty()) {
                                                log.debug("No corresponding RosterEntry found");
                                            } else if (rl.size() == 1) {
                                                log.debug("Matching RosterEntry found");
                                                dev.setRosterEntry(rl.get(0));
                                                String title = rl.get(0).getDecoderModel() + " (" + rl.get(0).getDecoderFamily() + ")";
                                                DecoderFile decoderFile = InstanceManager.getDefault(DecoderIndexFile.class).fileFromTitle(title);
                                                if (decoderFile != null) {
                                                    dev.setDecoderFile(decoderFile);
                                                    log.debug("Attached a decoderfile");
                                                } else {
                                                    log.warn("Could not attach decoderfile {} to entry", (Object)rl.get(0).getFileName());
                                                }
                                            } else {
                                                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("WarnMultipleLncvModsFound", art, dev.getDestAddr(), rl.size()), Bundle.getMessage("WarningTitle"), 2);
                                                log.info("Found multiple matching roster entries. Cannot associate any one to this device.");
                                            }
                                        }
                                        catch (Exception e) {
                                            log.error("Error creating Roster.matchingList: {}", (Object)e.getMessage());
                                        }
                                    }, ROSTER_THREAD_NAME + this.memo.getSystemPrefix()).start();
                                }
                                this.firePropertyChange("DeviceListChanged", true, false);
                            }
                        } else {
                            log.debug("LNCV device was already in list");
                        }
                    }
                } else {
                    log.debug("LNCV device check skipped as value not CV0/module address");
                }
            } else {
                log.debug("LNCV message not a READ REPLY [{}]", (Object)m);
            }
        } else {
            log.debug("LNCV message not recognized");
        }
    }

    public synchronized LncvDevice getDevice(int art, int addr) {
        for (int i = 0; i < this.lncvDevices.size(); ++i) {
            LncvDevice dev = this.lncvDevices.getDevice(i);
            if (dev.getProductID() != art || dev.getDestAddr() != addr) continue;
            return dev;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgrammingResult prepareForSymbolicProgrammer(LncvDevice dev, ProgrammingTool t) {
        LncvDevicesManager lncvDevicesManager = this;
        synchronized (lncvDevicesManager) {
            if (this.lncvDevices.isDeviceExistant(dev) < 0) {
                return ProgrammingResult.FAIL_NO_SUCH_DEVICE;
            }
            int destAddr = dev.getDestAddr();
            if (destAddr == 0) {
                return ProgrammingResult.FAIL_DESTINATION_ADDRESS_IS_ZERO;
            }
            int deviceCount = 0;
            for (LncvDevice d : this.lncvDevices.getDevices()) {
                if (destAddr != d.getDestAddr()) continue;
                ++deviceCount;
            }
            log.debug("prepareForSymbolicProgrammer found {} matches", (Object)deviceCount);
            if (deviceCount > 1) {
                return ProgrammingResult.FAIL_MULTIPLE_DEVICES_SAME_DESTINATION_ADDRESS;
            }
        }
        if (dev.getRosterName() == null || dev.getRosterName().isEmpty()) {
            return ProgrammingResult.FAIL_NO_MATCHING_ROSTER_ENTRY;
        }
        RosterEntry re = Roster.getDefault().entryFromTitle(dev.getRosterName());
        if (re == null) {
            log.warn("Could not open LNSV1 Programmer because {} not found in Roster. Removed from device", (Object)dev.getRosterName());
            dev.setRosterEntry(null);
            ThreadingUtil.runOnLayoutEventually(() -> this.firePropertyChange("DeviceListChanged", true, false));
            return ProgrammingResult.FAIL_NO_MATCHING_ROSTER_ENTRY;
        }
        String name = re.getId();
        DefaultProgrammerManager pm = this.memo.getProgrammerManager();
        if (pm == null) {
            return ProgrammingResult.FAIL_NO_APPROPRIATE_PROGRAMMER;
        }
        AddressedProgrammer p = pm.getAddressedProgrammer(false, dev.getDestAddr());
        if (p == null) {
            return ProgrammingResult.FAIL_NO_ADDRESSED_PROGRAMMER;
        }
        if (!p.getSupportedModes().contains(LnProgrammerManager.LOCONETLNCVMODE)) {
            return ProgrammingResult.FAIL_NO_LNCV_PROGRAMMER;
        }
        p.setMode(LnProgrammerManager.LOCONETLNCVMODE);
        ProgrammingMode prgMode = p.getMode();
        if (!prgMode.equals(LnProgrammerManager.LOCONETLNCVMODE)) {
            return ProgrammingResult.FAIL_NO_LNCV_PROGRAMMER;
        }
        t.openPaneOpsProgFrame(re, name, "programmers/Comprehensive.xml", p);
        return ProgrammingResult.SUCCESS_PROGRAMMER_OPENED;
    }

    @Override
    public void dispose() {
        if (this.memo.getLnTrafficController() != null) {
            this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
        }
    }

    public static enum ProgrammingResult {
        SUCCESS_PROGRAMMER_OPENED,
        FAIL_NO_SUCH_DEVICE,
        FAIL_NO_APPROPRIATE_PROGRAMMER,
        FAIL_NO_MATCHING_ROSTER_ENTRY,
        FAIL_DESTINATION_ADDRESS_IS_ZERO,
        FAIL_MULTIPLE_DEVICES_SAME_DESTINATION_ADDRESS,
        FAIL_NO_ADDRESSED_PROGRAMMER,
        FAIL_NO_LNCV_PROGRAMMER;

    }
}

