/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jmri.AddressedProgrammer;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.ProgrammingMode;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrix.ProgrammingTool;
import jmri.jmrix.loconet.Bundle;
import jmri.jmrix.loconet.LnProgrammerManager;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.lnsvf1.Lnsv1Device;
import jmri.jmrix.loconet.lnsvf1.Lnsv1Devices;
import jmri.jmrix.loconet.lnsvf1.Lnsv1MessageContents;
import jmri.managers.DefaultProgrammerManager;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lnsv1DevicesManager
extends PropertyChangeSupport
implements LocoNetListener,
Disposable {
    private final LocoNetSystemConnectionMemo memo;
    @GuardedBy(value="this")
    private final Lnsv1Devices lnsv1Devices;
    static final String ROSTER_THREAD_NAME = "rosterMatchingListLnsv1DM";
    private static final Logger log = LoggerFactory.getLogger(Lnsv1DevicesManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lnsv1DevicesManager(@Nonnull LocoNetSystemConnectionMemo memo) {
        this.memo = memo;
        if (memo.getLnTrafficController() != null) {
            memo.getLnTrafficController().addLocoNetListener(-1, this);
        } else {
            log.error("No LocoNet connection available, this tool cannot function");
        }
        Lnsv1DevicesManager lnsv1DevicesManager = this;
        synchronized (lnsv1DevicesManager) {
            this.lnsv1Devices = new Lnsv1Devices();
        }
    }

    public synchronized Lnsv1Devices getDeviceList() {
        return this.lnsv1Devices;
    }

    public synchronized int getDeviceCount() {
        return this.lnsv1Devices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDevicesList() {
        Lnsv1DevicesManager lnsv1DevicesManager = this;
        synchronized (lnsv1DevicesManager) {
            this.lnsv1Devices.removeAllDevices();
        }
        ThreadingUtil.runOnLayoutEventually(() -> this.firePropertyChange("DeviceListChanged", true, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(LocoNetMessage m) {
        if (Lnsv1MessageContents.isSupportedSv1Message(m)) {
            if (Lnsv1MessageContents.extractMessageType(m) == Lnsv1MessageContents.Sv1Command.SV1_READ && Lnsv1MessageContents.extractMessageVersion(m) > 0) {
                Lnsv1MessageContents contents = new Lnsv1MessageContents(m);
                int vrs = contents.getVersionNum();
                int addrL = contents.getSrcL();
                int subAddr = contents.getSubAddress();
                int sv = contents.getSvNum();
                int val = contents.getSvValue();
                log.debug("Lnsv1DevicesManager got read reply: vrs:{}, address:{}/{} cv:{} val:{}", new Object[]{vrs, addrL, subAddr, sv, val});
                Lnsv1DevicesManager lnsv1DevicesManager = this;
                synchronized (lnsv1DevicesManager) {
                    if (this.lnsv1Devices.addDevice(new Lnsv1Device(addrL, subAddr, sv, val, "", "", vrs))) {
                        log.debug("new Lnsv1Device added to table");
                        for (int i = 0; i < this.lnsv1Devices.size(); ++i) {
                            Lnsv1Device dev = this.lnsv1Devices.getDevice(i);
                            if (dev.getDestAddrLow() != addrL || dev.getDestAddrHigh() != subAddr) continue;
                            log.debug("Looking for adr {} in Roster", (Object)dev.getDestAddr());
                            ThreadingUtil.newThread(() -> {
                                try {
                                    List<RosterEntry> rl = Roster.getDefault().getEntriesMatchingCriteria(Integer.toString(dev.getDestAddr()), null, null, null, null);
                                    log.debug("Lnsv1DeviceManager found {} matches in Roster", (Object)rl.size());
                                    if (rl.isEmpty()) {
                                        log.debug("No corresponding roster entry found");
                                    } else if (rl.size() == 1) {
                                        log.debug("Matching roster entry found");
                                        dev.setRosterEntry(rl.get(0));
                                        String title = rl.get(0).getDecoderModel() + " (" + rl.get(0).getDecoderFamily() + ")";
                                        DecoderFile decoderFile = InstanceManager.getDefault(DecoderIndexFile.class).fileFromTitle(title);
                                        if (decoderFile != null) {
                                            dev.setDecoderFile(decoderFile);
                                            log.debug("Attached a decoderfile");
                                        } else {
                                            log.warn("Could not attach decoderfile {} to entry", (Object)rl.get(0).getFileName());
                                        }
                                    } else {
                                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("WarnMultipleLnsv1ModsFound", rl.size(), addrL, subAddr), Bundle.getMessage("WarningTitle"), 2);
                                        log.info("Found multiple matching LNSV1 roster entries. Cannot associate any one to this device.");
                                    }
                                }
                                catch (Exception e) {
                                    log.error("Error creating Roster.matchingList: {}", (Object)e.getMessage());
                                }
                            }, ROSTER_THREAD_NAME + this.memo.getSystemPrefix()).start();
                            this.firePropertyChange("DeviceListChanged", true, false);
                        }
                    } else {
                        log.debug("LNSV1 device was already in list");
                    }
                }
            } else {
                log.debug("LNSV1 message not a READ REPLY [{}]", (Object)m);
            }
        } else {
            log.debug("LNSV1 message not recognized");
        }
    }

    public synchronized Lnsv1Device getDevice(int vrs, int addr) {
        for (int i = 0; i < this.lnsv1Devices.size(); ++i) {
            Lnsv1Device dev = this.lnsv1Devices.getDevice(i);
            if (dev.getSwVersion() != vrs || dev.getDestAddr() != addr) continue;
            return dev;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgrammingResult prepareForSymbolicProgrammer(Lnsv1Device dev, ProgrammingTool t) {
        Lnsv1DevicesManager lnsv1DevicesManager = this;
        synchronized (lnsv1DevicesManager) {
            if (this.lnsv1Devices.isDeviceExistant(dev) < 0) {
                return ProgrammingResult.FAIL_NO_SUCH_DEVICE;
            }
            int destAddr = dev.getDestAddr();
            if (destAddr == 0) {
                return ProgrammingResult.FAIL_DESTINATION_ADDRESS_IS_ZERO;
            }
            int deviceCount = 0;
            for (Lnsv1Device d : this.lnsv1Devices.getDevices()) {
                if (destAddr != d.getDestAddr()) continue;
                ++deviceCount;
            }
            log.debug("prepareForSymbolicProgrammer found {} matches", (Object)deviceCount);
            if (deviceCount > 1) {
                return ProgrammingResult.FAIL_MULTIPLE_DEVICES_SAME_DESTINATION_ADDRESS;
            }
        }
        if (dev.getRosterName() == null || dev.getRosterName().isEmpty()) {
            return ProgrammingResult.FAIL_NO_MATCHING_ROSTER_ENTRY;
        }
        RosterEntry re = Roster.getDefault().entryFromTitle(dev.getRosterName());
        if (re == null) {
            log.warn("Could not open LNSV1 Programmer because {} not found in Roster. Removed from device", (Object)dev.getRosterName());
            dev.setRosterEntry(null);
            ThreadingUtil.runOnLayoutEventually(() -> this.firePropertyChange("DeviceListChanged", true, false));
            return ProgrammingResult.FAIL_NO_MATCHING_ROSTER_ENTRY;
        }
        String name = re.getId();
        DefaultProgrammerManager pm = this.memo.getProgrammerManager();
        if (pm == null) {
            return ProgrammingResult.FAIL_NO_APPROPRIATE_PROGRAMMER;
        }
        AddressedProgrammer p = pm.getAddressedProgrammer(false, dev.getDestAddr());
        if (p == null) {
            return ProgrammingResult.FAIL_NO_ADDRESSED_PROGRAMMER;
        }
        if (!p.getSupportedModes().contains(LnProgrammerManager.LOCONETOPSBOARD)) {
            return ProgrammingResult.FAIL_NO_LNSV1_PROGRAMMER;
        }
        p.setMode(LnProgrammerManager.LOCONETSV1MODE);
        ProgrammingMode prgMode = p.getMode();
        if (!prgMode.equals(LnProgrammerManager.LOCONETSV1MODE)) {
            return ProgrammingResult.FAIL_NO_LNSV1_PROGRAMMER;
        }
        t.openPaneOpsProgFrame(re, name, "programmers/Comprehensive.xml", p);
        return ProgrammingResult.SUCCESS_PROGRAMMER_OPENED;
    }

    @Override
    public void dispose() {
        if (this.memo.getLnTrafficController() != null) {
            this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
        }
    }

    public static enum ProgrammingResult {
        SUCCESS_PROGRAMMER_OPENED,
        FAIL_NO_SUCH_DEVICE,
        FAIL_NO_APPROPRIATE_PROGRAMMER,
        FAIL_NO_MATCHING_ROSTER_ENTRY,
        FAIL_DESTINATION_ADDRESS_IS_ZERO,
        FAIL_MULTIPLE_DEVICES_SAME_DESTINATION_ADDRESS,
        FAIL_NO_ADDRESSED_PROGRAMMER,
        FAIL_NO_LNSV1_PROGRAMMER;

    }
}

