/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import jmri.jmrix.loconet.LocoNetException;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.SlotListener;
import jmri.jmrix.loconet.SlotMapEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoNetSlot {
    boolean localF9 = false;
    boolean localF10 = false;
    boolean localF11 = false;
    boolean localF12 = false;
    boolean localF13 = false;
    boolean localF14 = false;
    boolean localF15 = false;
    boolean localF16 = false;
    boolean localF17 = false;
    boolean localF18 = false;
    boolean localF19 = false;
    boolean localF20 = false;
    boolean localF21 = false;
    boolean localF22 = false;
    boolean localF23 = false;
    boolean localF24 = false;
    boolean localF25 = false;
    boolean localF26 = false;
    boolean localF27 = false;
    boolean localF28 = false;
    private final int slot;
    private boolean isInitialized;
    private int loconetProtocol;
    private SlotMapEntry.SlotType slotType;
    private int stat;
    private int addr;
    private int spd;
    private int dirf;
    private int trk = 7;
    private int ss2;
    private int snd;
    private int id;
    private int expandedThrottleControllingID;
    private int leadSlot;
    private int _pcmd;
    private long lastUpdateTime;
    private final List<SlotListener> slotListeners = new ArrayList<SlotListener>();
    private static final Logger log = LoggerFactory.getLogger(LocoNetSlot.class);

    public LocoNetSlot(int slotNum) {
        this(slotNum, 0);
    }

    public LocoNetSlot(int slotNum, int inLoconetProtocol) {
        this(slotNum, inLoconetProtocol, SlotMapEntry.SlotType.LOCO);
        this.slotType = slotNum == 0 || slotNum > 120 && this.slot < 128 || slotNum > 247 && slotNum < 257 || slotNum > 375 && slotNum < 385 ? SlotMapEntry.SlotType.SYSTEM : SlotMapEntry.SlotType.LOCO;
    }

    public LocoNetSlot(int slotNum, int inLoconetProtocol, SlotMapEntry.SlotType inSlotType) {
        this.slot = slotNum;
        this.loconetProtocol = inLoconetProtocol;
        if (slotNum > 127) {
            this.loconetProtocol = 2;
        }
        this.slotType = inSlotType;
    }

    public LocoNetSlot(LocoNetMessage l) throws LocoNetException {
        if (l.getOpCode() == 231 || l.getOpCode() == 239) {
            this.slot = l.getElement(2);
            this.loconetProtocol = 1;
        } else if (l.getOpCode() == 230 || l.getOpCode() == 238) {
            this.slot = (l.getElement(2) & 3) * 128 + l.getElement(3);
            this.loconetProtocol = 2;
        } else {
            throw new LocoNetException("Invalid loconet message for setting up a slot");
        }
        this.setSlot(l);
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlotType(SlotMapEntry.SlotType value) {
        this.slotType = value;
    }

    public boolean isSystemSlot() {
        return this.slotType == SlotMapEntry.SlotType.SYSTEM;
    }

    public SlotMapEntry.SlotType getSlotType() {
        return this.slotType;
    }

    public int getProtocol() {
        return this.loconetProtocol;
    }

    protected void setProtocol(int value) {
        this.loconetProtocol = value;
    }

    public int decoderType() {
        return this.stat & 7;
    }

    public int slotStatus() {
        return this.stat & 0x30;
    }

    public int ss2() {
        return this.ss2;
    }

    public boolean getIsInitilized() {
        return this.isInitialized;
    }

    protected void setIsInitialized(boolean state) {
        this.isInitialized = state;
    }

    public int consistStatus() {
        return this.stat & 0x48;
    }

    public boolean isForward() {
        return 0 == (this.dirf & 0x20);
    }

    private boolean[] getFuncArray() {
        return new boolean[]{this.isF0(), this.isF1(), this.isF2(), this.isF3(), this.isF4(), this.isF5(), this.isF6(), this.isF7(), this.isF8(), this.isF9(), this.isF10(), this.isF11(), this.isF12(), this.isF13(), this.isF14(), this.isF15(), this.isF16(), this.isF17(), this.isF18(), this.isF19(), this.isF20(), this.isF21(), this.isF22(), this.isF23(), this.isF24(), this.isF25(), this.isF26(), this.isF27(), this.isF28()};
    }

    public boolean isFunction(int Fn) {
        return this.getFuncArray()[Fn];
    }

    public boolean isF0() {
        return 0 != (this.dirf & 0x10);
    }

    public boolean isF1() {
        return 0 != (this.dirf & 1);
    }

    public boolean isF2() {
        return 0 != (this.dirf & 2);
    }

    public boolean isF3() {
        return 0 != (this.dirf & 4);
    }

    public boolean isF4() {
        return 0 != (this.dirf & 8);
    }

    public boolean isF5() {
        return 0 != (this.snd & 1);
    }

    public boolean isF6() {
        return 0 != (this.snd & 2);
    }

    public boolean isF7() {
        return 0 != (this.snd & 4);
    }

    public boolean isF8() {
        return 0 != (this.snd & 8);
    }

    public boolean isF9() {
        return this.localF9;
    }

    public boolean isF10() {
        return this.localF10;
    }

    public boolean isF11() {
        return this.localF11;
    }

    public boolean isF12() {
        return this.localF12;
    }

    public boolean isF13() {
        return this.localF13;
    }

    public boolean isF14() {
        return this.localF14;
    }

    public boolean isF15() {
        return this.localF15;
    }

    public boolean isF16() {
        return this.localF16;
    }

    public boolean isF17() {
        return this.localF17;
    }

    public boolean isF18() {
        return this.localF18;
    }

    public boolean isF19() {
        return this.localF19;
    }

    public boolean isF20() {
        return this.localF20;
    }

    public boolean isF21() {
        return this.localF21;
    }

    public boolean isF22() {
        return this.localF22;
    }

    public boolean isF23() {
        return this.localF23;
    }

    public boolean isF24() {
        return this.localF24;
    }

    public boolean isF25() {
        return this.localF25;
    }

    public boolean isF26() {
        return this.localF26;
    }

    public boolean isF27() {
        return this.localF27;
    }

    public boolean isF28() {
        return this.localF28;
    }

    public int locoAddr() {
        return this.addr;
    }

    public int speed() {
        return this.spd;
    }

    public int dirf() {
        return this.dirf;
    }

    public int snd() {
        return this.snd;
    }

    public int id() {
        return this.id;
    }

    public int pcmd() {
        return this._pcmd;
    }

    public int cvval() {
        return this.snd + (this.ss2 & 2) * 64;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public void setSlot(LocoNetMessage l) throws LocoNetException {
        if (this.slotType != SlotMapEntry.SlotType.LOCO && this.slotType != SlotMapEntry.SlotType.SYSTEM) {
            this.slotType = SlotMapEntry.SlotType.LOCO;
            log.warn("Slot [{}] not in map but reports loco, check command station type", (Object)this.slot);
        }
        switch (l.getOpCode()) {
            case 213: {
                if (l.getElement(3) != this.expandedThrottleControllingID) {
                    log.debug("OPC_EXP_SEND_FUNCTION_OR_SPEED_AND_DIR for slot[{}] sent from throttle[{}], slot owned by [{}]", new Object[]{this.slot, l.getElement(3), this.expandedThrottleControllingID});
                    return;
                }
                if ((l.getElement(1) & 0xF0) == 0 && (this.stat & 0x48) != 72 && (this.stat & 0x48) != 64) {
                    this.spd = l.getElement(4);
                    this.dirf &= 0xDF;
                    if ((l.getElement(1) & 8) != 0) {
                        this.dirf |= 0x20;
                    }
                } else if ((l.getElement(1) & 0xF8) == 16) {
                    this.dirf &= 0xE0;
                    this.dirf |= l.getElement(4) & 0x1F;
                    this.snd &= 0xFC;
                    this.snd |= (l.getElement(4) & 0x60) >> 5;
                } else if ((l.getElement(1) & 0xF8) == 24) {
                    this.snd &= 0xF3;
                    this.snd |= (l.getElement(4) & 3) << 2;
                    this.localF9 = (l.getElement(4) & 4) != 0;
                    this.localF10 = (l.getElement(4) & 8) != 0;
                    this.localF11 = (l.getElement(4) & 0x10) != 0;
                    this.localF12 = (l.getElement(4) & 0x20) != 0;
                    this.localF13 = (l.getElement(4) & 0x40) != 0;
                } else if ((l.getElement(1) & 0xF8) == 32) {
                    this.localF14 = (l.getElement(4) & 1) != 0;
                    this.localF15 = (l.getElement(4) & 2) != 0;
                    this.localF16 = (l.getElement(4) & 4) != 0;
                    this.localF17 = (l.getElement(4) & 8) != 0;
                    this.localF18 = (l.getElement(4) & 0x10) != 0;
                    this.localF19 = (l.getElement(4) & 0x20) != 0;
                    this.localF20 = (l.getElement(4) & 0x40) != 0;
                } else if ((l.getElement(1) & 0xF8) == 40 || (l.getElement(1) & 0xF8) == 48) {
                    this.localF21 = (l.getElement(4) & 1) != 0;
                    this.localF22 = (l.getElement(4) & 2) != 0;
                    this.localF23 = (l.getElement(4) & 4) != 0;
                    this.localF24 = (l.getElement(4) & 8) != 0;
                    this.localF25 = (l.getElement(4) & 0x10) != 0;
                    this.localF26 = (l.getElement(4) & 0x20) != 0;
                    this.localF27 = (l.getElement(4) & 0x40) != 0;
                    this.localF28 = (l.getElement(1) & 0x10) != 0;
                }
                this.notifySlotListeners();
                break;
            }
            case 230: 
            case 238: {
                this.lastUpdateTime = System.currentTimeMillis();
                this.stat = l.getElement(4);
                this.addr = l.getElement(5) + 128 * l.getElement(6);
                this.spd = l.getElement(8);
                if (this.loconetProtocol == 0) {
                    this.loconetProtocol = 2;
                }
                this.dirf = l.getElement(10) & 0x3F;
                this.id = l.getElement(18) + 128 * l.getElement(19);
                this.expandedThrottleControllingID = l.getElement(18);
                this.snd &= 0xFC;
                this.snd |= (l.getElement(11) & 0x60) >> 5;
                this.snd = l.getElement(11) & 0xF;
                this.trk = l.getElement(7);
                this.localF9 = (l.getElement(11) & 0x10) != 0;
                this.localF10 = (l.getElement(11) & 0x20) != 0;
                this.localF11 = (l.getElement(11) & 0x40) != 0;
                this.localF12 = (l.getElement(9) & 0x10) != 0;
                this.localF13 = (l.getElement(12) & 1) != 0;
                this.localF14 = (l.getElement(12) & 2) != 0;
                this.localF15 = (l.getElement(12) & 4) != 0;
                this.localF16 = (l.getElement(12) & 8) != 0;
                this.localF17 = (l.getElement(12) & 0x10) != 0;
                this.localF18 = (l.getElement(12) & 0x20) != 0;
                this.localF19 = (l.getElement(12) & 0x40) != 0;
                this.localF20 = (l.getElement(9) & 0x20) != 0;
                this.localF21 = (l.getElement(13) & 1) != 0;
                this.localF22 = (l.getElement(13) & 2) != 0;
                this.localF23 = (l.getElement(13) & 4) != 0;
                this.localF24 = (l.getElement(13) & 8) != 0;
                this.localF25 = (l.getElement(13) & 0x10) != 0;
                this.localF26 = (l.getElement(13) & 0x20) != 0;
                this.localF27 = (l.getElement(13) & 0x40) != 0;
                this.localF28 = (l.getElement(9) & 0x40) != 0;
                this.leadSlot = (l.getElement(9) & 3) * 128 + l.getElement(8);
                this.notifySlotListeners();
                break;
            }
            case 231: {
                this.lastUpdateTime = System.currentTimeMillis();
            }
            case 239: {
                if (l.getElement(1) != 14) {
                    return;
                }
                if (this.slot != l.getElement(2)) {
                    log.error("Asked to handle message not for this slot ({}) {}", (Object)this.slot, (Object)l);
                }
                if (this.loconetProtocol == 0) {
                    this.loconetProtocol = 1;
                }
                this.stat = l.getElement(3);
                this._pcmd = l.getElement(4);
                this.addr = l.getElement(4) + 128 * l.getElement(9);
                this.spd = l.getElement(5);
                this.dirf = l.getElement(6);
                this.trk = l.getElement(7);
                this.ss2 = l.getElement(8);
                this.snd = l.getElement(10);
                this.id = l.getElement(11) + 128 * l.getElement(12);
                this.expandedThrottleControllingID = l.getElement(11);
                this.notifySlotListeners();
                return;
            }
            case 181: {
                if (this.slot != l.getElement(1)) {
                    log.error("Asked to handle message not for this slot {}", (Object)l);
                }
                this.stat = l.getElement(2);
                this.notifySlotListeners();
                this.lastUpdateTime = System.currentTimeMillis();
                return;
            }
            case 162: {
                this.snd &= 0xFFFFFFF0;
                this.snd |= 0xF & l.getElement(2);
                this.notifySlotListeners();
                this.lastUpdateTime = System.currentTimeMillis();
                return;
            }
            case 161: {
                if ((this.stat & 0x48) == 72 || (this.stat & 0x48) == 64) {
                    this.dirf &= 0xFFFFFFE0;
                    this.dirf += 0x1F & l.getElement(2);
                } else {
                    this.dirf &= 0xFFFFFFC0;
                    this.dirf += 0x3F & l.getElement(2);
                }
                this.notifySlotListeners();
                this.lastUpdateTime = System.currentTimeMillis();
                return;
            }
            case 184: 
            case 185: 
            case 186: {
                this.lastUpdateTime = System.currentTimeMillis();
                this.notifySlotListeners();
                return;
            }
            case 160: {
                if ((this.stat & 0x48) != 72 && (this.stat & 0x48) != 64) {
                    this.spd = l.getElement(2);
                    this.notifySlotListeners();
                    this.lastUpdateTime = System.currentTimeMillis();
                } else {
                    log.info("Ignoring speed change for slot {} marked as consist-mid or consist-sub.", (Object)this.slot);
                }
                return;
            }
            case 182: {
                if ((this.stat & 0x48) == 72 || (this.stat & 0x48) == 64) {
                    this.dirf &= 0xFFFFFFE0;
                    this.dirf += 0x1F & l.getElement(2);
                    this.notifySlotListeners();
                    this.lastUpdateTime = System.currentTimeMillis();
                }
                return;
            }
            case 212: {
                if (l.getElement(1) == 32) {
                    int data = l.getElement(4);
                    switch (l.getElement(3)) {
                        case 7: {
                            this.localF9 = (data & 0x10) != 0;
                            this.localF10 = (data & 0x20) != 0;
                            this.localF11 = (data & 0x40) != 0;
                            return;
                        }
                        case 8: {
                            this.localF13 = (data & 1) != 0;
                            this.localF14 = (data & 2) != 0;
                            this.localF15 = (data & 4) != 0;
                            this.localF16 = (data & 8) != 0;
                            this.localF17 = (data & 0x10) != 0;
                            this.localF18 = (data & 0x20) != 0;
                            this.localF19 = (data & 0x40) != 0;
                            return;
                        }
                        case 9: {
                            this.localF21 = (data & 1) != 0;
                            this.localF22 = (data & 2) != 0;
                            this.localF23 = (data & 4) != 0;
                            this.localF24 = (data & 8) != 0;
                            this.localF25 = (data & 0x10) != 0;
                            this.localF26 = (data & 0x20) != 0;
                            this.localF27 = (data & 0x40) != 0;
                            return;
                        }
                        case 5: {
                            this.localF12 = (data & 0x10) != 0;
                            this.localF20 = (data & 0x20) != 0;
                            this.localF28 = (data & 0x40) != 0;
                            return;
                        }
                    }
                    log.debug("Found IB RE_OPC_IB2_SPECIAL message of {}", (Object)l);
                    return;
                }
                int src = this.slot;
                int dest = (l.getElement(3) & 7) * 128 + (l.getElement(4) & 0x7F);
                if ((l.getElement(1) & 0xF8) == 56) {
                    if ((l.getElement(3) & 0x70) == 96) {
                        this.stat = l.getElement(4);
                        this.notifySlotListeners();
                        return;
                    }
                    if ((l.getElement(3) & 0x70) == 80) {
                        return;
                    }
                    if ((l.getElement(3) & 0x70) == 64) {
                        this.stat |= 8;
                        this.notifySlotListeners();
                        return;
                    }
                    if (src == 0 && dest == 0) {
                        this.stat &= 0xFFFFFFCF;
                        log.debug("set idle");
                        this.notifySlotListeners();
                        return;
                    }
                }
                return;
            }
            default: {
                throw new LocoNetException("message can't be parsed");
            }
        }
    }

    public void functionMessage(long pkt) {
        if ((pkt & 0xFFFFFF0L) == 160L) {
            this.localF9 = (pkt & 1L) != 0L;
            this.localF10 = (pkt & 2L) != 0L;
            this.localF11 = (pkt & 4L) != 0L;
            this.localF12 = (pkt & 8L) != 0L;
            this.notifySlotListeners();
        } else if ((pkt & 0xFFFFFFFFFFFFFF00L) == 56832L) {
            this.localF13 = (pkt & 1L) != 0L;
            this.localF14 = (pkt & 2L) != 0L;
            this.localF15 = (pkt & 4L) != 0L;
            this.localF16 = (pkt & 8L) != 0L;
            this.localF17 = (pkt & 0x10L) != 0L;
            this.localF18 = (pkt & 0x20L) != 0L;
            this.localF19 = (pkt & 0x40L) != 0L;
            this.localF20 = (pkt & 0x80L) != 0L;
            this.notifySlotListeners();
        } else if ((pkt & 0xFFFFFFFFFFFFFF00L) == 57088L) {
            this.localF21 = (pkt & 1L) != 0L;
            this.localF22 = (pkt & 2L) != 0L;
            this.localF23 = (pkt & 4L) != 0L;
            this.localF24 = (pkt & 8L) != 0L;
            this.localF25 = (pkt & 0x10L) != 0L;
            this.localF26 = (pkt & 0x20L) != 0L;
            this.localF27 = (pkt & 0x40L) != 0L;
            this.localF28 = (pkt & 0x80L) != 0L;
            this.notifySlotListeners();
        }
    }

    public LocoNetMessage writeMode(int status) {
        if (this.loconetProtocol != 2) {
            LocoNetMessage l = new LocoNetMessage(4);
            l.setOpCode(181);
            l.setElement(1, this.slot);
            l.setElement(2, this.stat & 0xFFFFFFF8 | status);
            return l;
        }
        LocoNetMessage l = new LocoNetMessage(6);
        l.setOpCode(212);
        l.setElement(1, this.slot / 128 & 3 | 0x38);
        l.setElement(2, this.slot & 0x7F);
        l.setElement(3, 96);
        l.setElement(4, this.stat & 0xFFFFFFF8 | status);
        return l;
    }

    public LocoNetMessage writeThrottleID(int newID) {
        this.id = newID & 0x17F;
        return this.writeSlot();
    }

    public void setThrottleIdentity(int throttleId) {
        this.id = throttleId;
    }

    public int getThrottleIdentity() {
        return this.id;
    }

    public int getLeadSlot() {
        return this.leadSlot;
    }

    public LocoNetMessage writeStatus(int status) {
        if (this.loconetProtocol != 2) {
            LocoNetMessage l = new LocoNetMessage(4);
            l.setOpCode(181);
            l.setElement(1, this.slot);
            l.setElement(2, this.stat & 0xFFFFFFCF | status);
            return l;
        }
        LocoNetMessage l = new LocoNetMessage(6);
        l.setOpCode(212);
        l.setElement(1, this.slot / 128 & 3 | 0x38);
        l.setElement(2, this.slot & 0x7F);
        l.setElement(3, 96);
        l.setElement(4, this.stat & 0xFFFFFFCF | status);
        return l;
    }

    public LocoNetMessage writeSpeed(int speed) {
        if (this.loconetProtocol != 2) {
            LocoNetMessage l = new LocoNetMessage(4);
            l.setOpCode(160);
            l.setElement(1, this.slot);
            l.setElement(2, speed);
            return l;
        }
        LocoNetMessage l = new LocoNetMessage(6);
        l.setOpCode(213);
        l.setElement(1, this.slot / 128 & 3 | (this.dirf & 0x20) >> 2);
        l.setElement(2, this.slot & 0x7F);
        l.setElement(3, this.id & 0x7F);
        l.setElement(4, speed);
        return l;
    }

    public LocoNetMessage dispatchSlot() {
        if (this.loconetProtocol != 2) {
            LocoNetMessage l = new LocoNetMessage(4);
            l.setOpCode(186);
            l.setElement(1, this.slot);
            l.setElement(2, 0);
            return l;
        }
        LocoNetMessage l = new LocoNetMessage(6);
        l.setOpCode(212);
        l.setElement(1, this.slot / 128 & 3 | 0x38);
        l.setElement(2, this.slot & 0x7F);
        l.setElement(3, 0);
        l.setElement(4, 0);
        return l;
    }

    public LocoNetMessage writeNullMove() {
        if (this.loconetProtocol != 2) {
            LocoNetMessage msg = new LocoNetMessage(4);
            msg.setOpCode(186);
            msg.setElement(1, this.slot);
            msg.setElement(2, this.slot);
            return msg;
        }
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(212);
        msg.setElement(1, this.slot / 128 | 0x38);
        msg.setElement(2, this.slot & 0x7F);
        msg.setElement(3, this.slot / 128 & 7);
        msg.setElement(4, this.slot & 0x7F);
        return msg;
    }

    public LocoNetMessage releaseSlot() {
        return this.writeStatus(16);
    }

    public LocoNetMessage writeSlot() {
        if (this.loconetProtocol != 2 || this.slot == 123) {
            LocoNetMessage l = new LocoNetMessage(14);
            l.setOpCode(239);
            l.setElement(1, 14);
            l.setElement(2, this.slot & 0x7F);
            l.setElement(3, this.stat & 0x7F);
            l.setElement(4, this.addr & 0x7F);
            l.setElement(9, this.addr / 128 & 0x7F);
            l.setElement(5, this.spd & 0x7F);
            l.setElement(6, this.dirf & 0x7F);
            l.setElement(7, this.trk & 0x7F);
            l.setElement(8, this.ss2 & 0x7F);
            l.setElement(10, this.snd & 0x7F);
            l.setElement(11, this.id & 0x7F);
            l.setElement(12, this.id / 128 & 0x7F);
            return l;
        }
        LocoNetMessage l = new LocoNetMessage(21);
        l.setOpCode(238);
        l.setElement(1, 21);
        l.setElement(2, this.slot / 128 & 3);
        l.setElement(3, this.slot & 0x7F);
        l.setElement(4, this.stat & 0x7F);
        l.setElement(6, this.addr / 128 & 0x7F);
        l.setElement(5, this.addr & 0x7F);
        l.setElement(7, (this.trk | 0x40) & 0x7F);
        l.setElement(8, this.spd & 0x7F);
        l.setElement(9, (this.isF12() ? 16 : 0) | (this.isF20() ? 32 : 0) | (this.isF28() ? 64 : 0));
        l.setElement(10, (this.isForward() ? 0 : 0x100000) | (this.isF0() ? 16 : 0) | (this.isF1() ? 1 : 0) | (this.isF2() ? 2 : 0) | (this.isF3() ? 4 : 0) | (this.isF4() ? 8 : 0));
        l.setElement(11, (this.isF5() ? 1 : 0) | (this.isF6() ? 2 : 0) | (this.isF7() ? 4 : 0) | (this.isF8() ? 8 : 0) | (this.isF9() ? 16 : 0) | (this.isF10() ? 32 : 0) | (this.isF11() ? 64 : 0));
        l.setElement(12, (this.isF13() ? 1 : 0) | (this.isF14() ? 2 : 0) | (this.isF15() ? 4 : 0) | (this.isF16() ? 8 : 0) | (this.isF17() ? 16 : 0) | (this.isF18() ? 32 : 0) | (this.isF19() ? 64 : 0));
        l.setElement(13, (this.isF21() ? 1 : 0) | (this.isF22() ? 2 : 0) | (this.isF23() ? 4 : 0) | (this.isF24() ? 8 : 0) | (this.isF25() ? 16 : 0) | (this.isF26() ? 32 : 0) | (this.isF27() ? 64 : 0));
        l.setElement(18, this.id & 0x7F);
        l.setElement(19, this.id / 128 & 0x7F);
        return l;
    }

    public synchronized void addSlotListener(SlotListener l) {
        if (!this.slotListeners.contains(l)) {
            this.slotListeners.add(l);
        }
    }

    public synchronized void removeSlotListener(SlotListener l) {
        if (this.slotListeners.contains(l)) {
            this.slotListeners.remove(l);
        }
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySlotListeners() {
        ArrayList<SlotListener> v;
        LocoNetSlot locoNetSlot = this;
        synchronized (locoNetSlot) {
            v = new ArrayList<SlotListener>(this.slotListeners);
        }
        log.debug("notify {} SlotListeners", (Object)v.size());
        int cnt = v.size();
        for (int i = 0; i < cnt; ++i) {
            SlotListener client = (SlotListener)v.get(i);
            client.notifyChangedSlot(this);
        }
    }

    public void setFcCntrlBitOn(int val) {
        if (this.getSlot() != 123) {
            log.error("setFcCntrl invalid for slot [{}]", (Object)this.getSlot());
        }
        this.snd |= val;
    }

    public void setFcCntrlBitOff(int val) {
        if (this.getSlot() != 123) {
            log.error("setFcCntrl invalid for slot [{}]", (Object)this.getSlot());
        }
        this.snd &= ~val;
    }

    public int getTrackStatus() {
        return this.trk;
    }

    public void setTrackStatus(int status) {
        this.trk = status;
    }

    public int getFcDays() {
        if (this.getSlot() != 123) {
            log.error("getFcDays invalid for slot {}", (Object)this.getSlot());
        }
        return (this.addr & 0x3F80) / 128;
    }

    public void setFcDays(int val) {
        if (this.getSlot() != 123) {
            log.error("setFcDays invalid for slot {}", (Object)this.getSlot());
        }
        this.addr = val * 128 + (this.addr & 0x7F);
    }

    public int getFcHours() {
        if (this.getSlot() != 123) {
            log.error("getFcHours invalid for slot {}", (Object)this.getSlot());
        }
        int temp = (256 - this.ss2 & 0x7F) % 24;
        return (24 - temp) % 24;
    }

    public void setFcHours(int val) {
        if (this.getSlot() != 123) {
            log.error("setFcHours invalid for slot {}", (Object)this.getSlot());
        }
        this.ss2 = 256 - (24 - val) & 0x7F;
    }

    public int getFcMinutes() {
        if (this.getSlot() != 123) {
            log.error("getFcMinutes invalid for slot {}", (Object)this.getSlot());
        }
        int temp = (255 - this.dirf & 0x7F) % 60;
        return (60 - temp) % 60;
    }

    public void setFcMinutes(int val) {
        if (this.getSlot() != 123) {
            log.error("setFcMinutes invalid for slot {}", (Object)this.getSlot());
        }
        this.dirf = 255 - (60 - val) & 0x7F;
    }

    public int getFcFracMins() {
        if (this.getSlot() != 123) {
            log.error("getFcFracMins invalid for slot {}", (Object)this.getSlot());
        }
        return this.addr & 0x7F | (this.spd & 0x7F) << 8;
    }

    public void setFcFracMins(int val) {
        if (this.getSlot() != 123) {
            log.error("setFcFracMins invalid for slot {}", (Object)this.getSlot());
        }
        int temp = 0x7F7F & val;
        this.addr = this.addr & 0x7F00 | temp & 0x7F;
        this.spd = temp >> 8 & 0x7F;
    }

    public int getFcRate() {
        if (this.getSlot() != 123) {
            log.error("getFcRate invalid for slot {}", (Object)this.getSlot());
        }
        return this.stat;
    }

    public void setFcRate(int val) {
        if (this.getSlot() != 123) {
            log.error("setFcRate invalid for slot {}", (Object)this.getSlot());
        }
        this.stat = val & 0x7F;
    }
}

