/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.CheckForNull;
import javax.swing.Timer;
import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.NmraPacket;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.loconet.LnConstants;
import jmri.jmrix.loconet.LnThrottleManager;
import jmri.jmrix.loconet.LocoNetInterface;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoNetThrottle
extends AbstractThrottle
implements SlotListener {
    protected LocoNetSlot slot;
    protected LocoNetInterface network;
    protected LnThrottleManager throttleManager;
    protected int address;
    protected int layout_spd;
    protected int layout_dirf;
    protected int layout_snd;
    protected int layout_stat1 = 0;
    protected int new_spd;
    protected long new_spd_lastupdated;
    protected boolean new_isFwd;
    protected long new_isFwd_lastupdated;
    protected int slotStatus;
    protected boolean isDisposing = false;
    private static final int[] EXP_FUNCTION_GROUPS = new int[]{1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    Timer mRefreshTimer = null;
    private static final Logger log = LoggerFactory.getLogger(LocoNetThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocoNetThrottle(LocoNetSystemConnectionMemo memo, LocoNetSlot slot) {
        super(memo, 69);
        this.slot = slot;
        slot.setIsInitialized(false);
        this.network = memo.getLnTrafficController();
        this.throttleManager = (LnThrottleManager)memo.getThrottleManager();
        this.layout_spd = slot.speed();
        this.layout_dirf = slot.dirf();
        this.layout_snd = slot.snd();
        LocoNetThrottle locoNetThrottle = this;
        synchronized (locoNetThrottle) {
            this.speedSetting = this.floatSpeed(slot.speed());
        }
        for (int i = 0; i < 29; ++i) {
            super.updateFunction(i, slot.isFunction(i));
        }
        super.updateFunctionMomentary(2, true);
        this.address = slot.locoAddr();
        this.isForward = slot.isForward();
        this.slotStatus = slot.slotStatus();
        switch (slot.decoderType()) {
            case 3: 
            case 7: {
                this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_128);
                break;
            }
            case 0: 
            case 1: 
            case 4: {
                this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_28);
                break;
            }
            case 2: {
                this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_14);
                break;
            }
            default: {
                log.warn("Unhandled decoder type: {}", (Object)slot.decoderType());
            }
        }
        slot.addSlotListener(this);
        this.network.sendLocoNetMessage(slot.writeNullMove());
        this.startRefresh();
        log.debug("constructed a new throttle using slot {} for loco address {}", (Object)slot.getSlot(), (Object)slot.locoAddr());
    }

    protected float floatSpeed(int lSpeed) {
        log.debug("speed (int) is {}", (Object)lSpeed);
        if (lSpeed == 0) {
            return 0.0f;
        }
        if (lSpeed == 1) {
            return -1.0f;
        }
        if (this.getSpeedStepMode() == SpeedStepMode.NMRA_DCC_28) {
            if (lSpeed <= 15) {
                return 0.0f;
            }
            return (float)(lSpeed - 12) / 4.0f / 28.0f;
        }
        if (this.getSpeedStepMode() == SpeedStepMode.NMRA_DCC_14) {
            if (lSpeed <= 15) {
                return 0.0f;
            }
            return (float)(lSpeed - 8) / 8.0f / 14.0f;
        }
        return (float)(lSpeed - 1) / 126.0f;
    }

    @Override
    protected int intSpeed(float fSpeed) {
        log.debug("intSpeed speed is {}", (Object)Float.valueOf(fSpeed));
        int speed = super.intSpeed(fSpeed);
        if (speed <= 1) {
            return speed;
        }
        switch (this.getSpeedStepMode()) {
            case NMRA_DCC_28: 
            case MOTOROLA_28: {
                speed = (int)(fSpeed * 28.0f * 4.0f) + 12;
                if (speed < 16) {
                    speed = 16;
                }
                return speed;
            }
            case NMRA_DCC_14: {
                speed = (int)(fSpeed * 14.0f * 8.0f) + 8;
                if (speed < 16) {
                    speed = 16;
                }
                return speed;
            }
            case NMRA_DCC_128: {
                return speed;
            }
        }
        log.warn("Unhandled speed step: {}", (Object)this.getSpeedStepMode());
        return speed;
    }

    @Override
    protected void sendFunctionGroup(int functionNum, boolean momentary) {
        if (this.slot.getProtocol() != 2) {
            super.sendFunctionGroup(functionNum, momentary);
            return;
        }
        switch (EXP_FUNCTION_GROUPS[functionNum]) {
            case 1: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup1();
                    break;
                }
                this.sendExpFunctionGroup1();
                break;
            }
            case 2: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup2();
                    break;
                }
                this.sendExpFunctionGroup2();
                break;
            }
            case 3: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup3();
                    break;
                }
                this.sendExpFunctionGroup3();
                break;
            }
            case 4: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup4();
                    break;
                }
                this.sendExpFunctionGroup4();
                break;
            }
            case 5: {
                super.sendFunctionGroup(functionNum, momentary);
                break;
            }
        }
    }

    @Override
    protected void sendFunctionGroup1() {
        int new_dirf = (this.getIsForward() ? 0 : 32) | (this.getFunction(0) ? 16 : 0) | (this.getFunction(1) ? 1 : 0) | (this.getFunction(2) ? 2 : 0) | (this.getFunction(3) ? 4 : 0) | (this.getFunction(4) ? 8 : 0);
        log.debug("sendFunctionGroup1 sending {} to LocoNet slot {}", (Object)new_dirf, (Object)this.slot.getSlot());
        LocoNetMessage msg = new LocoNetMessage(4);
        msg.setOpCode(161);
        msg.setElement(1, this.slot.getSlot());
        msg.setElement(2, new_dirf);
        this.network.sendLocoNetMessage(msg);
    }

    @Override
    protected void sendFunctionGroup2() {
        int new_snd = (this.getFunction(8) ? 8 : 0) | (this.getFunction(7) ? 4 : 0) | (this.getFunction(6) ? 2 : 0) | (this.getFunction(5) ? 1 : 0);
        log.debug("sendFunctionGroup2 sending {} to LocoNet slot {}", (Object)new_snd, (Object)this.slot.getSlot());
        LocoNetMessage msg = new LocoNetMessage(4);
        msg.setOpCode(162);
        msg.setElement(1, this.slot.getSlot());
        msg.setElement(2, new_snd);
        this.network.sendLocoNetMessage(msg);
    }

    @Override
    protected void sendFunctionGroup3() {
        byte[] result = NmraPacket.function9Through12Packet(this.address, this.address >= 128, this.getFunction(9), this.getFunction(10), this.getFunction(11), this.getFunction(12));
        log.debug("sendFunctionGroup3 sending {} to LocoNet slot {}", (Object)result, (Object)this.slot.getSlot());
        this.adapterMemo.get(CommandStation.class).sendPacket(result, 4);
    }

    @Override
    protected void sendFunctionGroup4() {
        byte[] result = NmraPacket.function13Through20Packet(this.address, this.address >= 128, this.getFunction(13), this.getFunction(14), this.getFunction(15), this.getFunction(16), this.getFunction(17), this.getFunction(18), this.getFunction(19), this.getFunction(20));
        log.debug("sendFunctionGroup4 sending {} to LocoNet slot {}", (Object)result, (Object)this.slot.getSlot());
        this.adapterMemo.get(CommandStation.class).sendPacket(result, 4);
    }

    @Override
    protected void sendFunctionGroup5() {
        byte[] result = NmraPacket.function21Through28Packet(this.address, this.address >= 128, this.getFunction(21), this.getFunction(22), this.getFunction(23), this.getFunction(24), this.getFunction(25), this.getFunction(26), this.getFunction(27), this.getFunction(28));
        log.debug("sendFunctionGroup5 sending {} to LocoNet slot {}", (Object)result, (Object)this.slot.getSlot());
        this.adapterMemo.get(CommandStation.class).sendPacket(result, 4);
    }

    @Override
    protected void sendFunctionGroup6() {
        int i = 29;
        byte[] result = NmraPacket.function29Through36Packet(this.address, this.address >= 128, this.getFunction(i), this.getFunction(i + 1), this.getFunction(i + 2), this.getFunction(i + 3), this.getFunction(i + 4), this.getFunction(i + 5), this.getFunction(i + 6), this.getFunction(i + 7));
        log.debug("sendFunctionGroup6 sending {} to LocoNet slot {}", (Object)result, (Object)this.slot.getSlot());
        this.adapterMemo.get(CommandStation.class).sendPacket(result, 4);
    }

    @Override
    protected void sendFunctionGroup7() {
        int i = 37;
        byte[] result = NmraPacket.function37Through44Packet(this.address, this.address >= 128, this.getFunction(i), this.getFunction(i + 1), this.getFunction(i + 2), this.getFunction(i + 3), this.getFunction(i + 4), this.getFunction(i + 5), this.getFunction(i + 6), this.getFunction(i + 7));
        log.debug("sendFunctionGroup7 sending {} to LocoNet slot {}", (Object)result, (Object)this.slot.getSlot());
        this.adapterMemo.get(CommandStation.class).sendPacket(result, 4);
    }

    @Override
    protected void sendFunctionGroup8() {
        int i = 45;
        byte[] result = NmraPacket.function45Through52Packet(this.address, this.address >= 128, this.getFunction(i), this.getFunction(i + 1), this.getFunction(i + 2), this.getFunction(i + 3), this.getFunction(i + 4), this.getFunction(i + 5), this.getFunction(i + 6), this.getFunction(i + 7));
        log.debug("sendFunctionGroup8 sending {} to LocoNet slot {}", (Object)result, (Object)this.slot.getSlot());
        this.adapterMemo.get(CommandStation.class).sendPacket(result, 4);
    }

    @Override
    protected void sendFunctionGroup9() {
        int i = 53;
        byte[] result = NmraPacket.function53Through60Packet(this.address, this.address >= 128, this.getFunction(i), this.getFunction(i + 1), this.getFunction(i + 2), this.getFunction(i + 3), this.getFunction(i + 4), this.getFunction(i + 5), this.getFunction(i + 6), this.getFunction(i + 7));
        log.debug("sendFunctionGroup9 sending {} to LocoNet slot {}", (Object)result, (Object)this.slot.getSlot());
        this.adapterMemo.get(CommandStation.class).sendPacket(result, 4);
    }

    @Override
    protected void sendFunctionGroup10() {
        int i = 61;
        byte[] result = NmraPacket.function61Through68Packet(this.address, this.address >= 128, this.getFunction(i), this.getFunction(i + 1), this.getFunction(i + 2), this.getFunction(i + 3), this.getFunction(i + 4), this.getFunction(i + 5), this.getFunction(i + 6), this.getFunction(i + 7));
        log.debug("sendFunctionGroup10 sending {} to LocoNet slot {}", (Object)result, (Object)this.slot.getSlot());
        this.adapterMemo.get(CommandStation.class).sendPacket(result, 4);
    }

    protected void sendExpFunctionGroup1() {
        int new_F0F6 = (this.getFunction(5) ? 32 : 0) | (this.getFunction(6) ? 64 : 0) | (this.getFunction(0) ? 16 : 0) | (this.getFunction(1) ? 1 : 0) | (this.getFunction(2) ? 2 : 0) | (this.getFunction(3) ? 4 : 0) | (this.getFunction(4) ? 8 : 0);
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(213);
        msg.setElement(1, this.slot.getSlot() / 128 | 0x10);
        msg.setElement(2, this.slot.getSlot() & 0x7F);
        msg.setElement(3, this.slot.id() & 0x7F);
        msg.setElement(4, new_F0F6);
        this.network.sendLocoNetMessage(msg);
    }

    protected void sendExpFunctionGroup2() {
        int new_F7F13 = (this.getFunction(7) ? 1 : 0) | (this.getFunction(8) ? 2 : 0) | (this.getFunction(9) ? 4 : 0) | (this.getFunction(10) ? 8 : 0) | (this.getFunction(11) ? 16 : 0) | (this.getFunction(12) ? 32 : 0) | (this.getFunction(13) ? 64 : 0);
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(213);
        msg.setElement(1, this.slot.getSlot() / 128 | 0x18);
        msg.setElement(2, this.slot.getSlot() & 0x7F);
        msg.setElement(3, this.slot.id() & 0x7F);
        msg.setElement(4, new_F7F13);
        this.network.sendLocoNetMessage(msg);
    }

    protected void sendExpFunctionGroup3() {
        int new_F14F20 = (this.getFunction(14) ? 1 : 0) | (this.getFunction(15) ? 2 : 0) | (this.getFunction(16) ? 4 : 0) | (this.getFunction(17) ? 8 : 0) | (this.getFunction(18) ? 16 : 0) | (this.getFunction(19) ? 32 : 0) | (this.getFunction(20) ? 64 : 0);
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(213);
        msg.setElement(1, this.slot.getSlot() / 128 | 0x20);
        msg.setElement(2, this.slot.getSlot() & 0x7F);
        msg.setElement(3, this.slot.id() & 0x7F);
        msg.setElement(4, new_F14F20);
        this.network.sendLocoNetMessage(msg);
    }

    protected void sendExpFunctionGroup4() {
        int new_F2128 = (this.getFunction(21) ? 1 : 0) | (this.getFunction(22) ? 2 : 0) | (this.getFunction(23) ? 4 : 0) | (this.getFunction(24) ? 8 : 0) | (this.getFunction(25) ? 16 : 0) | (this.getFunction(26) ? 32 : 0) | (this.getFunction(27) ? 64 : 0);
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(213);
        if (!this.getFunction(28)) {
            msg.setElement(1, this.slot.getSlot() / 128 | 0x28);
        } else {
            msg.setElement(1, this.slot.getSlot() / 128 | 0x30);
        }
        msg.setElement(2, this.slot.getSlot() & 0x7F);
        msg.setElement(3, this.slot.id() & 0x7F);
        msg.setElement(4, new_F2128);
        this.network.sendLocoNetMessage(msg);
    }

    protected void sendExpSpeedAndDirection(int speed) {
        boolean isFwd = this.slot.getLastUpdateTime() < this.new_isFwd_lastupdated ? this.new_isFwd : this.slot.isForward();
        this.new_spd = speed;
        this.new_spd_lastupdated = System.currentTimeMillis();
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(213);
        msg.setElement(1, this.slot.getSlot() / 128 & 3 | (isFwd ? 0 : 8));
        msg.setElement(2, this.slot.getSlot() & 0x7F);
        msg.setElement(3, this.slot.id() & 0x7F);
        msg.setElement(4, speed);
        this.network.sendLocoNetMessage(msg);
    }

    protected void sendExpSpeedAndDirection(boolean isFwd) {
        int speed = this.slot.getLastUpdateTime() < this.new_spd_lastupdated ? this.new_spd : this.slot.speed();
        this.new_isFwd = isFwd;
        this.new_isFwd_lastupdated = System.currentTimeMillis();
        LocoNetMessage msg = new LocoNetMessage(6);
        msg.setOpCode(213);
        msg.setElement(1, this.slot.getSlot() / 128 & 3 | (isFwd ? 0 : 8));
        msg.setElement(2, this.slot.getSlot() & 0x7F);
        msg.setElement(3, this.slot.id() & 0x7F);
        msg.setElement(4, speed);
        this.network.sendLocoNetMessage(msg);
    }

    @Override
    public void setSpeedSetting(float speed) {
        this.setSpeedSetting(speed, false, false);
    }

    @Override
    public void setSpeedSettingAgain(float speed) {
        this.setSpeedSetting(speed, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public void setSpeedSetting(float speed, boolean allowDuplicates, boolean allowDuplicatesOnStop) {
        float oldSpeed;
        log.debug("setSpeedSetting: called with speed {} for LocoNet slot {} allowDup {} allowDupOnStop {}", new Object[]{Float.valueOf(speed), this.slot.getSlot(), allowDuplicates, allowDuplicatesOnStop});
        if (72 == this.slot.consistStatus() || 64 == this.slot.consistStatus()) {
            log.debug("Attempt to change speed on locomotive {} which is a {}", (Object)this.getLocoAddress(), (Object)LnConstants.CONSIST_STAT(this.slot.consistStatus()));
            return;
        }
        LocoNetThrottle locoNetThrottle = this;
        synchronized (locoNetThrottle) {
            oldSpeed = this.speedSetting;
            this.speedSetting = speed;
            if (speed < 0.0f) {
                this.speedSetting = -1.0f;
            }
        }
        this.new_spd = this.intSpeed(speed);
        boolean sendLoconetMessage = false;
        if (this.new_spd != this.layout_spd) {
            sendLoconetMessage = true;
        } else if (allowDuplicates) {
            sendLoconetMessage = true;
        } else if (allowDuplicatesOnStop && this.new_spd <= 1) {
            sendLoconetMessage = true;
        }
        if (sendLoconetMessage) {
            log.debug("setSpeedSetting: sending speed {} to LocoNet slot {}", (Object)Float.valueOf(speed), (Object)this.slot.getSlot());
            if (this.slot.getProtocol() != 2) {
                LocoNetMessage msg = new LocoNetMessage(4);
                msg.setOpCode(160);
                msg.setElement(1, this.slot.getSlot());
                log.debug("setSpeedSetting: float speed: {} LocoNet speed: {}", (Object)Float.valueOf(speed), (Object)this.new_spd);
                msg.setElement(2, this.new_spd);
                this.network.sendLocoNetMessage(msg);
            } else {
                this.sendExpSpeedAndDirection(this.new_spd);
            }
            if (this.mRefreshTimer != null) {
                this.mRefreshTimer.stop();
                this.mRefreshTimer.setRepeats(true);
                this.mRefreshTimer.start();
                log.debug("Initially starting refresh timer for slot {} address {}", (Object)this.slot.getSlot(), (Object)this.slot.locoAddr());
            }
        } else {
            log.debug("setSpeedSetting: not sending LocoNet speed message to slot {}, new({})==old({})", new Object[]{this.slot.getSlot(), this.new_spd, this.layout_spd});
        }
        LocoNetThrottle locoNetThrottle2 = this;
        synchronized (locoNetThrottle2) {
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        }
        log.debug("about to invoke record({})", (Object)Float.valueOf(speed));
        this.record(speed);
    }

    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        log.debug("setIsForward to {}, old value {}", (Object)this.isForward, (Object)old);
        if (this.slot.getProtocol() != 2) {
            this.sendFunctionGroup1();
        } else {
            this.sendExpSpeedAndDirection(forward);
        }
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @CheckForNull
    public LocoNetSlot getLocoNetSlot() {
        if (this.slot == null) {
            return this.slot;
        }
        log.debug("getLocoNetSlot is returning slot {}", (Object)this.slot.getSlot());
        return this.slot;
    }

    public String toString() {
        return this.getLocoAddress().toString();
    }

    @Override
    public void throttleDispose() {
        if (this.isDisposing) {
            return;
        }
        log.debug("throttleDispose - disposing of throttle (and setting slot = null)");
        this.isDisposing = true;
        if (this.slot != null) {
            if (this.slot.slotStatus() == 48) {
                log.debug("dispatchThrottle is dispatching slot {}", (Object)this.slot);
                this.network.sendLocoNetMessage(this.slot.releaseSlot());
            }
            this.slot.removeSlotListener(this);
            if (this.mRefreshTimer != null) {
                this.mRefreshTimer.stop();
                log.debug("Stopped refresh timer for slot {} address {} as part of throttleDispose", (Object)this.slot.getSlot(), (Object)this.slot.locoAddr());
                this.mRefreshTimer = null;
            }
            this.slot = null;
            this.network = null;
            this.finishRecord();
            this.isDisposing = false;
        }
    }

    protected void startRefresh() {
        this.mRefreshTimer = new Timer(50000, e -> this.timeout());
        this.mRefreshTimer.setRepeats(true);
        this.mRefreshTimer.start();
        log.debug("Starting refresh timer for slot {} address {}", (Object)this.slot.getSlot(), (Object)this.slot.locoAddr());
    }

    protected synchronized void timeout() {
        if (this.slot != null) {
            log.debug("refresh timer timed-out on slot {}", (Object)this.slot.getSlot());
            this.layout_spd = -1;
            this.setSpeedSetting(this.speedSetting);
        } else {
            log.debug("refresh timer time-out on a null slot");
        }
    }

    public void notifyRefused(int addr, String s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public void notifyChangedSlot(LocoNetSlot pSlot) {
        log.debug("notifyChangedSlot executing for slot {}, slotStatus {}", (Object)this.slot.getSlot(), (Object)Integer.toHexString(this.slot.slotStatus()));
        if (this.slot != pSlot) {
            log.error("notified of change in different slot");
        }
        if (!this.slot.getIsInitilized() && this.slot.slotStatus() == 48) {
            log.debug("Attempting to update slot with this JMRI instance's throttle id ({})", (Object)this.throttleManager.getThrottleID());
            this.network.sendLocoNetMessage(this.slot.writeThrottleID(this.throttleManager.getThrottleID()));
            this.slot.setIsInitialized(true);
            this.throttleManager.notifyComplete(this, this.slot);
        }
        this.layout_spd = this.slot.speed();
        this.layout_dirf = this.slot.dirf();
        this.layout_snd = this.slot.snd();
        LocoNetThrottle locoNetThrottle = this;
        synchronized (locoNetThrottle) {
            if (this.speedSetting != this.floatSpeed(this.slot.speed())) {
                float old = this.speedSetting;
                this.speedSetting = this.floatSpeed(this.slot.speed());
                log.debug("notifyChangedSlot: old speed: {} new speed: {}", (Object)Float.valueOf(old), (Object)Float.valueOf(this.speedSetting));
                this.firePropertyChange("SpeedSetting", Float.valueOf(old), Float.valueOf(this.speedSetting));
            }
        }
        this.isForward = this.slot.isForward();
        this.firePropertyChange("IsForward", this.isForward, this.isForward);
        if (this.slotStatus != this.slot.slotStatus()) {
            int newStat = this.slot.slotStatus();
            log.debug("Slot status changed from {} to {}", (Object)LnConstants.LOCO_STAT(this.slotStatus), (Object)LnConstants.LOCO_STAT(newStat));
            this.firePropertyChange("ThrottleConnected", (this.slotStatus & 0x30) == 48, (this.slotStatus & 0x30) != 48);
            this.slotStatus = newStat;
        }
        if (this.slot == null) {
            return;
        }
        switch (this.slot.decoderType()) {
            case 3: 
            case 7: {
                if (SpeedStepMode.NMRA_DCC_128 == this.getSpeedStepMode()) break;
                this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_128);
                break;
            }
            case 0: 
            case 1: 
            case 4: {
                if (SpeedStepMode.NMRA_DCC_28 == this.getSpeedStepMode()) break;
                this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_28);
                break;
            }
            case 2: {
                if (SpeedStepMode.NMRA_DCC_14 == this.getSpeedStepMode()) break;
                this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_14);
                break;
            }
            default: {
                log.warn("Unhandled decoder type: {}", (Object)this.slot.decoderType());
            }
        }
        this.updateFunctions();
        log.debug("notifyChangedSlot ends");
    }

    protected void updateFunctions() {
        for (int i = 0; i < 29; ++i) {
            log.debug("updateFunction({}, {})", (Object)i, (Object)this.slot.isFunction(i));
            if (i == 20 && log.isTraceEnabled()) {
                log.trace("Tracing back F20", (Throwable)new Exception("traceback"));
            }
            this.updateFunction(i, this.slot.isFunction(i));
        }
    }

    @Override
    public void setSpeedStepMode(SpeedStepMode Mode) {
        int status = this.slot.slotStatus();
        log.debug("Speed Step Mode Change to Mode: {} Current mode is: {}", (Object)Mode, (Object)this.speedStepMode);
        log.debug("Current Slot Mode: {}", (Object)LnConstants.DEC_MODE(status));
        this.speedStepMode = Mode;
        this.firePropertyChange("SpeedSteps", (Object)this.speedStepMode, (Object)this.speedStepMode);
        if (Mode == SpeedStepMode.NMRA_DCC_14) {
            log.debug("14 speed step change");
            status = status & 0xFFFFFFFC | 2;
        } else if (Mode == SpeedStepMode.MOTOROLA_28) {
            log.debug("28-Tristate speed step change");
            status = status & 0xFFFFFFFC | 1;
        } else if (Mode == SpeedStepMode.NMRA_DCC_28) {
            log.debug("28 speed step change");
            status &= 0xFFFFFFFC;
        } else {
            log.debug("128 speed step change");
            status = status & 0xFFFFFFFC | 3;
        }
        log.debug("New Slot Mode: {}", (Object)LnConstants.DEC_MODE(status));
        if (this.slot.getIsInitilized()) {
            this.network.sendLocoNetMessage(this.slot.writeMode(status));
        }
    }

    @Override
    public LocoAddress getLocoAddress() {
        if (this.slot != null && (this.slot.slotStatus() == 48 || this.slot.slotStatus() == 16)) {
            log.debug("getLocoAddress replying address {} for slot {}", (Object)this.address, (Object)this.slot.getSlot());
            return new DccLocoAddress(this.address, LnThrottleManager.isLongAddress(this.address));
        }
        log.debug("getLocoAddress replying address {} for slot not in-use or for sub-consisted slot or for null slot", (Object)this.address);
        return new DccLocoAddress(this.address, LnThrottleManager.isLongAddress(this.address));
    }

    public void dispatchThrottle(DccThrottle t, ThrottleListener l) {
        LocoNetThrottle lnt;
        LocoNetSlot tSlot;
        log.debug("dispatchThrottle - throttle {}", (Object)t.getLocoAddress());
        if (t instanceof LocoNetThrottle && (tSlot = (lnt = (LocoNetThrottle)t).getLocoNetSlot()) != null && tSlot.slotStatus() != 16) {
            this.network.sendLocoNetMessage(tSlot.writeStatus(16));
            log.debug("dispatchThrottle is dispatching slot {}", (Object)tSlot);
            this.network.sendLocoNetMessage(tSlot.dispatchSlot());
        }
    }
}

