/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import jmri.jmrix.loconet.LocoNetInterface;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoNetThrottledTransmitter
implements LocoNetInterface {
    LocoNetSystemConnectionMemo memo = null;
    boolean mTurnoutExtraSpace;
    volatile boolean disposed = false;
    volatile boolean running = false;
    LocoNetInterface controller;
    long minInterval;
    long lastSendTimeMSec = 0L;
    DelayQueue<Memo> queue = new DelayQueue();
    public static final String SERVICE_THREAD_NAME = " LocoNetThrottledTransmitter";
    ServiceThread theServiceThread;
    private static final Logger log = LoggerFactory.getLogger(LocoNetThrottledTransmitter.class);

    public LocoNetThrottledTransmitter(@Nonnull LocoNetInterface controller, boolean mTurnoutExtraSpace) {
        this.controller = controller;
        this.memo = controller.getSystemConnectionMemo();
        this.mTurnoutExtraSpace = mTurnoutExtraSpace;
        this.minInterval = 18L;
        if (mTurnoutExtraSpace) {
            this.minInterval *= 4L;
        }
        this.attachServiceThread();
    }

    @Override
    public void setSystemConnectionMemo(LocoNetSystemConnectionMemo m) {
        log.debug("LnTrafficController set memo to {}", (Object)m.getUserName());
        this.memo = m;
    }

    @Override
    public LocoNetSystemConnectionMemo getSystemConnectionMemo() {
        log.debug("getSystemConnectionMemo {} called in LnTC", (Object)this.memo.getUserName());
        return this.memo;
    }

    public void dispose() {
        this.disposed = true;
        Memo m = new Memo(null, LocoNetThrottledTransmitter.nowMSec(), TimeUnit.MILLISECONDS){

            @Override
            boolean requestsShutDown() {
                return true;
            }
        };
        this.queue.add(m);
    }

    @Override
    public void addLocoNetListener(int mask, LocoNetListener listener) {
        this.controller.addLocoNetListener(mask, listener);
    }

    @Override
    public void removeLocoNetListener(int mask, LocoNetListener listener) {
        this.controller.removeLocoNetListener(mask, listener);
    }

    @Override
    public boolean status() {
        return this.controller.status();
    }

    @Override
    public void sendLocoNetMessage(LocoNetMessage msg) {
        if (this.disposed) {
            log.error("Message sent after queue disposed");
            return;
        }
        long sendTime = this.calcSendTimeMSec();
        Memo m = new Memo(msg, sendTime, TimeUnit.MILLISECONDS);
        this.queue.add(m);
    }

    long calcSendTimeMSec() {
        this.lastSendTimeMSec = Math.max(LocoNetThrottledTransmitter.nowMSec(), this.minInterval + this.lastSendTimeMSec);
        return this.lastSendTimeMSec;
    }

    private void attachServiceThread() {
        this.theServiceThread = new ServiceThread();
        this.theServiceThread.setPriority(5);
        this.theServiceThread.setName(this.memo.getUserName() + SERVICE_THREAD_NAME);
        this.theServiceThread.setDaemon(true);
        this.theServiceThread.start();
    }

    static long nowMSec() {
        return System.currentTimeMillis();
    }

    static class Memo
    implements Delayed {
        long endTimeMsec;
        LocoNetMessage msg;

        public Memo(LocoNetMessage msg, long endTime, TimeUnit unit) {
            this.msg = msg;
            this.endTimeMsec = unit.toMillis(endTime);
        }

        LocoNetMessage getMessage() {
            return this.msg;
        }

        boolean requestsShutDown() {
            return false;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long delay = this.endTimeMsec - LocoNetThrottledTransmitter.nowMSec();
            return unit.convert(delay, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed d) {
            long delta = d instanceof Memo ? this.endTimeMsec - ((Memo)d).endTimeMsec : this.getDelay(TimeUnit.MILLISECONDS) - d.getDelay(TimeUnit.MILLISECONDS);
            if (delta > 0L) {
                return 1;
            }
            if (delta < 0L) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Delayed) {
                return this.compareTo((Delayed)o) == 0;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.getDelay(TimeUnit.MILLISECONDS) & 0xFFFFFFL);
        }
    }

    class ServiceThread
    extends Thread {
        ServiceThread() {
        }

        @Override
        public void run() {
            LocoNetThrottledTransmitter.this.running = true;
            try {
                while (true) {
                    Memo m;
                    if ((m = (Memo)LocoNetThrottledTransmitter.this.queue.take()).requestsShutDown()) {
                        log.debug("item requests shutdown");
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("forwarding message: {}", (Object)m.getMessage());
                    }
                    LocoNetThrottledTransmitter.this.controller.sendLocoNetMessage(m.getMessage());
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
            }
            LocoNetThrottledTransmitter.this.running = false;
        }
    }
}

