/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import jmri.InstanceManager;
import jmri.implementation.DefaultSignalHead;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SE8cSignalHead
extends DefaultSignalHead
implements LocoNetListener {
    LnTrafficController tc;
    int mNumber;
    private static final Logger log = LoggerFactory.getLogger(SE8cSignalHead.class);

    public SE8cSignalHead(int pNumber, String userName) {
        super("LH" + pNumber, userName);
        this.init(pNumber);
    }

    public SE8cSignalHead(int pNumber) {
        super("LH" + pNumber);
        this.init(pNumber);
    }

    void init(int pNumber) {
        this.tc = InstanceManager.getDefault(LnTrafficController.class);
        this.mNumber = pNumber;
        this.mAppearance = 0;
        this.tc.addLocoNetListener(-1, this);
        this.updateOutput();
    }

    public int getNumber() {
        return this.mNumber;
    }

    @Override
    protected void updateOutput() {
        LocoNetMessage l = new LocoNetMessage(4);
        l.setOpCode(176);
        int address = 0;
        boolean closed = false;
        if (!this.mLit) {
            address = this.mNumber + 1;
            closed = true;
        } else if (!(this.mFlashOn || this.mAppearance != 32 && this.mAppearance != 8 && this.mAppearance != 2)) {
            address = this.mNumber + 1;
            closed = true;
        } else {
            switch (this.mAppearance) {
                case 1: 
                case 2: {
                    address = this.mNumber;
                    closed = false;
                    break;
                }
                case 4: 
                case 8: {
                    address = this.mNumber + 1;
                    closed = false;
                    break;
                }
                case 16: 
                case 32: {
                    address = this.mNumber;
                    closed = true;
                    break;
                }
                case 0: {
                    address = this.mNumber + 1;
                    closed = true;
                    break;
                }
                default: {
                    log.error("Invalid state request: {}", (Object)this.mAppearance);
                    return;
                }
            }
        }
        int hiadr = (address - 1) / 128;
        int loadr = address - 1 - hiadr * 128;
        if (closed) {
            hiadr |= 0x20;
        }
        l.setElement(1, loadr);
        l.setElement(2, hiadr |= 0x10);
        this.tc.sendLocoNetMessage(l);
    }

    @Override
    public void message(LocoNetMessage l) {
        int oldAppearance = this.mAppearance;
        switch (l.getOpCode()) {
            case 176: {
                int sw1 = l.getElement(1);
                int sw2 = l.getElement(2);
                if (this.myAddress(sw1, sw2)) {
                    if ((sw2 & 0x20) != 0) {
                        if (this.mAppearance != 32) {
                            this.mAppearance = 16;
                        }
                    } else if (this.mAppearance != 2) {
                        this.mAppearance = 1;
                    }
                }
                if (!this.myAddressPlusOne(sw1, sw2)) break;
                if ((sw2 & 0x20) != 0) {
                    if (this.mAppearance == 8 || this.mAppearance == 0 || this.mAppearance == 32 || this.mAppearance == 2 || !this.mLit || !this.mFlashOn) break;
                    this.mAppearance = 0;
                    break;
                }
                if (this.mAppearance == 8) break;
                this.mAppearance = 4;
                break;
            }
            case 177: {
                int sw1 = l.getElement(1);
                int sw2 = l.getElement(2);
                if (this.myAddress(sw1, sw2) && (sw2 & 0x40) == 0) {
                    if ((sw2 & 0x20) != 0 && this.mAppearance != 32) {
                        this.mAppearance = 16;
                    }
                    if ((sw2 & 0x10) != 0 && this.mAppearance != 2) {
                        this.mAppearance = 1;
                    }
                }
                if (this.myAddressPlusOne(sw1, sw2)) {
                    if ((sw2 & 0x40) == 0 && this.mAppearance != 8 && this.mAppearance != 0 && this.mAppearance != 32 && this.mAppearance != 2 && this.mLit && this.mFlashOn) {
                        this.mAppearance = 0;
                    }
                    if ((sw2 & 0x10) != 0 && this.mAppearance != 8) {
                        this.mAppearance = 4;
                    }
                }
                return;
            }
            default: {
                return;
            }
        }
        if (oldAppearance != this.mAppearance) {
            this.firePropertyChange("Appearance", oldAppearance, this.mAppearance);
        }
    }

    @Override
    public void dispose() {
        this.tc.removeLocoNetListener(-1, this);
        super.dispose();
    }

    private boolean myAddress(int a1, int a2) {
        return (a2 & 0xF) * 128 + (a1 & 0x7F) + 1 == this.mNumber;
    }

    private boolean myAddressPlusOne(int a1, int a2) {
        return (a2 & 0xF) * 128 + (a1 & 0x7F) + 1 == this.mNumber + 1;
    }
}

