/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet;

import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.jmrix.CaptiveSystemConnectionMemo;
import jmri.jmrix.loconet.TranspondingTag;
import jmri.managers.DefaultIdTagManager;
import jmri.managers.configurexml.DefaultIdTagManagerXml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranspondingTagManager
extends DefaultIdTagManager {
    private static final Logger log = LoggerFactory.getLogger(TranspondingTagManager.class);

    public TranspondingTagManager() {
        super(new CaptiveSystemConnectionMemo("L", "LocoNet"));
        this.storeInstance();
    }

    final void storeInstance() {
        InstanceManager.store(this, TranspondingTagManager.class);
    }

    @Override
    @Nonnull
    protected TranspondingTag createNewIdTag(String systemName, String userName) throws IllegalArgumentException {
        if (!((String)systemName).startsWith(this.getSystemPrefix() + this.typeLetter())) {
            systemName = this.getSystemPrefix() + this.typeLetter() + (String)systemName;
        }
        return new TranspondingTag((String)systemName, userName);
    }

    @Override
    @Nonnull
    public IdTag newIdTag(@Nonnull String systemName, @CheckForNull String userName) throws IllegalArgumentException {
        TranspondingTag s;
        log.debug("new IdTag:{};{}", (Object)systemName, (Object)(userName == null ? "null" : userName));
        if (userName != null && (s = (TranspondingTag)this.getByUserName(userName)) != null) {
            if (this.getBySystemName(systemName) != s) {
                log.error("inconsistent user ({}) and system name ({}) results; userName related to ({})", new Object[]{userName, systemName, s.getSystemName()});
            }
            return s;
        }
        s = (TranspondingTag)this.getBySystemName(systemName);
        if (s != null) {
            if (s.getUserName() == null && userName != null) {
                s.setUserName(userName);
            } else if (userName != null) {
                log.warn("Found IdTag via system name ({}) with non-null user name ({})", (Object)systemName, (Object)userName);
            }
            return s;
        }
        s = this.createNewIdTag(systemName, userName);
        this.register(s);
        return s;
    }

    @Override
    public void writeIdTagDetails() throws IOException {
        if (this.dirty) {
            new DefaultIdTagManagerXml(this, "TranspondingIdTags.xml").store();
            this.dirty = false;
            log.debug("...done writing IdTag details");
        }
    }

    @Override
    public void readIdTagDetails() {
        log.debug("reading idTag Details");
        new DefaultIdTagManagerXml(this, "TranspondingIdTags.xml").load();
        this.dirty = false;
        log.debug("...done reading IdTag details");
    }
}

