/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.alm;

import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.alm.AlmMsgTypes;

public class Alm {
    private static final LocoNetMessage almcapq = new LocoNetMessage(new int[]{238, 16, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private static final int[] capqmask = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0};
    private static final LocoNetMessage capCsRr = new LocoNetMessage(new int[]{230, 16, 1, 0, 64, 2, 3, 2, 8, 0, 0, 0, 0, 0, 0, 0});
    private static final int[] csCapabilitiesMasks = new int[]{255, 127, 127, 127, 63, 125, 0, 127, 103, 127, 127, 127, 127, 127, 127, 0};
    private static final LocoNetMessage drcDs74 = new LocoNetMessage(new int[]{230, 16, 2, 0, 16, 0, 0, 2, 8, 116, 0, 0, 0, 0, 0, 0});
    private static final int[] ds74CapabilitiesMasks = new int[]{255, 127, 127, 127, 127, 127, 127, 127, 127, 127, 0, 0, 0, 0, 0, 0};
    private static final LocoNetMessage drcDs78v = new LocoNetMessage(new int[]{230, 16, 2, 0, 32, 0, 0, 2, 8, 124, 0, 0, 0, 0, 0, 0});
    private static final LocoNetMessage drcSe74 = new LocoNetMessage(new int[]{230, 16, 2, 0, 16, 0, 0, 2, 8, 70, 0, 70, 8, 124, 1, 0});
    private static final LocoNetMessage drcPm74 = new LocoNetMessage(new int[]{230, 16, 2, 0, 1, 0, 0, 2, 4, 74, 0, 0, 0, 0, 0, 0});
    private static final LocoNetMessage almchga = new LocoNetMessage(new int[]{238, 16, 2, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private static final int[] almchgam = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0};
    private static final LocoNetMessage almgetr = new LocoNetMessage(new int[]{238, 16, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private static final int[] almgetrm = new int[]{255, 255, 255, 255, 0, 126, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0};

    private Alm() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isCsCapsRpt(LocoNetMessage l) {
        return l.equals(capCsRr, csCapabilitiesMasks);
    }

    public static boolean isDs74CapsRpt(LocoNetMessage l) {
        return l.equals(drcDs74, ds74CapabilitiesMasks);
    }

    public static boolean isDs78vCapsRpt(LocoNetMessage l) {
        return l.equals(drcDs78v, ds74CapabilitiesMasks);
    }

    public static boolean isSe74CapsRpt(LocoNetMessage l) {
        return l.equals(drcSe74, ds74CapabilitiesMasks);
    }

    public static boolean isPm74CapsRpt(LocoNetMessage l) {
        return l.equals(drcPm74, ds74CapabilitiesMasks);
    }

    public static boolean isDevBAW(LocoNetMessage l) {
        return Alm.getAlmMsgType(l) == AlmMsgTypes.ALM_BAW;
    }

    public static boolean isDs7xRQ(LocoNetMessage l) {
        return Alm.getAlmMsgType(l) == AlmMsgTypes.ALM_RDQ;
    }

    static AlmMsgTypes getAlmMsgType(LocoNetMessage m) {
        if (m.getOpCode() != 238 && m.getOpCode() != 230 || m.getElement(1) != 16 || m.getNumDataElements() != 16) {
            return AlmMsgTypes.NOT_ALM_MSG;
        }
        if (m.equals(almcapq)) {
            return AlmMsgTypes.ALM_ROUTCAPQ;
        }
        if (m.equals(almcapq, capqmask)) {
            return AlmMsgTypes.ALM_ROUTCAPREP;
        }
        if (m.equals(almchga, almchgam)) {
            return AlmMsgTypes.ALM_BAW;
        }
        if (m.equals(almgetr, almgetrm)) {
            return AlmMsgTypes.ALM_RDQ;
        }
        if (m.equals(capCsRr, csCapabilitiesMasks)) {
            return AlmMsgTypes.ALM_ROUTECSCAPREP;
        }
        return AlmMsgTypes.NOT_ALM_MSG;
    }
}

