/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.alm;

import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.alm.LnSimple7thGenRoute;
import jmri.jmrix.loconet.alm.LnSimpleRouteEntry;
import jmri.jmrix.loconet.alm.RouteSwitchPositionEnum;
import jmri.jmrix.loconet.ds64.SimpleTurnoutStateEntry;
import jmri.jmrix.loconet.swing.LnPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnSimple7thGenDeviceRoutes
extends LnPanel {
    private JComponent[] routePanel;
    private LnSimple7thGenRoute[] route;
    private final int deviceNumber;
    private final int serNum;
    private int baseAddr;
    private int howManyRoutes;
    private final String[] entryName;
    private int opsw1to7;
    private JTabbedPane routesTabbedPane;
    private static final Logger log = LoggerFactory.getLogger(LnSimple7thGenDeviceRoutes.class);

    public LnSimple7thGenDeviceRoutes(int deviceType, int serNum) {
        this.deviceNumber = deviceType;
        this.serNum = serNum;
        this.howManyRoutes = 8;
        if (this.deviceNumber == 124) {
            this.howManyRoutes = 16;
        }
        this.route = new LnSimple7thGenRoute[this.howManyRoutes];
        for (int i = 0; i < this.howManyRoutes; ++i) {
            this.route[i] = new LnSimple7thGenRoute();
        }
        this.entryName = new String[]{"Top", "2", "3", "4", "5", "6", "7", "8"};
    }

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
    }

    @Override
    public void initComponents() {
        super.initComponents();
        this.routesTabbedPane = new JTabbedPane();
        this.routePanel = new JComponent[this.howManyRoutes];
        this.route = new LnSimple7thGenRoute[this.howManyRoutes];
        for (int i = 0; i < this.howManyRoutes; ++i) {
            this.route[i] = new LnSimple7thGenRoute();
            this.routePanel[i] = this.makeTextPanel(i, 8);
            this.routesTabbedPane.addTab("Route " + Integer.toString(i + 1), null, this.routePanel[i], "");
            this.routesTabbedPane.setMnemonicAt(i, 49 + i);
        }
        this.routePanel[this.howManyRoutes - 1].setPreferredSize(new Dimension(460, 50));
        this.add(this.routesTabbedPane);
        this.routesTabbedPane.setTabLayoutPolicy(1);
        this.routesTabbedPane.addChangeListener(e -> {
            if (e.getSource() instanceof JTabbedPane) {
                JTabbedPane pane = (JTabbedPane)e.getSource();
                int routeNum = pane.getSelectedIndex() + 1;
                this.memo.getLnTrafficController().sendLocoNetMessage(new LocoNetMessage(new int[]{238, 16, 2, 2, (routeNum - 1) * 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
            }
        });
        this.routesTabbedPane.repaint();
        this.memo.getLnTrafficController().sendLocoNetMessage(new LocoNetMessage(new int[]{238, 16, 2, 14, 0, 0, 0, 0, 0, this.deviceNumber, this.opsw1to7, this.serNum & 0x7F, this.serNum >> 7 & 0x7F, this.baseAddr - 1 & 0x7F, this.baseAddr - 1 >> 7 & 0x7F, 0}));
    }

    protected JComponent makeTextPanel(int i, int numEntries) {
        JPanel panel = new JPanel(false);
        panel.setLayout(new BoxLayout(panel, 3));
        for (int j = 0; j < 8; ++j) {
            JPanel jp = new JPanel();
            jp.setLayout(new FlowLayout());
            SimpleTurnoutStateEntry stse = this.route[i].getRouteEntry((int)j).guiEntry;
            jp.add(stse.createEntryPanel(this.entryName[j]));
            jp.add(stse.getAddressField());
            jp.add(stse.closedRadioButton);
            jp.add(stse.thrownRadioButton);
            jp.add(stse.unusedRadioButton);
            ButtonGroup bg = new ButtonGroup();
            bg.add(stse.closedRadioButton);
            bg.add(stse.thrownRadioButton);
            bg.add(stse.unusedRadioButton);
            stse.unusedRadioButton.setSelected(true);
            panel.add(jp);
        }
        return panel;
    }

    public static int getDeviceType(String name) {
        String s;
        switch (s = name.toUpperCase()) {
            case "DS74": {
                return 116;
            }
            case "DS78V": {
                return 124;
            }
            case "PM74": {
                return 74;
            }
            case "SE74": {
                return 70;
            }
        }
        return -1;
    }

    public static String getDeviceName(int typeNum) {
        switch (typeNum) {
            case 116: {
                return "DS74";
            }
            case 124: {
                return "DS78V";
            }
            case 74: {
                return "PM74";
            }
            case 70: {
                return "SE74";
            }
        }
        return null;
    }

    public int getDeviceType() {
        return this.deviceNumber;
    }

    public int getSerNum() {
        return this.serNum;
    }

    public LnSimple7thGenRoute[] getRoutes() {
        return (LnSimple7thGenRoute[])this.route.clone();
    }

    public LnSimple7thGenRoute getRoutes(int routeNumber) {
        return this.route[routeNumber];
    }

    public void setRoutes(LnSimple7thGenRoute[] newRoutes) {
        this.route = (LnSimple7thGenRoute[])newRoutes.clone();
    }

    public void setOneEntry(int routeNum, int entryNum, int turn, RouteSwitchPositionEnum posn) {
        LnSimpleRouteEntry entry = new LnSimpleRouteEntry();
        entry.setNumber(turn);
        entry.setPosition(posn);
        this.route[routeNum].setRouteEntry(entryNum, entry);
    }

    public LnSimple7thGenRoute setFourEntries(int routeNum, int entrySet, int entrya, int entryb, int entryc, int entryd) {
        int entry = entrySet == 1 ? 4 : 0;
        int entryaTurn = entrya == 16383 ? 0 : entrya & 0x7FF;
        RouteSwitchPositionEnum entrya_posn = RouteSwitchPositionEnum.UNUSED;
        if (entrya != 16383) {
            entrya_posn = (entrya & 0x3800) == 6144 ? RouteSwitchPositionEnum.CLOSED : RouteSwitchPositionEnum.THROWN;
        }
        this.setOneEntry(routeNum, entry, entryaTurn, entrya_posn);
        int entrybTurn = entryb == 16383 ? 0 : entryb & 0x7FF;
        RouteSwitchPositionEnum entryb_posn = RouteSwitchPositionEnum.UNUSED;
        if (entryb != 16383) {
            entryb_posn = (entryb & 0x3800) == 6144 ? RouteSwitchPositionEnum.CLOSED : RouteSwitchPositionEnum.THROWN;
        }
        this.setOneEntry(routeNum, entry + 1, entrybTurn, entryb_posn);
        int entrycTurn = entryc == 16383 ? 0 : entryc & 0x7FF;
        RouteSwitchPositionEnum entryc_posn = RouteSwitchPositionEnum.UNUSED;
        if (entryc != 16383) {
            entryc_posn = (entryc & 0x3800) == 6144 ? RouteSwitchPositionEnum.CLOSED : RouteSwitchPositionEnum.THROWN;
        }
        this.setOneEntry(routeNum, entry + 2, entrycTurn, entryc_posn);
        int entrydTurn = entryd == 16383 ? 0 : entryd & 0x7FF;
        RouteSwitchPositionEnum entryd_posn = RouteSwitchPositionEnum.UNUSED;
        if (entryd != 16383) {
            entryd_posn = (entryd & 0x3800) == 6144 ? RouteSwitchPositionEnum.CLOSED : RouteSwitchPositionEnum.THROWN;
        }
        this.setOneEntry(routeNum, entry + 3, entrydTurn, entryd_posn);
        log.debug("setFourEntries: done: route {} entry {} thru {}, {}, {}, {}, {}", new Object[]{routeNum, entry, entry + 3, this.getOneEntryString(routeNum, entry), this.getOneEntryString(routeNum, entry + 1), this.getOneEntryString(routeNum, entry + 2), this.getOneEntryString(routeNum, entry + 3)});
        return this.getRoute(routeNum);
    }

    public String getOneEntryString(int routeNum, int entryNum) {
        RouteSwitchPositionEnum r = this.route[routeNum].getRouteEntry(entryNum).getPosition();
        if (r.equals((Object)RouteSwitchPositionEnum.UNUSED)) {
            return "Unused";
        }
        return Integer.toString(this.route[routeNum].getRouteEntry(entryNum).getNumber()) + r.toString();
    }

    public LnSimple7thGenRoute getRoute(int routeNum) {
        if (routeNum >= 0 && routeNum < this.route.length) {
            return this.route[routeNum];
        }
        log.warn("getRoutes({}): not configured.", (Object)routeNum);
        return null;
    }

    public int getBaseAddr() {
        return this.baseAddr;
    }

    public void setBaseAddr(int baseAddr) {
        this.baseAddr = baseAddr;
    }
}

