/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.alm;

import java.util.ArrayList;
import jmri.jmrix.loconet.alm.LnSimple7thGenDeviceRoutes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnSimple7thGenDevicesRoutes {
    private final ArrayList<LnSimple7thGenDeviceRoutes> devicesRoutes = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(LnSimple7thGenDevicesRoutes.class);

    public void add(LnSimple7thGenDeviceRoutes dr) {
        LnSimple7thGenDeviceRoutes deviceRoutes = this.isDeviceRoutes(dr) ? this.getDeviceRoutes(dr) : new LnSimple7thGenDeviceRoutes(dr.getDeviceType(), dr.getSerNum());
        deviceRoutes.setRoutes(dr.getRoutes());
        this.devicesRoutes.add(deviceRoutes);
    }

    public boolean isDeviceRoutes(LnSimple7thGenDeviceRoutes dr) {
        for (LnSimple7thGenDeviceRoutes lndr : this.devicesRoutes) {
            if (lndr.getDeviceType() != dr.getDeviceType() || lndr.getSerNum() != dr.getSerNum()) continue;
            return true;
        }
        return false;
    }

    public boolean isDeviceRoutes(int deviceType, int serNum) {
        for (LnSimple7thGenDeviceRoutes lndr : this.devicesRoutes) {
            if (lndr.getDeviceType() != deviceType || lndr.getSerNum() != serNum) continue;
            return true;
        }
        return false;
    }

    public LnSimple7thGenDeviceRoutes getDeviceRoutes(int deviceType, int serNum) {
        for (LnSimple7thGenDeviceRoutes lndr : this.devicesRoutes) {
            if (lndr.getDeviceType() != deviceType || lndr.getSerNum() != serNum) continue;
            return lndr;
        }
        return null;
    }

    public LnSimple7thGenDeviceRoutes getDeviceRoutes(LnSimple7thGenDeviceRoutes dr) {
        for (LnSimple7thGenDeviceRoutes lndr : this.devicesRoutes) {
            if (lndr.getDeviceType() != dr.getDeviceType() || lndr.getSerNum() != dr.getSerNum()) continue;
            return lndr;
        }
        return null;
    }

    public void removeExistingDevice(int devType, int serNum) {
        for (LnSimple7thGenDeviceRoutes lndr : this.devicesRoutes) {
            if (lndr.getDeviceType() != devType || lndr.getSerNum() != serNum) continue;
            this.devicesRoutes.remove(lndr);
            return;
        }
        log.warn("removeExistingDevice: device type/serNum not found.");
    }

    public int size() {
        return this.devicesRoutes.size();
    }

    public LnSimple7thGenDeviceRoutes getDeviceRoutes(int i) {
        if (this.devicesRoutes.size() > i && i >= 0) {
            return this.devicesRoutes.get(i);
        }
        return null;
    }
}

