/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.alm.almi;

import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.alm.Alm;
import jmri.jmrix.loconet.alm.almi.Bundle;

public class Almir {
    private static final String EMPTY = "";
    private static final LocoNetMessage DESEL = new LocoNetMessage(new int[]{238, 16, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3});
    private static final LocoNetMessage almRouteCapabilitiesQuery = new LocoNetMessage(new int[]{238, 16, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private static final LocoNetMessage almRouteCapabilitiesQuery2 = new LocoNetMessage(new int[]{238, 16, 1, 0, 0, 0, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private static final LocoNetMessage cmdStnRoutesCap = new LocoNetMessage(new int[]{230, 16, 1, 0, 64, 0, 3, 2, 8, 127, 0, 0, 0, 0, 0, 100});
    private static final LocoNetMessage cmdStnRoutesCap2 = new LocoNetMessage(new int[]{230, 16, 1, 0, 0, 2, 3, 2, 16, 127, 0, 0, 0, 0, 0, 100});
    private static final LocoNetMessage AlmRoutesDataQuery = new LocoNetMessage(new int[]{238, 16, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private static final int[] ardqm = new int[]{255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private Almir() {
        throw new IllegalStateException("Utility class");
    }

    static String interpretAlmRoutes(LocoNetMessage l) {
        if (l.getElement(2) != 1 && l.getElement(2) != 2) {
            return EMPTY;
        }
        if (l.getNumDataElements() != 16) {
            return EMPTY;
        }
        if (l.equals(DESEL)) {
            return Bundle.getMessage("MSG_LN_ALM_DEVICE_DESEL");
        }
        String ret = Almir.cardq(l);
        if (ret.length() > 1) {
            return ret;
        }
        String key = EMPTY;
        if (l.getOpCode() == 230 && l.getElement(3) == 2) {
            if (l.getElement(2) == 1) {
                key = "LN_MSG_ALM_ROUTE_CMD_STN_REPORT";
            } else {
                if (l.getElement(2) != 2) {
                    return EMPTY;
                }
                key = "LN_MSG_ALM_ROUTE_DEV_REPORT";
            }
        } else if (l.getOpCode() == 238 && l.getElement(3) == 3) {
            if (l.getElement(2) == 1) {
                key = "LN_MSG_ALM_ROUTE_CMD_STN_WRITE";
            } else {
                if (l.getElement(2) != 2) {
                    return EMPTY;
                }
                key = "LN_MSG_ALM_ROUTE_DEV_WRITE";
            }
        }
        if (key.length() > 1) {
            return Bundle.getMessage(key, 1 + ((l.getElement(4) + l.getElement(5) * 128) / 2 & 0x7F), 1 + ((l.getElement(4) & 1) << 2), 4 + ((l.getElement(4) & 1) << 2), 1 + ((l.getElement(4) + l.getElement(5) * 128) / 4 & 0x3F), 1 + ((l.getElement(4) & 3) << 2), 4 + ((l.getElement(4) & 3) << 2), Almir.getTurnoutNum(l, 0), Almir.getTurnoutStat(l, 0), Almir.getTurnoutNum(l, 1), Almir.getTurnoutStat(l, 1), Almir.getTurnoutNum(l, 2), Almir.getTurnoutStat(l, 2), Almir.getTurnoutNum(l, 3), Almir.getTurnoutStat(l, 3));
        }
        ret = Almir.checkarcq(l);
        if (ret.length() > 1) {
            return ret;
        }
        ret = Almir.checkCsrc1(l);
        if (ret.length() > 1) {
            return ret;
        }
        ret = Almir.checkCsrc2(l);
        if (ret.length() > 1) {
            return ret;
        }
        ret = Almir.dealWithAlmStyle2(l);
        if (ret.length() > 1) {
            return ret;
        }
        return EMPTY;
    }

    private static String checkarcq(LocoNetMessage l) {
        if (l.equals(almRouteCapabilitiesQuery) || l.equals(almRouteCapabilitiesQuery2)) {
            return Bundle.getMessage("LN_MSG_ALM_RTS_CAP_Q");
        }
        return EMPTY;
    }

    private static String cardq(LocoNetMessage l) {
        if (l.equals(AlmRoutesDataQuery, ardqm)) {
            return Bundle.getMessage("LN_MSG_CMD_STN_ROUTE_QUERY", Almir.getRouteNum(l), Almir.getTurnoutGroup(l), Almir.getTurnoutGroup(l) + 3, Almir.getAltRouteNum(l), Almir.getAltTurnoutGroup(l), Almir.getAltTurnoutGroup(l) + 3);
        }
        return EMPTY;
    }

    private static int getTurnoutGroup(LocoNetMessage l) {
        return 1 + ((l.getElement(4) & 1) << 2);
    }

    private static int getAltTurnoutGroup(LocoNetMessage l) {
        return 1 + ((l.getElement(4) & 3) << 2);
    }

    private static int getRouteNum(LocoNetMessage l) {
        return 1 + ((l.getElement(4) + l.getElement(5) * 128) / 2 & 0x7F);
    }

    private static int getAltRouteNum(LocoNetMessage l) {
        return 1 + ((l.getElement(4) + l.getElement(5) * 128) / 4 & 0x3F);
    }

    private static String checkCsrc1(LocoNetMessage l) {
        if (l.equals(cmdStnRoutesCap)) {
            return Bundle.getMessage("LN_MSG_ALM_RTS_CAP_R");
        }
        return EMPTY;
    }

    private static String checkCsrc2(LocoNetMessage l) {
        if (l.equals(cmdStnRoutesCap2)) {
            return Bundle.getMessage("LN_MSG_ALM_RTS_CAP_R2");
        }
        return EMPTY;
    }

    private static String getTurnoutNum(LocoNetMessage l, int num) {
        if (l.getElement(7 + num * 2) == 127 && l.getElement(8 + num * 2) == 127) {
            return Bundle.getMessage("LN_ROUTE_UNUSED_ENTRY_HELPER");
        }
        if (num < 0 || num > 3) {
            throw new IllegalArgumentException();
        }
        int val = 1 + l.getElement(7 + num * 2) + ((l.getElement(8 + num * 2) & 0xF) << 7);
        return Integer.toString(val);
    }

    private static String getTurnoutStat(LocoNetMessage l, int num) {
        if (l.getElement(7 + num * 2) == 127 && l.getElement(8 + num * 2) == 127) {
            return EMPTY;
        }
        if (num < 0 || num > 3) {
            throw new IllegalArgumentException();
        }
        boolean isClosed = (l.getElement(8 + num * 2) & 0x20) == 32;
        return isClosed ? Bundle.getMessage("LN_SW_CLOSED") : Bundle.getMessage("LN_SW_THROWN");
    }

    private static String dealWithAlmStyle2(LocoNetMessage l) {
        int re;
        int be;
        int ents;
        int rts;
        String dev;
        int sn = Almir.getSN(l);
        String ser = Integer.toHexString(sn);
        int bs = Almir.getBS(l);
        boolean enb = Almir.getEnb(l);
        String enable = enb ? Bundle.getMessage("LN_MSG_HELPER_DISABLED") : Bundle.getMessage("LN_MSG_HELPER_ENABLED");
        DevMode mod = Almir.getMode(l);
        switch (l.getElement(9)) {
            case 116: {
                dev = "DS74";
                rts = 8;
                ents = 8;
                be = mod == DevMode.DS74_LIGHT ? bs + 7 : bs + 3;
                break;
            }
            case 124: {
                dev = "DS78V";
                rts = 16;
                ents = 8;
                be = mod == DevMode.DS78V_3_POS ? bs + 15 : bs + 7;
                break;
            }
            case 70: {
                dev = "SE74";
                rts = 64;
                ents = 16;
                be = bs + 36;
                break;
            }
            case 74: {
                dev = "PM74";
                rts = 0;
                ents = 0;
                be = bs + 7;
                break;
            }
            case 67: {
                dev = "BDL716";
                rts = 0;
                ents = 0;
                be = bs + 15;
                break;
            }
            default: {
                dev = Bundle.getMessage("LN_MSG_ALM_HELPER_DEVICE_UNKNOWN");
                be = bs;
                rts = 0;
                ents = 0;
            }
        }
        int rn = 1 + l.getElement(4) / 2 + ((l.getElement(5) & 3) << 6);
        int n = re = (l.getElement(4) & 1) == 1 ? 5 : 1;
        if (Alm.isDs7xRQ(l)) {
            return Bundle.getMessage("LN_MSG_ALM_SEL_ROUTE_QUERY", rn, re, re + 3);
        }
        if (Alm.isDs74CapsRpt(l) || Alm.isDs78vCapsRpt(l) || Alm.isSe74CapsRpt(l) || Alm.isPm74CapsRpt(l)) {
            String mode;
            if (Alm.isDs74CapsRpt(l) || Alm.isDs78vCapsRpt(l)) {
                switch ((l.getElement(10) & 0x1E) >> 1) {
                    case 0: {
                        mode = "LN_MSG_ALM_HELPER_DEV_MODE_PS";
                        be = bs + 3;
                        break;
                    }
                    case 1: {
                        mode = "LN_MSG_ALM_HELPER_DEV_MODE_SM";
                        be = bs + 3;
                        break;
                    }
                    case 2: {
                        mode = "LN_MSG_ALM_HELPER_DEV_MODE_S2";
                        be = bs + 7;
                        break;
                    }
                    case 5: {
                        mode = "LN_MSG_ALM_HELPER_DEV_MODE_LT";
                        be = bs + 7;
                        break;
                    }
                    case 6: {
                        mode = "LN_MSG_ALM_HELPER_DEV_MODE_S3";
                        be = bs + 15;
                        break;
                    }
                    default: {
                        mode = "LN_MSG_ALM_HELPER_DEV_MODE_UNDEF";
                        be = bs;
                        break;
                    }
                }
            } else if (Alm.isSe74CapsRpt(l)) {
                mode = "LN_MSG_ALM_HELPER_DEV_MODE_UNDEF";
            } else if (Alm.isPm74CapsRpt(l)) {
                mode = "LN_MSG_ALM_HELPER_DEV_MODE_UNDEF";
            } else {
                be = bs;
                mode = "LN_MSG_ALM_HELPER_DEV_MODE_UNDEF";
            }
            mode = Bundle.getMessage(mode);
            if (Alm.isPm74CapsRpt(l)) {
                return Bundle.getMessage("LN_MSG_DEVICE_NO_ROUTES_CAPABILITIES_REPLY", dev, ser, bs);
            }
            return Bundle.getMessage("LN_MSG_DEVICE_ROUTES_CAPABILITIES_REPLY", dev, ser, mode, enable, bs, be, rts, ents);
        }
        LocoNetMessage seldev = new LocoNetMessage(new int[]{238, 16, 2, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        int[] sdm = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0};
        if (l.equals(seldev, sdm)) {
            return Bundle.getMessage("LN_MSG_DEVICE_ROUTES_SELECT_REQUEST", dev, ser, bs, be);
        }
        seldev.setElement(0, 230);
        sdm[4] = 0;
        sdm[5] = 0;
        sdm[6] = 0;
        sdm[7] = 0;
        sdm[8] = 0;
        if (l.equals(seldev, sdm)) {
            return Bundle.getMessage("LN_MSG_DEV_ROUTES_SELECT_REPLY", dev, ser, Integer.toString(bs), Integer.toString(be));
        }
        if (Alm.isDevBAW(l)) {
            return Bundle.getMessage("LN_MSG_ALM_DEVICE_CHG_SA", dev, ser, Integer.toString(bs));
        }
        return EMPTY;
    }

    private static int getSN(LocoNetMessage l) {
        return l.getElement(11) + (l.getElement(12) << 7);
    }

    private static int getBS(LocoNetMessage l) {
        return l.getElement(13) + (l.getElement(14) << 7) + 1;
    }

    private static boolean getEnb(LocoNetMessage l) {
        return (l.getElement(10) & 0x40) == 64;
    }

    private static DevMode getMode(LocoNetMessage l) {
        if (l.getElement(9) == 116) {
            switch (l.getElement(10) & 0x1E) {
                case 0: {
                    return DevMode.DS74_SOLE;
                }
                case 2: {
                    return DevMode.DS74_STALL;
                }
                case 10: {
                    return DevMode.DS74_LIGHT;
                }
            }
        } else if (l.getElement(9) == 124) {
            switch (l.getElement(10) & 0xF) {
                case 4: {
                    return DevMode.DS78V_2_POS;
                }
                case 12: {
                    return DevMode.DS78V_3_POS;
                }
            }
        }
        return DevMode.UNKN;
    }

    private static enum DevMode {
        DS74_SOLE,
        DS74_STALL,
        DS74_LIGHT,
        DS78V_2_POS,
        DS78V_3_POS,
        UNKN;

    }
}

