/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.bdl16;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jmri.jmrix.loconet.AbstractBoardProgPanel;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.bdl16.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDL16Panel
extends AbstractBoardProgPanel {
    JComboBox<Integer> addressComboBox;
    int[] boardNumbers;
    int origAccessBoardNum = 0;
    ArrayList<Integer> boardNumsEntryValue = new ArrayList();
    JComboBox<String>[] comboBox = new JComboBox[48];
    private GridBagConstraints gc = new GridBagConstraints();
    private GridBagLayout gl = new GridBagLayout();
    private static final Logger log = LoggerFactory.getLogger(BDL16Panel.class);

    public BDL16Panel() {
        this(1, false);
    }

    public BDL16Panel(int boardNum, boolean readOnInit) {
        super(boardNum, readOnInit, "BDL16");
        this.setTypeWord(113);
        this.origAccessBoardNum = boardNum;
        this.boardNumsEntryValue.add(boardNum);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.bdl16.BDL16Frame";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("MenuItemBDL16Programmer"));
    }

    @Override
    protected void copyToOpsw() {
        this.opsw[1] = this.comboBox[1].getSelectedIndex() == 1;
        this.opsw[3] = this.comboBox[3].getSelectedIndex() == 1;
        this.opsw[5] = this.comboBox[5].getSelectedIndex() == 1;
        this.opsw[6] = this.comboBox[6].getSelectedIndex() == 1;
        this.opsw[7] = this.comboBox[7].getSelectedIndex() == 1;
        this.opsw[9] = this.comboBox[9].getSelectedIndex() == 1;
        this.opsw[10] = this.comboBox[10].getSelectedIndex() == 1;
        this.opsw[11] = this.comboBox[11].getSelectedIndex() == 1;
        this.opsw[12] = this.comboBox[12].getSelectedIndex() == 1;
        this.opsw[13] = this.comboBox[13].getSelectedIndex() == 1;
        this.opsw[19] = this.comboBox[19].getSelectedIndex() == 1;
        this.opsw[25] = this.comboBox[25].getSelectedIndex() == 1;
        this.opsw[26] = this.comboBox[26].getSelectedIndex() == 1;
        this.opsw[36] = this.comboBox[36].getSelectedIndex() == 1;
        this.opsw[39] = this.comboBox[39].getSelectedIndex() == 1;
        this.opsw[42] = this.comboBox[42].getSelectedIndex() == 1;
        int index = this.comboBox[37].getSelectedIndex();
        this.opsw[37] = index == 1 || index == 3;
        this.opsw[38] = index >= 2;
        index = this.comboBox[43].getSelectedIndex();
        this.opsw[43] = index == 1 || index == 3;
        this.opsw[44] = index >= 2;
        this.opsw[40] = this.comboBox[40].getSelectedIndex() == 1;
    }

    @Override
    protected void updateDisplay() {
        this.comboBox[1].setSelectedIndex(this.opsw[1] ? 1 : 0);
        this.comboBox[3].setSelectedIndex(this.opsw[3] ? 1 : 0);
        this.comboBox[5].setSelectedIndex(this.opsw[5] ? 1 : 0);
        this.comboBox[6].setSelectedIndex(this.opsw[6] ? 1 : 0);
        this.comboBox[7].setSelectedIndex(this.opsw[7] ? 1 : 0);
        this.comboBox[9].setSelectedIndex(this.opsw[9] ? 1 : 0);
        this.comboBox[10].setSelectedIndex(this.opsw[10] ? 1 : 0);
        this.comboBox[11].setSelectedIndex(this.opsw[11] ? 1 : 0);
        this.comboBox[12].setSelectedIndex(this.opsw[12] ? 1 : 0);
        this.comboBox[13].setSelectedIndex(this.opsw[13] ? 1 : 0);
        this.comboBox[19].setSelectedIndex(this.opsw[19] ? 1 : 0);
        this.comboBox[25].setSelectedIndex(this.opsw[25] ? 1 : 0);
        this.comboBox[26].setSelectedIndex(this.opsw[26] ? 1 : 0);
        this.comboBox[36].setSelectedIndex(this.opsw[36] ? 1 : 0);
        this.comboBox[39].setSelectedIndex(this.opsw[39] ? 1 : 0);
        this.comboBox[42].setSelectedIndex(this.opsw[42] ? 1 : 0);
        this.comboBox[40].setSelectedIndex(this.opsw[40] ? 1 : 0);
        int temp = this.opsw[37] ? 1 : 0;
        this.comboBox[37].setSelectedIndex(temp += this.opsw[38] ? 2 : 0);
        temp = this.opsw[43] ? 1 : 0;
        this.comboBox[43].setSelectedIndex(temp += this.opsw[44] ? 2 : 0);
    }

    @Override
    protected int nextState(int state) {
        switch (state) {
            case 1: {
                return 3;
            }
            case 3: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 9;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 12;
            }
            case 12: {
                return 13;
            }
            case 13: {
                return 19;
            }
            case 19: {
                return 25;
            }
            case 25: {
                return 26;
            }
            case 26: {
                return 36;
            }
            case 36: {
                return 37;
            }
            case 37: {
                return 38;
            }
            case 38: {
                return 39;
            }
            case 39: {
                return 42;
            }
            case 42: {
                return 43;
            }
            case 43: {
                return 44;
            }
            case 44: {
                return 40;
            }
            case 40: {
                return 0;
            }
        }
        log.error("unexpected state {}", (Object)state);
        return 0;
    }

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        LocoNetMessage m = new LocoNetMessage(6);
        m.setElement(0, 208);
        m.setElement(1, 98);
        m.setElement(2, 0);
        m.setElement(3, 112);
        m.setElement(4, 0);
        memo.getLnTrafficController().sendLocoNetMessage(m);
    }

    @Override
    public void initComponents() {
        JPanel addressingPanel = this.provideAddressing(" ");
        int indexOfTargetBoardAddress = 0;
        this.addressComboBox = new JComboBox();
        Integer index = 0;
        while (index < this.boardNumsEntryValue.size()) {
            if (this.boardNumsEntryValue.get(index) == this.origAccessBoardNum) {
                this.origAccessBoardNum = -1;
                indexOfTargetBoardAddress = index;
            }
            this.addressComboBox.addItem(this.boardNumsEntryValue.get(index));
            index = index + 1;
        }
        this.addressComboBox.setSelectedIndex(indexOfTargetBoardAddress);
        addressingPanel.add((Component)this.addressComboBox, 2);
        addressingPanel.getComponent(1).setVisible(false);
        this.addressComboBox.setEditable(true);
        addressingPanel.add((Component)new JLabel(Bundle.getMessage("LabelBoardID")), 1);
        addressingPanel.getComponent(0).setVisible(false);
        this.readAllButton.setPreferredSize(null);
        this.readAllButton.setText(Bundle.getMessage("ButtonReadFullSheet"));
        this.readAllButton.setToolTipText(Bundle.getMessage("ToolTipButtonReadFullSheet"));
        this.writeAllButton.setPreferredSize(null);
        this.writeAllButton.setText(Bundle.getMessage("ButtonWriteFullSheet"));
        this.writeAllButton.setToolTipText(Bundle.getMessage("ToolTipButtonWriteFullSheet"));
        Dimension d = this.writeAllButton.getPreferredSize();
        int w = d.width;
        d = this.readAllButton.getPreferredSize();
        if (d.width > w) {
            w = d.width;
        }
        this.writeAllButton.setPreferredSize(new Dimension((int)((double)w * 1.1), d.height));
        this.readAllButton.setPreferredSize(new Dimension((int)((double)w * 1.1), d.height));
        this.appendLine(addressingPanel);
        JPanel frame1 = new JPanel();
        frame1.setLayout(new BoxLayout(frame1, 3));
        Border blackline = BorderFactory.createLineBorder(Color.black);
        TitledBorder allBoardsTitleBorder = BorderFactory.createTitledBorder(blackline, Bundle.getMessage("TitledBorderLabelAllBoards"));
        frame1.setBorder(allBoardsTitleBorder);
        JPanel allBoardsOptions = new JPanel();
        allBoardsOptions.setLayout(this.gl);
        this.gc.ipadx = 15;
        this.gc.ipady = 20;
        this.gc.gridy = 0;
        allBoardsOptions.add(this.getLabel(1));
        allBoardsOptions.add(this.getComboBox(1));
        ++this.gc.gridy;
        allBoardsOptions.add(this.getLabel(9));
        allBoardsOptions.add(this.getComboBox(9));
        ++this.gc.gridy;
        allBoardsOptions.add(this.getLabel(10));
        allBoardsOptions.add(this.getComboBox(10));
        ++this.gc.gridy;
        allBoardsOptions.add(this.getLabel(11));
        allBoardsOptions.add(this.getComboBox(11));
        ++this.gc.gridy;
        allBoardsOptions.add(this.getLabel(12));
        allBoardsOptions.add(this.getComboBox(12));
        ++this.gc.gridy;
        allBoardsOptions.add(this.getLabel(13));
        allBoardsOptions.add(this.getComboBox(13));
        ++this.gc.gridy;
        allBoardsOptions.add(this.getLabel(19));
        allBoardsOptions.add(this.getComboBox(19));
        ++this.gc.gridy;
        allBoardsOptions.add(this.getLabel(25));
        allBoardsOptions.add(this.getComboBox(25));
        ++this.gc.gridy;
        allBoardsOptions.add(this.getLabel(26));
        allBoardsOptions.add(this.getComboBox(26));
        ++this.gc.gridy;
        allBoardsOptions.add(this.getLabel(40));
        allBoardsOptions.add(this.getComboBox(40));
        frame1.add(allBoardsOptions);
        JPanel frame2 = new JPanel();
        frame2.setLayout(new BoxLayout(frame2, 3));
        TitledBorder bdl162Bdl168BoardsTitleBorder = BorderFactory.createTitledBorder(blackline, Bundle.getMessage("TitledBorderLabelBdl162Bdl168Boards"));
        frame2.setBorder(bdl162Bdl168BoardsTitleBorder);
        JPanel bdl162Bdl168BoardsOptions = new JPanel();
        bdl162Bdl168BoardsOptions.setLayout(this.gl);
        this.gc.gridy = 0;
        bdl162Bdl168BoardsOptions.add(this.getLabel(3));
        bdl162Bdl168BoardsOptions.add(this.getComboBox(3));
        ++this.gc.gridy;
        bdl162Bdl168BoardsOptions.add(this.getLabel(5));
        bdl162Bdl168BoardsOptions.add(this.getComboBox(5));
        ++this.gc.gridy;
        bdl162Bdl168BoardsOptions.add(this.getLabel(6));
        bdl162Bdl168BoardsOptions.add(this.getComboBox(6));
        ++this.gc.gridy;
        bdl162Bdl168BoardsOptions.add(this.getLabel(7));
        bdl162Bdl168BoardsOptions.add(this.getComboBox(7));
        ++this.gc.gridy;
        bdl162Bdl168BoardsOptions.add(this.getLabel(36));
        bdl162Bdl168BoardsOptions.add(this.getComboBox(36));
        frame2.add(bdl162Bdl168BoardsOptions);
        frame1.add(frame2);
        JPanel frame3 = new JPanel();
        frame3.setLayout(new BoxLayout(frame3, 3));
        TitledBorder bdl168SpecificTitleBorder = BorderFactory.createTitledBorder(blackline, Bundle.getMessage("TitledBorderLabelBdl168Only"));
        frame3.setBorder(bdl168SpecificTitleBorder);
        JPanel bdl168SpecificOptions = new JPanel();
        bdl168SpecificOptions.setLayout(this.gl);
        this.gc.gridy = 0;
        bdl168SpecificOptions.add(this.getLabel(37, 38));
        bdl168SpecificOptions.add(this.getComboBox(37, 38));
        ++this.gc.gridy;
        bdl168SpecificOptions.add(this.getLabel(42));
        bdl168SpecificOptions.add(this.getComboBox(42));
        ++this.gc.gridy;
        bdl168SpecificOptions.add(this.getLabel(39));
        bdl168SpecificOptions.add(this.getComboBox(39));
        ++this.gc.gridy;
        bdl168SpecificOptions.add(this.getLabel(43, 44));
        bdl168SpecificOptions.add(this.getComboBox(43, 44));
        frame3.add(bdl168SpecificOptions);
        frame2.add(frame3);
        this.appendLine(frame1);
        this.appendLine(this.provideStatusLine());
        this.setStatus(Bundle.getMessage("STATUS_TEXT_BOARD_MODE"));
        this.panelToScroll();
    }

    private JLabel getLabel(int n) {
        Object number = Integer.toString(n);
        if (((String)number).length() == 1) {
            number = "0" + (String)number;
        }
        JLabel label = new JLabel(Bundle.getMessage("LabelX", number));
        label.setHorizontalAlignment(4);
        label.setPreferredSize(new JLabel("XXXXXXXXXXXXXXXXXX").getPreferredSize());
        this.gc.gridx = 0;
        this.gc.weightx = 0.5;
        this.gc.anchor = 13;
        this.gl.setConstraints(label, this.gc);
        return label;
    }

    private JLabel getLabel(int n, int n2) {
        Object number2;
        Object number = Integer.toString(n);
        if (((String)number).length() == 1) {
            number = "0" + (String)number;
        }
        if (((String)(number2 = Integer.toString(n2))).length() == 1) {
            number2 = "0" + (String)number2;
        }
        JLabel label = new JLabel(Bundle.getMessage("LabelXY", number, number2));
        label.setHorizontalAlignment(4);
        label.setPreferredSize(new JLabel("XXXXXXXXXXXXXXXXXX").getPreferredSize());
        this.gc.gridx = 0;
        this.gc.weightx = 0.5;
        this.gc.anchor = 13;
        this.gl.setConstraints(label, this.gc);
        return label;
    }

    private JComboBox<String> getComboBox(int n) {
        Object number = Integer.toString(n);
        if (((String)number).length() == 1) {
            number = "0" + (String)number;
        }
        String[] s = new String[]{Bundle.getMessage("COMBOBOX_TEXT_OPSW" + (String)number + "_THROWN"), Bundle.getMessage("COMBOBOX_TEXT_OPSW" + (String)number + "_CLOSED")};
        this.comboBox[n] = new JComboBox<String>(s);
        this.comboBox[n].setSelectedIndex(this.getIndexForDefault(n));
        this.comboBox[n].setPreferredSize(new JLabel("XXXXXXX" + Bundle.getMessage("COMBOBOX_TEXT_OPSW36_THROWN")).getPreferredSize());
        this.gc.gridx = 1;
        this.gc.weightx = 1.0;
        this.gc.anchor = 17;
        this.gl.setConstraints(this.comboBox[n], this.gc);
        return this.comboBox[n];
    }

    private JComboBox<String> getComboBox(int n, int n2) {
        Object number2;
        Object number = Integer.toString(n);
        if (((String)number).length() == 1) {
            number = "0" + (String)number;
        }
        if (((String)(number2 = Integer.toString(n2))).length() == 1) {
            number2 = "0" + (String)number2;
        }
        this.comboBox[n] = new JComboBox<String>(new String[]{Bundle.getMessage("COMBOBOX_TEXT_OPSW" + (String)number + "_THROWN_OPSW" + (String)number2 + "_THROWN"), Bundle.getMessage("COMBOBOX_TEXT_OPSW" + (String)number + "_CLOSED_OPSW" + (String)number2 + "_THROWN"), Bundle.getMessage("COMBOBOX_TEXT_OPSW" + (String)number + "_THROWN_OPSW" + (String)number2 + "_CLOSED"), Bundle.getMessage("COMBOBOX_TEXT_OPSW" + (String)number + "_CLOSED_OPSW" + (String)number2 + "_CLOSED")});
        this.comboBox[n].setPreferredSize(new JLabel("XXXXXXX" + Bundle.getMessage("COMBOBOX_TEXT_OPSW36_THROWN")).getPreferredSize());
        this.gc.gridx = 1;
        this.gc.weightx = 1.0;
        this.gc.anchor = 17;
        this.gl.setConstraints(this.comboBox[n], this.gc);
        return this.comboBox[n];
    }

    private int getIndexForDefault(int n) {
        switch (n) {
            case 5: 
            case 11: 
            case 12: {
                return 1;
            }
        }
        return 0;
    }

    private boolean alreadyKnowThisBoardId(Integer id) {
        return this.boardNumsEntryValue.contains(id);
    }

    private Integer addBoardIdToList(Integer id) {
        this.boardNumsEntryValue.add(this.boardNumsEntryValue.size(), id);
        this.addressComboBox.removeAllItems();
        Collections.sort(this.boardNumsEntryValue);
        Integer indexOfTargetBoardAddress = 0;
        Integer index = 0;
        while (index < this.boardNumsEntryValue.size()) {
            if (this.boardNumsEntryValue.get(index).equals(id)) {
                indexOfTargetBoardAddress = index;
            }
            this.addressComboBox.addItem(this.boardNumsEntryValue.get(index));
            index = index + 1;
        }
        return indexOfTargetBoardAddress;
    }

    private void selectBoardIdByIndex(Integer index) {
        this.addressComboBox.setSelectedIndex(index);
    }

    @Override
    public void readAll() {
        this.addrField.setText(this.addressComboBox.getSelectedItem().toString());
        Integer curAddr = Integer.parseInt(this.addrField.getText());
        if (!this.alreadyKnowThisBoardId(curAddr)) {
            Integer index = this.addBoardIdToList(curAddr);
            this.selectBoardIdByIndex(index);
        }
        super.readAll();
    }

    @Override
    public void message(LocoNetMessage m) {
        Integer extractedBoardId;
        super.message(m);
        if (m.getOpCode() == 208 && (m.getElement(1) & 0x7E) == 98 && m.getElement(3) == 1 && !this.alreadyKnowThisBoardId(extractedBoardId = Integer.valueOf(1 + ((m.getElement(1) & 1) << 7) + (m.getElement(2) & 0x7F)))) {
            this.addBoardIdToList(extractedBoardId);
        }
    }
}

