/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.clockmon;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotListener;
import jmri.jmrix.loconet.clockmon.Bundle;
import jmri.jmrix.loconet.swing.LnPanel;
import jmri.util.swing.WrapLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockMonPane
extends LnPanel
implements SlotListener {
    JTextField days = new JTextField("00");
    JTextField hours = new JTextField("00");
    JTextField minutes = new JTextField("00");
    JTextField frac_mins = new JTextField("00");
    JTextField rate = new JTextField(4);
    JButton readButton = new JButton(Bundle.getMessage("ButtonRead"));
    static final JTextField spacer = new JTextField("123");
    private static final Logger log = LoggerFactory.getLogger(ClockMonPane.class);

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.clockmon.ClockMonFrame";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("MenuItemClockMon"));
    }

    @Override
    public void initComponents(final LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new WrapLayout());
        panel1.add(new JLabel(Bundle.getMessage("ClockDayLabel")));
        panel1.add(this.days);
        this.days.setPreferredSize(spacer.getPreferredSize());
        panel1.add(new JLabel(Bundle.getMessage("ClockTimeLabel")));
        panel1.add(this.hours);
        this.hours.setPreferredSize(spacer.getPreferredSize());
        panel1.add(new JLabel(":"));
        panel1.add(this.minutes);
        this.minutes.setPreferredSize(spacer.getPreferredSize());
        panel1.add(new JLabel("."));
        panel1.add(this.frac_mins);
        this.add(panel1);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new WrapLayout());
        panel2.add(new JLabel(Bundle.getMessage("ClockRateLabel")));
        panel2.add(this.rate);
        this.add(panel2);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new WrapLayout());
        panel3.add(this.readButton);
        this.add(panel3);
        this.notifyChangedSlot(memo.getSlotManager().slot(123));
        this.readButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                memo.getSlotManager().sendReadSlot(123);
            }
        });
        if (memo.getSlotManager() != null) {
            memo.getSlotManager().addSlotListener(this);
        } else {
            log.error("No LocoNet connection available, can't function");
        }
    }

    @Override
    public void notifyChangedSlot(LocoNetSlot s) {
        if (s.getSlot() != 123) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("slot update {}", (Object)s);
        }
        this.days.setText("" + s.getFcDays());
        this.hours.setText("" + s.getFcHours());
        this.minutes.setText("" + s.getFcMinutes());
        this.rate.setText("" + s.getFcRate());
        this.frac_mins.setText("" + s.getFcFracMins());
    }

    @Override
    public void dispose() {
        if (this.memo.getSlotManager() != null) {
            this.memo.getSlotManager().removeSlotListener(this);
        }
        super.dispose();
    }
}

