/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.configurexml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import jmri.jmrit.XmlFile;
import jmri.jmrix.loconet.Ln7gAccyRoutesManager;
import jmri.jmrix.loconet.alm.LnSimple7thGenDeviceRoutes;
import jmri.jmrix.loconet.alm.LnSimpleRouteEntry;
import jmri.jmrix.loconet.alm.RouteSwitchPositionEnum;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Digitrax7thGenAccyRoutesXML {
    private final Ln7gAccyRoutesManager l7garm;
    private static final Logger log = LoggerFactory.getLogger(Digitrax7thGenAccyRoutesXML.class);

    public Digitrax7thGenAccyRoutesXML(Ln7gAccyRoutesManager l7garm) {
        this.l7garm = l7garm;
    }

    public boolean loadXML() {
        if (this.l7garm.getCountOfDevicesWithRoutes() > 0) {
            log.warn("loadXML: already loaded.  Quitting.");
            return true;
        }
        DigitraxRoutesXmlFile xmlFile = new DigitraxRoutesXmlFile();
        File file = xmlFile.getLoadFile();
        if (file == null) {
            this.doStore();
            file = xmlFile.getStoreFile();
        }
        if (!file.exists()) {
            log.warn("loadXML: Note: File does not exist.");
            return false;
        }
        try {
            Element root = xmlFile.rootFromFile(file);
            if (root == null) {
                log.warn("loadXML: File could not be read");
                return false;
            }
            if (!root.getName().equals("DigitraxRoutesPreferences")) {
                log.warn("loadXML: Wrong root name: {}", (Object)root.getName());
                return false;
            }
            for (Element routes : root.getChildren()) {
                if (!routes.getAttributeValue("class").equals("Accy7thGenRoutes.configurexml.RoutesManagerXml")) {
                    log.debug("loadXML: routes ignored at element {}, class {}", (Object)routes.getName(), (Object)routes.getAttribute("class"));
                    continue;
                }
                for (Element device : routes.getChildren("device")) {
                    String type = device.getAttributeValue("type");
                    String serNum = device.getAttributeValue("serNum");
                    String baseAddr = device.getAttributeValue("baseAddr");
                    log.debug("loadXML: device {}, serNum {}, baseAddr {}", new Object[]{type, serNum, baseAddr});
                    LnSimple7thGenDeviceRoutes dev = new LnSimple7thGenDeviceRoutes(LnSimple7thGenDeviceRoutes.getDeviceType(type), Integer.parseInt(serNum));
                    dev.setBaseAddr(Integer.parseInt(baseAddr));
                    log.debug("loadXML: add {}", (Object)dev.getDeviceType());
                    int numRoutes = dev.getDeviceType() == 124 ? 16 : 8;
                    for (int i = 0; i < numRoutes; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            dev.setOneEntry(i, j, -1, RouteSwitchPositionEnum.UNUSED);
                        }
                    }
                    for (Element route : device.getChildren()) {
                        log.debug("\tdevice's route {}", (Object)route.getAttributeValue("number"));
                        int rn = Integer.parseInt(route.getAttributeValue("number")) - 1;
                        int entryNum = 0;
                        for (Element entry : route.getChildren()) {
                            if (entry.getName().equals("routeTop")) {
                                log.debug("\t\trouteTop: {}, {}", (Object)entry.getAttributeValue("controlTurnout"), (Object)entry.getAttributeValue("controlTurnoutState"));
                                int t = Integer.parseInt(entry.getAttributeValue("controlTurnout"));
                                dev.setOneEntry(rn, entryNum, t, RouteSwitchPositionEnum.valueOf(entry.getAttributeValue("controlTurnoutState")));
                            } else {
                                log.debug("\t\tsubsequent Entry: {}, {}", (Object)entry.getAttributeValue("turnout"), (Object)entry.getAttributeValue("state"));
                                dev.setOneEntry(rn, entryNum, Integer.parseInt(entry.getAttributeValue("turnout")), RouteSwitchPositionEnum.valueOf(entry.getAttributeValue("state")));
                            }
                            ++entryNum;
                        }
                    }
                    this.l7garm.addDevice(dev);
                }
            }
        }
        catch (JDOMException ex) {
            log.error("loadXML: File invalid", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error("loadXML: Error reading file", (Throwable)ex);
            return false;
        }
        log.debug("loadXML: Finished reading the 'DigitraxRoutes' file.");
        return false;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public boolean doStore() {
        Element digitraxRoutesPreferencesElement = new Element("DigitraxRoutesPreferences");
        digitraxRoutesPreferencesElement.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/DigitraxRoutes.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Element routesEntity = new Element("routes");
        digitraxRoutesPreferencesElement.addContent((Content)routesEntity);
        routesEntity.setAttribute("class", "jmri.jmrix.loconet.configurexml.CmdStnRoutesManagerXml");
        routesEntity = new Element("routes");
        digitraxRoutesPreferencesElement.addContent((Content)routesEntity);
        routesEntity.setAttribute("class", "Accy7thGenRoutes.configurexml.RoutesManagerXml");
        int countOfDevices = this.l7garm.getCountOfDevicesWithRoutes();
        log.debug("Saving {} devices", (Object)this.l7garm.getCountOfDevicesWithRoutes());
        if (countOfDevices < 1) {
            log.debug("No Digitrax 7th-gen Accessory devices with stored/storable routes.");
        } else {
            StringBuilder loggingString = new StringBuilder("Known Digitrax 7th-gen Accessory devices with stored/storable routes:\n");
            for (int aDevice = 0; aDevice < this.l7garm.getCountOfDevicesWithRoutes(); ++aDevice) {
                LnSimple7thGenDeviceRoutes device = this.l7garm.getDevice(aDevice);
                loggingString.append("\tDevice ");
                loggingString.append(this.l7garm.getDevName(device.getDeviceType()));
                loggingString.append(", ser. num. ");
                loggingString.append(device.getSerNum());
                loggingString.append(", base addr. ");
                loggingString.append(device.getBaseAddr());
                loggingString.append(".\n");
                log.debug("doStore: saving {}\n", (Object)loggingString.toString());
                Element deviceEntity = new Element("device");
                routesEntity.addContent((Content)deviceEntity);
                deviceEntity.setAttribute("type", this.l7garm.getDevName(device.getDeviceType()));
                deviceEntity.setAttribute("serNum", Integer.toString(device.getSerNum()));
                deviceEntity.setAttribute("baseAddr", Integer.toString(device.getBaseAddr()));
                int numAvailRoutes = device.getDeviceType() == 124 ? 16 : 8;
                for (int routeNumber = 0; routeNumber < numAvailRoutes; ++routeNumber) {
                    LnSimpleRouteEntry re;
                    log.debug("doStore: device {} route {} (of {} possible device routes)", new Object[]{aDevice, routeNumber + 1, numAvailRoutes});
                    if (device.getRoutes(routeNumber) == null || (re = device.getRoutes(routeNumber).getRouteEntry(0)) == null) continue;
                    int turn = device.getRoutes(routeNumber).getRouteEntry(0).getNumber();
                    log.debug("\tdoStore: route {} entry 0 turn = {}", (Object)routeNumber, (Object)turn);
                    if (turn >= 0 && turn <= 2043) {
                        log.debug("\tdoStore: Continued at route {} with 1<=address<=2044: {}.", (Object)routeNumber, (Object)turn);
                        Element routeElement = new Element("route");
                        routeElement.setAttribute("number", Integer.toString(routeNumber + 1));
                        loggingString.append("\t\tRoute ");
                        loggingString.append(routeNumber + 1);
                        loggingString.append(":\n");
                        boolean anUndefined = false;
                        for (int entryNumber = 0; entryNumber < 8 && !anUndefined; ++entryNumber) {
                            int addr = device.getRoutes(routeNumber).getRouteEntry(entryNumber).getNumber();
                            RouteSwitchPositionEnum state = device.getRoutes(routeNumber).getRouteEntry(entryNumber).getPosition();
                            if (state == null) {
                                state = RouteSwitchPositionEnum.UNUSED;
                                anUndefined = true;
                                log.debug("\tDevice {} Route {} loop entry {} has state {} ", new Object[]{aDevice, routeNumber + 1, entryNumber, state.toString()});
                            } else {
                                Element routeEntryElement;
                                log.debug("\tDevice {} Route {} loop entry {} address {} has state {} ", new Object[]{aDevice, routeNumber + 1, entryNumber, addr, state.toString()});
                                if (entryNumber == 0) {
                                    routeEntryElement = new Element("routeTop");
                                    routeEntryElement.setAttribute("controlTurnout", Integer.toString(addr + 1));
                                    routeEntryElement.setAttribute("controlTurnoutState", state.toString());
                                    routeElement.addContent((Content)routeEntryElement);
                                    loggingString.append("\t\tTop Addr:");
                                    loggingString.append(Integer.toString(addr + 1));
                                } else {
                                    routeEntryElement = new Element("routeOutputTurnout");
                                    routeEntryElement.setAttribute("turnout", Integer.toString(addr + 1));
                                    routeEntryElement.setAttribute("state", state.toString());
                                    routeElement.addContent((Content)routeEntryElement);
                                    loggingString.append("\tAddr:");
                                    loggingString.append(Integer.toString(addr + 1));
                                }
                                loggingString.append(", State:");
                                loggingString.append((Object)state);
                            }
                            if (entryNumber != 0 || state == RouteSwitchPositionEnum.UNUSED) continue;
                            deviceEntity.addContent((Content)routeElement);
                        }
                        loggingString.append("\n");
                        continue;
                    }
                    log.debug("\tdoStore: no entries because top address is -1.");
                }
            }
            log.debug("doStore: saving string as: {}", (Object)loggingString.toString());
        }
        DigitraxRoutesXmlFile dtxXmlFil = new DigitraxRoutesXmlFile();
        File fileFileFile = dtxXmlFil.getStoreFile();
        Document xmlDoc = new Document(digitraxRoutesPreferencesElement);
        log.debug("doStore: checking canwrite()");
        if (!fileFileFile.canWrite()) {
            log.debug("doStore: canwrite is false; Unable to create writable local Digitrax routes file");
            try {
                fileFileFile.createNewFile();
            }
            catch (IOException e) {
                log.error("IOError trying to create file!");
                return false;
            }
            if (!fileFileFile.canWrite()) {
                return false;
            }
        }
        try {
            dtxXmlFil.writeXML(fileFileFile, xmlDoc);
        }
        catch (FileNotFoundException ex) {
            log.error("File not found when writing", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error("IO Exception when writing", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static class DigitraxRoutesXmlFile
    extends XmlFile {
        private static final String PRODUCTIONFILEPATH = FileUtil.getProgramPath() + "resources/digitraxRoutes/";
        private static final String USERFILEPATH = FileUtil.getUserFilesPath() + "resources/digitraxRoutes/";
        private static final String TARGETFILEPATH = "DigitraxRoutes.xml";

        public static String getStoreFileName() {
            return USERFILEPATH + TARGETFILEPATH;
        }

        public static String getLoadFileName() {
            return DigitraxRoutesXmlFile.getStoreFileName();
        }

        public File getStoreFile() {
            log.debug("getStoreFile: check directory exists - {}", (Object)USERFILEPATH);
            File chkdir = new File(USERFILEPATH);
            log.debug("getStoreFile: check directory exists result: chkdir {}", (Object)chkdir);
            if (!chkdir.exists() && !chkdir.mkdirs()) {
                log.warn("getStoreFile: check directory does not exist & make directory failed!");
                return null;
            }
            File file = this.findFile(DigitraxRoutesXmlFile.getStoreFileName());
            log.debug("getStoreFile part n/2: file is {}.", (Object)file);
            if (file == null) {
                log.debug("getStoreFile: Try to Create new DigitraxRoutes.xml file");
                file = new File(DigitraxRoutesXmlFile.getStoreFileName());
                log.debug("getStoreFile part n: file is {}.", (Object)file);
            } else {
                try {
                    FileUtil.rotate(file, 4, "bup");
                }
                catch (IOException ex) {
                    log.debug("Rotate failed, reverting to xml backup");
                    this.makeBackupFile(DigitraxRoutesXmlFile.getStoreFileName());
                }
            }
            return file;
        }

        public File getLoadFile() {
            log.debug("getLoadFile: USERFILEPATH = {}, TARGETFILEPATH = {}", (Object)USERFILEPATH, (Object)TARGETFILEPATH);
            File file = this.findFile(USERFILEPATH + TARGETFILEPATH);
            if (file == null) {
                file = this.findFile(PRODUCTIONFILEPATH + TARGETFILEPATH);
                log.debug("getLoadFile: try2 - file = {}", (Object)file);
            }
            return file;
        }
    }
}

