/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.demoport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JTextArea;
import jmri.InstanceManager;
import jmri.SystemConnectionMemo;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.demoport.Bundle;
import jmri.jmrix.loconet.demoport.DemoSerialPort;
import jmri.util.swing.JmriPanel;

class DemoPanel
extends JmriPanel {
    private final Map<SystemConnectionMemo, AbstractSerialPortController> memoMap = new HashMap<SystemConnectionMemo, AbstractSerialPortController>();
    private DemoSerialPort _demoSerialPort;
    private LocoNetConnection _connection;
    private JComboBox<LocoNetConnection> _locoNetConnection;
    private JTextArea _textArea;
    private boolean turnoutThrown1;
    private boolean turnoutThrown2;

    DemoPanel() {
    }

    @Override
    public void initComponents() {
        super.initComponents();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        this.add((Component)new JLabel(Bundle.getMessage("DemoPanel_Connection")), c);
        for (ConnectionConfig cc : InstanceManager.getDefault(ConnectionConfigManager.class)) {
            AbstractSerialPortController pc;
            if (!(cc.getAdapter() instanceof AbstractSerialPortController) || !(pc = (AbstractSerialPortController)cc.getAdapter()).isPortOpen()) continue;
            this.memoMap.put(cc.getAdapter().getSystemConnectionMemo(), pc);
        }
        this._locoNetConnection = new JComboBox();
        c.gridx = 1;
        c.anchor = 17;
        this.add(this._locoNetConnection, c);
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 1;
        JButton buttonStartTest = new JButton(Bundle.getMessage("DemoPanel_ButtonStartTest"));
        buttonStartTest.setEnabled(false);
        this.add((Component)buttonStartTest, c);
        c.gridy = 2;
        JButton buttonThrowTurnout1 = new JButton(Bundle.getMessage("DemoPanel_ButtonThrowTurnout1"));
        buttonThrowTurnout1.addActionListener(e -> {
            this._demoSerialPort.throwTurnout(1, this.turnoutThrown1);
            this.turnoutThrown1 = !this.turnoutThrown1;
        });
        buttonThrowTurnout1.setEnabled(false);
        this.add((Component)buttonThrowTurnout1, c);
        c.gridy = 3;
        JButton buttonThrowTurnout2 = new JButton(Bundle.getMessage("DemoPanel_ButtonThrowTurnout2"));
        buttonThrowTurnout2.addActionListener(e -> {
            this._demoSerialPort.throwTurnout(2, this.turnoutThrown2);
            this.turnoutThrown2 = !this.turnoutThrown2;
        });
        buttonThrowTurnout2.setEnabled(false);
        this.add((Component)buttonThrowTurnout2, c);
        c.gridy = 4;
        this.add((Component)new JLabel(Bundle.getMessage("DemoPanel_LocoNetMonitor")), c);
        c.gridy = 5;
        this._textArea = new JTextArea();
        this._textArea.setColumns(50);
        this._textArea.setRows(30);
        this.add((Component)this._textArea, c);
        this._locoNetConnection.addActionListener(e -> {
            this._connection = this._locoNetConnection.getItemAt(this._locoNetConnection.getSelectedIndex());
            buttonStartTest.setEnabled(true);
        });
        List<LocoNetSystemConnectionMemo> systemConnections = InstanceManager.getList(LocoNetSystemConnectionMemo.class);
        for (LocoNetSystemConnectionMemo memo : systemConnections) {
            if (this.memoMap.get(memo) == null) continue;
            LocoNetConnection conn = new LocoNetConnection(memo);
            this._locoNetConnection.addItem(conn);
        }
        buttonStartTest.addActionListener(e -> {
            this._demoSerialPort = new DemoSerialPort(this, this._connection._memo);
            this._demoSerialPort.startDemo();
            this._locoNetConnection.setEnabled(false);
            buttonStartTest.setEnabled(false);
            buttonThrowTurnout1.setEnabled(true);
            buttonThrowTurnout2.setEnabled(true);
        });
    }

    public AbstractSerialPortController getPortController() {
        if (this._connection == null) {
            return null;
        }
        return this.memoMap.get(this._connection._memo);
    }

    public void addMessage(String msg) {
        this._textArea.append(msg);
    }

    @Override
    public String getTitle() {
        return "Demo panel";
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        return menuList;
    }

    private static class LocoNetConnection {
        private final LocoNetSystemConnectionMemo _memo;

        public LocoNetConnection(LocoNetSystemConnectionMemo memo) {
            this._memo = memo;
        }

        public String toString() {
            return this._memo.getUserName();
        }
    }
}

