/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.demoport;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import jmri.SystemConnectionMemo;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.demoport.Bundle;
import jmri.jmrix.loconet.demoport.DemoPanel;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoSerialPort
extends AbstractSerialPortController {
    private final DemoPanel _panel;
    private BufferedOutputStream _outputStream;
    private static final Logger log = LoggerFactory.getLogger(DemoSerialPort.class);

    DemoSerialPort(DemoPanel panel, SystemConnectionMemo memo) {
        super(memo);
        this._panel = panel;
    }

    @Override
    public void configure() {
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting via {} {}", (Object)portName, (Object)this.currentSerialPort);
        this.setBaudRate(this.currentSerialPort, 57600);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.RTSCTS);
        this.setComPortTimeouts(this.currentSerialPort, AbstractSerialPortController.Blocking.READ_SEMI_BLOCKING, 100);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    public void startDemo() {
        log.error("startDemo()");
        AbstractSerialPortController pc = this._panel.getPortController();
        if (pc == null) {
            log.error("startDemo(). PortController is null");
            return;
        }
        String portName = pc.getCurrentPortName();
        log.error("Serial port: {}", (Object)pc.getPortSettingsString());
        pc.replacePortWithFakePort();
        String result = this.openPort(portName, "JMRI app");
        if (result == null) {
            this._panel.addMessage("Connection successful\n");
            ThreadingUtil.newThread(new LocoNetListener(this.getInputStream()), "Demo serial port").start();
            this._outputStream = new BufferedOutputStream(this.getOutputStream());
        } else {
            this._panel.addMessage(result);
        }
    }

    public void throwTurnout(int turnout, boolean throwTurnout) {
        try {
            LocoNetMessage msg = new LocoNetMessage(4);
            msg.setOpCode(176);
            msg.setElement(1, turnout - 1);
            msg.setElement(2, throwTurnout ? 16 : 48);
            msg.setParity();
            for (int i = 0; i < msg.getNumDataElements(); ++i) {
                this._outputStream.write(msg.getElement(i));
            }
            this._outputStream.flush();
        }
        catch (IOException ex) {
            log.error("Exception: {}", (Object)ex.getMessage());
        }
    }

    private final class LocoNetListener
    implements Runnable {
        private final InputStream _stream;
        private final int[] data = new int[256];
        private int pos = 0;

        private LocoNetListener(InputStream stream) {
            this._stream = stream;
        }

        private int numBytesInMessage() {
            switch (this.data[0] & 0xE0) {
                case 128: {
                    return 2;
                }
                case 160: {
                    return 4;
                }
                case 192: {
                    return 6;
                }
                case 224: {
                    if (this.pos >= 2) {
                        return this.data[1];
                    }
                    return 255;
                }
            }
            throw new IllegalArgumentException("Unknown length of package");
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    int b = this._stream.read();
                    DemoSerialPort.this._panel.addMessage(String.format("%02X ", b));
                    if (b < 128 && this.pos == 0) continue;
                    this.data[this.pos++] = b;
                    if (this.pos < this.numBytesInMessage()) continue;
                    LocoNetMessage msg = new LocoNetMessage(this.data);
                    DemoSerialPort.this._panel.addMessage(msg.toMonitorString());
                    this.pos = 0;
                }
                catch (InterruptedIOException b) {
                }
                catch (IOException ex) {
                    log.error("Exception: {}", (Object)ex.getMessage());
                    return;
                }
            }
        }
    }
}

