/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.downloader;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.jmrit.MemoryContents;
import jmri.jmrix.AbstractLoaderPane;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.downloader.Bundle;
import jmri.jmrix.loconet.swing.LnPanel;
import jmri.jmrix.loconet.swing.LnPanelInterface;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderPane
extends AbstractLoaderPane
implements LnPanelInterface {
    protected LocoNetSystemConnectionMemo memo;
    JTextField bootload = new JTextField();
    JTextField mfg = new JTextField();
    JTextField developer = new JTextField();
    JTextField product = new JTextField();
    JTextField hardware = new JTextField();
    JTextField software = new JTextField();
    JTextField delay = new JTextField();
    JTextField eestart = new JTextField();
    JTextField eraseBlockSize = new JTextField();
    JRadioButton checkhardwareno = new JRadioButton(Bundle.getMessage("ButtonCheckHardwareNo"));
    JRadioButton checkhardwareexact = new JRadioButton(Bundle.getMessage("ButtonCheckHardwareExact"));
    JRadioButton checkhardwaregreater = new JRadioButton(Bundle.getMessage("ButtonCheckHardwareGreater"));
    ButtonGroup hardgroup = new ButtonGroup();
    JRadioButton checksoftwareno = new JRadioButton(Bundle.getMessage("ButtonCheckSoftwareNo"));
    JRadioButton checksoftwareless = new JRadioButton(Bundle.getMessage("ButtonCheckSoftwareLess"));
    ButtonGroup softgroup = new ButtonGroup();
    private static final int PXCT1DOWNLOAD = 64;
    static int PXCT2SETUP = 0;
    static int PXCT2SENDADDRESS = 16;
    static int PXCT2SENDDATA = 32;
    static int PXCT2VERIFYDATA = 48;
    static int PXCT2ENDOPERATION = 64;
    private static final int DO_NOT_CHECK_SOFTWARE_VERSION = 0;
    private static final int CHECK_SOFTWARE_VERSION_LESS = 4;
    private static final int DO_NOT_CHECK_HARDWARE_VERSION = 0;
    private static final int REQUIRE_HARDWARE_VERSION_EXACT_MATCH = 1;
    private static final int ACCEPT_LATER_HARDWARE_VERSIONS = 3;
    private static final int SW_FLAGS_MSK = 4;
    private static final int HW_FLAGS_MSK = 3;
    private static final String MIN_VALUE_ZERO = "0";
    private static final String MIN_EESTART_VALUE = "8";
    private static final String MAX_VALUE_255 = "255";
    private static final String MAX_VALUE_65535 = "65535";
    private static final String MAX_EESTART_VALUE = "FFFFF8";
    private static final String MIN_DELAY_VALUE = "5";
    private static final String MAX_DELAY_VALUE = "500";
    private static final String MIN_VALUE_64 = "64";
    private static final String MAX_VALUE_128 = "128";
    private int operation;
    int startaddr;
    int endaddr;
    int delayval;
    int eestartval;
    private static final Logger log = LoggerFactory.getLogger(LoaderPane.class);

    @Override
    public void initContext(Object context) {
        if (context instanceof LocoNetSystemConnectionMemo) {
            this.initComponents((LocoNetSystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents() {
    }

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        this.memo = memo;
        super.initComponents();
    }

    public String getTitle(String menuTitle) {
        return LnPanel.getTitleHelper(this.memo, menuTitle);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.downloader.LoaderFrame";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("TitleLoader"));
    }

    @Override
    protected void addOptionsPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("LabelBootload") + " "));
        p.add(this.bootload);
        this.bootload.setToolTipText(Bundle.getMessage("TipValueRange", MIN_VALUE_ZERO, MAX_VALUE_255));
        this.bootload.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                LoaderPane.this.intParameterIsValid(LoaderPane.this.bootload, 0, 255);
                LoaderPane.this.updateDownloadVerifyButtons();
            }
        });
        this.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("LabelMfg") + " "));
        this.mfg.setToolTipText(Bundle.getMessage("TipValueRange", MIN_VALUE_ZERO, MAX_VALUE_255));
        p.add(this.mfg);
        this.mfg.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                LoaderPane.this.intParameterIsValid(LoaderPane.this.mfg, 0, 255);
                LoaderPane.this.updateDownloadVerifyButtons();
            }
        });
        this.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("LabelDev") + " "));
        this.developer.setToolTipText(Bundle.getMessage("TipValueRange", MIN_VALUE_ZERO, MAX_VALUE_255));
        p.add(this.developer);
        this.developer.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                LoaderPane.this.intParameterIsValid(LoaderPane.this.developer, 0, 255);
                LoaderPane.this.updateDownloadVerifyButtons();
            }
        });
        this.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("LabelProduct") + " "));
        this.product.setToolTipText(Bundle.getMessage("TipValueRange", MIN_VALUE_ZERO, MAX_VALUE_65535));
        p.add(this.product);
        this.product.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                LoaderPane.this.intParameterIsValid(LoaderPane.this.product, 0, 65535);
                LoaderPane.this.updateDownloadVerifyButtons();
            }
        });
        this.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.hardware.setToolTipText(Bundle.getMessage("TipValueRange", MIN_VALUE_ZERO, MAX_VALUE_255));
        p.add(new JLabel(Bundle.getMessage("LabelHardware") + " "));
        p.add(this.hardware);
        this.hardware.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                LoaderPane.this.intParameterIsValid(LoaderPane.this.hardware, 0, 255);
                LoaderPane.this.updateDownloadVerifyButtons();
            }
        });
        this.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.checkhardwareno);
        p.add(this.checkhardwareexact);
        p.add(this.checkhardwaregreater);
        this.hardgroup.add(this.checkhardwareno);
        this.hardgroup.add(this.checkhardwareexact);
        this.hardgroup.add(this.checkhardwaregreater);
        this.checkhardwareno.addActionListener(this);
        this.checkhardwareexact.addActionListener(this);
        this.checkhardwaregreater.addActionListener(this);
        this.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("LabelSoftware") + " "));
        this.software.setToolTipText(Bundle.getMessage("TipValueRange", MIN_VALUE_ZERO, MAX_VALUE_255));
        p.add(this.software);
        this.software.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                LoaderPane.this.intParameterIsValid(LoaderPane.this.software, 0, 255);
                LoaderPane.this.updateDownloadVerifyButtons();
            }
        });
        this.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.checksoftwareno);
        p.add(this.checksoftwareless);
        this.softgroup.add(this.checksoftwareno);
        this.softgroup.add(this.checksoftwareless);
        this.checksoftwareno.addActionListener(this);
        this.checksoftwareless.addActionListener(this);
        this.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("LabelDelay") + " "));
        this.delay.setToolTipText(Bundle.getMessage("TipValueRange", MIN_DELAY_VALUE, MAX_DELAY_VALUE));
        p.add(this.delay);
        this.delay.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                LoaderPane.this.intParameterIsValid(LoaderPane.this.hardware, Integer.parseInt(LoaderPane.MIN_DELAY_VALUE), Integer.parseInt(LoaderPane.MAX_DELAY_VALUE));
                LoaderPane.this.updateDownloadVerifyButtons();
            }
        });
        this.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("LabelEEStart") + " "));
        this.eestart.setToolTipText(Bundle.getMessage("TipValueRange", MIN_EESTART_VALUE, MAX_EESTART_VALUE));
        p.add(this.eestart);
        this.eestart.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                LoaderPane.this.updateDownloadVerifyButtons();
            }
        });
        this.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("LabelEraseBlockSize") + " "));
        this.eraseBlockSize.setToolTipText(Bundle.getMessage("TipValueRange", MIN_VALUE_64, MAX_VALUE_128));
        p.add(this.eraseBlockSize);
        this.eraseBlockSize.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!LoaderPane.this.intParameterIsValid(LoaderPane.this.eraseBlockSize, 64, 128)) {
                    LoaderPane.this.status.setText(Bundle.getMessage("ErrorInvalidParameter"));
                }
                LoaderPane.this.updateDownloadVerifyButtons();
            }
        });
        this.add(p);
        this.add(new JSeparator());
    }

    @Override
    protected void handleOptionsInFileContent(MemoryContents inputContent) {
        String text = inputContent.extractValueOfKey("Bootloader Version");
        if (text != null) {
            this.bootload.setText(text);
        }
        if ((text = inputContent.extractValueOfKey("Manufacturer Code")) != null) {
            this.mfg.setText(text);
        }
        if ((text = inputContent.extractValueOfKey("Developer Code")) != null) {
            this.developer.setText(text);
        }
        if ((text = inputContent.extractValueOfKey("Product Code")) != null) {
            this.product.setText(text);
        }
        if ((text = inputContent.extractValueOfKey("Hardware Version")) != null) {
            this.hardware.setText(text);
        }
        if ((text = inputContent.extractValueOfKey("Software Version")) != null) {
            this.software.setText(text);
        }
        if ((text = inputContent.extractValueOfKey("Options")) != null) {
            try {
                this.setOptionsRadiobuttons(text);
            }
            catch (NumberFormatException ex) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorInvalidOptionInFile", text, "Options"), Bundle.getMessage("ErrorTitle"), 0);
                this.disableDownloadVerifyButtons();
                log.warn("Invalid dmf file 'Options' value {}", (Object)text);
                return;
            }
        }
        if ((text = inputContent.extractValueOfKey("Delay")) != null) {
            this.delay.setText(text);
        }
        if ((text = inputContent.extractValueOfKey("EEPROM Start Address")) != null) {
            this.eestart.setText(text);
        }
        if ((text = inputContent.extractValueOfKey("Erase Blk Size")) != null) {
            this.eraseBlockSize.setText(text);
            boolean interpretationProblem = false;
            try {
                int i = Integer.parseInt(text);
                if (i > 128 || i < 64) {
                    interpretationProblem = true;
                }
            }
            catch (NumberFormatException e) {
                interpretationProblem = true;
            }
            if (interpretationProblem) {
                log.warn("Invalid dmf file 'Erase Blk Size' value {}", (Object)text);
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorInvalidEraseBlkSize", text, "Erase Blk Size"), Bundle.getMessage("ErrorTitle"), 0);
                this.disableDownloadVerifyButtons();
                inputContent.clear();
                this.setDefaultFieldValues();
                this.clearInputFileName();
            }
        }
    }

    @Override
    protected void addChooserFilters(JFileChooser chooser) {
        FileNameExtensionFilter filter = new FileNameExtensionFilter(Bundle.getMessage("FileFilterLabel", "*.dfm, *.hex"), "dmf", "hex");
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("Digitrax Mangled Firmware (*.dmf)", "dmf"));
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("Intel Hex Format Firmware (*.hex)", "hex"));
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
    }

    private void setOptionsRadiobuttons(String text) throws NumberFormatException {
        try {
            int control = Integer.parseInt(text);
            switch (control & 4) {
                case 4: {
                    this.checksoftwareless.setSelected(true);
                    this.checksoftwareno.setSelected(false);
                    break;
                }
                case 0: {
                    this.checksoftwareless.setSelected(false);
                    this.checksoftwareno.setSelected(true);
                    break;
                }
                default: {
                    throw new NumberFormatException("Invalid Software Options: " + (control & 4));
                }
            }
            switch (control & 3) {
                case 0: {
                    this.checkhardwareno.setSelected(true);
                    this.checkhardwareexact.setSelected(false);
                    this.checkhardwaregreater.setSelected(false);
                    break;
                }
                case 1: {
                    this.checkhardwareno.setSelected(false);
                    this.checkhardwareexact.setSelected(true);
                    this.checkhardwaregreater.setSelected(false);
                    break;
                }
                case 3: {
                    this.checkhardwareno.setSelected(false);
                    this.checkhardwareexact.setSelected(false);
                    this.checkhardwaregreater.setSelected(true);
                    break;
                }
                default: {
                    throw new NumberFormatException("Invalid Hardware Options: " + (control & 3));
                }
            }
        }
        catch (NumberFormatException ex) {
            log.error("Invalid Option value: {}", (Object)text);
            throw new NumberFormatException(ex.getLocalizedMessage());
        }
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        this.operation = PXCT2SENDDATA;
        this.sendSequence();
    }

    @Override
    protected void doVerify() {
        super.doVerify();
        this.operation = PXCT2VERIFYDATA;
        this.sendSequence();
    }

    private void sendSequence() {
        int softval;
        int hardval;
        int prodval;
        int developerval;
        int mfgval;
        if (!this.parametersAreValid()) {
            this.disableDownloadVerifyButtons();
            this.status.setText(Bundle.getMessage("ErrorInvalidParameter"));
            return;
        }
        if (this.inputContent.isEmpty()) {
            this.disableDownloadVerifyButtons();
            this.status.setText(Bundle.getMessage("ErrorEmptyFirmwareFile"));
            return;
        }
        try {
            mfgval = Integer.parseInt(this.mfg.getText());
            if (mfgval < 0 || mfgval > 255) {
                throw new NumberFormatException("out of range");
            }
        }
        catch (NumberFormatException ex) {
            log.error("sendSequence() failed due to bad Manufacturer Number value {}", (Object)this.mfg.getText());
            this.mfg.setForeground(Color.red);
            this.mfg.requestFocusInWindow();
            this.enableDownloadVerifyButtons();
            this.status.setText(Bundle.getMessage("ErrorInvalidValueInGUI", Bundle.getMessage("LabelMfg"), this.mfg.getText()));
            return;
        }
        try {
            developerval = Integer.parseInt(this.developer.getText());
            if (developerval < 0 || developerval > 255) {
                throw new NumberFormatException("out of range");
            }
        }
        catch (NumberFormatException ex) {
            log.error("sendSequence() failed due to bad Developer Number value {}", (Object)this.developer.getText());
            this.developer.setForeground(Color.red);
            this.developer.requestFocusInWindow();
            this.enableDownloadVerifyButtons();
            this.status.setText(Bundle.getMessage("ErrorInvalidValueInGUI", Bundle.getMessage("LabelDev"), this.developer.getText()));
            return;
        }
        try {
            prodval = Integer.parseInt(this.product.getText());
            if (prodval < 0 || prodval > 65535) {
                throw new NumberFormatException("out of range");
            }
        }
        catch (NumberFormatException ex) {
            log.error("sendSequence() failed due to bad Product Code value {}", (Object)this.product.getText());
            this.product.setForeground(Color.red);
            this.product.requestFocusInWindow();
            this.enableDownloadVerifyButtons();
            this.enableDownloadVerifyButtons();
            this.status.setText(Bundle.getMessage("ErrorInvalidValueInGUI", Bundle.getMessage("LabelProduct"), this.product.getText()));
            return;
        }
        try {
            hardval = Integer.parseInt(this.hardware.getText());
            if (hardval < 0 || hardval > 255) {
                throw new NumberFormatException("out of range");
            }
        }
        catch (NumberFormatException ex) {
            log.error("sendSequence() failed due to bad Hardware Version value {}", (Object)this.hardware.getText());
            this.hardware.setForeground(Color.red);
            this.hardware.requestFocusInWindow();
            this.enableDownloadVerifyButtons();
            this.status.setText(Bundle.getMessage("ErrorInvalidValueInGUI", Bundle.getMessage("LabelHardware"), this.hardware.getText()));
            return;
        }
        try {
            softval = Integer.parseInt(this.software.getText());
            if (softval < 0 || softval > 255) {
                throw new NumberFormatException("out of range");
            }
        }
        catch (NumberFormatException ex) {
            log.error("sendSequence() failed due to bad Software Version value {}", (Object)this.software.getText());
            this.software.setForeground(Color.red);
            this.software.requestFocusInWindow();
            this.enableDownloadVerifyButtons();
            this.status.setText(Bundle.getMessage("ErrorInvalidValueInGUI", Bundle.getMessage("LabelSoftware"), this.software.getText()));
            return;
        }
        int control = this.computeOptionsValFromRadiobuttons();
        try {
            this.delayval = Integer.parseInt(this.delay.getText());
            if (this.delayval < Integer.parseInt(MIN_DELAY_VALUE) || this.delayval > Integer.parseInt(MAX_DELAY_VALUE)) {
                throw new NumberFormatException("out of range");
            }
        }
        catch (NumberFormatException ex) {
            log.error("sendSequence() failed due to bad Delay value {}", (Object)this.delay.getText());
            this.delay.setForeground(Color.red);
            this.delay.requestFocusInWindow();
            this.enableDownloadVerifyButtons();
            this.status.setText(Bundle.getMessage("ErrorInvalidValueInGUI", Bundle.getMessage("LabelDelay"), this.delay.getText()));
            return;
        }
        try {
            this.eestartval = Integer.parseInt(this.eestart.getText(), 16);
            if (this.eestartval < Integer.parseInt(MIN_EESTART_VALUE, 16) || this.eestartval > Integer.parseInt(MAX_EESTART_VALUE, 16)) {
                throw new NumberFormatException("out of range");
            }
        }
        catch (NumberFormatException ex) {
            log.error("sendSequence() failed due to bad EESTART value {}", (Object)this.eestart.getText());
            this.eestart.setForeground(Color.red);
            this.eestart.requestFocusInWindow();
            this.enableDownloadVerifyButtons();
            this.status.setText(Bundle.getMessage("ErrorInvalidValueInGUI", Bundle.getMessage("LabelEEStart"), this.eestart.getText()));
            return;
        }
        this.sendOne(PXCT2SETUP, mfgval, prodval & 0xFF, hardval, softval, control, 0, developerval, prodval / 256);
        new Thread(new Sender()).start();
    }

    void sendOne(int pxct2, int d1, int d2, int d3, int d4, int d5, int d6, int d7, int d8) {
        LocoNetMessage m = new LocoNetMessage(16);
        m.setOpCode(229);
        m.setElement(1, 16);
        m.setElement(2, 127);
        m.setElement(3, 127);
        m.setElement(4, 127);
        int d1u = (d1 & 0x80) / 128;
        int d2u = (d2 & 0x80) / 64;
        int d3u = (d3 & 0x80) / 32;
        int d4u = (d4 & 0x80) / 16;
        int lowbits = d1u | d2u | d3u | d4u;
        m.setElement(5, (lowbits | 0x40) & 0x7F);
        m.setElement(6, d1 & 0x7F);
        m.setElement(7, d2 & 0x7F);
        m.setElement(8, d3 & 0x7F);
        m.setElement(9, d4 & 0x7F);
        int d5u = (d5 & 0x80) / 128;
        int d6u = (d6 & 0x80) / 64;
        int d7u = (d7 & 0x80) / 32;
        int d8u = (d8 & 0x80) / 16;
        lowbits = d5u | d6u | d7u | d8u;
        m.setElement(10, (lowbits | pxct2) & 0x7F);
        m.setElement(11, d5 & 0x7F);
        m.setElement(12, d6 & 0x7F);
        m.setElement(13, d7 & 0x7F);
        m.setElement(14, d8 & 0x7F);
        this.memo.getLnTrafficController().sendLocoNetMessage(m);
    }

    @Override
    protected void setDefaultFieldValues() {
        this.addressSizeButtonGroup.clearSelection();
        this.bootload.setText("1");
        this.mfg.setText("1");
        this.developer.setText("1");
        this.product.setText("1");
        this.hardware.setText("1");
        this.software.setText("1");
        this.delay.setText("200");
        this.eestart.setText("C00000");
        this.eraseBlockSize.setText(MIN_VALUE_64);
        try {
            this.setOptionsRadiobuttons(Integer.toString(1));
        }
        catch (NumberFormatException ex) {
            throw new Error("SetCheckboxes Failed to update the GUI for known-good parameters");
        }
        this.parametersAreValid();
    }

    @Override
    protected boolean parametersAreValid() {
        boolean allIsOk = true;
        boolean temp = this.intParameterIsValid(this.bootload, 0, 255);
        allIsOk &= temp;
        if (!temp) {
            log.info("Bootloader Version Number is not valid: {}", (Object)this.bootload.getText());
        }
        temp = this.intParameterIsValid(this.mfg, 0, 255);
        allIsOk &= temp;
        if (!temp) {
            log.info("Manufacturer Number is not valid: {}", (Object)this.mfg.getText());
        }
        temp = this.intParameterIsValid(this.developer, 0, 255);
        allIsOk &= temp;
        if (!temp) {
            log.info("Developer Number is not valid: {}", (Object)this.bootload.getText());
        }
        temp = this.intParameterIsValid(this.product, 0, 65535);
        allIsOk &= temp;
        if (!temp) {
            log.info("Product Code is not valid: {}", (Object)this.product.getText());
        }
        temp = this.intParameterIsValid(this.hardware, 0, 255);
        allIsOk &= temp;
        if (!temp) {
            log.info("Hardware Version Number is not valid: {}", (Object)this.hardware.getText());
        }
        temp = this.intParameterIsValid(this.software, 0, 255);
        allIsOk &= temp;
        if (!temp) {
            log.info("Software Version Number is not valid: {}", (Object)this.software.getText());
        }
        temp = this.intParameterIsValid(this.delay, Integer.parseInt(MIN_DELAY_VALUE), Integer.parseInt(MAX_DELAY_VALUE));
        allIsOk &= temp;
        if (!temp) {
            log.info("Delay is not valid: {}", (Object)this.delay.getText());
        }
        temp = this.hardgroup.getSelection() != null;
        allIsOk &= temp;
        if (!temp) {
            log.info("No harware version check radio button is selected.");
        }
        temp = this.softgroup.getSelection() != null;
        allIsOk &= temp;
        if (!temp) {
            log.info("No software version check radio button is selected.");
        }
        temp = true;
        this.eestart.setForeground(Color.black);
        String text = this.eestart.getText();
        if (text.equals("")) {
            this.eestart.setText(MIN_VALUE_ZERO);
            this.eestart.setForeground(Color.red);
            temp = false;
        } else {
            int junk;
            try {
                junk = Integer.parseInt(text, 16);
            }
            catch (NumberFormatException ex) {
                junk = -1;
            }
            if (junk < Integer.parseInt(MIN_EESTART_VALUE, 16) || junk % 8 != 0 || junk > Integer.parseInt(MAX_EESTART_VALUE, 16)) {
                this.eestart.setForeground(Color.red);
                temp = false;
            } else {
                this.eestart.setForeground(Color.black);
                temp = true;
            }
        }
        this.eestart.updateUI();
        allIsOk &= temp;
        temp = this.intParameterIsValid(this.eraseBlockSize, 64, 128);
        allIsOk &= temp;
        if (!temp) {
            log.info("Erase Block Sizez is not valid: {}", (Object)this.eraseBlockSize.getText());
        }
        if (allIsOk) {
            log.debug("No problems found when checking parameter values.");
        }
        return allIsOk;
    }

    private int computeOptionsValFromRadiobuttons() {
        int control = 0;
        if (this.checksoftwareless.isSelected()) {
            control |= 4;
        }
        if (this.checkhardwareexact.isSelected()) {
            control |= 1;
        } else if (this.checkhardwaregreater.isSelected()) {
            control |= 3;
        }
        return control;
    }

    @Override
    protected void updateDownloadVerifyButtons() {
        if (this.parametersAreValid() && !this.inputContent.isEmpty()) {
            this.enableDownloadVerifyButtons();
        } else {
            this.disableDownloadVerifyButtons();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateDownloadVerifyButtons();
        log.info("ActionListener");
    }

    private class Sender
    implements Runnable {
        int totalmsgs;
        int sentmsgs;

        private Sender() {
        }

        @Override
        public void run() {
            int next;
            LoaderPane.this.startaddr = 0;
            LoaderPane.this.endaddr = 0xFFFFFF;
            if ((LoaderPane.this.startaddr & 7) != 0) {
                log.error("Can only start on an 8-byte boundary: {}", (Object)LoaderPane.this.startaddr);
            }
            int location = LoaderPane.this.inputContent.nextContent(LoaderPane.this.startaddr);
            this.totalmsgs = 0;
            this.sentmsgs = 0;
            location &= 0xFFFFF8;
            do {
                ++this.totalmsgs;
            } while ((next = LoaderPane.this.inputContent.nextContent(location += 8)) >= 0 && (location = next & 0xFFFFF8) <= LoaderPane.this.endaddr);
            location = LoaderPane.this.inputContent.nextContent(LoaderPane.this.startaddr);
            if (location < 0) {
                log.info("No data, which seems odd");
                return;
            }
            this.doLongWait(location &= 0xFFFFF8, 5);
            this.setAddr(location);
            this.doLongWait(location, 2);
            do {
                ++this.sentmsgs;
                LoaderPane.this.sendOne(LoaderPane.this.operation, LoaderPane.this.inputContent.getLocation(location++), LoaderPane.this.inputContent.getLocation(location++), LoaderPane.this.inputContent.getLocation(location++), LoaderPane.this.inputContent.getLocation(location++), LoaderPane.this.inputContent.getLocation(location++), LoaderPane.this.inputContent.getLocation(location++), LoaderPane.this.inputContent.getLocation(location++), LoaderPane.this.inputContent.getLocation(location++));
                if (this.sentmsgs % 5 == 0) {
                    this.updateGUI(100 * this.sentmsgs / this.totalmsgs);
                }
                this.doWait(location);
                next = LoaderPane.this.inputContent.nextContent(location);
                if (next < 0) break;
                if ((next &= 0xFFFFF8) != location || (location & 0x3F) == 0) {
                    this.doLongWait(next, 4);
                    this.setAddr(next);
                    this.doLongWait(next, 2);
                }
                location = next;
            } while (!LoaderPane.this.isOperationAborted() && location <= LoaderPane.this.endaddr);
            this.doLongWait(location, 4);
            LoaderPane.this.sendOne(PXCT2ENDOPERATION, 0, 0, 0, 0, 0, 0, 0, 0);
            this.updateGUI(100);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Sender.this.enableGUI();
                }
            };
            SwingUtilities.invokeLater(r);
        }

        void setAddr(int location) {
            LoaderPane.this.sendOne(PXCT2SENDADDRESS, location / 256 / 256 & 0xFF, location / 256 & 0xFF, location & 0xFF, 0, 0, 0, 0, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doWait(int address) {
            try {
                Sender sender = this;
                synchronized (sender) {
                    int tdelay = address >= LoaderPane.this.eestartval ? LoaderPane.this.delayval + 50 + 14 : LoaderPane.this.delayval + 4 + 14;
                    this.wait(tdelay);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doLongWait(int address, int multiplier) {
            try {
                Sender sender = this;
                synchronized (sender) {
                    int tdelay = address >= LoaderPane.this.eestartval ? (LoaderPane.this.delayval + 50 + 14) * multiplier : LoaderPane.this.delayval * multiplier;
                    this.wait(tdelay);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        void enableGUI() {
            LoaderPane.this.enableDownloadVerifyButtons();
        }

        void updateGUI(final int value) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    log.debug("updateGUI with {}", (Object)value);
                    LoaderPane.this.bar.setValue(value);
                }
            });
        }
    }
}

