/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.ds64;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.jmrix.loconet.AbstractBoardProgPanel;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.ds64.Bundle;
import jmri.jmrix.loconet.ds64.SimpleTurnoutStateEntry;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.ValidatedTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ds64TabbedPanel
extends AbstractBoardProgPanel {
    int[] boardNumbers;
    int origAccessBoardNum = 0;
    ArrayList<Integer> boardNumsEntryValue = new ArrayList();
    JPanel generalPanel = null;
    JPanel opswsPanel = null;
    JScrollPane opswsScrollPane = null;
    JTabbedPane generalTabbedPane = null;
    JTabbedPane routesTabbedPane;
    JPanel opswsValues = null;
    JPanel outputAddrsPanel = null;
    ValidatedTextField outAddr1 = null;
    JLabel outState1 = null;
    ValidatedTextField outAddr2 = null;
    JLabel outState2 = null;
    ValidatedTextField outAddr3 = null;
    JLabel outState3 = null;
    ValidatedTextField outAddr4 = null;
    JLabel outState4 = null;
    JPanel[] routePanel;
    SimpleTurnoutStateEntry[] routeTop;
    SimpleTurnoutStateEntry[] routeA2;
    SimpleTurnoutStateEntry[] routeA3;
    SimpleTurnoutStateEntry[] routeA4;
    SimpleTurnoutStateEntry[] routeA5;
    SimpleTurnoutStateEntry[] routeA6;
    SimpleTurnoutStateEntry[] routeA7;
    SimpleTurnoutStateEntry[] routeA8;
    JToggleButton resetRouteButton = null;
    JComboBox<Integer> addressComboBox;
    JLabel outputTypeLabel;
    JComboBox<String> outputType;
    JLabel delayTimeLabel;
    JComboBox<String> delayTime;
    JLabel outputStatesLabel;
    JComboBox<String> outputStates;
    JLabel startupDelayLabel;
    JComboBox<String> startupDelay;
    JLabel staticOutputShutoffLabel;
    JComboBox<String> staticOutputShutoff;
    JLabel commandTypeLabel;
    JComboBox<String> commandType;
    JLabel commandSourceLabel;
    JComboBox<String> commandSource;
    JCheckBox output1CrossbuckFlasherCheckBox;
    JCheckBox output2CrossbuckFlasherCheckBox;
    JCheckBox output3CrossbuckFlasherCheckBox;
    JCheckBox output4CrossbuckFlasherCheckBox;
    JLabel routesControlLabel;
    JComboBox<String> routesControl;
    JLabel localControlOfOutputsStyleLabel;
    JComboBox<String> localControlOfOutputsStyle;
    JLabel sensorMessageTriggerLabel;
    JComboBox<String> sensorMessageTrigger;
    JComboBox<String> localSensorType;
    JToggleButton factoryResetButton;
    JRadioButtonWithInteger[] opswThrown = new JRadioButtonWithInteger[21];
    JRadioButtonWithInteger[] opswClosed = new JRadioButtonWithInteger[21];
    JPanel sensorMessageTriggerPanel;
    JPanel localInputControlsPanel;
    public Timer boardResetResponseTimer = null;
    Component colorizedObject;
    private OpSwOpType operationType = null;
    Boolean isRead;
    Boolean isWritingResetOpSw = false;
    Integer indexToRead = 0;
    Boolean resetOpSwVal = false;
    private final ActionListener routeResetResponseTimerListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("routeresetresponsetimerlistener state={}, indextoread{}", (Object)Ds64TabbedPanel.this.state, (Object)Ds64TabbedPanel.this.indexToRead);
            Ds64TabbedPanel.this.resetRouteButton.setSelected(false);
            Ds64TabbedPanel.this.readAllButton.setEnabled(true);
            Ds64TabbedPanel.this.writeAllButton.setEnabled(true);
            Ds64TabbedPanel.this.factoryResetButton.setEnabled(true);
        }
    };
    private final ActionListener basicConfigChangeActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().getClass() == JComboBox.class) {
                switch (((Component)e.getSource()).getName()) {
                    case "1": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[1] = Ds64TabbedPanel.this.outputType.getSelectedIndex() == 1;
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(1);
                        break;
                    }
                    case "2345": {
                        int selection = Ds64TabbedPanel.this.delayTime.getSelectedIndex();
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[2] = (selection & 1) == 1;
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[3] = (selection & 2) == 2;
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[4] = (selection & 4) == 4;
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[5] = (selection & 8) == 8;
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(2);
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(3);
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(4);
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(5);
                        break;
                    }
                    case "6": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[6] = Ds64TabbedPanel.this.outputStates.getSelectedIndex() == 1;
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(6);
                        break;
                    }
                    case "8": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[8] = Ds64TabbedPanel.this.startupDelay.getSelectedIndex() == 1;
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(8);
                        break;
                    }
                    case "9": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[9] = Ds64TabbedPanel.this.staticOutputShutoff.getSelectedIndex() == 1;
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(9);
                        break;
                    }
                    case "10": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[10] = Ds64TabbedPanel.this.commandType.getSelectedIndex() == 1;
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(10);
                        break;
                    }
                    case "13": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[13] = Ds64TabbedPanel.this.sensorMessageTrigger.getSelectedIndex() == 1;
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(13);
                        break;
                    }
                    case "14": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[14] = Ds64TabbedPanel.this.commandSource.getSelectedIndex() == 1;
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(14);
                        break;
                    }
                    case "21": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[21] = Ds64TabbedPanel.this.localSensorType.getSelectedIndex() == 1;
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(21);
                        break;
                    }
                    case "1116": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[11] = Ds64TabbedPanel.this.routesControl.getSelectedIndex() == 1 || Ds64TabbedPanel.this.routesControl.getSelectedIndex() == 3;
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[16] = Ds64TabbedPanel.this.routesControl.getSelectedIndex() >= 2;
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(11);
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(16);
                        break;
                    }
                    case "1215": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[12] = (Ds64TabbedPanel.this.localControlOfOutputsStyle.getSelectedIndex() & 1) == 1;
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[15] = Ds64TabbedPanel.this.localControlOfOutputsStyle.getSelectedIndex() >= 2;
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(12);
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(15);
                        break;
                    }
                }
            } else if (e.getSource().getClass() == JCheckBox.class) {
                switch (((Component)e.getSource()).getName()) {
                    case "17": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[17] = Ds64TabbedPanel.this.output1CrossbuckFlasherCheckBox.isSelected();
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(17);
                        break;
                    }
                    case "18": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[18] = Ds64TabbedPanel.this.output2CrossbuckFlasherCheckBox.isSelected();
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(18);
                        break;
                    }
                    case "19": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[19] = Ds64TabbedPanel.this.output3CrossbuckFlasherCheckBox.isSelected();
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(19);
                        break;
                    }
                    case "20": {
                        ((Ds64TabbedPanel)Ds64TabbedPanel.this).opsw[20] = Ds64TabbedPanel.this.output4CrossbuckFlasherCheckBox.isSelected();
                        Ds64TabbedPanel.this.updateGuiBasicOpSw(20);
                        break;
                    }
                }
            }
        }
    };
    private static final Logger log = LoggerFactory.getLogger(Ds64TabbedPanel.class);

    public Ds64TabbedPanel(int boardNum, boolean readOnInit) {
        super(boardNum, readOnInit, "DS64");
        this.origAccessBoardNum = boardNum;
        this.boardNumsEntryValue.add(boardNum);
    }

    public Ds64TabbedPanel() {
        this(1, false);
    }

    public Ds64TabbedPanel(int boardNum) {
        this(boardNum, false);
        this.origAccessBoardNum = boardNum;
    }

    public Ds64TabbedPanel(boolean readOnInit, Integer[] boardNums) {
        this((int)boardNums[0], readOnInit);
        log.debug("into DS64 tabbed panel with list of boards of length {}", (Object)boardNums.length);
        log.debug("boardNums[0] = {}", (Object)boardNums[0]);
        this.origAccessBoardNum = boardNums[0];
        this.boardNumsEntryValue.remove(0);
        Integer[] integerArray = boardNums;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int boardNum = integerArray[i];
            log.debug("board {}", (Object)boardNum);
            this.boardNumsEntryValue.add(boardNum);
        }
        Collections.sort(this.boardNumsEntryValue);
    }

    public Ds64TabbedPanel(boolean readBoardOnInit) {
        this(1, readBoardOnInit);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.ds64.DS64TabbedPanel";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("MenuItemDS64Programmer"));
    }

    public void updateGuiBasicOpSw(int index) {
        if (index < 1 || index == 7 || index > 21) {
            return;
        }
        if (this.opsw[index]) {
            this.opswThrown[index].setSelected(false);
            this.opswClosed[index].setSelected(true);
        } else {
            this.opswThrown[index].setSelected(true);
            this.opswClosed[index].setSelected(false);
        }
        this.opswThrown[index].updateUI();
        this.opswClosed[index].updateUI();
    }

    @Override
    protected void copyToOpsw() {
        this.opsw[1] = this.outputType.getSelectedIndex() == 1;
        this.updateGuiBasicOpSw(1);
        int selection = this.delayTime.getSelectedIndex();
        this.opsw[2] = (selection & 1) == 1;
        this.opsw[3] = (selection & 2) == 2;
        this.opsw[4] = (selection & 4) == 4;
        this.opsw[5] = (selection & 8) == 8;
        this.updateGuiBasicOpSw(2);
        this.updateGuiBasicOpSw(3);
        this.updateGuiBasicOpSw(4);
        this.updateGuiBasicOpSw(5);
        this.opsw[6] = this.outputStates.getSelectedIndex() == 1;
        this.updateGuiBasicOpSw(6);
        this.opsw[7] = this.isWritingResetOpSw != false ? this.resetOpSwVal : false;
        this.updateGuiBasicOpSw(7);
        this.opsw[8] = this.startupDelay.getSelectedIndex() == 1;
        this.updateGuiBasicOpSw(8);
        this.opsw[9] = this.staticOutputShutoff.getSelectedIndex() == 1;
        this.updateGuiBasicOpSw(9);
        this.opsw[10] = this.commandType.getSelectedIndex() == 1;
        this.updateGuiBasicOpSw(10);
        this.opsw[11] = this.routesControl.getSelectedIndex() == 1 || this.routesControl.getSelectedIndex() == 3;
        this.updateGuiBasicOpSw(11);
        this.opsw[12] = (this.localControlOfOutputsStyle.getSelectedIndex() & 1) == 1;
        this.updateGuiBasicOpSw(12);
        this.opsw[13] = this.sensorMessageTrigger.getSelectedIndex() == 1;
        this.updateGuiBasicOpSw(13);
        this.opsw[14] = this.commandSource.getSelectedIndex() == 1;
        this.updateGuiBasicOpSw(14);
        this.opsw[15] = this.localControlOfOutputsStyle.getSelectedIndex() >= 2;
        this.updateGuiBasicOpSw(15);
        this.opsw[16] = this.routesControl.getSelectedIndex() >= 2;
        this.updateGuiBasicOpSw(16);
        this.opsw[17] = this.output1CrossbuckFlasherCheckBox.isSelected();
        this.updateGuiBasicOpSw(17);
        this.opsw[18] = this.output2CrossbuckFlasherCheckBox.isSelected();
        this.updateGuiBasicOpSw(18);
        this.opsw[19] = this.output3CrossbuckFlasherCheckBox.isSelected();
        this.updateGuiBasicOpSw(19);
        this.opsw[20] = this.output4CrossbuckFlasherCheckBox.isSelected();
        this.updateGuiBasicOpSw(20);
        this.opsw[21] = this.localSensorType.getSelectedIndex() == 1;
        this.updateGuiBasicOpSw(21);
    }

    @Override
    protected void updateDisplay() {
        switch (this.state) {
            case 1: {
                this.outputType.setSelectedIndex(this.opsw[1] ? 1 : 0);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.delayTime.setSelectedIndex((this.opsw[2] ? 1 : 0) + (this.opsw[3] ? 2 : 0) + (this.opsw[4] ? 4 : 0) + (this.opsw[5] ? 8 : 0));
                break;
            }
            case 6: {
                this.outputStates.setSelectedIndex(this.opsw[6] ? 1 : 0);
                break;
            }
            case 8: {
                this.startupDelay.setSelectedIndex(this.opsw[8] ? 1 : 0);
                break;
            }
            case 9: {
                this.staticOutputShutoff.setSelectedIndex(this.opsw[9] ? 1 : 0);
                break;
            }
            case 10: {
                this.commandType.setSelectedIndex(this.opsw[10] ? 1 : 0);
                break;
            }
            case 11: 
            case 16: {
                this.routesControl.setSelectedIndex((this.opsw[16] ? 2 : 0) + (this.opsw[11] ? 1 : 0));
                break;
            }
            case 12: 
            case 15: {
                this.localControlOfOutputsStyle.setSelectedIndex((this.opsw[15] ? 2 : 0) + (this.opsw[12] ? 1 : 0));
                break;
            }
            case 13: {
                this.sensorMessageTrigger.setSelectedIndex(this.opsw[13] ? 1 : 0);
                break;
            }
            case 14: {
                this.commandSource.setSelectedIndex(this.opsw[14] ? 1 : 0);
                break;
            }
            case 17: {
                this.output1CrossbuckFlasherCheckBox.setSelected(this.opsw[17]);
                break;
            }
            case 18: {
                this.output2CrossbuckFlasherCheckBox.setSelected(this.opsw[18]);
                break;
            }
            case 19: {
                this.output3CrossbuckFlasherCheckBox.setSelected(this.opsw[19]);
                break;
            }
            case 20: {
                this.output4CrossbuckFlasherCheckBox.setSelected(this.opsw[20]);
                break;
            }
            case 21: {
                this.localSensorType.setSelectedIndex(this.opsw[21] ? 1 : 0);
                break;
            }
            default: {
                log.debug("Unhandled state code: {}", (Object)this.state);
            }
        }
        this.updateUI();
    }

    @Override
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Cannot catch an exception without grabbing the exception, but we don't do anything with the exception details.")
    protected int nextState(int state) {
        if (this.isWritingResetOpSw.booleanValue()) {
            if (state == 7 && this.opsw[7]) {
                this.opsw[7] = false;
                return 7;
            }
            if (state == 7) {
                return 0;
            }
        }
        if (this.onlyOneOperation) {
            this.onlyOneOperation = false;
            return 0;
        }
        if (state > 1 && (this.isRead.booleanValue() && !this.readAllButton.isSelected() || !this.isRead.booleanValue() && !this.writeAllButton.isSelected() && !this.resetRouteButton.isSelected())) {
            Color noAccessColor = ValidatedTextField.COLOR_BG_UNEDITED;
            if (this.operationType == OpSwOpType.BasicsRead || this.operationType == OpSwOpType.BasicsWrite) {
                this.unhighlightAllBasicOpSws();
                this.unhighlightAllOutputEntryFields();
                this.unhighlightAllRouteEntryFields();
                return 0;
            }
            if (this.operationType == OpSwOpType.OutputsRead || this.operationType == OpSwOpType.OutputsWrite || this.operationType == OpSwOpType.Route1Read || this.operationType == OpSwOpType.Route1Write || this.operationType == OpSwOpType.Route2Read || this.operationType == OpSwOpType.Route2Write || this.operationType == OpSwOpType.Route3Read || this.operationType == OpSwOpType.Route3Write || this.operationType == OpSwOpType.Route4Read || this.operationType == OpSwOpType.Route4Write || this.operationType == OpSwOpType.Route5Read || this.operationType == OpSwOpType.Route5Write || this.operationType == OpSwOpType.Route6Read || this.operationType == OpSwOpType.Route6Write || this.operationType == OpSwOpType.Route7Read || this.operationType == OpSwOpType.Route7Write || this.operationType == OpSwOpType.Route8Read || this.operationType == OpSwOpType.Route8Write) {
                if (state == 48) {
                    this.changeComponentBgColor(this.whichComponent(33, this.indexToRead), noAccessColor);
                    log.debug("Decided to stop read/write after OpSw 48 because no read/write button selected.");
                    return 0;
                }
                if (state == 64) {
                    this.changeComponentBgColor(this.whichComponent(49, this.indexToRead), noAccessColor);
                    log.debug("Decided to stop read/write after OpSw 64 because no read/write button selected.");
                    return 0;
                }
            }
        }
        switch (state) {
            case 1: {
                if (this.colorizedObject == null) {
                    this.colorizedObject = this.outputType;
                }
                this.colorizedObject.setBackground(null);
                this.isRead = this.read;
                this.indexToRead = 0;
                if (this.operationType == null || this.operationType == OpSwOpType.BasicsRead || this.operationType == OpSwOpType.BasicsWrite) {
                    this.colorizedObject = this.delayTime;
                    this.colorizedObject.setBackground(Color.blue.brighter());
                    return 2;
                }
                if (this.operationType == OpSwOpType.OutputsRead || this.operationType == OpSwOpType.OutputsWrite) {
                    this.indexToRead = 0;
                    this.read = false;
                    this.setOpSwIndex(this.indexToRead);
                    return 25;
                }
                if (this.operationType == OpSwOpType.Route1Read || this.operationType == OpSwOpType.Route1Write) {
                    this.indexToRead = 16;
                    this.read = false;
                    this.setOpSwIndex(this.indexToRead);
                    return 25;
                }
                if (this.operationType == OpSwOpType.Route2Read || this.operationType == OpSwOpType.Route2Write) {
                    this.indexToRead = 20;
                    this.read = false;
                    this.setOpSwIndex(this.indexToRead);
                    return 25;
                }
                if (this.operationType == OpSwOpType.Route3Read || this.operationType == OpSwOpType.Route3Write) {
                    this.indexToRead = 24;
                    this.read = false;
                    this.setOpSwIndex(this.indexToRead);
                    return 25;
                }
                if (this.operationType == OpSwOpType.Route4Read || this.operationType == OpSwOpType.Route4Write) {
                    this.indexToRead = 28;
                    this.read = false;
                    this.setOpSwIndex(this.indexToRead);
                    return 25;
                }
                if (this.operationType == OpSwOpType.Route5Read || this.operationType == OpSwOpType.Route5Write) {
                    this.indexToRead = 32;
                    this.read = false;
                    this.setOpSwIndex(this.indexToRead);
                    return 25;
                }
                if (this.operationType == OpSwOpType.Route6Read || this.operationType == OpSwOpType.Route6Write) {
                    this.indexToRead = 36;
                    this.read = false;
                    this.setOpSwIndex(this.indexToRead);
                    return 25;
                }
                if (this.operationType == OpSwOpType.Route7Read || this.operationType == OpSwOpType.Route7Write) {
                    this.indexToRead = 40;
                    this.read = false;
                    this.setOpSwIndex(this.indexToRead);
                    return 25;
                }
                if (this.operationType == OpSwOpType.Route8Read || this.operationType == OpSwOpType.Route8Write) {
                    this.indexToRead = 44;
                    this.read = false;
                    this.setOpSwIndex(this.indexToRead);
                    return 25;
                }
                return 0;
            }
            case 2: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.delayTime;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 3;
            }
            case 3: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.delayTime;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 4;
            }
            case 4: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.delayTime;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 5;
            }
            case 5: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.outputStates;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 6;
            }
            case 6: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.startupDelay;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 8;
            }
            case 8: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.staticOutputShutoff;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 9;
            }
            case 9: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.commandType;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 10;
            }
            case 10: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.routesControl;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 11;
            }
            case 11: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.localControlOfOutputsStyle;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 12;
            }
            case 12: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.sensorMessageTrigger;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 13;
            }
            case 13: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.commandSource;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 14;
            }
            case 14: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.localControlOfOutputsStyle;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 15;
            }
            case 15: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.routesControl;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 16;
            }
            case 16: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.output1CrossbuckFlasherCheckBox;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 17;
            }
            case 17: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.output2CrossbuckFlasherCheckBox;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 18;
            }
            case 18: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.output3CrossbuckFlasherCheckBox;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 19;
            }
            case 19: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.output4CrossbuckFlasherCheckBox;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 20;
            }
            case 20: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.colorizedObject = this.localSensorType;
                this.colorizedObject.setBackground(Color.blue.brighter());
                return 21;
            }
            case 21: {
                if (this.colorizedObject != null) {
                    this.colorizedObject.setBackground(null);
                }
                this.readAllButton.setEnabled(true);
                this.writeAllButton.setEnabled(true);
                return 0;
            }
            case 22: {
                return 0;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return state + 1;
            }
            case 32: {
                this.read = this.isRead;
                log.debug("Dealing with index {}", (Object)this.indexToRead);
                this.changeGuiElementHighlight(33, this.indexToRead);
                if (this.isRead.booleanValue()) {
                    return 46;
                }
                this.updateOpswForWrite(this.indexToRead);
                return 33;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: {
                return state + 1;
            }
            case 45: {
                if (this.isRead.booleanValue()) {
                    int extractedDataValue = 0;
                    for (int i = 48; i >= 33; --i) {
                        extractedDataValue = (extractedDataValue << 1) + (this.opsw[i] ? 1 : 0);
                    }
                    log.debug("Read Index {} value (OpSws 33-48) = 0x{}", (Object)(this.indexToRead + 1), (Object)Integer.toHexString(extractedDataValue));
                    this.updateGuiFromOpSws33_48();
                    this.changeGuiElementHighlight(48, this.indexToRead);
                    return 62;
                }
                return 46;
            }
            case 48: {
                this.changeGuiElementHighlight(48, this.indexToRead);
                if (this.isRead.booleanValue()) {
                    if (!this.opsw[47] && !this.opsw[48]) {
                        log.debug("Read of low value in index {} is a valid entry.", (Object)this.indexToRead);
                        return 33;
                    }
                    log.debug("Read of low value in index {} is an invalid entry.", (Object)this.indexToRead);
                    this.changeGuiElementUnHighlight(48, this.indexToRead);
                    for (int i = 33; i < 46; ++i) {
                        this.opsw[i] = true;
                    }
                    this.opsw[40] = false;
                    this.updateGuiFromOpSws33_48();
                    this.changeGuiElementHighlight(48, this.indexToRead);
                    return 62;
                }
                int extractedDataValue = 0;
                for (int i = 48; i >= 33; --i) {
                    extractedDataValue = (extractedDataValue << 1) + (this.opsw[i] ? 1 : 0);
                }
                log.debug("Wrote Index {} value (OpSws 33-48) = 0x{}", (Object)(this.indexToRead + 1), (Object)Integer.toHexString(extractedDataValue));
                this.updateGuiFromOpSws33_48();
                switch (this.indexToRead) {
                    case 0: {
                        this.outAddr1.setLastQueriedValue(this.outAddr1.getText());
                        break;
                    }
                    case 1: {
                        this.outAddr3.setLastQueriedValue(this.outAddr3.getText());
                        break;
                    }
                    case 16: 
                    case 20: 
                    case 24: 
                    case 28: 
                    case 32: 
                    case 36: 
                    case 40: 
                    case 44: {
                        Integer effectiveIndex = (this.indexToRead - 12) / 4;
                        this.routeTop[effectiveIndex.intValue()].addressField.setLastQueriedValue(this.routeTop[effectiveIndex.intValue()].addressField.getText());
                        try {
                            this.routeTop[effectiveIndex].setAddress(Integer.parseInt(this.routeTop[effectiveIndex.intValue()].addressField.getText()));
                        }
                        catch (NumberFormatException e) {
                            this.routeTop[effectiveIndex].setIsUnused();
                        }
                        break;
                    }
                    case 17: 
                    case 21: 
                    case 25: 
                    case 29: 
                    case 33: 
                    case 37: 
                    case 41: 
                    case 45: {
                        Integer effectiveIndex = (this.indexToRead - 13) / 4;
                        this.routeA3[effectiveIndex.intValue()].addressField.setLastQueriedValue(this.routeA3[effectiveIndex.intValue()].addressField.getText());
                        try {
                            this.routeA3[effectiveIndex].setAddress(Integer.parseInt(this.routeA3[effectiveIndex.intValue()].addressField.getText()));
                        }
                        catch (NumberFormatException e) {
                            this.routeA3[effectiveIndex].setIsUnused();
                        }
                        break;
                    }
                    case 18: 
                    case 22: 
                    case 26: 
                    case 30: 
                    case 34: 
                    case 38: 
                    case 42: 
                    case 46: {
                        Integer effectiveIndex = (this.indexToRead - 14) / 4;
                        this.routeA5[effectiveIndex.intValue()].addressField.setLastQueriedValue(this.routeA5[effectiveIndex.intValue()].addressField.getText());
                        try {
                            this.routeA5[effectiveIndex].setAddress(Integer.parseInt(this.routeA5[effectiveIndex.intValue()].addressField.getText()));
                        }
                        catch (NumberFormatException e) {
                            this.routeA5[effectiveIndex].setIsUnused();
                        }
                        break;
                    }
                    case 19: 
                    case 23: 
                    case 27: 
                    case 31: 
                    case 35: 
                    case 39: 
                    case 43: 
                    case 47: {
                        Integer effectiveIndex = (this.indexToRead - 15) / 4;
                        this.routeA7[effectiveIndex.intValue()].addressField.setLastQueriedValue(this.routeA7[effectiveIndex.intValue()].addressField.getText());
                        try {
                            this.routeA7[effectiveIndex].setAddress(Integer.parseInt(this.routeA7[effectiveIndex.intValue()].addressField.getText()));
                        }
                        catch (NumberFormatException e) {
                            this.routeA7[effectiveIndex].setIsUnused();
                        }
                        break;
                    }
                    default: {
                        log.error("invalid indirectIndex for write: {}", (Object)this.indexToRead);
                        return 0;
                    }
                }
                return 49;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: {
                return state + 1;
            }
            case 55: {
                return 57;
            }
            case 61: {
                if (this.isRead.booleanValue()) {
                    int extractedDataValue = 0;
                    for (int i2 = 64; i2 >= 49; --i2) {
                        extractedDataValue = (extractedDataValue << 1) + (this.opsw[i2] ? 1 : 0);
                    }
                    log.debug("Read Index {} value (OpSws 49-64) = 0x{}", (Object)(this.indexToRead + 1), (Object)Integer.toHexString(extractedDataValue));
                    this.updateGuiFromOpSws49_64();
                    this.changeGuiElementHighlight(61, this.indexToRead);
                    return this.determineNextStateForRead();
                }
                return 62;
            }
            case 64: {
                if (this.isRead.booleanValue()) {
                    if (!this.opsw[63] && !this.opsw[64]) {
                        log.debug("Read of high value in index {} is a valid entry.", (Object)this.indexToRead);
                        this.changeGuiElementUnHighlight(64, this.indexToRead);
                        return 49;
                    }
                    log.debug("Read of high value in index {} is an invalid entry.", (Object)this.indexToRead);
                    for (int i = 49; i < 62; ++i) {
                        this.opsw[i] = true;
                    }
                    this.opsw[56] = false;
                    this.updateGuiFromOpSws49_64();
                    this.changeGuiElementHighlight(64, this.indexToRead);
                    return this.determineNextStateForRead();
                }
                this.changeGuiElementHighlight(64, this.indexToRead);
                switch (this.indexToRead) {
                    case 0: {
                        this.outAddr2.setLastQueriedValue(this.outAddr2.getText());
                        this.outAddr2.repaint();
                        Integer i = this.indexToRead;
                        Integer i2 = this.indexToRead = Integer.valueOf(this.indexToRead + 1);
                        this.read = false;
                        this.setOpSwIndex(this.indexToRead);
                        return 25;
                    }
                    case 1: {
                        this.outAddr4.setLastQueriedValue(this.outAddr4.getText());
                        this.outAddr4.repaint();
                        this.readAllButton.setEnabled(true);
                        this.writeAllButton.setEnabled(true);
                        return 0;
                    }
                    case 16: 
                    case 20: 
                    case 24: 
                    case 28: 
                    case 32: 
                    case 36: 
                    case 40: 
                    case 44: {
                        Integer effectiveIndex = (this.indexToRead - 12) / 4;
                        this.routeA2[effectiveIndex.intValue()].addressField.setLastQueriedValue(this.routeA2[effectiveIndex.intValue()].addressField.getText());
                        try {
                            this.routeA2[effectiveIndex].setAddress(Integer.parseInt(this.routeA2[effectiveIndex.intValue()].addressField.getText()));
                        }
                        catch (NumberFormatException e) {
                            this.routeA2[effectiveIndex].setIsUnused();
                        }
                        Integer e = this.indexToRead;
                        Integer n = this.indexToRead = Integer.valueOf(this.indexToRead + 1);
                        this.read = false;
                        this.setOpSwIndex(this.indexToRead);
                        return 25;
                    }
                    case 17: 
                    case 21: 
                    case 25: 
                    case 29: 
                    case 33: 
                    case 37: 
                    case 41: 
                    case 45: {
                        Integer effectiveIndex = (this.indexToRead - 13) / 4;
                        this.routeA4[effectiveIndex.intValue()].addressField.setLastQueriedValue(this.routeA4[effectiveIndex.intValue()].addressField.getText());
                        try {
                            this.routeA4[effectiveIndex].setAddress(Integer.parseInt(this.routeA4[effectiveIndex.intValue()].addressField.getText()));
                        }
                        catch (NumberFormatException e) {
                            this.routeA4[effectiveIndex].setIsUnused();
                        }
                        Integer e = this.indexToRead;
                        Integer n = this.indexToRead = Integer.valueOf(this.indexToRead + 1);
                        this.read = false;
                        this.setOpSwIndex(this.indexToRead);
                        return 25;
                    }
                    case 18: 
                    case 22: 
                    case 26: 
                    case 30: 
                    case 34: 
                    case 38: 
                    case 42: 
                    case 46: {
                        Integer effectiveIndex = (this.indexToRead - 14) / 4;
                        this.routeA6[effectiveIndex.intValue()].addressField.setLastQueriedValue(this.routeA6[effectiveIndex.intValue()].addressField.getText());
                        try {
                            this.routeA6[effectiveIndex].setAddress(Integer.parseInt(this.routeA6[effectiveIndex.intValue()].addressField.getText()));
                        }
                        catch (NumberFormatException e) {
                            this.routeA6[effectiveIndex].setIsUnused();
                        }
                        Integer e = this.indexToRead;
                        Integer n = this.indexToRead = Integer.valueOf(this.indexToRead + 1);
                        this.read = false;
                        this.setOpSwIndex(this.indexToRead);
                        return 25;
                    }
                    case 19: 
                    case 23: 
                    case 27: 
                    case 31: 
                    case 35: 
                    case 39: 
                    case 43: 
                    case 47: {
                        Integer effectiveIndex = (this.indexToRead - 15) / 4;
                        this.routeA8[effectiveIndex.intValue()].addressField.setLastQueriedValue(this.routeA8[effectiveIndex.intValue()].addressField.getText());
                        try {
                            this.routeA8[effectiveIndex].setAddress(Integer.parseInt(this.routeA8[effectiveIndex.intValue()].addressField.getText()));
                        }
                        catch (NumberFormatException e) {
                            this.routeA8[effectiveIndex].setIsUnused();
                        }
                        Integer n = this.indexToRead;
                        Integer n2 = this.indexToRead = Integer.valueOf(this.indexToRead + 1);
                        this.read = false;
                        this.setOpSwIndex(this.indexToRead);
                        return 0;
                    }
                }
                return 0;
            }
            case 7: {
                this.readAllButton.setEnabled(true);
                this.writeAllButton.setEnabled(true);
                log.warn("Board has been reset.  The board will now respond at Address 1.");
                return 0;
            }
        }
        log.error("unexpected state {}", (Object)state);
        this.readAllButton.setEnabled(true);
        this.writeAllButton.setEnabled(true);
        return 0;
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="False positive on the implied local variable in indexToRead++")
    private int determineNextStateForRead() {
        switch (this.indexToRead) {
            case 1: {
                this.readAllButton.setEnabled(true);
                this.writeAllButton.setEnabled(true);
                return 0;
            }
            case 0: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: {
                Integer n = this.indexToRead;
                Integer n2 = this.indexToRead = Integer.valueOf(this.indexToRead + 1);
                this.read = false;
                this.setOpSwIndex(this.indexToRead);
                return 25;
            }
            case 19: 
            case 23: 
            case 27: 
            case 31: 
            case 35: 
            case 39: 
            case 43: 
            case 47: {
                Integer n = this.indexToRead;
                Integer n3 = this.indexToRead = Integer.valueOf(this.indexToRead + 1);
                this.read = false;
                this.setOpSwIndex(this.indexToRead);
                return 0;
            }
        }
        return 0;
    }

    private void changeComponentBgColor(JComponent comp, Color color) {
        comp.setBackground(color);
    }

    private JComponent whichComponent(Integer reportedState, Integer reportedIndexToRead) {
        if (reportedState == 33) {
            switch (reportedIndexToRead) {
                case 0: {
                    return this.outAddr1;
                }
                case 1: {
                    return this.outAddr3;
                }
                case 16: 
                case 20: 
                case 24: 
                case 28: 
                case 32: 
                case 36: 
                case 40: 
                case 44: {
                    return this.routeTop[(reportedIndexToRead.intValue() - 12) / 4].addressField;
                }
                case 17: 
                case 21: 
                case 25: 
                case 29: 
                case 33: 
                case 37: 
                case 41: 
                case 45: {
                    return this.routeA3[(reportedIndexToRead.intValue() - 13) / 4].addressField;
                }
                case 18: 
                case 22: 
                case 26: 
                case 30: 
                case 34: 
                case 38: 
                case 42: 
                case 46: {
                    return this.routeA5[(reportedIndexToRead.intValue() - 14) / 4].addressField;
                }
                case 19: 
                case 23: 
                case 27: 
                case 31: 
                case 35: 
                case 39: 
                case 43: 
                case 47: {
                    return this.routeA7[(reportedIndexToRead.intValue() - 15) / 4].addressField;
                }
            }
            return null;
        }
        if (reportedState == 49) {
            switch (reportedIndexToRead) {
                case 0: {
                    return this.outAddr2;
                }
                case 1: {
                    return this.outAddr4;
                }
                case 16: 
                case 20: 
                case 24: 
                case 28: 
                case 32: 
                case 36: 
                case 40: 
                case 44: {
                    return this.routeA2[(reportedIndexToRead.intValue() - 12) / 4].addressField;
                }
                case 17: 
                case 21: 
                case 25: 
                case 29: 
                case 33: 
                case 37: 
                case 41: 
                case 45: {
                    return this.routeA4[(reportedIndexToRead.intValue() - 13) / 4].addressField;
                }
                case 18: 
                case 22: 
                case 26: 
                case 30: 
                case 34: 
                case 38: 
                case 42: 
                case 46: {
                    return this.routeA6[(reportedIndexToRead.intValue() - 14) / 4].addressField;
                }
                case 19: 
                case 23: 
                case 27: 
                case 31: 
                case 35: 
                case 39: 
                case 43: 
                case 47: {
                    return this.routeA8[(reportedIndexToRead.intValue() - 15) / 4].addressField;
                }
            }
            return null;
        }
        return null;
    }

    private void changeGuiElementUnHighlight(Integer reportedState, Integer reportedIndexToRead) {
        log.debug("changedGuiElementUnHiglight st={} index={}", (Object)reportedState, (Object)reportedIndexToRead);
        switch (reportedState) {
            case 33: {
                return;
            }
            case 45: 
            case 48: {
                JComponent jc = this.whichComponent(33, reportedIndexToRead);
                if (jc != null) {
                    this.changeComponentBgColor(jc, null);
                }
                return;
            }
            case 61: 
            case 64: {
                JComponent jc = this.whichComponent(49, reportedIndexToRead);
                if (jc == null) break;
                this.changeComponentBgColor(jc, null);
                break;
            }
        }
    }

    private void changeGuiElementHighlight(Integer reportedState, Integer reportedIndexToRead) {
        JComponent jc;
        log.debug("changedGuiElementHiglight st={} index={}", (Object)reportedState, (Object)reportedIndexToRead);
        Color accessColor = Color.blue.brighter();
        if (reportedState == 33) {
            jc = this.whichComponent(reportedState, reportedIndexToRead);
            this.changeComponentBgColor(jc, accessColor);
        }
        if (reportedState == 48) {
            this.changeGuiElementUnHighlight(33, reportedIndexToRead);
            jc = this.whichComponent(49, reportedIndexToRead);
            if (jc != null) {
                this.changeComponentBgColor(jc, accessColor);
            }
        }
        if (reportedState == 64) {
            jc = this.whichComponent(49, reportedIndexToRead);
            this.changeComponentBgColor(jc, null);
        }
    }

    private boolean alreadyKnowThisBoardId(Integer id) {
        return this.boardNumsEntryValue.contains(id);
    }

    private Integer addBoardIdToList(Integer id) {
        this.boardNumsEntryValue.add(this.boardNumsEntryValue.size(), id);
        this.addressComboBox.removeAllItems();
        Collections.sort(this.boardNumsEntryValue);
        Integer indexOfTargetBoardAddress = 0;
        Integer index = 0;
        while (index < this.boardNumsEntryValue.size()) {
            if (this.boardNumsEntryValue.get(index).equals(id)) {
                indexOfTargetBoardAddress = index;
            }
            this.addressComboBox.addItem(this.boardNumsEntryValue.get(index));
            index = index + 1;
        }
        return indexOfTargetBoardAddress;
    }

    private void selectBoardIdByIndex(Integer index) {
        this.addressComboBox.setSelectedIndex(index);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void readAll() {
        block25: {
            block24: {
                this.addrField.setText(this.addressComboBox.getSelectedItem().toString());
                Integer curAddr = Integer.parseInt(this.addrField.getText());
                if (!this.alreadyKnowThisBoardId(curAddr)) {
                    Integer index = this.addBoardIdToList(curAddr);
                    this.selectBoardIdByIndex(index);
                }
                if (this.generalTabbedPane.getSelectedComponent().getClass() != JPanel.class) break block24;
                if ((JPanel)this.generalTabbedPane.getSelectedComponent() == this.generalPanel) {
                    this.operationType = OpSwOpType.BasicsRead;
                    break block25;
                } else if ((JPanel)this.generalTabbedPane.getSelectedComponent() == this.outputAddrsPanel) {
                    this.operationType = OpSwOpType.OutputsRead;
                }
                break block25;
            }
            if (this.generalTabbedPane.getSelectedComponent().getClass() == JScrollPane.class) {
                if ((JScrollPane)this.generalTabbedPane.getSelectedComponent() == this.opswsScrollPane) {
                    this.operationType = OpSwOpType.BasicsRead;
                }
            } else {
                if (this.generalTabbedPane.getSelectedComponent().getClass() != JTabbedPane.class) {
                    return;
                }
                if ((JTabbedPane)this.generalTabbedPane.getSelectedComponent() != this.routesTabbedPane) {
                    log.error("DS64 TabbedPanel into ReadAll(): no selected tab group");
                    return;
                }
                if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[1]) {
                    this.operationType = OpSwOpType.Route1Read;
                } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[2]) {
                    this.operationType = OpSwOpType.Route2Read;
                } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[3]) {
                    this.operationType = OpSwOpType.Route3Read;
                } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[4]) {
                    this.operationType = OpSwOpType.Route4Read;
                } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[5]) {
                    this.operationType = OpSwOpType.Route5Read;
                } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[6]) {
                    this.operationType = OpSwOpType.Route6Read;
                } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[7]) {
                    this.operationType = OpSwOpType.Route7Read;
                } else {
                    if ((JPanel)this.routesTabbedPane.getSelectedComponent() != this.routePanel[8]) {
                        log.error("DS64 TabbedPanel into readAll(): no known Route[n] tab selected.");
                        return;
                    }
                    this.operationType = OpSwOpType.Route8Read;
                }
            }
        }
        super.readAll();
    }

    public void updateBoardAddress() {
        this.addrField.setText(this.addressComboBox.getSelectedItem().toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeAll() {
        this.addrField.setText(this.addressComboBox.getSelectedItem().toString());
        Integer curAddr = Integer.parseInt(this.addrField.getText());
        if (!this.boardNumsEntryValue.contains(curAddr)) {
            this.boardNumsEntryValue.add(this.boardNumsEntryValue.size(), curAddr);
            this.addressComboBox.removeAllItems();
            Collections.sort(this.boardNumsEntryValue);
            Integer indexOfTargetBoardAddress = 0;
            Integer index = 0;
            while (index < this.boardNumsEntryValue.size()) {
                if (this.boardNumsEntryValue.get(index).equals(curAddr)) {
                    indexOfTargetBoardAddress = index;
                }
                this.addressComboBox.addItem(this.boardNumsEntryValue.get(index));
                index = index + 1;
            }
            this.addressComboBox.setSelectedIndex(indexOfTargetBoardAddress);
        }
        if (this.generalTabbedPane.getSelectedComponent().getClass() == JPanel.class) {
            if ((JPanel)this.generalTabbedPane.getSelectedComponent() == this.generalPanel) {
                this.operationType = OpSwOpType.BasicsWrite;
            } else if ((JPanel)this.generalTabbedPane.getSelectedComponent() == this.outputAddrsPanel) {
                this.operationType = OpSwOpType.OutputsWrite;
            }
        } else if (this.generalTabbedPane.getSelectedComponent().getClass() == JScrollPane.class) {
            if ((JScrollPane)this.generalTabbedPane.getSelectedComponent() == this.opswsScrollPane) {
                this.operationType = OpSwOpType.BasicsWrite;
            }
        } else {
            if (this.generalTabbedPane.getSelectedComponent().getClass() != JTabbedPane.class) return;
            if ((JTabbedPane)this.generalTabbedPane.getSelectedComponent() != this.routesTabbedPane) return;
            if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[1]) {
                this.operationType = OpSwOpType.Route1Write;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[2]) {
                this.operationType = OpSwOpType.Route2Write;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[3]) {
                this.operationType = OpSwOpType.Route3Write;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[4]) {
                this.operationType = OpSwOpType.Route4Write;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[5]) {
                this.operationType = OpSwOpType.Route5Write;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[6]) {
                this.operationType = OpSwOpType.Route6Write;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[7]) {
                this.operationType = OpSwOpType.Route7Write;
            } else {
                if ((JPanel)this.routesTabbedPane.getSelectedComponent() != this.routePanel[8]) return;
                this.operationType = OpSwOpType.Route8Write;
            }
        }
        super.writeAll();
    }

    protected void setOpSwIndex(int index) {
        this.opsw[25] = (index & 1) == 1;
        this.opsw[26] = (index & 2) == 2;
        this.opsw[27] = (index & 4) == 4;
        this.opsw[28] = (index & 8) == 8;
        this.opsw[29] = (index & 0x10) == 16;
        this.opsw[30] = (index & 0x20) == 32;
        this.opsw[31] = (index & 0x40) == 64;
        this.opsw[32] = (index & 0x80) == 128;
    }

    protected void updateOpSwsOutAddr(int address1, boolean state1, boolean is1Unused, int address2, boolean state2, boolean is2Unused) {
        int addr1 = address1 - 1;
        int addr2 = address2 - 1;
        if (address1 == 0 || is1Unused) {
            addr1 = 2047;
            is1Unused = true;
        }
        if (address2 == 0 || is2Unused) {
            addr2 = 2047;
            is2Unused = true;
        }
        this.opsw[33] = (addr1 & 1) == 1;
        this.opsw[34] = (addr1 & 2) == 2;
        this.opsw[35] = (addr1 & 4) == 4;
        this.opsw[36] = (addr1 & 8) == 8;
        this.opsw[37] = (addr1 & 0x10) == 16;
        this.opsw[38] = (addr1 & 0x20) == 32;
        this.opsw[39] = (addr1 & 0x40) == 64;
        this.opsw[40] = false;
        this.opsw[41] = (addr1 & 0x80) == 128;
        this.opsw[42] = (addr1 & 0x100) == 256;
        this.opsw[43] = (addr1 & 0x200) == 512;
        this.opsw[44] = (addr1 & 0x400) == 1024;
        this.opsw[45] = true;
        this.opsw[46] = state1;
        if (!is1Unused) {
            this.opsw[47] = false;
            this.opsw[48] = false;
        } else {
            this.opsw[47] = true;
            this.opsw[48] = true;
        }
        this.opsw[49] = (addr2 & 1) == 1;
        this.opsw[50] = (addr2 & 2) == 2;
        this.opsw[51] = (addr2 & 4) == 4;
        this.opsw[52] = (addr2 & 8) == 8;
        this.opsw[53] = (addr2 & 0x10) == 16;
        this.opsw[54] = (addr2 & 0x20) == 32;
        this.opsw[55] = (addr2 & 0x40) == 64;
        this.opsw[56] = false;
        this.opsw[57] = (addr2 & 0x80) == 128;
        this.opsw[58] = (addr2 & 0x100) == 256;
        this.opsw[59] = (addr2 & 0x200) == 512;
        this.opsw[60] = (addr2 & 0x400) == 1024;
        this.opsw[61] = true;
        this.opsw[62] = state2;
        if (!is2Unused) {
            this.opsw[63] = false;
            this.opsw[64] = false;
        } else {
            this.opsw[63] = true;
            this.opsw[64] = true;
        }
    }

    protected void updateOpswForWrite(int index) {
        switch (index) {
            case 0: {
                Integer value2Address;
                Integer value1Address;
                try {
                    value1Address = Integer.parseInt(this.outAddr1.getText());
                }
                catch (NumberFormatException e) {
                    value1Address = 2048;
                }
                try {
                    value2Address = Integer.parseInt(this.outAddr2.getText());
                }
                catch (NumberFormatException e) {
                    value2Address = 2048;
                }
                this.updateOpSwsOutAddr(value1Address, false, false, value2Address, false, false);
                break;
            }
            case 1: {
                Integer value2Address;
                Integer value1Address;
                try {
                    value1Address = Integer.parseInt(this.outAddr3.getText());
                }
                catch (NumberFormatException e) {
                    value1Address = 2048;
                }
                try {
                    value2Address = Integer.parseInt(this.outAddr4.getText());
                }
                catch (NumberFormatException e) {
                    value2Address = 2048;
                }
                this.updateOpSwsOutAddr(value1Address, false, false, value2Address, false, false);
                break;
            }
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: {
                boolean value2DirectionIsClosed;
                boolean value2IsUnused;
                Integer value2Address;
                boolean value1DirectionIsClosed;
                boolean value1IsUnused;
                Integer value1Address;
                Integer extractedIndex = (index - 12) / 4;
                this.opsw[47] = false;
                this.opsw[48] = false;
                this.opsw[63] = false;
                this.opsw[64] = false;
                if (this.routeTop[extractedIndex].getIsUnused()) {
                    log.warn("updateOpswForWrite - routetop[{}] is unused.", (Object)extractedIndex);
                    value1Address = 2048;
                    value1IsUnused = true;
                    value1DirectionIsClosed = true;
                } else {
                    value1DirectionIsClosed = this.routeTop[extractedIndex.intValue()].closedRadioButton.isSelected();
                    value1IsUnused = false;
                    try {
                        value1Address = Integer.parseInt(this.routeTop[extractedIndex.intValue()].addressField.getText());
                    }
                    catch (NumberFormatException e) {
                        value1Address = 2048;
                        value1IsUnused = true;
                        value1DirectionIsClosed = true;
                    }
                }
                if (this.routeA2[extractedIndex].getIsUnused()) {
                    log.warn("updateOpswForWrite - routeA2[{}] is unused.", (Object)extractedIndex);
                    value2Address = 2048;
                    value2IsUnused = true;
                    value2DirectionIsClosed = true;
                } else {
                    value2DirectionIsClosed = this.routeA2[extractedIndex.intValue()].closedRadioButton.isSelected();
                    value2IsUnused = false;
                    try {
                        value2Address = Integer.parseInt(this.routeA2[extractedIndex.intValue()].addressField.getText());
                    }
                    catch (NumberFormatException e) {
                        value2Address = 2048;
                        value2IsUnused = true;
                        value2DirectionIsClosed = true;
                    }
                }
                this.updateOpSwsOutAddr(value1Address, value1DirectionIsClosed, value1IsUnused, value2Address, value2DirectionIsClosed, value2IsUnused);
                if (value1IsUnused) {
                    this.opsw[46] = true;
                    this.opsw[47] = true;
                    this.opsw[48] = true;
                    this.routeTop[extractedIndex.intValue()].unusedRadioButton.setSelected(true);
                    this.routeTop[extractedIndex.intValue()].unusedRadioButton.repaint();
                    this.routeTop[extractedIndex].setAddress(2048);
                    this.routeTop[extractedIndex.intValue()].addressField.setText("");
                }
                if (!value2IsUnused) break;
                this.opsw[62] = true;
                this.opsw[63] = true;
                this.opsw[64] = true;
                this.routeA2[extractedIndex.intValue()].unusedRadioButton.setSelected(true);
                this.routeA2[extractedIndex.intValue()].unusedRadioButton.repaint();
                this.routeA2[extractedIndex].setAddress(2048);
                this.routeA2[extractedIndex.intValue()].addressField.setText("");
                break;
            }
            case 17: 
            case 21: 
            case 25: 
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 45: {
                boolean value2DirectionIsClosed;
                boolean value2IsUnused;
                Integer value2Address;
                boolean value1DirectionIsClosed;
                boolean value1IsUnused;
                Integer value1Address;
                Integer extractedIndex = (index - 13) / 4;
                this.opsw[47] = false;
                this.opsw[48] = false;
                this.opsw[63] = false;
                this.opsw[64] = false;
                if (this.routeA3[extractedIndex].getIsUnused()) {
                    value1Address = 2048;
                    value1IsUnused = true;
                    value1DirectionIsClosed = true;
                } else {
                    value1DirectionIsClosed = this.routeA3[extractedIndex.intValue()].closedRadioButton.isSelected();
                    value1IsUnused = false;
                    try {
                        value1Address = Integer.parseInt(this.routeA3[extractedIndex.intValue()].addressField.getText());
                    }
                    catch (NumberFormatException e) {
                        value1Address = 2048;
                        value1IsUnused = true;
                    }
                }
                if (this.routeA4[extractedIndex].getIsUnused()) {
                    value2Address = 2048;
                    value2IsUnused = true;
                    value2DirectionIsClosed = true;
                } else {
                    value2DirectionIsClosed = this.routeA4[extractedIndex.intValue()].closedRadioButton.isSelected();
                    value2IsUnused = false;
                    try {
                        value2Address = Integer.parseInt(this.routeA4[extractedIndex.intValue()].addressField.getText());
                    }
                    catch (NumberFormatException e) {
                        value2Address = 2048;
                        value2IsUnused = true;
                    }
                }
                this.updateOpSwsOutAddr(value1Address, value1DirectionIsClosed, value1IsUnused, value2Address, value2DirectionIsClosed, value2IsUnused);
                if (value1IsUnused) {
                    this.opsw[46] = true;
                    this.opsw[47] = true;
                    this.opsw[48] = true;
                    this.routeA3[extractedIndex.intValue()].unusedRadioButton.setSelected(true);
                    this.routeA3[extractedIndex.intValue()].unusedRadioButton.repaint();
                    this.routeA3[extractedIndex].setAddress(2048);
                    this.routeA3[extractedIndex.intValue()].addressField.setText("");
                }
                if (!value2IsUnused) break;
                this.opsw[62] = true;
                this.opsw[63] = true;
                this.opsw[64] = true;
                this.routeA4[extractedIndex.intValue()].unusedRadioButton.setSelected(true);
                this.routeA4[extractedIndex.intValue()].unusedRadioButton.repaint();
                this.routeA4[extractedIndex].setAddress(2048);
                this.routeA4[extractedIndex.intValue()].addressField.setText("");
                break;
            }
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 42: 
            case 46: {
                boolean value2DirectionIsClosed;
                boolean value2IsUnused;
                Integer value2Address;
                boolean value1DirectionIsClosed;
                boolean value1IsUnused;
                Integer value1Address;
                Integer extractedIndex = (index - 14) / 4;
                this.opsw[47] = false;
                this.opsw[48] = false;
                this.opsw[63] = false;
                this.opsw[64] = false;
                if (this.routeA5[extractedIndex].getIsUnused()) {
                    value1Address = 2048;
                    value1IsUnused = true;
                    value1DirectionIsClosed = true;
                } else {
                    value1DirectionIsClosed = this.routeA5[extractedIndex.intValue()].closedRadioButton.isSelected();
                    value1IsUnused = false;
                    try {
                        value1Address = Integer.parseInt(this.routeA5[extractedIndex.intValue()].addressField.getText());
                    }
                    catch (NumberFormatException e) {
                        value1Address = 2048;
                        value1IsUnused = true;
                    }
                }
                if (this.routeA6[extractedIndex].getIsUnused()) {
                    value2Address = 2048;
                    value2IsUnused = true;
                    value2DirectionIsClosed = true;
                } else {
                    value2DirectionIsClosed = this.routeA6[extractedIndex.intValue()].closedRadioButton.isSelected();
                    value2IsUnused = false;
                    try {
                        value2Address = Integer.parseInt(this.routeA6[extractedIndex.intValue()].addressField.getText());
                    }
                    catch (NumberFormatException e) {
                        value2Address = 2048;
                        value2IsUnused = true;
                    }
                }
                this.updateOpSwsOutAddr(value1Address, value1DirectionIsClosed, value1IsUnused, value2Address, value2DirectionIsClosed, value2IsUnused);
                if (value1IsUnused) {
                    this.opsw[46] = true;
                    this.opsw[47] = true;
                    this.opsw[48] = true;
                    this.routeA5[extractedIndex.intValue()].unusedRadioButton.setSelected(true);
                    this.routeA5[extractedIndex.intValue()].unusedRadioButton.repaint();
                    this.routeA5[extractedIndex].setAddress(2048);
                    this.routeA5[extractedIndex.intValue()].addressField.setText("");
                }
                if (!value2IsUnused) break;
                this.opsw[62] = true;
                this.opsw[63] = true;
                this.opsw[64] = true;
                this.routeA6[extractedIndex.intValue()].unusedRadioButton.setSelected(true);
                this.routeA6[extractedIndex.intValue()].unusedRadioButton.repaint();
                this.routeA6[extractedIndex].setAddress(2048);
                this.routeA6[extractedIndex.intValue()].addressField.setText("");
                break;
            }
            case 19: 
            case 23: 
            case 27: 
            case 31: 
            case 35: 
            case 39: 
            case 43: 
            case 47: {
                boolean value2DirectionIsClosed;
                boolean value2IsUnused;
                Integer value2Address;
                boolean value1DirectionIsClosed;
                boolean value1IsUnused;
                Integer value1Address;
                Integer extractedIndex = (index - 15) / 4;
                this.opsw[47] = false;
                this.opsw[48] = false;
                this.opsw[63] = false;
                this.opsw[64] = false;
                if (this.routeA7[extractedIndex].getIsUnused()) {
                    value1Address = 2048;
                    value1IsUnused = true;
                    value1DirectionIsClosed = true;
                } else {
                    value1DirectionIsClosed = this.routeA7[extractedIndex.intValue()].closedRadioButton.isSelected();
                    value1IsUnused = false;
                    try {
                        value1Address = Integer.parseInt(this.routeA7[extractedIndex.intValue()].addressField.getText());
                    }
                    catch (NumberFormatException e) {
                        value1Address = 2048;
                        value1IsUnused = true;
                    }
                }
                if (this.routeA8[extractedIndex].getIsUnused()) {
                    value2Address = 2048;
                    value2IsUnused = true;
                    value2DirectionIsClosed = true;
                } else {
                    value2DirectionIsClosed = this.routeA8[extractedIndex.intValue()].closedRadioButton.isSelected();
                    value2IsUnused = false;
                    try {
                        value2Address = Integer.parseInt(this.routeA8[extractedIndex.intValue()].addressField.getText());
                    }
                    catch (NumberFormatException e) {
                        value2Address = 2048;
                        value2IsUnused = true;
                    }
                }
                this.updateOpSwsOutAddr(value1Address, value1DirectionIsClosed, value1IsUnused, value2Address, value2DirectionIsClosed, value2IsUnused);
                if (value1IsUnused) {
                    this.opsw[46] = true;
                    this.opsw[47] = true;
                    this.opsw[48] = true;
                    this.routeA7[extractedIndex.intValue()].unusedRadioButton.setSelected(true);
                    this.routeA7[extractedIndex.intValue()].unusedRadioButton.repaint();
                    this.routeA7[extractedIndex].setAddress(2048);
                    this.routeA7[extractedIndex.intValue()].addressField.setText("");
                }
                if (!value2IsUnused) break;
                this.opsw[62] = true;
                this.opsw[63] = true;
                this.opsw[64] = true;
                this.routeA8[extractedIndex.intValue()].unusedRadioButton.setSelected(true);
                this.routeA8[extractedIndex.intValue()].unusedRadioButton.repaint();
                this.routeA8[extractedIndex].setAddress(2048);
                this.routeA8[extractedIndex.intValue()].addressField.setText("");
                break;
            }
            case 48: {
                break;
            }
        }
    }

    private void resetRouteOperation(Integer routeNumber) {
        if (routeNumber < 1 || routeNumber > 8) {
            return;
        }
        this.routeTop[routeNumber.intValue()].unusedRadioButton.setSelected(true);
        this.routeTop[routeNumber].setIsUnused();
        this.routeTop[routeNumber.intValue()].addressField.setText("");
        this.routeA2[routeNumber].setIsUnused();
        this.routeA2[routeNumber.intValue()].unusedRadioButton.setSelected(true);
        this.routeA2[routeNumber.intValue()].addressField.setText("");
        this.routeA3[routeNumber].setIsUnused();
        this.routeA3[routeNumber.intValue()].unusedRadioButton.setSelected(true);
        this.routeA3[routeNumber.intValue()].addressField.setText("");
        this.routeA4[routeNumber].setIsUnused();
        this.routeA4[routeNumber.intValue()].unusedRadioButton.setSelected(true);
        this.routeA4[routeNumber.intValue()].addressField.setText("");
        this.routeA5[routeNumber].setIsUnused();
        this.routeA5[routeNumber.intValue()].unusedRadioButton.setSelected(true);
        this.routeA5[routeNumber.intValue()].addressField.setText("");
        this.routeA6[routeNumber].setIsUnused();
        this.routeA6[routeNumber.intValue()].unusedRadioButton.setSelected(true);
        this.routeA6[routeNumber.intValue()].addressField.setText("");
        this.routeA7[routeNumber].setIsUnused();
        this.routeA7[routeNumber.intValue()].unusedRadioButton.setSelected(true);
        this.routeA7[routeNumber.intValue()].addressField.setText("");
        this.routeA8[routeNumber].setIsUnused();
        this.routeA8[routeNumber.intValue()].unusedRadioButton.setSelected(true);
        this.routeA8[routeNumber.intValue()].addressField.setText("");
        this.writeAll();
    }

    private void unhighlightAllBasicOpSws() {
        this.outputType.setBackground(null);
        this.delayTime.setBackground(null);
        this.outputStates.setBackground(null);
        this.startupDelay.setBackground(null);
        this.staticOutputShutoff.setBackground(null);
        this.commandType.setBackground(null);
        this.routesControl.setBackground(null);
        this.localControlOfOutputsStyle.setBackground(null);
        this.sensorMessageTrigger.setBackground(null);
        this.commandSource.setBackground(null);
        this.output1CrossbuckFlasherCheckBox.setBackground(null);
        this.output2CrossbuckFlasherCheckBox.setBackground(null);
        this.output3CrossbuckFlasherCheckBox.setBackground(null);
        this.output4CrossbuckFlasherCheckBox.setBackground(null);
        this.localSensorType.setBackground(null);
    }

    private void unhighlightAllRouteEntryFields() {
        for (int i = 1; i < 9; ++i) {
            this.routeTop[i].addressField.setBackground(null);
            this.routeA2[i].addressField.setBackground(null);
            this.routeA3[i].addressField.setBackground(null);
            this.routeA4[i].addressField.setBackground(null);
            this.routeA5[i].addressField.setBackground(null);
            this.routeA6[i].addressField.setBackground(null);
            this.routeA7[i].addressField.setBackground(null);
            this.routeA8[i].addressField.setBackground(null);
            this.updateUI();
        }
    }

    private void unhighlightAllOutputEntryFields() {
        this.outAddr1.setBackground(null);
        this.outAddr2.setBackground(null);
        this.outAddr3.setBackground(null);
        this.outAddr4.setBackground(null);
    }

    @Override
    public void message(LocoNetMessage m) {
        Integer extractedBoardId;
        super.message(m);
        if (m.getOpCode() == 180 && (m.getElement(1) == 80 || m.getElement(1) == 0) && this.state == 0 && this.resetRouteButton.isSelected()) {
            this.resetRouteButton.setSelected(false);
            this.resetRouteButton.updateUI();
        }
        if (m.getOpCode() == 176) {
            boolean dir;
            int swAddr = (m.getElement(2) & 0xF) * 128 + (m.getElement(1) & 0x7F) + 1;
            boolean bl = dir = (m.getElement(2) & 0x20) == 32;
            if (swAddr == Integer.parseInt(this.outAddr1.getText())) {
                this.outState1.setText(dir ? Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateClosed")) : Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateThrown")));
                this.outState1.updateUI();
            }
            if (swAddr == Integer.parseInt(this.outAddr2.getText())) {
                this.outState2.setText(dir ? Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateClosed")) : Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateThrown")));
                this.outState2.updateUI();
            }
            if (swAddr == Integer.parseInt(this.outAddr3.getText())) {
                this.outState3.setText(dir ? Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateClosed")) : Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateThrown")));
                this.outState3.updateUI();
            }
            if (swAddr == Integer.parseInt(this.outAddr4.getText())) {
                this.outState4.setText(dir ? Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateClosed")) : Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateThrown")));
                this.outState4.updateUI();
            }
        } else if (m.getOpCode() == 208 && (m.getElement(1) & 0x7E) == 98 && m.getElement(3) == 3 && !this.alreadyKnowThisBoardId(extractedBoardId = Integer.valueOf(1 + ((m.getElement(1) & 1) << 7) + (m.getElement(2) & 0x7F)))) {
            this.addBoardIdToList(extractedBoardId);
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Functionality not yet confirmed with hardware; may be useful at a future date.")
    private void boardFactoryReset() {
        Object[] dialogBoxButtonOptions = new Object[]{Bundle.getMessage("ButtonResetToFactoryDefault"), Bundle.getMessage("ButtonCancel")};
        int userReply = JmriJOptionPane.showOptionDialog(this, Bundle.getMessage("DialogTextBoardResetWarning"), Bundle.getMessage("WarningTitle"), 0, 3, null, dialogBoxButtonOptions, dialogBoxButtonOptions[1]);
        if (userReply != 0) {
            this.factoryResetButton.setSelected(false);
            return;
        }
        this.readAllButton.setEnabled(false);
        this.writeAllButton.setEnabled(false);
        this.resetRouteButton.setEnabled(false);
        this.factoryResetButton.setEnabled(false);
        this.read = false;
        this.isWritingResetOpSw = true;
        this.resetOpSwVal = true;
        this.opsw[7] = true;
        this.updateBoardAddress();
        this.writeOne(7);
        this.boardResetResponseTimer = new Timer(750, event -> {
            this.factoryResetButton.setSelected(false);
            this.factoryResetButton.setEnabled(true);
            this.readAllButton.setEnabled(true);
            this.writeAllButton.setEnabled(true);
            this.resetRouteButton.setEnabled(true);
            this.updateUI();
        });
        this.boardResetResponseTimer.start();
    }

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        LocoNetMessage m = new LocoNetMessage(6);
        m.setElement(0, 208);
        m.setElement(1, 98);
        m.setElement(2, 0);
        m.setElement(3, 112);
        m.setElement(4, 0);
        memo.getLnTrafficController().sendLocoNetMessage(m);
    }

    @Override
    public void initComponents() {
        super.initComponents();
        String[] outputTypes = new String[]{Bundle.getMessage("ComboBoxOutputType0"), Bundle.getMessage("ComboBoxOutputType1")};
        this.outputTypeLabel = new JLabel(Bundle.getMessage("LabelOutputType"));
        this.outputType = new JComboBox<String>(outputTypes);
        this.outputType.setToolTipText(Bundle.getMessage("ToolTipOutputType"));
        this.outputType.addActionListener(this.basicConfigChangeActionListener);
        this.outputType.setName("1");
        String[] availableDelayTimes = new String[]{Bundle.getMessage("ComboBoxPulseTime0point1"), Bundle.getMessage("ComboBoxPulseTime0point2"), Bundle.getMessage("ComboBoxPulseTime0point4"), Bundle.getMessage("ComboBoxPulseTime0point6"), Bundle.getMessage("ComboBoxPulseTime0point8"), Bundle.getMessage("ComboBoxPulseTime1point0"), Bundle.getMessage("ComboBoxPulseTime1point2"), Bundle.getMessage("ComboBoxPulseTime1point4"), Bundle.getMessage("ComboBoxPulseTime1point6"), Bundle.getMessage("ComboBoxPulseTime1point8"), Bundle.getMessage("ComboBoxPulseTime2point0"), Bundle.getMessage("ComboBoxPulseTime2point2"), Bundle.getMessage("ComboBoxPulseTime2point4"), Bundle.getMessage("ComboBoxPulseTime2point6"), Bundle.getMessage("ComboBoxPulseTime2point8"), Bundle.getMessage("ComboBoxPulseTime3point0")};
        this.delayTimeLabel = new JLabel(Bundle.getMessage("LabelPulseTimeout"));
        this.delayTime = new JComboBox<String>(availableDelayTimes);
        this.delayTime.setToolTipText(Bundle.getMessage("ToolTipPulseTimeout"));
        this.delayTime.setName("2345");
        this.delayTime.addActionListener(this.basicConfigChangeActionListener);
        String[] initialOutputStates = new String[]{Bundle.getMessage("ComboBoxOutputPowerupType0"), Bundle.getMessage("ComboBoxOutputPowerupType1")};
        this.outputStatesLabel = new JLabel(Bundle.getMessage("LabelPowerUpOutputActivity"));
        this.outputStates = new JComboBox<String>(initialOutputStates);
        this.outputStates.setToolTipText(Bundle.getMessage("ToolTipOutputStates"));
        this.outputStates.setName("6");
        this.outputStates.addActionListener(this.basicConfigChangeActionListener);
        String[] startupDelays = new String[]{Bundle.getMessage("ComboBoxOutputPowerupDelayType0"), Bundle.getMessage("ComboBoxOutputPowerupDelayType1")};
        this.startupDelayLabel = new JLabel(Bundle.getMessage("LabelInitialPowerUpDelay"));
        this.startupDelay = new JComboBox<String>(startupDelays);
        this.startupDelay.setToolTipText(Bundle.getMessage("ToolTipStartupDelay"));
        this.startupDelay.setName("8");
        this.startupDelay.addActionListener(this.basicConfigChangeActionListener);
        String[] staticOutputShutoffs = new String[]{Bundle.getMessage("ComboBoxOutputPowerManagementType0"), Bundle.getMessage("ComboBoxOutputPowerManagementType1")};
        this.staticOutputShutoffLabel = new JLabel(Bundle.getMessage("LabelOutputPowerManagementStyle"));
        this.staticOutputShutoff = new JComboBox<String>(staticOutputShutoffs);
        this.staticOutputShutoff.setToolTipText(Bundle.getMessage("ToolTipLabelOutputPowerManagementStyle"));
        this.staticOutputShutoff.setName("9");
        this.staticOutputShutoff.addActionListener(this.basicConfigChangeActionListener);
        String[] commandTypes = new String[]{Bundle.getMessage("ComboBoxCommandsRecognizedFromType0"), Bundle.getMessage("ComboBoxCommandsRecognizedFromType1")};
        this.commandTypeLabel = new JLabel(Bundle.getMessage("LabelAcceptedSwitchCommandTypes"));
        this.commandType = new JComboBox<String>(commandTypes);
        this.commandType.setToolTipText(Bundle.getMessage("ToolTipLabelAcceptedSwitchCommandTypes"));
        this.commandType.setName("10");
        this.commandType.addActionListener(this.basicConfigChangeActionListener);
        String[] commandSources = new String[]{Bundle.getMessage("ComboBoxCommandSourceType0"), Bundle.getMessage("ComboBoxCommandSourceType1")};
        this.commandSourceLabel = new JLabel(Bundle.getMessage("LabelAcceptSwitchCommandsFrom"));
        this.commandSource = new JComboBox<String>(commandSources);
        this.commandSource.setToolTipText(Bundle.getMessage("ToolTipCommandSource"));
        this.commandSource.setName("14");
        this.commandSource.addActionListener(this.basicConfigChangeActionListener);
        this.output1CrossbuckFlasherCheckBox = new JCheckBox(Bundle.getMessage("CheckBoxOutputXCrossbuck", 1));
        this.output1CrossbuckFlasherCheckBox.setToolTipText(Bundle.getMessage("ToolTipCheckBoxOutput1Crossbuck"));
        this.output1CrossbuckFlasherCheckBox.setName("17");
        this.output1CrossbuckFlasherCheckBox.addActionListener(this.basicConfigChangeActionListener);
        this.output2CrossbuckFlasherCheckBox = new JCheckBox(Bundle.getMessage("CheckBoxOutputXCrossbuck", 2));
        this.output2CrossbuckFlasherCheckBox.setToolTipText(Bundle.getMessage("ToolTipCheckBoxOutput2Crossbuck"));
        this.output2CrossbuckFlasherCheckBox.setName("18");
        this.output2CrossbuckFlasherCheckBox.addActionListener(this.basicConfigChangeActionListener);
        this.output3CrossbuckFlasherCheckBox = new JCheckBox(Bundle.getMessage("CheckBoxOutputXCrossbuck", 3));
        this.output3CrossbuckFlasherCheckBox.setToolTipText(Bundle.getMessage("ToolTipCheckBoxOutput3Crossbuck"));
        this.output3CrossbuckFlasherCheckBox.setName("19");
        this.output3CrossbuckFlasherCheckBox.addActionListener(this.basicConfigChangeActionListener);
        this.output4CrossbuckFlasherCheckBox = new JCheckBox(Bundle.getMessage("CheckBoxOutputXCrossbuck", 4));
        this.output4CrossbuckFlasherCheckBox.setToolTipText(Bundle.getMessage("ToolTipCheckBoxOutput4Crossbuck"));
        this.output4CrossbuckFlasherCheckBox.setName("20");
        this.output4CrossbuckFlasherCheckBox.addActionListener(this.basicConfigChangeActionListener);
        String[] routesControls = new String[]{Bundle.getMessage("ComboBoxEntryRoutesOption0"), Bundle.getMessage("ComboBoxEntryRoutesOption1"), Bundle.getMessage("ComboBoxEntryRoutesOption2"), Bundle.getMessage("ComboBoxEntryRoutesOption3")};
        this.routesControlLabel = new JLabel(Bundle.getMessage("LabelTriggerDs64Routes"));
        this.routesControl = new JComboBox<String>(routesControls);
        this.routesControl.setToolTipText(Bundle.getMessage("ToolTipLabelRouteControlOptions"));
        this.routesControl.setName("1116");
        this.routesControl.addActionListener(this.basicConfigChangeActionListener);
        String[] localControlOfOutputsStyles = new String[]{Bundle.getMessage("ComboBoxInputsControlOutputsType0"), Bundle.getMessage("ComboBoxInputsControlOutputsType1"), Bundle.getMessage("ComboBoxInputsControlOutputsType2"), Bundle.getMessage("comboboxInputsControlOutputsType3")};
        this.localControlOfOutputsStyleLabel = new JLabel(Bundle.getMessage("LabelLocalInputsControlOutputs"));
        this.localControlOfOutputsStyle = new JComboBox<String>(localControlOfOutputsStyles);
        this.localControlOfOutputsStyle.setToolTipText(Bundle.getMessage("ToolTipLocalInputsControl"));
        this.localControlOfOutputsStyle.setName("1215");
        this.localControlOfOutputsStyle.addActionListener(this.basicConfigChangeActionListener);
        String[] sensorMessageTriggers = new String[]{Bundle.getMessage("ComboBoxInputsCauseMessagesType0"), Bundle.getMessage("ComboBoxInputsCauseMessagesType1")};
        this.sensorMessageTriggerLabel = new JLabel(Bundle.getMessage("LabelBetweenForMessageTypeSent"));
        this.sensorMessageTrigger = new JComboBox<String>(sensorMessageTriggers);
        this.sensorMessageTrigger.setToolTipText(Bundle.getMessage("ToolTipSensorMessageTrigger"));
        this.sensorMessageTrigger.setName("13");
        this.sensorMessageTrigger.addActionListener(this.basicConfigChangeActionListener);
        String[] localSensorTypes = new String[]{Bundle.getMessage("ComboBoxSensorMessageTypeSentType0"), Bundle.getMessage("ComboBoxSensorMessageTypeSentType1")};
        this.localSensorType = new JComboBox<String>(localSensorTypes);
        this.localSensorType.setToolTipText(Bundle.getMessage("ToolTipLocalSensorsType"));
        this.localSensorType.setName("21");
        this.localSensorType.addActionListener(this.basicConfigChangeActionListener);
        this.factoryResetButton = new JToggleButton(Bundle.getMessage("ButtonResetToFactoryDefault"));
        this.factoryResetButton.setToolTipText(Bundle.getMessage("ToolTipButtonResetToFactoryDefault"));
        this.factoryResetButton.addActionListener(event -> {
            this.readAllButton.setEnabled(false);
            this.writeAllButton.setEnabled(false);
            this.resetRouteButton.setEnabled(false);
            this.boardFactoryReset();
        });
        this.routesTabbedPane = new JTabbedPane();
        this.routePanel = new JPanel[9];
        this.routeTop = new SimpleTurnoutStateEntry[9];
        this.routeA2 = new SimpleTurnoutStateEntry[9];
        this.routeA3 = new SimpleTurnoutStateEntry[9];
        this.routeA4 = new SimpleTurnoutStateEntry[9];
        this.routeA5 = new SimpleTurnoutStateEntry[9];
        this.routeA6 = new SimpleTurnoutStateEntry[9];
        this.routeA7 = new SimpleTurnoutStateEntry[9];
        this.routeA8 = new SimpleTurnoutStateEntry[9];
        this.resetRouteButton = new JToggleButton(Bundle.getMessage("ButtonResetRoute"));
        this.resetRouteButton.setToolTipText(Bundle.getMessage("ToolTipButtonResetRoute"));
        this.resetRouteButton.setEnabled(false);
        this.resetRouteButton.setVisible(false);
        JPanel addressingPanel = this.provideAddressing(" ");
        this.readAllButton.setPreferredSize(null);
        this.readAllButton.setText(Bundle.getMessage("ButtonReadFullSheet"));
        this.readAllButton.setToolTipText(Bundle.getMessage("ToolTipButtonReadFullSheet"));
        this.writeAllButton.setPreferredSize(null);
        this.writeAllButton.setText(Bundle.getMessage("ButtonWriteFullSheet"));
        this.writeAllButton.setToolTipText(Bundle.getMessage("ToolTipButtonWriteFullSheet"));
        Dimension d = this.writeAllButton.getPreferredSize();
        int w = d.width;
        d = this.readAllButton.getPreferredSize();
        if (d.width > w) {
            w = d.width;
        }
        this.writeAllButton.setPreferredSize(new Dimension((int)((double)w * 1.1), d.height));
        this.readAllButton.setPreferredSize(new Dimension((int)((double)w * 1.1), d.height));
        addressingPanel.add(this.resetRouteButton);
        int indexOfTargetBoardAddress = 0;
        this.addressComboBox = new JComboBox();
        Integer index = 0;
        while (index < this.boardNumsEntryValue.size()) {
            if (this.boardNumsEntryValue.get(index) == this.origAccessBoardNum) {
                this.origAccessBoardNum = -1;
                indexOfTargetBoardAddress = index;
            }
            this.addressComboBox.addItem(this.boardNumsEntryValue.get(index));
            index = index + 1;
        }
        this.addressComboBox.setSelectedIndex(indexOfTargetBoardAddress);
        addressingPanel.add((Component)this.addressComboBox, 1);
        addressingPanel.getComponent(2).setVisible(false);
        this.addressComboBox.setEditable(true);
        this.appendLine(addressingPanel);
        this.generalTabbedPane = new JTabbedPane();
        this.generalPanel = new JPanel();
        this.generalPanel.setLayout(new BoxLayout(this.generalPanel, 1));
        this.generalPanel.setName("Basic Settings");
        JPanel allOutputControls = new JPanel();
        allOutputControls.setLayout(new BoxLayout(allOutputControls, 1));
        Border blackline = BorderFactory.createLineBorder(Color.black);
        TitledBorder allOutputControlsTitleBorder = BorderFactory.createTitledBorder(blackline, Bundle.getMessage("TitledBorderLabelOutputControls"));
        allOutputControls.setBorder(allOutputControlsTitleBorder);
        JPanel outputTypePanel = new JPanel();
        outputTypePanel.setLayout(new FlowLayout());
        outputTypePanel.add(this.outputTypeLabel);
        outputTypePanel.add(this.outputType);
        allOutputControls.add(outputTypePanel);
        JPanel delayTimePanel = new JPanel();
        delayTimePanel.setLayout(new FlowLayout());
        delayTimePanel.add(this.delayTimeLabel);
        delayTimePanel.add(this.delayTime);
        allOutputControls.add(delayTimePanel);
        JPanel outputStatePanel = new JPanel();
        outputStatePanel.setLayout(new FlowLayout());
        outputStatePanel.add(this.outputStatesLabel);
        outputStatePanel.add(this.outputStates);
        allOutputControls.add(outputStatePanel);
        JPanel startupDelayPanel = new JPanel();
        startupDelayPanel.setLayout(new FlowLayout());
        startupDelayPanel.add(this.startupDelayLabel);
        startupDelayPanel.add(this.startupDelay);
        allOutputControls.add(startupDelayPanel);
        JPanel staticOutputShutoffPanel = new JPanel();
        staticOutputShutoffPanel.setLayout(new FlowLayout());
        staticOutputShutoffPanel.add(this.staticOutputShutoffLabel);
        staticOutputShutoffPanel.add(this.staticOutputShutoff);
        allOutputControls.add(staticOutputShutoffPanel);
        JPanel crossingGateControls = new JPanel(new GridLayout(2, 2));
        crossingGateControls.add(this.output1CrossbuckFlasherCheckBox);
        crossingGateControls.add(this.output3CrossbuckFlasherCheckBox);
        crossingGateControls.add(this.output2CrossbuckFlasherCheckBox);
        crossingGateControls.add(this.output4CrossbuckFlasherCheckBox);
        allOutputControls.add(crossingGateControls);
        this.generalPanel.add(allOutputControls);
        JPanel ds64CommandSourcesPanel = new JPanel();
        ds64CommandSourcesPanel.setLayout(new BoxLayout(ds64CommandSourcesPanel, 1));
        TitledBorder ds64CommandSourcesTitleBorder = BorderFactory.createTitledBorder(blackline, Bundle.getMessage("TitledBorderLabelCommandSources"));
        ds64CommandSourcesPanel.setBorder(ds64CommandSourcesTitleBorder);
        JPanel commandTypePanel = new JPanel();
        commandTypePanel.setLayout(new FlowLayout());
        commandTypePanel.add(this.commandTypeLabel);
        commandTypePanel.add(this.commandType);
        ds64CommandSourcesPanel.add(commandTypePanel);
        JPanel commandSourcePanel = new JPanel();
        commandSourcePanel.setLayout(new FlowLayout());
        commandSourcePanel.add(this.commandSourceLabel);
        commandSourcePanel.add(this.commandSource);
        ds64CommandSourcesPanel.add(commandSourcePanel);
        this.generalPanel.add(ds64CommandSourcesPanel);
        JPanel localRoutesPanel = new JPanel();
        localRoutesPanel.setLayout(new BoxLayout(localRoutesPanel, 1));
        TitledBorder localRoutesTitleBorder = BorderFactory.createTitledBorder(blackline, Bundle.getMessage("TitledBorderLabelRoutes"));
        localRoutesPanel.setBorder(localRoutesTitleBorder);
        JPanel routesControlPanel = new JPanel();
        routesControlPanel.setLayout(new FlowLayout());
        routesControlPanel.add(this.routesControlLabel);
        routesControlPanel.add(this.routesControl);
        localRoutesPanel.add(routesControlPanel);
        this.generalPanel.add(localRoutesPanel);
        this.localInputControlsPanel = new JPanel();
        this.localInputControlsPanel.setLayout(new BoxLayout(this.localInputControlsPanel, 1));
        TitledBorder localInputControlsTitleBorder = BorderFactory.createTitledBorder(blackline, Bundle.getMessage("TitledBorderLabelLocalInputControls"));
        this.localInputControlsPanel.setBorder(localInputControlsTitleBorder);
        JPanel localControlOfOutputsStylePanel = new JPanel(new FlowLayout());
        localControlOfOutputsStylePanel.add(this.localControlOfOutputsStyleLabel);
        localControlOfOutputsStylePanel.add(this.localControlOfOutputsStyle);
        this.localInputControlsPanel.add(localControlOfOutputsStylePanel);
        this.sensorMessageTriggerPanel = new JPanel(new FlowLayout());
        this.sensorMessageTriggerPanel.add(this.localSensorType);
        this.sensorMessageTriggerPanel.add(this.sensorMessageTriggerLabel);
        this.sensorMessageTriggerPanel.add(this.sensorMessageTrigger);
        this.localInputControlsPanel.add(this.sensorMessageTriggerPanel);
        this.generalPanel.add(this.localInputControlsPanel);
        this.generalPanel.add(new JSeparator());
        JPanel factoryResetButtonPanel = new JPanel();
        factoryResetButtonPanel.add(this.factoryResetButton);
        this.generalPanel.add(factoryResetButtonPanel);
        this.generalTabbedPane.addTab(Bundle.getMessage("TabTextBasicSettings"), null, this.generalPanel, Bundle.getMessage("TabToolTipBasicSettings"));
        this.opswsPanel = new JPanel();
        this.opswsValues = new JPanel();
        this.opswsValues.setLayout(new BoxLayout(this.opswsValues, 1));
        TitledBorder opswsValuesTitleBorder = BorderFactory.createTitledBorder(blackline, Bundle.getMessage("TitledBorderLabelOpSws"));
        this.opswsValues.setBorder(opswsValuesTitleBorder);
        this.opswsPanel.setLayout(new BoxLayout(this.opswsPanel, 1));
        ButtonGroup[] g = new ButtonGroup[22];
        this.opswThrown = new JRadioButtonWithInteger[22];
        this.opswClosed = new JRadioButtonWithInteger[22];
        for (int i = 1; i <= 21; ++i) {
            if (i == 7) continue;
            log.debug("Creating entry for OpSw {}", (Object)i);
            JPanel innerPanel = new JPanel(new FlowLayout());
            innerPanel.add(new JLabel("OpSw " + i));
            this.opswThrown[i] = new JRadioButtonWithInteger(i, Bundle.getMessage("TurnoutStateThrown"));
            this.opswClosed[i] = new JRadioButtonWithInteger(i, Bundle.getMessage("TurnoutStateClosed"));
            g[i] = new ButtonGroup();
            g[i].add(this.opswThrown[i]);
            g[i].add(this.opswClosed[i]);
            innerPanel.add(this.opswThrown[i]);
            innerPanel.add(this.opswClosed[i]);
            this.opswsPanel.add(innerPanel);
            this.opswThrown[i].addItemListener(event -> {
                if (event.getSource().getClass() == JRadioButtonWithInteger.class) {
                    JRadioButtonWithInteger source = (JRadioButtonWithInteger)event.getSource();
                    int ind = source.index;
                    boolean st = event.getStateChange() == 2;
                    log.debug("ItemEventListener Opsw values: {} thrown radio button event: {} {}.", new Object[]{ind, st, st ? "Closed" : "Thrown"});
                    this.opsw[ind] = st;
                    this.copyOpswToBasic();
                }
            });
        }
        this.opswsValues.add(this.opswsPanel);
        this.opswsScrollPane = new JScrollPane(this.opswsValues);
        this.opswsScrollPane.setPreferredSize(new Dimension(180, 200));
        this.opswsScrollPane.setName("Simple OpSws");
        this.generalTabbedPane.addTab(Bundle.getMessage("TabTextOpSwValues"), null, this.opswsScrollPane, Bundle.getMessage("TabToolTipOpSwValues"));
        this.outputAddrsPanel = new JPanel();
        this.outputAddrsPanel.setLayout(new BoxLayout(this.outputAddrsPanel, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel(Bundle.getMessage("LabelCautionReadingWritingCanCauseOutputChanges")));
        this.outputAddrsPanel.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel(Bundle.getMessage("LabelTextOutputX", 1)));
        this.outAddr1 = new ValidatedTextField(5, false, 1, 2048, Bundle.getMessage("ErrorTextNonBlankAddressInvalid"));
        this.outState1 = new JLabel(Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateUnknown")));
        p.add(this.outAddr1);
        p.add(this.outState1);
        this.outputAddrsPanel.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel(Bundle.getMessage("LabelTextOutputX", 2)));
        this.outAddr2 = new ValidatedTextField(5, false, 1, 2048, Bundle.getMessage("ErrorTextNonBlankAddressInvalid"));
        this.outState2 = new JLabel(Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateUnknown")));
        p.add(this.outAddr2);
        p.add(this.outState2);
        this.outputAddrsPanel.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel(Bundle.getMessage("LabelTextOutputX", 3)));
        this.outAddr3 = new ValidatedTextField(5, false, 1, 2048, Bundle.getMessage("ErrorTextNonBlankAddressInvalid"));
        this.outState3 = new JLabel(Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateUnknown")));
        p.add(this.outAddr3);
        p.add(this.outState3);
        this.outputAddrsPanel.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel(Bundle.getMessage("LabelTextOutputX", 4)));
        this.outAddr4 = new ValidatedTextField(5, false, 1, 2048, Bundle.getMessage("ErrorTextNonBlankAddressInvalid"));
        this.outState4 = new JLabel(Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateUnknown")));
        p.add(this.outAddr4);
        p.add(this.outState4);
        this.outputAddrsPanel.add(p);
        this.outputAddrsPanel.add(new JSeparator());
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel(Bundle.getMessage("LabelOutputsTabSensorNotes")));
        this.outputAddrsPanel.add(p);
        this.generalTabbedPane.addTab(Bundle.getMessage("TabTextOutputAddrs"), null, this.outputAddrsPanel, Bundle.getMessage("TabToolTipOutputAddrs"));
        this.routePanel[0] = new JPanel();
        this.routesTabbedPane.setTabPlacement(2);
        for (int i = 1; i <= 8; ++i) {
            this.routePanel[i] = new JPanel();
            this.routePanel[i].setLayout(new BoxLayout(this.routePanel[i], 1));
            this.routePanel[i].add(new JLabel(Bundle.getMessage("TabTextSpecificRoute", Integer.toString(i))));
            this.routePanel[i].add(new JSeparator());
            JPanel q = new JPanel(new FlowLayout());
            q.add(new JLabel(Bundle.getMessage("LabelCautionReadingWritingCanCauseOutputChanges")));
            this.routePanel[i].add(q);
            this.routePanel[i].add(new JSeparator());
            this.routeTop[i] = new SimpleTurnoutStateEntry(2048, false, true);
            this.routeA2[i] = new SimpleTurnoutStateEntry(2048, false, true);
            this.routeA3[i] = new SimpleTurnoutStateEntry(2048, false, true);
            this.routeA4[i] = new SimpleTurnoutStateEntry(2048, false, true);
            this.routeA5[i] = new SimpleTurnoutStateEntry(2048, false, true);
            this.routeA6[i] = new SimpleTurnoutStateEntry(2048, false, true);
            this.routeA7[i] = new SimpleTurnoutStateEntry(2048, false, true);
            this.routeA8[i] = new SimpleTurnoutStateEntry(2048, false, true);
            this.routePanel[i].add(this.routeTop[i].createEntryPanel(Bundle.getMessage("LabelTextRouteXSpecificTurnout", Bundle.getMessage("LabelTextRouteXTopTurnout"))));
            this.routePanel[i].add(this.routeA2[i].createEntryPanel(Bundle.getMessage("LabelTextRouteXSpecificTurnout", 2)));
            this.routePanel[i].add(this.routeA3[i].createEntryPanel(Bundle.getMessage("LabelTextRouteXSpecificTurnout", 3)));
            this.routePanel[i].add(this.routeA4[i].createEntryPanel(Bundle.getMessage("LabelTextRouteXSpecificTurnout", 4)));
            this.routePanel[i].add(this.routeA5[i].createEntryPanel(Bundle.getMessage("LabelTextRouteXSpecificTurnout", 5)));
            this.routePanel[i].add(this.routeA6[i].createEntryPanel(Bundle.getMessage("LabelTextRouteXSpecificTurnout", 6)));
            this.routePanel[i].add(this.routeA7[i].createEntryPanel(Bundle.getMessage("LabelTextRouteXSpecificTurnout", 7)));
            this.routePanel[i].add(this.routeA8[i].createEntryPanel(Bundle.getMessage("LabelTextRouteXSpecificTurnout", 8)));
            this.routesTabbedPane.addTab(Bundle.getMessage("TabTextSpecificRoute", Integer.toString(i)), null, this.routePanel[i], Bundle.getMessage("TabToolTipSpecificRoute", Integer.toString(i)));
        }
        this.generalTabbedPane.addTab(Bundle.getMessage("TabTextRoutes"), null, this.routesTabbedPane, Bundle.getMessage("ToolTipTabTextRoutes"));
        this.resetRouteButton.addActionListener(event -> {
            this.readAllButton.setEnabled(false);
            this.writeAllButton.setEnabled(false);
            this.factoryResetButton.setEnabled(false);
            Integer routeNumber = 0;
            if ((JTabbedPane)this.generalTabbedPane.getSelectedComponent() != this.routesTabbedPane) {
                return;
            }
            if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[1]) {
                routeNumber = 1;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[2]) {
                routeNumber = 2;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[3]) {
                routeNumber = 3;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[4]) {
                routeNumber = 4;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[5]) {
                routeNumber = 5;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[6]) {
                routeNumber = 6;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[7]) {
                routeNumber = 7;
            } else if ((JPanel)this.routesTabbedPane.getSelectedComponent() == this.routePanel[8]) {
                routeNumber = 8;
            }
            if (routeNumber != 0) {
                Object[] dialogBoxButtonOptions = new Object[]{Bundle.getMessage("ButtonResetRouteN", routeNumber), Bundle.getMessage("ButtonCancel")};
                int userReply = JmriJOptionPane.showOptionDialog(this, Bundle.getMessage("DialogTextClearRouteWarning", routeNumber), Bundle.getMessage("WarningTitle"), 0, 3, null, dialogBoxButtonOptions, dialogBoxButtonOptions[1]);
                if (userReply != 0) {
                    this.resetRouteButton.setSelected(false);
                    return;
                }
                this.resetRouteOperation(routeNumber);
            }
            this.readAllButton.setEnabled(true);
            this.writeAllButton.setEnabled(true);
            this.factoryResetButton.setEnabled(true);
            this.resetRouteButton.setSelected(false);
        });
        this.appendLine(this.generalTabbedPane);
        JPanel statusPanel = new JPanel();
        this.setStatus(" ");
        statusPanel.add(new JSeparator());
        statusPanel.add(this.provideStatusLine());
        statusPanel.add(new JSeparator());
        this.appendLine(statusPanel);
        this.setTypeWord(115);
        this.opsw[7] = false;
        this.operationType = OpSwOpType.BasicsRead;
        this.routesTabbedPane.addChangeListener(new ChangeListener(){
            String route1TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(1));
            String route2TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(2));
            String route3TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(3));
            String route4TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(4));
            String route5TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(5));
            String route6TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(6));
            String route7TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(7));
            String route8TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(8));

            @Override
            public void stateChanged(ChangeEvent evt) {
                Ds64TabbedPanel.this.unhighlightAllBasicOpSws();
                Ds64TabbedPanel.this.unhighlightAllOutputEntryFields();
                Ds64TabbedPanel.this.unhighlightAllRouteEntryFields();
                String activeTabTitle = Ds64TabbedPanel.this.routesTabbedPane.getTitleAt(Ds64TabbedPanel.this.routesTabbedPane.getSelectedIndex());
                if (activeTabTitle.equals(this.route1TabText) || activeTabTitle.equals(this.route2TabText) || activeTabTitle.equals(this.route3TabText) || activeTabTitle.equals(this.route4TabText) || activeTabTitle.equals(this.route5TabText) || activeTabTitle.equals(this.route6TabText) || activeTabTitle.equals(this.route7TabText) || activeTabTitle.equals(this.route8TabText)) {
                    Ds64TabbedPanel.this.resetRouteButton.setVisible(true);
                    Ds64TabbedPanel.this.resetRouteButton.setEnabled(true);
                    Ds64TabbedPanel.this.resetRouteButton.updateUI();
                    Ds64TabbedPanel.this.readAllButton.setSelected(false);
                    Ds64TabbedPanel.this.readAllButton.updateUI();
                    Ds64TabbedPanel.this.updateUI();
                }
            }
        });
        this.generalTabbedPane.addChangeListener(new ChangeListener(){
            String route1TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(1));
            String route2TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(2));
            String route3TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(3));
            String route4TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(4));
            String route5TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(5));
            String route6TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(6));
            String route7TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(7));
            String route8TabText = Bundle.getMessage("TabTextSpecificRoute", Integer.toString(8));
            String outputsTabText = Bundle.getMessage("TabTextOutputAddrs");

            @Override
            public void stateChanged(ChangeEvent evt) {
                Ds64TabbedPanel.this.unhighlightAllBasicOpSws();
                Ds64TabbedPanel.this.unhighlightAllOutputEntryFields();
                Ds64TabbedPanel.this.unhighlightAllRouteEntryFields();
                String activeTabTitle = Ds64TabbedPanel.this.generalTabbedPane.getTitleAt(Ds64TabbedPanel.this.generalTabbedPane.getSelectedIndex());
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                if (activeTabTitle.equals(Bundle.getMessage("TabTextRoutes"))) {
                    activeTabTitle = Ds64TabbedPanel.this.routesTabbedPane.getTitleAt(Ds64TabbedPanel.this.routesTabbedPane.getSelectedIndex());
                    if (activeTabTitle.equals(this.route1TabText) || activeTabTitle.equals(this.route2TabText) || activeTabTitle.equals(this.route3TabText) || activeTabTitle.equals(this.route4TabText) || activeTabTitle.equals(this.route5TabText) || activeTabTitle.equals(this.route6TabText) || activeTabTitle.equals(this.route7TabText) || activeTabTitle.equals(this.route8TabText)) {
                        Ds64TabbedPanel.this.resetRouteButton.setEnabled(true);
                        Ds64TabbedPanel.this.resetRouteButton.setVisible(true);
                        Ds64TabbedPanel.this.readAllButton.setEnabled(true);
                        Ds64TabbedPanel.this.writeAllButton.setSelected(false);
                        Ds64TabbedPanel.this.readAllButton.setSelected(false);
                        Ds64TabbedPanel.this.writeAllButton.setEnabled(true);
                        Ds64TabbedPanel.this.factoryResetButton.setEnabled(true);
                        Ds64TabbedPanel.this.routesTabbedPane.updateUI();
                        Ds64TabbedPanel.this.updateUI();
                    } else {
                        Ds64TabbedPanel.this.routesTabbedPane.setSelectedIndex(0);
                        Ds64TabbedPanel.this.routesTabbedPane.updateUI();
                    }
                } else if (activeTabTitle.equals(this.outputsTabText)) {
                    Ds64TabbedPanel.this.resetRouteButton.setEnabled(false);
                    Ds64TabbedPanel.this.resetRouteButton.setVisible(false);
                    Ds64TabbedPanel.this.readAllButton.setEnabled(true);
                    Ds64TabbedPanel.this.writeAllButton.setSelected(false);
                    Ds64TabbedPanel.this.readAllButton.setSelected(false);
                    Ds64TabbedPanel.this.writeAllButton.setEnabled(true);
                    Ds64TabbedPanel.this.readAllButton.updateUI();
                    Ds64TabbedPanel.this.updateUI();
                } else {
                    Ds64TabbedPanel.this.readAllButton.setEnabled(true);
                    Ds64TabbedPanel.this.writeAllButton.setEnabled(true);
                    Ds64TabbedPanel.this.writeAllButton.setSelected(false);
                    Ds64TabbedPanel.this.readAllButton.setSelected(false);
                    Ds64TabbedPanel.this.resetRouteButton.setVisible(false);
                    Ds64TabbedPanel.this.resetRouteButton.setEnabled(false);
                    Ds64TabbedPanel.this.readAllButton.updateUI();
                    Ds64TabbedPanel.this.updateUI();
                }
                Container c = pane.getRootPane().getParent();
                c.setPreferredSize(null);
                if (c instanceof Window) {
                    ((Window)c).pack();
                }
            }
        });
        this.responseTimer.addActionListener(this.routeResetResponseTimerListener);
        this.commandType.setToolTipText(Bundle.getMessage("ToolTipLabelAcceptedSwitchCommandTypes"));
        this.updateBasicOpSwTab();
        this.panelToScroll();
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Cannot catch an exception without grabbing the exception, but we don't do anything with the exception details.")
    private void updateGuiFromOpSws49_64() {
        boolean isUsed = true;
        Integer readValue = 0;
        for (int i = 60; i >= 49; --i) {
            if (i == 56) continue;
            readValue = (readValue << 1) + (this.opsw[i] ? 1 : 0);
        }
        Integer i = readValue;
        Integer n = readValue = Integer.valueOf(readValue + 1);
        String readValueString = readValue.toString();
        if (this.opsw[63] && this.opsw[64]) {
            readValueString = "";
            isUsed = false;
        }
        boolean direction = this.opsw[62];
        switch (this.indexToRead) {
            case 0: {
                this.outAddr2.setText(Integer.toString(readValue));
                this.outAddr2.setLastQueriedValue(this.outAddr2.getText());
                this.outState2.setText(direction ? Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateClosed")) : Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateThrown")));
                break;
            }
            case 1: {
                this.outAddr4.setText(Integer.toString(readValue));
                this.outAddr4.setLastQueriedValue(this.outAddr4.getText());
                this.outState4.setText(direction ? Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateClosed")) : Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateThrown")));
                break;
            }
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: {
                Integer effectiveIndex = (this.indexToRead - 12) / 4;
                if (!isUsed) {
                    this.routeA2[effectiveIndex].setIsUnused();
                    this.routeA2[effectiveIndex.intValue()].addressField.setText("");
                    this.routeA2[effectiveIndex.intValue()].unusedRadioButton.setSelected(true);
                    break;
                }
                this.routeA2[effectiveIndex].setAddress(readValue);
                this.routeA2[effectiveIndex.intValue()].addressField.setText(readValueString);
                this.routeA2[effectiveIndex.intValue()].addressField.setLastQueriedValue(readValueString);
                if (this.opsw[62]) {
                    this.routeA2[effectiveIndex.intValue()].closedRadioButton.setSelected(true);
                    break;
                }
                this.routeA2[effectiveIndex.intValue()].thrownRadioButton.setSelected(true);
                break;
            }
            case 17: 
            case 21: 
            case 25: 
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 45: {
                Integer effectiveIndex = (this.indexToRead - 13) / 4;
                if (!isUsed) {
                    this.routeA4[effectiveIndex].setIsUnused();
                    this.routeA4[effectiveIndex.intValue()].addressField.setText("");
                    this.routeA4[effectiveIndex.intValue()].unusedRadioButton.setSelected(true);
                    break;
                }
                this.routeA4[effectiveIndex].setAddress(readValue);
                this.routeA4[effectiveIndex.intValue()].addressField.setText(readValueString);
                this.routeA4[effectiveIndex.intValue()].addressField.setLastQueriedValue(readValueString);
                if (this.opsw[62]) {
                    this.routeA4[effectiveIndex.intValue()].closedRadioButton.setSelected(true);
                    break;
                }
                this.routeA4[effectiveIndex.intValue()].thrownRadioButton.setSelected(true);
                break;
            }
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 42: 
            case 46: {
                Integer effectiveIndex = (this.indexToRead - 14) / 4;
                if (!isUsed) {
                    this.routeA6[effectiveIndex].setIsUnused();
                    this.routeA6[effectiveIndex.intValue()].addressField.setText("");
                    this.routeA6[effectiveIndex.intValue()].unusedRadioButton.setSelected(true);
                    break;
                }
                this.routeA6[effectiveIndex].setAddress(readValue);
                this.routeA6[effectiveIndex.intValue()].addressField.setText(readValueString);
                this.routeA6[effectiveIndex.intValue()].addressField.setLastQueriedValue(readValueString);
                if (this.opsw[62]) {
                    this.routeA6[effectiveIndex.intValue()].closedRadioButton.setSelected(true);
                    break;
                }
                this.routeA6[effectiveIndex.intValue()].thrownRadioButton.setSelected(true);
                break;
            }
            case 19: 
            case 23: 
            case 27: 
            case 31: 
            case 35: 
            case 39: 
            case 43: 
            case 47: {
                Integer effectiveIndex = (this.indexToRead - 15) / 4;
                if (!isUsed) {
                    this.routeA8[effectiveIndex].setIsUnused();
                    this.routeA8[effectiveIndex.intValue()].addressField.setText("");
                    this.routeA8[effectiveIndex.intValue()].unusedRadioButton.setSelected(true);
                    break;
                }
                this.routeA8[effectiveIndex].setAddress(readValue);
                this.routeA8[effectiveIndex.intValue()].addressField.setText(readValueString);
                this.routeA8[effectiveIndex.intValue()].addressField.setLastQueriedValue(readValueString);
                if (this.opsw[62]) {
                    this.routeA8[effectiveIndex.intValue()].closedRadioButton.setSelected(true);
                    break;
                }
                this.routeA8[effectiveIndex.intValue()].thrownRadioButton.setSelected(true);
                break;
            }
        }
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Cannot catch an exception without grabbing the exception, but we don't do anything with the exception details.")
    void updateGuiFromOpSws33_48() {
        boolean isUsed = true;
        Integer readValue = 0;
        for (int i = 44; i >= 33; --i) {
            if (i == 40) continue;
            readValue = (readValue << 1) + (this.opsw[i] ? 1 : 0);
        }
        Integer i = readValue;
        Integer n = readValue = Integer.valueOf(readValue + 1);
        String readValueString = readValue.toString();
        if (this.opsw[47] && this.opsw[48]) {
            readValueString = "";
            isUsed = false;
        }
        boolean direction = this.opsw[46];
        switch (this.indexToRead) {
            case 0: {
                this.outAddr1.setText(readValueString);
                this.outAddr1.setLastQueriedValue(readValueString);
                this.outAddr1.isValid();
                this.outState1.setText(direction ? Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateClosed")) : Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateThrown")));
                break;
            }
            case 1: {
                this.outAddr3.setText(readValueString);
                this.outAddr3.setLastQueriedValue(readValueString);
                this.outState3.setText(direction ? Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateClosed")) : Bundle.getMessage("LabelTurnoutCurrentStateX", Bundle.getMessage("BeanStateThrown")));
                break;
            }
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: {
                Integer effectiveIndex = (this.indexToRead - 12) / 4;
                if (!isUsed) {
                    this.routeTop[effectiveIndex].setIsUnused();
                    this.routeTop[effectiveIndex.intValue()].addressField.setText("");
                    this.routeTop[effectiveIndex.intValue()].unusedRadioButton.setSelected(true);
                    break;
                }
                this.routeTop[effectiveIndex].setAddress(readValue);
                this.routeTop[effectiveIndex.intValue()].addressField.setText(readValueString);
                this.routeTop[effectiveIndex.intValue()].addressField.setLastQueriedValue(readValueString);
                if (this.opsw[46]) {
                    this.routeTop[effectiveIndex.intValue()].closedRadioButton.setSelected(true);
                    break;
                }
                this.routeTop[effectiveIndex.intValue()].thrownRadioButton.setSelected(true);
                break;
            }
            case 17: 
            case 21: 
            case 25: 
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 45: {
                Integer effectiveIndex = (this.indexToRead - 13) / 4;
                if (!isUsed) {
                    this.routeA3[effectiveIndex].setIsUnused();
                    this.routeA3[effectiveIndex.intValue()].addressField.setText("");
                    this.routeA3[effectiveIndex.intValue()].unusedRadioButton.setSelected(true);
                    break;
                }
                this.routeA3[effectiveIndex].setAddress(readValue);
                this.routeA3[effectiveIndex.intValue()].addressField.setText(readValueString);
                this.routeA3[effectiveIndex.intValue()].addressField.setLastQueriedValue(readValueString);
                if (this.opsw[46]) {
                    this.routeA3[effectiveIndex.intValue()].closedRadioButton.setSelected(true);
                    break;
                }
                this.routeA3[effectiveIndex.intValue()].thrownRadioButton.setSelected(true);
                break;
            }
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 42: 
            case 46: {
                Integer effectiveIndex = (this.indexToRead - 14) / 4;
                if (!isUsed) {
                    this.routeA5[effectiveIndex].setIsUnused();
                    this.routeA5[effectiveIndex.intValue()].addressField.setText("");
                    this.routeA5[effectiveIndex.intValue()].unusedRadioButton.setSelected(true);
                    break;
                }
                this.routeA5[effectiveIndex].setAddress(readValue);
                this.routeA5[effectiveIndex.intValue()].addressField.setText(readValueString);
                this.routeA5[effectiveIndex.intValue()].addressField.setLastQueriedValue(readValueString);
                if (this.opsw[46]) {
                    this.routeA5[effectiveIndex.intValue()].closedRadioButton.setSelected(true);
                    break;
                }
                this.routeA5[effectiveIndex.intValue()].thrownRadioButton.setSelected(true);
                break;
            }
            case 19: 
            case 23: 
            case 27: 
            case 31: 
            case 35: 
            case 39: 
            case 43: 
            case 47: {
                Integer effectiveIndex = (this.indexToRead - 15) / 4;
                if (!isUsed) {
                    this.routeA7[effectiveIndex].setIsUnused();
                    this.routeA7[effectiveIndex.intValue()].addressField.setText("");
                    this.routeA7[effectiveIndex.intValue()].unusedRadioButton.setSelected(true);
                    break;
                }
                this.routeA7[effectiveIndex].setAddress(readValue);
                this.routeA7[effectiveIndex.intValue()].addressField.setText(readValueString);
                this.routeA7[effectiveIndex.intValue()].addressField.setLastQueriedValue(readValueString);
                if (this.opsw[46]) {
                    this.routeA7[effectiveIndex.intValue()].closedRadioButton.setSelected(true);
                    break;
                }
                this.routeA7[effectiveIndex.intValue()].thrownRadioButton.setSelected(true);
                break;
            }
        }
    }

    private void updateBasicOpSwTab() {
        for (int i = 1; i <= 21; ++i) {
            if (i == 7) continue;
            this.opswThrown[i].setSelected(!this.opsw[i]);
            this.opswClosed[i].setSelected(this.opsw[i]);
        }
    }

    protected void copyOpswToBasic() {
        this.outputType.setSelectedIndex(this.opsw[1] ? 1 : 0);
        this.delayTime.setSelectedIndex((this.opsw[2] ? 1 : 0) + (this.opsw[3] ? 2 : 0) + (this.opsw[4] ? 4 : 0) + (this.opsw[5] ? 8 : 0));
        this.outputStates.setSelectedIndex(this.opsw[6] ? 1 : 0);
        this.isWritingResetOpSw = this.opsw[7];
        this.startupDelay.setSelectedIndex(this.opsw[8] ? 1 : 0);
        this.staticOutputShutoff.setSelectedIndex(this.opsw[9] ? 1 : 0);
        this.commandType.setSelectedIndex(this.opsw[10] ? 1 : 0);
        this.routesControl.setSelectedIndex((this.opsw[11] ? 1 : 0) + (this.opsw[16] ? 2 : 0));
        this.localControlOfOutputsStyle.setSelectedIndex((this.opsw[12] ? 1 : 0) + (this.opsw[15] ? 2 : 0));
        this.sensorMessageTrigger.setSelectedIndex(this.opsw[13] ? 1 : 0);
        this.commandSource.setSelectedIndex(this.opsw[14] ? 1 : 0);
        this.output1CrossbuckFlasherCheckBox.setSelected(this.opsw[17]);
        this.output2CrossbuckFlasherCheckBox.setSelected(this.opsw[18]);
        this.output3CrossbuckFlasherCheckBox.setSelected(this.opsw[19]);
        this.output4CrossbuckFlasherCheckBox.setSelected(this.opsw[20]);
        this.localSensorType.setSelectedIndex(this.opsw[21] ? 1 : 0);
    }

    private static class JRadioButtonWithInteger
    extends JRadioButton {
        public int index;

        JRadioButtonWithInteger(int i, String s) {
            super(s);
            this.index = i;
        }
    }

    private static enum OpSwOpType {
        OutputsRead,
        OutputsWrite,
        Route1Read,
        Route1Write,
        Route2Read,
        Route2Write,
        Route3Read,
        Route3Write,
        Route4Read,
        Route4Write,
        Route5Read,
        Route5Write,
        Route6Read,
        Route6Write,
        Route7Read,
        Route7Write,
        Route8Read,
        Route8Write,
        BasicsRead,
        BasicsWrite;

    }
}

