/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.ds64;

import java.awt.FlowLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jmri.jmrix.loconet.ds64.Bundle;
import jmri.jmrix.loconet.ds64.SimpleTurnout;
import jmri.util.swing.ValidatedTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTurnoutStateEntry
extends SimpleTurnout {
    private JPanel entryPanel = null;
    public ValidatedTextField addressField = null;
    public JRadioButton thrownRadioButton = new JRadioButton(Bundle.getMessage("TurnoutStateThrown"));
    public JRadioButton closedRadioButton = new JRadioButton(Bundle.getMessage("TurnoutStateClosed"));
    public JRadioButton unusedRadioButton;
    private static final Logger log = LoggerFactory.getLogger(SimpleTurnoutStateEntry.class);

    public SimpleTurnoutStateEntry() {
        this(1, true);
    }

    public SimpleTurnoutStateEntry(Integer address, boolean isClosed) {
        super(address, isClosed);
        this.unusedRadioButton = null;
        this.addressField = new ValidatedTextField(5, true, 1, 2048, Bundle.getMessage("ErrorTextAddressInvalid"));
        this.entryPanel = null;
        this.addressField.setText(Integer.toString(address));
        this.setAddressLastQueriedValue(address);
        if (isClosed) {
            this.thrownRadioButton.setSelected(false);
            this.closedRadioButton.setSelected(true);
        } else {
            this.thrownRadioButton.setSelected(true);
            this.closedRadioButton.setSelected(false);
        }
        this.thrownRadioButton.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SimpleTurnoutStateEntry.this.thrownRadioButton.isSelected()) {
                    SimpleTurnoutStateEntry.this.setIsClosed(false);
                }
            }
        });
        this.closedRadioButton.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SimpleTurnoutStateEntry.this.closedRadioButton.isSelected()) {
                    SimpleTurnoutStateEntry.this.setIsClosed(true);
                }
            }
        });
    }

    public SimpleTurnoutStateEntry(Integer address, boolean closed, boolean unused) {
        super(address, closed, unused);
        this.unusedRadioButton = new JRadioButton(Bundle.getMessage("RadioButtonTextUnused"));
        this.addressField = new ValidatedTextField(5, true, 1, 2048, Bundle.getMessage("ErrorTextAddressInvalid"));
        this.entryPanel = null;
        if (unused) {
            this.addressField.setText("");
        } else {
            this.addressField.setText(Integer.toString(address));
        }
        this.setAddressLastQueriedValue(address);
        if (closed) {
            this.thrownRadioButton.setSelected(false);
            this.unusedRadioButton.setSelected(false);
            this.closedRadioButton.setSelected(true);
        } else {
            this.thrownRadioButton.setSelected(true);
            this.unusedRadioButton.setSelected(false);
            this.closedRadioButton.setSelected(false);
        }
        this.thrownRadioButton.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SimpleTurnoutStateEntry.this.thrownRadioButton.isSelected()) {
                    SimpleTurnoutStateEntry.this.setIsClosed(false);
                }
            }
        });
        this.closedRadioButton.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SimpleTurnoutStateEntry.this.closedRadioButton.isSelected()) {
                    SimpleTurnoutStateEntry.this.setIsClosed(true);
                }
            }
        });
        this.unusedRadioButton.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SimpleTurnoutStateEntry.this.unusedRadioButton.isSelected()) {
                    SimpleTurnoutStateEntry.this.setIsUnused();
                    SimpleTurnoutStateEntry.this.addressField.setText("");
                }
            }
        });
    }

    public JPanel getEntryPanel() {
        return this.entryPanel;
    }

    public JPanel createEntryPanel(String label) {
        this.entryPanel = new JPanel();
        this.entryPanel.setLayout(new FlowLayout());
        this.entryPanel.add(new JLabel(label));
        this.entryPanel.add(this.addressField);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        ButtonGroup g = new ButtonGroup();
        if (this.addressField.getText().length() == 0) {
            this.closedRadioButton.setSelected(false);
            this.thrownRadioButton.setSelected(false);
            if (this.unusedRadioButton != null) {
                this.unusedRadioButton.setSelected(true);
            }
            this.addressField.setText("");
        } else if (Integer.parseInt(this.addressField.getText()) == 2048) {
            this.closedRadioButton.setSelected(false);
            this.thrownRadioButton.setSelected(false);
            if (this.unusedRadioButton != null) {
                this.unusedRadioButton.setSelected(true);
            }
            this.addressField.setText("");
        } else {
            if (this.unusedRadioButton != null) {
                this.unusedRadioButton.setSelected(false);
            }
            this.closedRadioButton.setSelected(this.getIsClosed());
            this.thrownRadioButton.setSelected(!this.getIsClosed());
        }
        g.add(this.thrownRadioButton);
        g.add(this.closedRadioButton);
        p2.add(this.thrownRadioButton);
        p2.add(this.closedRadioButton);
        if (this.unusedRadioButton != null) {
            g.add(this.unusedRadioButton);
            p2.add(this.unusedRadioButton);
        }
        this.entryPanel.add(p2);
        return this.entryPanel;
    }

    public ValidatedTextField getAddressField() {
        return this.addressField;
    }

    @Override
    public void setAddress(Integer addr) {
        log.debug("simpleturnoutstateentry - setaddress {}", (Object)addr);
        super.setAddress(addr);
        if (this.isValid()) {
            this.addressField.setText(String.valueOf(addr));
        } else {
            this.addressField.setText("");
        }
        this.addressField.updateUI();
    }

    public final void setAddressLastQueriedValue(Integer addr) {
        this.addressField.setLastQueriedValue(String.valueOf(addr));
    }

    @Override
    public void setIsClosed(boolean isclosed) {
        super.setIsClosed(isclosed);
        this.closedRadioButton.setSelected(this.getIsClosed());
        this.thrownRadioButton.setSelected(!this.getIsClosed());
        this.closedRadioButton.updateUI();
        this.thrownRadioButton.updateUI();
        if (this.unusedRadioButton != null) {
            this.unusedRadioButton.setSelected(false);
            this.unusedRadioButton.updateUI();
        }
    }
}

