/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.duplexgroup.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.CheckForNull;
import javax.swing.JComponent;
import javax.swing.Timer;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnIPLImplementation
extends JComponent
implements LocoNetListener {
    LnIPLImplementation thisone = this;
    private LocoNetSystemConnectionMemo memo;
    private Timer swingTmrIplQuery;
    private boolean waitingForIplReply;
    private static final Logger log = LoggerFactory.getLogger(LnIPLImplementation.class);

    public LnIPLImplementation(LocoNetSystemConnectionMemo lnMemo) {
        this.memo = lnMemo;
        this.moreInit();
    }

    private void moreInit() {
        this.waitingForIplReply = false;
        this.connect(this.memo.getLnTrafficController());
        this.swingTmrIplQuery = new Timer(1300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LnIPLImplementation.this.swingTmrIplQuery.stop();
                LnIPLImplementation.this.waitingForIplReply = false;
                int oldvalue = 9999;
                int newvalue = 0;
                LnIPLImplementation.this.thisone.firePropertyChange("LnIPLEndOfDeviceQuery", oldvalue, newvalue);
            }
        });
    }

    public static final LocoNetMessage createQueryAllIplDevicesPacket() {
        LocoNetMessage m = new LocoNetMessage(20);
        m.setElement(0, 229);
        m.setElement(1, 20);
        m.setElement(2, 15);
        m.setElement(3, 8);
        m.setElement(4, 0);
        m.setElement(5, 0);
        m.setElement(6, 0);
        m.setElement(7, 0);
        m.setElement(8, 0);
        m.setElement(9, 0);
        m.setElement(10, 0);
        m.setElement(11, 1);
        m.setElement(12, 0);
        m.setElement(13, 0);
        m.setElement(14, 0);
        m.setElement(15, 0);
        m.setElement(16, 0);
        m.setElement(17, 0);
        m.setElement(18, 0);
        return m;
    }

    public void sendIplQueryAllDevices() {
        LnTrafficController tc = this.memo.getLnTrafficController();
        tc.sendLocoNetMessage(LnIPLImplementation.createQueryAllIplDevicesPacket());
        this.waitingForIplReply = true;
    }

    public static final LocoNetMessage createIplSpecificHostQueryPacket(Integer hostMfr, Integer hostDevice) {
        LocoNetMessage m = LnIPLImplementation.createQueryAllIplDevicesPacket();
        m.setElement(4, (int)(hostMfr & 0x7F));
        m.setElement(5, (int)(hostDevice & 0x7F));
        return m;
    }

    public static final LocoNetMessage createIplSpecificSlaveQueryPacket(Integer slaveMfr, Integer slaveDevice) {
        LocoNetMessage m = LnIPLImplementation.createQueryAllIplDevicesPacket();
        m.setElement(7, (int)(slaveMfr & 0x7F));
        m.setElement(6, (int)(slaveDevice & 0x7F));
        return m;
    }

    public static final LocoNetMessage createIplSpecificSlaveQueryPacket(Integer hostMfr, Integer hostDevice, Integer slaveMfr, Integer slaveDevice) {
        LocoNetMessage m = LnIPLImplementation.createQueryAllIplDevicesPacket();
        m.setElement(4, (int)(hostMfr & 0x7F));
        m.setElement(5, (int)(hostDevice & 0x7F));
        m.setElement(7, (int)(slaveMfr & 0x7F));
        m.setElement(6, (int)(slaveDevice & 0x7F));
        return m;
    }

    public static final LocoNetMessage createIplUr92QueryPacket() {
        return LnIPLImplementation.createIplSpecificHostQueryPacket(0, 92);
    }

    public static final LocoNetMessage createIplDt402QueryPacket() {
        return LnIPLImplementation.createIplSpecificHostQueryPacket(0, 42);
    }

    public static final LocoNetMessage createIplUt4QueryPacket() {
        return LnIPLImplementation.createIplSpecificHostQueryPacket(0, 4);
    }

    public static final LocoNetMessage createIplDcs51QueryPacket() {
        return LnIPLImplementation.createIplSpecificHostQueryPacket(0, 51);
    }

    public static final LocoNetMessage createIplDcs52QueryPacket() {
        return LnIPLImplementation.createIplSpecificHostQueryPacket(0, 52);
    }

    public static final LocoNetMessage createIplPr3QueryPacket() {
        return LnIPLImplementation.createIplSpecificHostQueryPacket(0, 35);
    }

    public static final boolean isIplIdentityQueryMessage(LocoNetMessage m) {
        return m.getOpCode() == 229 && m.getElement(1) == 20 && m.getElement(2) == 15 && m.getElement(3) == 8;
    }

    public static final boolean isIplIdentityReportMessage(LocoNetMessage m) {
        return m.getOpCode() == 229 && m.getElement(1) == 20 && m.getElement(2) == 15 && m.getElement(3) == 16;
    }

    public static final boolean isIplSpecificIdentityReportMessage(LocoNetMessage m, Integer hostMfr, Integer hostDevice) {
        if (!LnIPLImplementation.isIplIdentityReportMessage(m)) {
            return false;
        }
        return m.getElement(4) == (hostMfr & 0x7F) && m.getElement(5) == (hostDevice & 0x7F);
    }

    public static final boolean isIplUr92IdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 92);
    }

    public static final boolean isIplDt402IdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 42);
    }

    public static final boolean isIplUt4IdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 4);
    }

    public static final boolean isIplDcs51IdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 51);
    }

    public static final boolean isIplDcs52IdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 52);
    }

    public static final boolean isIplUr93IdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 93);
    }

    public static final boolean isIplPr3IdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 35);
    }

    public static final boolean isIplDt402DIdentityReportMessage(LocoNetMessage m) {
        if (!LnIPLImplementation.isIplDt402IdentityReportMessage(m)) {
            return false;
        }
        return LnIPLImplementation.isIplRf24SlaveIdentityReportMessage(m);
    }

    public static final boolean isIplUt4DIdentityReportMessage(LocoNetMessage m) {
        if (!LnIPLImplementation.isIplUt4IdentityReportMessage(m)) {
            return false;
        }
        return LnIPLImplementation.isIplRf24SlaveIdentityReportMessage(m);
    }

    public static final boolean isIplPr4IdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 36);
    }

    public static final boolean isIplBxp88IdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 88);
    }

    public static final boolean isIplLnwiIdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 99);
    }

    public static final boolean isIplDcs240IdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 28);
    }

    public static final boolean isIplDcs210IdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 27);
    }

    public static final boolean isIplDcs210PlusIdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 26);
    }

    public static final boolean isIplDcs240PlusIdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 29);
    }

    public static final boolean isIplDt500DIdentityReportMessage(LocoNetMessage m) {
        if (!LnIPLImplementation.isIplDt500IdentityReportMessage(m)) {
            return false;
        }
        return LnIPLImplementation.isIplRf24SlaveIdentityReportMessage(m);
    }

    public static final boolean isIplDt500IdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.isIplSpecificIdentityReportMessage(m, 0, 50);
    }

    private static final boolean isIplRf24SlaveIdentityReportMessage(LocoNetMessage m) {
        return LnIPLImplementation.extractIplIdentitySlaveManufacturer(m) == 0 && LnIPLImplementation.extractIplIdentitySlaveDevice(m) == 24;
    }

    public static final String extractInterpretedIplHostDevice(LocoNetMessage m) {
        if (!LnIPLImplementation.isIplIdentityReportMessage(m)) {
            return null;
        }
        if (LnIPLImplementation.isIplDt402DIdentityReportMessage(m)) {
            return LnIPLImplementation.interpretHostManufacturerDevice(0, 42, 0, 24);
        }
        if (LnIPLImplementation.isIplUt4DIdentityReportMessage(m)) {
            return LnIPLImplementation.interpretHostManufacturerDevice(0, 4, 0, 24);
        }
        if (LnIPLImplementation.isIplDt500DIdentityReportMessage(m)) {
            return LnIPLImplementation.interpretHostManufacturerDevice(0, 50, 0, 24);
        }
        if (LnIPLImplementation.isIplUr92IdentityReportMessage(m)) {
            return LnIPLImplementation.interpretHostManufacturerDevice(0, 92, 0, 24);
        }
        return LnIPLImplementation.interpretHostManufacturerDevice(LnIPLImplementation.extractIplIdentityHostManufacturer(m), LnIPLImplementation.extractIplIdentityHostDevice(m));
    }

    public static final String extractInterpretedIplSlaveDevice(LocoNetMessage m) {
        if (!LnIPLImplementation.isIplIdentityReportMessage(m)) {
            return null;
        }
        return LnIPLImplementation.interpretSlaveManufacturerDevice(LnIPLImplementation.extractIplIdentitySlaveManufacturer(m), LnIPLImplementation.extractIplIdentitySlaveDevice(m));
    }

    public static final Integer extractIplIdentityHostManufacturer(LocoNetMessage m) {
        return m.getElement(4);
    }

    public static final Integer extractIplIdentityHostDevice(LocoNetMessage m) {
        return m.getElement(5);
    }

    public static final Integer extractIplIdentitySlaveManufacturer(LocoNetMessage m) {
        return m.getElement(7);
    }

    public static final Integer extractIplIdentitySlaveDevice(LocoNetMessage m) {
        return m.getElement(6);
    }

    public static final String extractIplIdentityHostFrimwareRev(LocoNetMessage m) {
        StringBuilder s = new StringBuilder();
        s.append(Integer.toString((m.getElement(8) & 0x78) >> 3));
        s.append(".");
        s.append(Integer.toString(m.getElement(8) & 7));
        return s.toString();
    }

    public static final Integer extractIplIdentityHostFrimwareRevNum(LocoNetMessage m) {
        return m.getElement(8);
    }

    public static final Integer extractIplIdentitySlaveFrimwareRevNum(LocoNetMessage m) {
        return (m.getElement(10) & 0x7F) + ((m.getElement(9) & 1) << 7);
    }

    public static final String extractIplIdentitySlaveFrimwareRev(LocoNetMessage m) {
        StringBuilder s = new StringBuilder();
        s.append(Integer.toString(((m.getElement(10) & 0x78) >> 3) + ((m.getElement(9) & 1) << 4)));
        s.append(".");
        s.append(Integer.toString(m.getElement(10) & 7));
        return s.toString();
    }

    public static final Long extractIplIdentityHostSerialNumber(LocoNetMessage m) {
        Integer di_f1 = m.getElement(9);
        Long sn = m.getElement(11) + ((di_f1 & 2) << 6);
        sn = sn + (((long)m.getElement(12) << 8) + (((long)di_f1.intValue() & 4L) << 13));
        sn = sn + (((long)m.getElement(13) << 16) + (((long)di_f1.intValue() & 8L) << 20));
        return sn;
    }

    public static final Long extractIplIdentitySlaveSerialNumber(LocoNetMessage m) {
        Integer di_f2 = m.getElement(14);
        Long sn = m.getElement(15) + ((di_f2 & 1) << 7);
        sn = sn + (((long)m.getElement(16) << 8) + (((long)di_f2.intValue() & 2L) << 14));
        sn = sn + (((long)m.getElement(17) << 16) + (((long)di_f2.intValue() & 4L) << 21));
        sn = sn + (((long)m.getElement(18) << 24) + (((long)di_f2.intValue() & 8L) << 28));
        return sn;
    }

    public static final String interpretHostManufacturerDevice(Integer hostMfr, Integer hostDevice, Integer slaveMfr, Integer slaveDevice) {
        int manuf = hostMfr & 0x7F;
        int device = hostDevice & 0x7F;
        int slave = slaveDevice & 0x7F;
        int smanuf = slaveMfr & 0x7F;
        String mfgName = LnIPLImplementation.getManufacturer(manuf);
        String devName = LnIPLImplementation.getDeviceName(manuf, device, smanuf, slave);
        if (mfgName == null) {
            log.debug("Unknown Unknown Host Manufacturer/Device [{}]", (Object)Integer.toHexString(manuf));
            return "Unknown Host Manufacturer/Device";
        }
        if (devName == null) {
            log.debug("Unknown Device Manufacturer[{}] Device[{}] Slave manufacturer[{}] Slave device[{}]", new Object[]{Integer.toHexString(manuf), Integer.toHexString(device), Integer.toHexString(smanuf), Integer.toHexString(slave)});
            return mfgName + " Unknown Device";
        }
        return mfgName + " " + devName;
    }

    public static final String interpretHostManufacturerDevice(Integer hostMfr, Integer hostDevice) {
        return LnIPLImplementation.interpretHostManufacturerDevice(hostMfr, hostDevice, 0, 0);
    }

    public static final String interpretSlaveManufacturerDevice(Integer slaveMfr, Integer slaveDevice) {
        String s = "Unknown Slave Manufacturer/Device";
        int sMfr = slaveMfr & 0x7F;
        int sDevice = slaveDevice & 0x7F;
        block0 : switch (sMfr) {
            case 0: {
                switch (sDevice) {
                    case 24: {
                        s = "Digitrax RF24";
                        break block0;
                    }
                }
                s = "Digitrax (unknown Slave Device)";
                break;
            }
            case 87: {
                s = "RR-CirKits (unknown Slave Device)";
                break;
            }
        }
        return s;
    }

    public void connect(LnTrafficController t) {
        if (t != null) {
            t.addLocoNetListener(-1, this);
        }
    }

    public void dispose() {
        if (this.swingTmrIplQuery != null) {
            this.swingTmrIplQuery.stop();
        }
        if (this.memo.getLnTrafficController() != null) {
            this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
        }
    }

    @Override
    public void message(LocoNetMessage m) {
        if (this.handleMessageIplDeviceQuery(m)) {
            return;
        }
        if (this.handleMessageIplDeviceReport(m)) {
            return;
        }
    }

    private boolean handleMessageIplDeviceQuery(LocoNetMessage m) {
        if (LnIPLImplementation.isIplIdentityQueryMessage(m)) {
            Integer deviceType = 256 * LnIPLImplementation.extractIplIdentityHostManufacturer(m) + LnIPLImplementation.extractIplIdentityHostDevice(m);
            int oldvalue = 99999;
            int newvalue = deviceType;
            this.thisone.firePropertyChange("IplDeviceTypeQuery", oldvalue, newvalue);
            if (this.waitingForIplReply) {
                this.swingTmrIplQuery.restart();
            }
            return true;
        }
        return false;
    }

    private boolean handleMessageIplDeviceReport(LocoNetMessage m) {
        if (LnIPLImplementation.isIplIdentityReportMessage(m)) {
            Integer deviceType = 256 * LnIPLImplementation.extractIplIdentityHostManufacturer(m) + LnIPLImplementation.extractIplIdentityHostDevice(m);
            int oldvalue = 99999;
            int newvalue = deviceType;
            this.thisone.firePropertyChange("IplDeviceTypeReport", oldvalue, newvalue);
            if (this.waitingForIplReply) {
                this.waitingForIplReply = false;
                this.swingTmrIplQuery.stop();
            }
            return true;
        }
        return false;
    }

    public boolean isIplQueryTimerRunning() {
        return this.swingTmrIplQuery.isRunning();
    }

    public static boolean isValidMfgDevice(int mfg, int deviceType) {
        return LnIPLImplementation.interpretHostManufacturerDevice(mfg, deviceType).compareTo("Unknown Host Manufacturer/Device") != 0;
    }

    @CheckForNull
    public static String getManufacturer(int manuf) {
        switch (manuf) {
            case 0: {
                return "Digitrax";
            }
            case 87: {
                return "RR-CirKits";
            }
        }
        return null;
    }

    @CheckForNull
    public static String getDeviceName(int manuf, int device, int slaveManuf, int slave) {
        if (LnIPLImplementation.getManufacturer(manuf) == null) {
            return null;
        }
        for (DeviceTypes t : DeviceTypes.values()) {
            if (manuf != t.getManufacturer() || device != t.getDeviceIdNumber() || slaveManuf != t.getSlaveManufacturer() || slave != t.getSlaveDeviceIdNumber()) continue;
            return t.getDeviceName();
        }
        return null;
    }

    public static enum DeviceTypes {
        UT4D(0, 4, 0, 24, "Digitrax", "UT4D"),
        UT4X(0, 4, 0, 0, "Digitrax", "UT4(x)"),
        DCS51(0, 51, 0, 0, "Digitrax", "DCS51"),
        DCS52(0, 52, 0, 0, "Digitrax", "DCS52"),
        DT402D(0, 42, 0, 24, "Digitrax", "DT402D"),
        DT402X(0, 42, 0, 0, "Digitrax", "DT402(x)"),
        PR3(0, 35, 0, 0, "Digitrax", "PR3"),
        UR92(0, 92, 0, 24, "Digitrax", "UR92"),
        DB210OPTO(0, 20, 0, 0, "Digitrax", "DB210Opto"),
        DB210(0, 21, 0, 0, "Digitrax", "DB210"),
        DB220(0, 22, 0, 0, "Digitrax", "DB220"),
        PR4(0, 36, 0, 0, "Digitrax", "PR4"),
        BXP88(0, 88, 0, 0, "Digitrax", "BXP88"),
        LNWI(0, 99, 0, 0, "Digitrax", "LNWI"),
        DCS210(0, 27, 0, 0, "Digitrax", "DCS210"),
        DCS240(0, 28, 0, 0, "Digitrax", "DCS240"),
        DT500D(0, 50, 0, 24, "Digitrax", "DT500D"),
        DT500X(0, 50, 0, 0, "Digitrax", "DT500(x)"),
        DT602X(0, 62, 0, 0, "Digitrax", "DT602(x)"),
        BXPA1(0, 81, 0, 0, "Digitrax", "BXPA1"),
        DCS210plus(0, 26, 0, 0, "Digitrax", "DCS210+"),
        DCS240plus(0, 29, 0, 0, "Digitrax", "DCS240+"),
        RR_CKTS_TC64(87, 11, 0, 0, "RR-CirKits", "TC-64"),
        RR_CKTS_TC_MKII(87, 24, 0, 0, "RR-CirKits", "TC-64 Mk-II"),
        RR_CKTS_LNCP(87, 12, 0, 0, "RR-CirKits", "LNCP"),
        RR_CKTS_MOTORMan(87, 25, 0, 0, "RR-CirKits", "MotorMan"),
        RR_CKTS_MOTORMANII(87, 28, 0, 0, "RR-CirKits", "MotorMan-II"),
        RR_CKTS_SIGNALMAN(87, 21, 0, 0, "RR-CirKits", "SignalMan"),
        RR_CKTS_TOWERMAN(87, 22, 0, 0, "RR-CirKits", "TowerMan"),
        RR_CKTS_WATCHMAN(87, 23, 0, 0, "RR-CirKits", "WatchMan");

        private int manufacturer;
        private int deviceIdNumber;
        private int slaveManufacturer;
        private int slaveDeviceIdNumber;
        private String manufacturerName;
        private String deviceName;

        private DeviceTypes(int mfg, int devId, int slaveMfg, int slaveDevId, String mfgName, String devName) {
            this.manufacturer = mfg & 0x7F;
            this.deviceIdNumber = devId & 0x7F;
            this.slaveManufacturer = slaveMfg & 0x7F;
            this.slaveDeviceIdNumber = slaveDevId & 0x7F;
            this.manufacturerName = mfgName;
            this.deviceName = devName;
        }

        public final int getManufacturer() {
            return this.manufacturer;
        }

        public final int getDeviceIdNumber() {
            return this.deviceIdNumber;
        }

        public final int getSlaveManufacturer() {
            return this.slaveManufacturer;
        }

        public final int getSlaveDeviceIdNumber() {
            return this.slaveDeviceIdNumber;
        }

        public final boolean isDeviceMatch(int mfg, int devId, int slaveMfg, int slaveDevId) {
            return mfg == this.manufacturer && devId == this.deviceIdNumber && slaveMfg == this.slaveManufacturer && slaveDevId == this.slaveDeviceIdNumber;
        }

        public final boolean isDeviceMatch(int mfg, int devId) {
            return this.isDeviceMatch(mfg, devId, 0, 0);
        }

        public final String getManufacturerName() {
            return this.manufacturerName;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }
    }
}

