/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.hexfile;

import jmri.AddressedProgrammerManager;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.ThrottleListener;
import jmri.jmrix.debugthrottle.DebugThrottleManager;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.hexfile.LnHexFilePort;
import jmri.progdebugger.DebugProgrammerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexFileServer {
    private int connectedAddresses = 0;
    boolean connected = false;
    LnPacketizer packets = null;
    private Thread sourceThread;
    private LnHexFilePort port = null;
    private static final Logger log = LoggerFactory.getLogger(HexFileServer.class);

    public void dispose() {
    }

    public void configure() {
        if (this.port == null) {
            log.error("initComponents called before adapter has been set");
            return;
        }
        this.packets = new LnPacketizer(this.port.getSystemConnectionMemo());
        this.packets.connectPort(this.port);
        this.connected = true;
        this.port.getSystemConnectionMemo().setLnTrafficController(this.packets);
        this.port.getSystemConnectionMemo().configureCommandStation(LnCommandStationType.COMMAND_STATION_DCS100, false, false, false, false, false);
        this.port.getSystemConnectionMemo().configureManagers();
        this.port.getSystemConnectionMemo().setProgrammerManager(new DebugProgrammerManager(this.port.getSystemConnectionMemo()));
        if (this.port.getSystemConnectionMemo().getProgrammerManager().isAddressedModePossible()) {
            InstanceManager.store(this.port.getSystemConnectionMemo().getProgrammerManager(), AddressedProgrammerManager.class);
        }
        if (this.port.getSystemConnectionMemo().getProgrammerManager().isGlobalProgrammerAvailable()) {
            InstanceManager.store(this.port.getSystemConnectionMemo().getProgrammerManager(), GlobalProgrammerManager.class);
        }
        DebugThrottleManager tm = new DebugThrottleManager(this.port.getSystemConnectionMemo()){

            @Override
            public boolean canBeLongAddress(int address) {
                return address >= 128;
            }

            @Override
            public void requestThrottleSetup(LocoAddress a, boolean control) {
                if (!(a instanceof DccLocoAddress)) {
                    log.error("{} is not a DccLocoAddress", (Object)a);
                    this.failedThrottleRequest(a, "LocoAddress " + a + " is not a DccLocoAddress");
                    return;
                }
                DccLocoAddress address = (DccLocoAddress)a;
                if (HexFileServer.this.connectedAddresses >= 5) {
                    log.warn("SLOT MAX of 5 reached, Current={}", (Object)HexFileServer.this.connectedAddresses);
                    this.failedThrottleRequest(address, "SLOT MAX of 5 reached");
                    return;
                }
                super.requestThrottleSetup(a, control);
                ++HexFileServer.this.connectedAddresses;
            }

            @Override
            public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
                if (super.disposeThrottle(t, l)) {
                    --HexFileServer.this.connectedAddresses;
                    return true;
                }
                return false;
            }
        };
        this.port.getSystemConnectionMemo().setThrottleManager(tm);
        InstanceManager.setThrottleManager(this.port.getSystemConnectionMemo().getThrottleManager());
        this.packets.startThreads();
        this.sourceThread = new Thread((Runnable)this.port, "LocoNet HexFileServer");
        this.sourceThread.start();
    }

    public void setAdapter(LnHexFilePort adapter) {
        this.port = adapter;
    }

    public LnHexFilePort getAdapter() {
        return this.port;
    }
}

