/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.lnsvf1;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import jmri.jmrix.loconet.lnsvf1.Lnsv1Device;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lnsv1Devices {
    @GuardedBy(value="this")
    private final List<Lnsv1Device> deviceList = new ArrayList<Lnsv1Device>();
    private static final Logger log = LoggerFactory.getLogger(Lnsv1Devices.class);

    public synchronized boolean addDevice(Lnsv1Device d) {
        if (!this.deviceExists(d)) {
            this.deviceList.add(d);
            log.debug("added device with addr {}", (Object)d.getDestAddr());
            return true;
        }
        log.debug("device already in list: addr {} ", (Object)d.getDestAddr());
        return false;
    }

    public synchronized void removeAllDevices() {
        this.deviceList.clear();
    }

    public synchronized int isDeviceExistant(Lnsv1Device deviceToBeFound) {
        log.debug("Looking for a known LNSV1 device which matches characteristics: address {}.", (Object)deviceToBeFound.getDestAddr());
        for (int i = 0; i < this.deviceList.size(); ++i) {
            Lnsv1Device dev = this.deviceList.get(i);
            log.debug("Comparing against known device: addr {}.", (Object)deviceToBeFound.getDestAddr());
            if (deviceToBeFound.getDestAddr() != -1 && dev.getDestAddr() != deviceToBeFound.getDestAddr()) continue;
            log.debug("Match Found! Searched device matched against known device: addr {}.", (Object)dev.getDestAddr());
            return i;
        }
        log.debug("No matching known device was found!");
        return -1;
    }

    public boolean deviceExists(Lnsv1Device d) {
        int i = this.isDeviceExistant(d);
        log.debug("deviceExists found {}", (Object)i);
        return i >= 0;
    }

    public synchronized Lnsv1Device getDevice(int index) {
        return this.deviceList.get(index);
    }

    public synchronized Lnsv1Device[] getDevices() {
        Lnsv1Device[] d = new Lnsv1Device[]{};
        return this.deviceList.toArray(d);
    }

    public synchronized int size() {
        return this.deviceList.size();
    }
}

