/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.lnsvf1;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.lnsvf1.Bundle;
import jmri.jmrix.loconet.messageinterp.LocoNetMessageInterpret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lnsv1MessageContents {
    public static final int LNSV1_BROADCAST_ADDRESS = 0;
    public static final int LNSV1_LOCOBUFFER_ADDRESS = 80;
    public static final int LNSV1_PEER_CODE_SV_VER0 = 0;
    public static final int LNSV1_PEER_CODE_SV_VER1 = 8;
    private final int src_l;
    private final int sv_cmd;
    private final int dst_l;
    private final int dst_h;
    private final int sub_adr;
    private final int sv_num;
    private final int vrs;
    private final int d4;
    private final int d6;
    private final int d7;
    private final int d8;
    public static final int SV1_SV_SRC_L_ELEMENT_INDEX = 2;
    public static final int SV1_SV_DST_L_ELEMENT_INDEX = 3;
    public static final int SV1_SV_DST_H_ELEMENT_INDEX = 4;
    public static final int SV1_SVX1_ELEMENT_INDEX = 5;
    public static final int SV1_SV_CMD_ELEMENT_INDEX = 6;
    public static final int SV1_SVX2_ELEMENT_INDEX = 10;
    public static final int SV1_SVX1_ELEMENT_VALIDITY_CHECK_MASK = 112;
    public static final int SV1_SVX1_ELEMENT_VALIDITY_CHECK_VALUE = 0;
    public static final int SV1_SVX2_ELEMENT_VALIDITY_CHECK_MASK = 112;
    public static final int SV0_SVX2_ELEMENT_VALIDITY_CHECK_VALUE = 16;
    public static final int SV1_SVX2_ELEMENT_VALIDITY_CHECK_VALUE = 0;
    public static final int SV_CMD_WRITE_ONE = 1;
    public static final int SV_CMD_READ_ONE = 2;
    private static final String HEX_FORMAT = "0x%02X";
    private static final Logger log = LoggerFactory.getLogger(Lnsv1MessageContents.class);

    public Lnsv1MessageContents(LocoNetMessage m) throws IllegalArgumentException {
        log.debug("interpreting a LocoNet message - may be an SV1 message");
        if (!Lnsv1MessageContents.isSupportedSv1Message(m)) {
            log.debug("interpreting a LocoNet message - is NOT an SV1 message");
            throw new IllegalArgumentException("LocoNet message is not an SV1 message");
        }
        this.src_l = m.getElement(2);
        this.dst_l = m.getElement(3);
        this.dst_h = m.getElement(4);
        int[] d = m.getPeerXfrData();
        this.sv_cmd = d[0];
        this.sv_num = d[1];
        this.vrs = d[2];
        this.d4 = d[3];
        this.sub_adr = d[4];
        this.d6 = d[5];
        this.d7 = d[6];
        this.d8 = d[7];
    }

    public static boolean isSupportedSv1Message(LocoNetMessage m) {
        if (m.getOpCode() != 229) {
            log.debug("cannot be SV1 message because not OPC_PEER_XFER");
            return false;
        }
        if (m.getElement(1) != 16) {
            log.debug("cannot be SV1 message because elem. 1 not 0x10");
            return false;
        }
        if (m.getElement(4) != 1) {
            log.debug("cannot be SV1 message because elem. 4 not 0x01");
            return false;
        }
        if ((m.getElement(5) & 0x70) != 0) {
            log.debug("cannot be SV1 message because SVX1 upper nibble wrong");
            return false;
        }
        if ((m.getElement(10) & 0x70) != 16 && (m.getElement(10) & 0x70) != 0) {
            log.debug("cannot be SV1 message because SVX2 upper nibble wrong: {}", (Object)(m.getElement(10) & 0x70));
            return false;
        }
        if (Lnsv1MessageContents.isSupportedSv1Command(m.getElement(6))) {
            log.debug("LocoNet message is a supported SV Format 1 message");
            return true;
        }
        log.debug("LocoNet message is not a supported SV Format 1 message");
        return false;
    }

    public static boolean isLnMessageASpecificSv1Command(LocoNetMessage m, Sv1Command svCmd) {
        if (m.getOpCode() != 229) {
            log.debug("cannot be SV1 message because not OPC_PEER_XFER");
            return false;
        }
        if (m.getElement(1) != 16) {
            log.debug("cannot be SV1 message because not length 0x10");
            return false;
        }
        if ((m.getElement(5) & 0x70) != 0) {
            log.debug("cannot be SV1 message because SVX1 upper nibble wrong");
            return false;
        }
        if ((m.getElement(10) & 0x70) != 16 && (m.getElement(10) & 0x70) != 0) {
            log.debug("cannot be SV1 message because SVX2 upper nibble wrong {}", (Object)(m.getElement(10) & 0x70));
            return false;
        }
        if (Lnsv1MessageContents.isSupportedSv1Command(m.getElement(6))) {
            log.debug("LocoNet message is a supported SV Format 1 message");
            if (Objects.equals((Object)Lnsv1MessageContents.extractMessageType(m), (Object)svCmd)) {
                log.debug("LocoNet message is the specified SV Format 1 message");
                return true;
            }
        }
        log.debug("LocoNet message is not a supported SV Format 1 message");
        return false;
    }

    public static Sv1Command extractMessageType(LocoNetMessage m) {
        if (Lnsv1MessageContents.isSupportedSv1Message(m)) {
            int msgCmd = m.getPeerXfrData()[0];
            for (Sv1Command s : Sv1Command.values()) {
                if (s.getCmd() != msgCmd) continue;
                log.debug("LocoNet message has SV1 message command {}", (Object)msgCmd);
                return s;
            }
        }
        return null;
    }

    public static int extractMessageVersion(LocoNetMessage m) {
        if (Lnsv1MessageContents.isSupportedSv1Message(m)) {
            int v = m.getPeerXfrData()[2];
            log.debug("LocoNet LNSV1 message contains version {}", (Object)v);
            return v > 0 ? v : -1;
        }
        return -1;
    }

    public String toString() {
        Locale l = Locale.getDefault();
        return this.toString(l);
    }

    public String toString(Locale locale) {
        String returnString;
        log.debug("interpreting an SV1 message - sv_cmd is {}", (Object)this.sv_cmd);
        switch (this.sv_cmd) {
            case 1: {
                if (this.src_l == 80) {
                    if (this.dst_l == 0) {
                        returnString = Bundle.getMessage(locale, "SV1_WRITE_ALL_INTERPRETED", this.sv_num == 1 ? "" : "sub", Lnsv1MessageContents.toHexStr(this.sv_num), Lnsv1MessageContents.toHexStr(this.d4));
                        break;
                    }
                    if (this.dst_l == 80) {
                        returnString = Bundle.getMessage(locale, "SV1_WRITE_LB_INTERPRETED", Lnsv1MessageContents.toHexStr(this.sv_num), Lnsv1MessageContents.toHexStr(this.d4), this.vrs > 0 ? " Firmware rev " + LocoNetMessageInterpret.dotme(this.vrs) : "");
                        break;
                    }
                    returnString = Bundle.getMessage(locale, "SV1_WRITE_INTERPRETED", Lnsv1MessageContents.toHexComposite(this.dst_l, this.sub_adr), Lnsv1MessageContents.toHexStr(this.sv_num), Lnsv1MessageContents.toHexStr(this.d4), this.vrs > 0 ? " Firmware rev " + LocoNetMessageInterpret.dotme(this.vrs) : "");
                    break;
                }
                returnString = Bundle.getMessage(locale, "SV1_WRITE_REPLY_INTERPRETED", Lnsv1MessageContents.toHexComposite(this.src_l, this.sub_adr), Lnsv1MessageContents.toHexStr(this.sv_num), Lnsv1MessageContents.toHexStr(this.d8), this.vrs > 0 ? " Firmware rev " + LocoNetMessageInterpret.dotme(this.vrs) : "");
                break;
            }
            case 2: {
                if (this.src_l == 80) {
                    if (this.dst_l == 0) {
                        returnString = Bundle.getMessage(locale, "SV1_PROBE_ALL_INTERPRETED", new Object[0]);
                        break;
                    }
                    if (this.dst_l == 80) {
                        returnString = Bundle.getMessage(locale, "SV1_READ_LB_INTERPRETED", Lnsv1MessageContents.toHexStr(this.sv_num), this.vrs > 0 ? " Firmware rev " + LocoNetMessageInterpret.dotme(this.vrs) : "");
                        break;
                    }
                    returnString = Bundle.getMessage(locale, "SV1_READ_INTERPRETED", Lnsv1MessageContents.toHexComposite(this.dst_l, this.sub_adr), Lnsv1MessageContents.toHexStr(this.sv_num), this.vrs > 0 ? " Firmware rev " + LocoNetMessageInterpret.dotme(this.vrs) : "");
                    break;
                }
                returnString = Bundle.getMessage(locale, "SV1_READ_REPLY_INTERPRETED", Lnsv1MessageContents.toHexComposite(this.src_l, this.sub_adr), Lnsv1MessageContents.toHexStr(this.sv_num), Lnsv1MessageContents.toHexStr(this.d6), this.vrs > 0 ? " Firmware rev " + LocoNetMessageInterpret.dotme(this.vrs) : "");
                break;
            }
            default: {
                return Bundle.getMessage(locale, "SV1_UNDEFINED_MESSAGE", new Object[0]) + "\n";
            }
        }
        log.debug("interpreted: {}", (Object)returnString);
        return returnString + "\n";
    }

    public static String toHexStr(int value) {
        if (value > 9) {
            return value + " (" + String.format(HEX_FORMAT, value) + ")";
        }
        return String.valueOf(value);
    }

    public static String toHexComposite(int low, int high) {
        Object res = String.valueOf(low);
        if (high == 0) {
            if (low > 9) {
                res = (String)res + " (" + String.format(HEX_FORMAT, low) + ")";
            }
            return res;
        }
        res = (String)res + "/" + high;
        if (low > 9 || high > 9) {
            res = (String)res + " (";
            res = (String)res + (Serializable)(low > 9 ? String.format(HEX_FORMAT, low) : Integer.valueOf(low));
            res = (String)res + "/";
            res = (String)res + (Serializable)(high > 9 ? String.format(HEX_FORMAT, high) : Integer.valueOf(high));
            res = (String)res + ")";
        }
        return res;
    }

    public static boolean isSupportedSv1Command(int possibleCmd) {
        switch (possibleCmd) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean isSupportedSv1Command() {
        return Lnsv1MessageContents.isSupportedSv1Command(this.sv_cmd);
    }

    public boolean isSupportedSv1ReadOneReply() {
        return this.sv_cmd == 2 && this.src_l != 80 && this.vrs != 0;
    }

    public int getSingleReadReportData() {
        return this.d6;
    }

    public int getSrcL() {
        return this.src_l;
    }

    public int getDstL() {
        return this.dst_l;
    }

    public int getDstH() {
        return this.dst_h;
    }

    public int getDestAddr() {
        return -1;
    }

    public int getSubAddress() {
        return this.sub_adr;
    }

    public int getCmd() {
        return this.sv_cmd;
    }

    public int getSvNum() {
        if (this.sv_cmd == Sv1Command.SV1_READ.sv_cmd || this.sv_cmd == Sv1Command.SV1_WRITE.sv_cmd) {
            return this.sv_num;
        }
        return -1;
    }

    public int getSvValue() {
        if (this.sv_cmd == Sv1Command.SV1_READ.sv_cmd) {
            if (this.vrs > 0) {
                return this.d6;
            }
            return this.d4;
        }
        if (this.sv_cmd == Sv1Command.SV1_WRITE.sv_cmd) {
            if (this.vrs > 0) {
                return this.d8;
            }
            return this.d4;
        }
        return -1;
    }

    public int getVersionNum() {
        if (this.vrs > 0) {
            return this.vrs;
        }
        return -1;
    }

    public int getSv1D4() {
        return this.d4;
    }

    public int getSv1D6() {
        return this.d6;
    }

    public int getSv1D7() {
        return this.d7;
    }

    public int getSv1D8() {
        return this.d8;
    }

    public static LocoNetMessage createSv0Message(int source, int destination, int subAddress, int command, int svNum, int version, int newVal, int d6, int d7, int d8) throws IllegalArgumentException {
        if (!Lnsv1MessageContents.isSupportedSv1Command(command)) {
            throw new IllegalArgumentException("Command is not a supported SV1 command");
        }
        int[] contents = new int[]{command, svNum, version, newVal, subAddress, d6, d7, d8};
        log.debug("createSv1Message src={} dst={} subAddr={} data[]={}", new Object[]{source, destination, subAddress, contents});
        return LocoNetMessage.makePeerXfr(source, destination, contents, 0);
    }

    public static LocoNetMessage createSv1Message(int source, int destination, int subAddress, int command, int svNum, int version, int newVal, int d6, int d7, int d8) throws IllegalArgumentException {
        if (!Lnsv1MessageContents.isSupportedSv1Command(command)) {
            throw new IllegalArgumentException("Command is not a supported SV1 command");
        }
        int[] contents = new int[]{command, svNum, version, newVal, subAddress, d6, d7, d8};
        log.debug("createSv1Message src={} dst={} subAddr={} data[]={}", new Object[]{source, destination, subAddress, contents});
        return LocoNetMessage.makePeerXfr(source, destination, contents, 8);
    }

    public static LocoNetMessage createSv1ReadRequest(int dst, int subAddress, int svNum) {
        int dstExtr = dst | 0x100;
        log.debug("createSv1ReadRequest dst={} dstExtr={} subAddr={}", new Object[]{dst, dstExtr, subAddress});
        return Lnsv1MessageContents.createSv1Message(80, dstExtr, subAddress, Sv1Command.SV1_READ.sv_cmd, svNum, 0, 0, 0, 0, 0);
    }

    public static LocoNetMessage createSv1ReadReply(int src, int dst, int subAddress, int version, int svNum, int returnValue) {
        log.debug("createSv0ReadReply");
        int dstExtr = dst | 0x100;
        return Lnsv1MessageContents.createSv0Message(src, dstExtr, subAddress, Sv1Command.SV1_READ.sv_cmd, svNum, version, 0, returnValue, 0, 0);
    }

    public static LocoNetMessage createSv1WriteRequest(int dst, int subAddress, int svNum, int newValue) {
        log.debug("createSv1WriteRequest");
        int dstExtr = dst | 0x100;
        return Lnsv1MessageContents.createSv1Message(80, dstExtr, subAddress, Sv1Command.SV1_WRITE.sv_cmd, svNum, 0, newValue, 0, 0, 0);
    }

    public static LocoNetMessage createSv1WriteReply(int src, int dst, int subAddress, int version, int svNum, int returnValue) {
        log.debug("createSv0WriteReply");
        int dstExtr = dst | 0x100;
        return Lnsv1MessageContents.createSv0Message(src, dstExtr, subAddress, Sv1Command.SV1_WRITE.sv_cmd, svNum, version, 0, 0, 0, returnValue);
    }

    public static LocoNetMessage[] createBroadcastSetAddress(int address, int subAddress) {
        LocoNetMessage[] messages = new LocoNetMessage[2];
        messages[0] = Lnsv1MessageContents.createSv1WriteRequest(0, 0, 1, address & 0xFF);
        if (subAddress != 0) {
            messages[1] = Lnsv1MessageContents.createSv1WriteRequest(0, 0, 2, subAddress);
        }
        return messages;
    }

    public static LocoNetMessage createBroadcastProbeAll() {
        return Lnsv1MessageContents.createSv1ReadRequest(0, 0, 2);
    }

    public static enum Sv1Command {
        SV1_WRITE(1),
        SV1_READ(2);

        private final int sv_cmd;

        private Sv1Command(int sv_cmd) {
            this.sv_cmd = sv_cmd;
        }

        int getCmd() {
            return this.sv_cmd;
        }

        public static int getCmd(Sv1Command mt) {
            return mt.getCmd();
        }
    }
}

