/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locobuffer;

import java.util.Arrays;
import java.util.Vector;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LnPacketizerStrict;
import jmri.jmrix.loconet.LnPortController;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locobuffer.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoBufferAdapter
extends LnPortController {
    Vector<String> portNameVector = null;
    protected String[] validSpeeds = new String[]{Bundle.getMessage("Baud19200LB"), Bundle.getMessage("Baud57600LB")};
    protected int[] validSpeedValues = new int[]{19200, 57600};
    protected String[] validOption1 = new String[]{Bundle.getMessage("FlowOptionHwRecomm"), Bundle.getMessage("FlowOptionNo")};
    private static String[][] packetizers = new String[][]{{Bundle.getMessage("PacketizerTypelnPacketizer"), "lnPacketizer"}, {Bundle.getMessage("PacketizerTypelnPacketizerStrict"), "lnPacketizerStrict"}};
    private static final Logger log = LoggerFactory.getLogger(LocoBufferAdapter.class);

    public LocoBufferAdapter() {
        this(new LocoNetSystemConnectionMemo());
    }

    public LocoBufferAdapter(LocoNetSystemConnectionMemo adapterMemo) {
        super(adapterMemo);
        this.option1Name = "FlowControl";
        this.option2Name = "CommandStation";
        this.option3Name = "TurnoutHandle";
        this.option4Name = "PacketizerType";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("XconnectionUsesLabel", Bundle.getMessage("TypeSerial")), this.validOption1));
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.getCommandStationListWithStandaloneLN(), false));
        this.options.put(this.option3Name, new AbstractPortController.Option(Bundle.getMessage("TurnoutHandling"), new String[]{Bundle.getMessage("HandleNormal"), Bundle.getMessage("HandleSpread"), Bundle.getMessage("HandleOneOnly"), Bundle.getMessage("HandleBoth")}));
        this.options.put(this.option4Name, new AbstractPortController.Option(Bundle.getMessage("PacketizerTypeLabel"), this.packetizerOptions()));
        this.options.put("TranspondingPresent", new AbstractPortController.Option(Bundle.getMessage("TranspondingPresent"), new String[]{Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYes")}));
        this.options.put("InterrogateOnStart", new AbstractPortController.Option(Bundle.getMessage("InterrogateOnStart"), new String[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo")}));
        this.options.put("LoconetProtocolAutoDetect", new AbstractPortController.Option(Bundle.getMessage("LoconetProtocolAutoDetectLabel"), new String[]{Bundle.getMessage("ButtonNo"), Bundle.getMessage("LoconetProtocolAutoDetect")}));
    }

    public String[] getCommandStationListWithStandaloneLN() {
        String[] result = new String[this.commandStationNames.length + 1];
        for (int i = 0; i < result.length - 1; ++i) {
            result[i] = this.commandStationNames[i];
        }
        result[this.commandStationNames.length] = LnCommandStationType.COMMAND_STATION_STANDALONE.getName();
        return result;
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect LocoBuffer to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        this.reportOpen(portName);
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setLocalFlowControl();
        this.setComPortTimeouts(this.currentSerialPort, AbstractSerialPortController.Blocking.READ_SEMI_BLOCKING, 100);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    protected void reportOpen(String portName) {
        log.info("Connecting LocoBuffer via {} {}", (Object)portName, (Object)this.currentSerialPort);
    }

    protected void setLocalFlowControl() {
        AbstractSerialPortController.FlowControl flow = AbstractSerialPortController.FlowControl.RTSCTS;
        if (this.getOptionState(this.option1Name).equals(this.validOption1[1])) {
            flow = AbstractSerialPortController.FlowControl.NONE;
        }
        this.setFlowControl(this.currentSerialPort, flow);
    }

    @Override
    public boolean okToSend() {
        return this.currentSerialPort.getCTS();
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option2Name));
        this.setTurnoutHandling(this.getOptionState(this.option3Name));
        this.setTranspondingAvailable(this.getOptionState("TranspondingPresent"));
        this.setInterrogateOnStart(this.getOptionState("InterrogateOnStart"));
        this.setLoconetProtocolAutoDetect(this.getOptionState("LoconetProtocolAutoDetect"));
        LnPacketizer packets = this.getPacketizer(this.getOptionState(this.option4Name));
        packets.connectPort(this);
        this.getSystemConnectionMemo().setLnTrafficController(packets);
        this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable, this.mInterrogateAtStart, this.mLoconetProtocolAutoDetect);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    private String[] packetizerOptions() {
        String[] retval = new String[packetizers.length];
        for (int i = 0; i < packetizers.length; ++i) {
            retval[i] = packetizers[i][0];
        }
        return retval;
    }

    protected String getPacketizerOption(String s) {
        for (int i = 0; i < packetizers.length; ++i) {
            if (!packetizers[i][0].equals(s)) continue;
            return packetizers[i][1];
        }
        return "lnPacketizer";
    }

    protected LnPacketizer getPacketizer(String s) {
        LnPacketizer packets;
        String packetSelection;
        switch (packetSelection = this.getPacketizerOption(s)) {
            case "lnPacketizer": {
                packets = new LnPacketizer(this.getSystemConnectionMemo());
                break;
            }
            case "lnPacketizerStrict": {
                packets = new LnPacketizerStrict(this.getSystemConnectionMemo());
                break;
            }
            default: {
                packets = new LnPacketizer(this.getSystemConnectionMemo());
                log.warn("Using Normal do not understand option [{}]", (Object)packetSelection);
            }
        }
        return packets;
    }
}

