/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locoid;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locoid.Bundle;
import jmri.jmrix.loconet.swing.LnPanel;

public class LocoIdPanel
extends LnPanel
implements LocoNetListener {
    JButton readButton;
    JButton setButton;
    JTextArea value;
    JComboBox<String> idBox;
    String[] IDValues = new String[]{"-", "0", "1", "2", "3", "4", "5", "6", "7"};

    public LocoIdPanel() {
        this.idBox = new JComboBox<String>(this.IDValues);
    }

    @Override
    public void initComponents() {
        this.setButton = new JButton(Bundle.getMessage("ButtonSet"));
        this.readButton = new JButton(Bundle.getMessage("ButtonRead"));
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(this.readButton);
        p.add(this.setButton);
        this.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel(Bundle.getMessage("LabelValue")));
        p.add(this.idBox);
        this.add(p);
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocoIdPanel.this.setButtonActionPerformed();
            }
        });
        this.readButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocoIdPanel.this.readButtonActionPerformed();
            }
        });
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.locoid.LocoIdFrame";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("MenuItemSetID"));
    }

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.connect(memo.getLnTrafficController());
        this.readButtonActionPerformed();
    }

    public void setButtonActionPerformed() {
        String value = (String)this.idBox.getSelectedItem();
        if (!value.equals("-")) {
            this.memo.getLnTrafficController().sendLocoNetMessage(this.createSetPacket(value));
        }
    }

    public void readButtonActionPerformed() {
        this.idBox.setSelectedIndex(0);
        this.memo.getLnTrafficController().sendLocoNetMessage(this.createReadPacket());
    }

    @Override
    public void message(LocoNetMessage m) {
        if (m.getNumDataElements() != 6) {
            return;
        }
        int b1 = m.getOpCode();
        int b2 = m.getElement(1);
        int b3 = m.getElement(2);
        int b4 = m.getElement(3) & 7;
        if (b1 == 215 && (b2 == 18 || b2 == 20 || b2 == 23 || b2 == 31) && b3 == 0) {
            this.idBox.setSelectedIndex(b4 + 1);
        }
    }

    LocoNetMessage createReadPacket() {
        LocoNetMessage m = new LocoNetMessage(6);
        m.setElement(0, 223);
        m.setElement(1, 0);
        m.setElement(2, 0);
        m.setElement(3, 0);
        m.setElement(4, 0);
        return m;
    }

    LocoNetMessage createSetPacket(String s) {
        int data = Integer.parseInt(s);
        LocoNetMessage m = new LocoNetMessage(6);
        m.setElement(0, 223);
        m.setElement(1, 64);
        m.setElement(2, 31);
        m.setElement(3, data);
        m.setElement(4, 0);
        return m;
    }

    public void connect(LnTrafficController t) {
        t.addLocoNetListener(-1, this);
    }

    @Override
    public void dispose() {
        this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
        super.dispose();
    }
}

