/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locoio;

import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;

public class LocoIO {
    public static final int LOCOIO_SV_WRITE = 1;
    public static final int LOCOIO_SV_READ = 2;
    public static final int LOCOIO_BROADCAST_ADDRESS = 256;
    public static final int LOCOIO_PEER_CODE_7BIT_ADDRS = 0;
    public static final int LOCOIO_PEER_CODE_ANSI_TEXT = 0;
    public static final int LOCOIO_PEER_CODE_SV_VER1 = 8;
    public static final int LOCOIO_PEER_CODE_SV_VER2 = 9;

    public static int SENSOR_ADR(int a1, int a2) {
        return (a2 & 0xF) * 128 + (a1 & 0x7F) + 1;
    }

    public static LocoNetMessage readSV(int locoIOAddress, int locoIOSubAddress, int sv) {
        int[] contents = new int[]{2, sv, 0, 0, locoIOSubAddress, 0, 0, 0};
        int dstExtr = locoIOAddress | 0x100;
        return LocoNetMessage.makePeerXfr(4176, dstExtr, contents, 8);
    }

    public static LocoNetMessage writeSV(int locoIOAddress, int locoIOSubAddress, int sv, int data) {
        int[] contents = new int[]{1, sv, 0, data, locoIOSubAddress, 0, 0, 0};
        int dstExtr = locoIOAddress | 0x100;
        return LocoNetMessage.makePeerXfr(4176, dstExtr, contents, 8);
    }

    public static void programLocoIOAddress(int address, int subAddress, LnTrafficController ln) {
        LocoNetMessage msg = LocoIO.writeSV(256, 0, 1, address & 0xFF);
        ln.sendLocoNetMessage(msg);
        if (subAddress != 0) {
            msg = LocoIO.writeSV(256, 0, 2, subAddress);
            ln.sendLocoNetMessage(msg);
        }
    }

    public static void probeLocoIOs(LnTrafficController ln) {
        LocoNetMessage msg = LocoIO.readSV(256, 0, 2);
        ln.sendLocoNetMessage(msg);
    }
}

