/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locoio;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrix.loconet.LnConstants;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.locoio.Bundle;
import jmri.jmrix.loconet.locoio.LocoIO;
import jmri.jmrix.loconet.locoio.LocoIOMode;
import jmri.jmrix.loconet.locoio.LocoIOModeList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoIOData
extends PropertyChangeSupport
implements LocoNetListener,
PropertyChangeListener {
    private int sv0;
    private int unitAddress;
    private int unitSubAddress;
    private final LnTrafficController tc;
    private final int _numRows = 16;
    private static final int LocoBufferAddress = 336;
    private String locoBufferVersion = Bundle.getMessage("StateUnknown");
    private String locoIOVersion = Bundle.getMessage("StateUnknown");
    private String status = Bundle.getMessage("StateUnknown");
    private LocoIOMode[] lim = new LocoIOMode[16];
    private int[] addr = new int[16];
    private int[] sv = new int[16];
    private int[] v1 = new int[16];
    private int[] v2 = new int[16];
    private int[] readState = new int[16];
    private int[] writeState = new int[16];
    private boolean[] capture = new boolean[16];
    private String[] mode = new String[16];
    private LocoIOModeList validmodes;
    protected final int NONE = 0;
    protected final int READVALUE1 = 1;
    protected final int READINGVALUE1 = 2;
    protected final int READVALUE2 = 3;
    protected final int READINGVALUE2 = 4;
    protected final int READMODE = 5;
    protected final int READINGMODE = 6;
    protected final int READ = 1;
    protected final int WRITEVALUE1 = 11;
    protected final int WRITINGVALUE1 = 12;
    protected final int WRITEVALUE2 = 13;
    protected final int WRITINGVALUE2 = 14;
    protected final int WRITEMODE = 15;
    protected final int WRITINGMODE = 16;
    protected final int WRITE = 11;
    private int lastOpCv = -1;
    private boolean reading = false;
    private int currentPin = 0;
    private static final int TIMEOUT = 2000;
    protected Timer timer = null;
    private int timeoutcounter = 0;
    private static final Logger log = LoggerFactory.getLogger(LocoIOData.class);

    public LocoIOData(int unitAddr, int unitSubAddr, LnTrafficController tc) {
        this.unitAddress = unitAddr;
        this.unitSubAddress = unitSubAddr;
        this.validmodes = new LocoIOModeList();
        for (int i = 0; i < 16; ++i) {
            this.setMode(i, "<none>");
            this.lim[i] = null;
            this.setAddr(i, 0);
            this.setSV(i, 0);
            this.setV1(i, 0);
            this.setV2(i, 0);
            this.readState[i] = 0;
            this.writeState[i] = 0;
            this.capture[i] = false;
        }
        this.tc = tc;
        if (tc != null) {
            tc.addLocoNetListener(-1, this);
        } else {
            log.error("No LocoNet interface available");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        log.info("LocoIOData: {} := {} from {}", new Object[]{evt.getPropertyName(), evt.getNewValue(), evt.getSource()});
    }

    public synchronized void setUnitAddress(int unit, int unitSub) {
        this.setUnitAddress(unit);
        this.setUnitSubAddress(unitSub);
    }

    public synchronized void setUnitAddress(int unit) {
        this.firePropertyChange("UnitAddress", this.unitAddress, 0x100 | unit & 0x7F);
        this.unitAddress = 0x100 | unit & 0x7F;
    }

    public synchronized void setUnitSubAddress(int unitSub) {
        this.firePropertyChange("UnitSubAddress", this.unitSubAddress, unitSub & 0x7F);
        this.unitSubAddress = unitSub & 0x7F;
    }

    public synchronized int getUnitAddress() {
        return this.unitAddress & 0x7F;
    }

    public synchronized int getUnitSubAddress() {
        return this.unitSubAddress & 0x7F;
    }

    public void setUnitConfig(int portRefresh, int altCodePBs, int isServo, int blinkRate) {
        int newsv0 = portRefresh & 1 | (altCodePBs & 1) << 1 | (isServo & 1) << 3 | (blinkRate & 0xF) << 4;
        this.firePropertyChange("UnitConfig", this.sv0, newsv0);
        this.sv0 = newsv0;
    }

    public int getUnitConfig() {
        return this.sv0 & 0xFF;
    }

    public void setLBVersion(String version) {
        this.locoBufferVersion = version;
        this.firePropertyChange("LBVersionChange", "", this.locoBufferVersion);
    }

    public String getLBVersion() {
        return this.locoBufferVersion;
    }

    public void setLIOVersion(String version) {
        this.locoIOVersion = version;
        this.firePropertyChange("LIOVersionChange", "", this.locoIOVersion);
    }

    public String getLIOVersion() {
        return this.locoBufferVersion;
    }

    public void setStatus(String msg) {
        this.status = msg;
        this.firePropertyChange("StatusChange", "", this.status);
    }

    public String getStatus() {
        return this.status;
    }

    public void setSV(int channel, int value) {
        this.sv[channel] = value & 0xFF;
        this.firePropertyChange("PortChange", -1, channel);
    }

    public int getSV(int channel) {
        return this.sv[channel] & 0xFF;
    }

    public void setV1(int channel, LocoIOMode l, int address) {
        this.setV1(channel, this.validmodes.addressToValue1(l, this.getAddr(channel)));
    }

    public void setV1(int channel, int value) {
        this.v1[channel] = value & 0xFF;
        this.firePropertyChange("PortChange", -1, channel);
    }

    public int getV1(int channel) {
        return this.v1[channel] & 0xFF;
    }

    public void setV2(int channel, LocoIOMode l, int address) {
        this.setV2(channel, this.validmodes.addressToValue2(l, this.getAddr(channel)));
    }

    public void setV2(int channel, int value) {
        this.v2[channel] = value & 0xFF;
        this.firePropertyChange("PortChange", -1, channel);
    }

    public int getV2(int channel) {
        return this.v2[channel] & 0xFF;
    }

    public void setAddr(int channel, int value) {
        this.addr[channel] = value & 0x7FF;
        this.firePropertyChange("PortChange", -1, channel);
    }

    public int getAddr(int channel) {
        return this.addr[channel] & 0x7FF;
    }

    public void setMode(int channel, String m) {
        this.mode[channel] = m;
        this.firePropertyChange("PortChange", -1, channel);
    }

    public String getMode(int channel) {
        return this.mode[channel];
    }

    public void setLIM(int channel, String s) {
        if (this.validmodes != null) {
            this.setLIM(channel, this.validmodes.getLocoIOModeFor(s));
        }
    }

    public void setLIM(int channel) {
        if (this.validmodes != null) {
            this.setLIM(channel, this.validmodes.getLocoIOModeFor(this.getSV(channel), this.getV1(channel), this.getV2(channel)));
        }
    }

    public void setLIM(int channel, LocoIOMode m) {
        this.lim[channel] = m;
        this.firePropertyChange("PortChange", -1, channel);
    }

    public LocoIOMode getLIM(int channel) {
        return this.lim[channel];
    }

    public void readValues(int channel) {
        this.readState[channel] = 1;
        this.issueNextOperation();
    }

    public void captureValues(int channel) {
        this.capture[channel] = true;
    }

    public void writeValues(int channel) {
        this.writeState[channel] = 11;
        this.issueNextOperation();
    }

    public void readAll() {
        for (int row = 0; row < 16; ++row) {
            this.readState[row] = 1;
        }
        this.issueNextOperation();
    }

    public void writeAll() {
        for (int row = 0; row < 16; ++row) {
            this.writeState[row] = 11;
        }
        this.issueNextOperation();
    }

    public LocoIOModeList getLocoIOModeList() {
        return this.validmodes;
    }

    protected int highPart(int value) {
        return value / 256;
    }

    protected int lowPart(int value) {
        return value - 256 * this.highPart(value);
    }

    private String dotme(int val) {
        int x = val;
        StringBuilder ret = new StringBuilder();
        if (val == 0) {
            return "0";
        }
        while (x != 0) {
            int dit = x % 10;
            ret.insert(0, dit);
            if ((x /= 10) == 0) continue;
            ret.insert(0, ".");
        }
        return ret.toString();
    }

    @Override
    public synchronized void message(LocoNetMessage m) {
        int opCode = m.getOpCode();
        switch (opCode) {
            case 229: {
                int src = m.getElement(2);
                int dst = m.getElement(3) + m.getElement(4) * 256;
                int[] packet = m.getPeerXfrData();
                if (src == this.lowPart(336)) {
                    String lbv = packet[2] != 0 ? this.dotme(packet[2]) : "1.0";
                    this.setLBVersion(lbv);
                }
                if (dst == 336 && src == this.lowPart(this.unitAddress) && packet[4] == this.unitSubAddress) {
                    this.stopTimer();
                    this.replyReceived();
                    String fw = packet[2] != 0 ? this.dotme(packet[2]) : "1.3.2";
                    this.setLIOVersion(fw);
                    if ((packet[0] == 2 || this.reading) && this.lastOpCv >= 0 && this.lastOpCv <= 50) {
                        int data = packet[2] != 0 ? packet[5] : packet[7];
                        int channel = this.lastOpCv / 3 - 1;
                        if (channel < 0) {
                            log.warn("... channel is less than zero!!!");
                            channel = 0;
                        }
                        int type = this.lastOpCv - (channel * 3 + 3);
                        log.debug("... updating port {} SV{}({}) = 0x{}", new Object[]{channel, type, type == 1 ? "value1" : (type == 2 ? "value2" : (type == 0 ? "mode" : "unknown")), Integer.toHexString(data)});
                        if (type == 2) {
                            this.setV2(channel, data);
                            this.setMode(channel, "<none>");
                        } else if (type == 1) {
                            this.setV1(channel, data);
                            this.setMode(channel, "<none>");
                        } else if (type == 0) {
                            this.setSV(channel, data);
                            LocoIOMode lim = this.validmodes.getLocoIOModeFor(this.getSV(channel), this.getV1(channel), this.getV2(channel));
                            if (lim == null) {
                                this.setMode(channel, "<none>");
                                this.setAddr(channel, 0);
                                log.debug("Could not find mode!");
                            } else {
                                this.setMode(channel, lim.getFullMode());
                                this.setAddr(channel, this.validmodes.valuesToAddress(lim.getOpCode(), this.getSV(channel), this.getV1(channel), this.getV2(channel)));
                            }
                            log.debug("... decoded address (cv={} v1={} v2={}) is {}(0x{})", new Object[]{Integer.toHexString(this.getSV(channel)), Integer.toHexString(this.getV1(channel)), Integer.toHexString(this.getV2(channel)), this.getAddr(channel), Integer.toHexString(this.getAddr(channel))});
                        } else {
                            log.warn("OPC_PEER_XFR: Type ({}) is not {0,1,2} for channel {}", (Object)type, (Object)channel);
                        }
                    }
                    this.issueNextOperation();
                    return;
                }
                return;
            }
            case 178: {
                log.debug("{} received", (Object)LnConstants.OPC_NAME(opCode));
                for (int i = 0; i < 16; ++i) {
                    if (!this.capture[i]) continue;
                    log.debug("row set for capture: {}", (Object)i);
                    int val1 = m.getElement(1);
                    int val2 = m.getElement(2);
                    this.setAddr(i, ((val2 & 0xF) << 5) * 256 + ((val1 & 0x7F) << 1) | ((val2 & 0x20) == 32 ? 1 : 0));
                    this.capture[i] = false;
                }
                return;
            }
            case 176: {
                log.debug("{} received", (Object)LnConstants.OPC_NAME(opCode));
                for (int i = 0; i < 16; ++i) {
                    if (!this.capture[i]) continue;
                    log.debug("row set for capture: {}", (Object)i);
                    int val1 = m.getElement(1);
                    int val2 = m.getElement(2);
                    int addr = LocoIO.SENSOR_ADR(val1, val2);
                    this.setAddr(i, addr);
                    this.capture[i] = false;
                }
                return;
            }
        }
        log.debug("{} received (ignored)", (Object)LnConstants.OPC_NAME(opCode));
    }

    protected synchronized void replyReceived() {
        this.timeoutcounter = 0;
        switch (this.readState[this.currentPin]) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                this.readState[this.currentPin] = 3;
                return;
            }
            case 3: 
            case 4: {
                this.readState[this.currentPin] = 5;
                return;
            }
            case 5: 
            case 6: {
                this.readState[this.currentPin] = 0;
                return;
            }
            default: {
                log.error("Pin {} unexpected read state, can't advance {}", (Object)this.currentPin, (Object)this.readState[this.currentPin]);
                this.readState[this.currentPin] = 0;
                return;
            }
        }
        switch (this.writeState[this.currentPin]) {
            case 0: {
                return;
            }
            case 11: 
            case 12: {
                this.writeState[this.currentPin] = 13;
                return;
            }
            case 13: 
            case 14: {
                this.writeState[this.currentPin] = 15;
                return;
            }
            case 15: 
            case 16: {
                this.writeState[this.currentPin] = 0;
                return;
            }
        }
        log.error("Pin {} unexpected write state, can't advance {}", (Object)this.currentPin, (Object)this.writeState[this.currentPin]);
        this.writeState[this.currentPin] = 0;
    }

    protected synchronized void issueNextOperation() {
        int i;
        this.stopTimer();
        for (i = 0; i < 16; ++i) {
            this.currentPin = i;
            if (this.readState[i] == 0) continue;
            log.debug("iNO: readState[{}] = {}", (Object)i, (Object)this.readState[i]);
            switch (this.readState[i]) {
                case 1: 
                case 2: {
                    this.readState[i] = 2;
                    this.lastOpCv = i * 3 + 4;
                    this.setStatus(Bundle.getMessage("StatusReading", this.lastOpCv, i + 1, 1));
                    this.sendReadCommand(this.unitAddress, this.unitSubAddress, this.lastOpCv);
                    return;
                }
                case 3: 
                case 4: {
                    this.readState[i] = 4;
                    this.lastOpCv = i * 3 + 5;
                    this.setStatus(Bundle.getMessage("StatusReading", this.lastOpCv, i + 1, 2));
                    this.sendReadCommand(this.unitAddress, this.unitSubAddress, this.lastOpCv);
                    return;
                }
                case 5: 
                case 6: {
                    this.readState[i] = 6;
                    this.lastOpCv = i * 3 + 3;
                    this.setStatus(Bundle.getMessage("StatusReadMode", this.lastOpCv, i + 1));
                    this.sendReadCommand(this.unitAddress, this.unitSubAddress, this.lastOpCv);
                    return;
                }
            }
            log.error("found an unexpected state: {} on port {}", (Object)this.readState[1], (Object)(i + 1));
            return;
        }
        for (i = 0; i < 16; ++i) {
            this.currentPin = i;
            if (this.writeState[i] == 0) continue;
            log.debug("iNO: writeState[{}] = {}", (Object)i, (Object)this.readState[i]);
            switch (this.writeState[i]) {
                case 11: 
                case 12: {
                    this.writeState[i] = 12;
                    this.lastOpCv = i * 3 + 4;
                    this.setStatus(Bundle.getMessage("StatusWriting", this.lastOpCv, i + 1, 1));
                    this.sendWriteCommand(this.unitAddress, this.unitSubAddress, this.lastOpCv, this.getV1(i));
                    return;
                }
                case 13: 
                case 14: {
                    this.writeState[i] = 14;
                    this.lastOpCv = i * 3 + 5;
                    this.setStatus(Bundle.getMessage("StatusWriting", this.lastOpCv, i + 1, 2));
                    this.sendWriteCommand(this.unitAddress, this.unitSubAddress, this.lastOpCv, this.getV2(i));
                    return;
                }
                case 15: 
                case 16: {
                    this.writeState[i] = 16;
                    this.lastOpCv = i * 3 + 3;
                    this.setStatus(Bundle.getMessage("StatusWriteMode", this.lastOpCv, i + 1));
                    this.sendWriteCommand(this.unitAddress, this.unitSubAddress, this.lastOpCv, this.getSV(i));
                    return;
                }
            }
            log.error("found an unexpected state: {} on port {}", (Object)this.writeState[1], (Object)(i + 1));
            return;
        }
        log.debug("No operation needed");
        this.setStatus(Bundle.getMessage("StatusOK"));
        this.lastOpCv = -1;
        this.currentPin = 0;
    }

    protected synchronized void timeout() {
        log.debug("timeout!");
        this.setStatus(Bundle.getMessage("Timeout"));
        if (this.timeoutcounter++ == 5) {
            for (int i = 0; i < 16; ++i) {
                this.readState[i] = 0;
                this.writeState[i] = 0;
            }
            this.setStatus(Bundle.getMessage("StateAborted"));
            this.setLIOVersion(Bundle.getMessage("StateUnknown"));
            this.timeoutcounter = 0;
            this.stopTimer();
        } else {
            this.issueNextOperation();
        }
    }

    protected void startTimer() {
        this.restartTimer(2000);
    }

    protected void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    protected void restartTimer(int delay) {
        if (this.timer == null) {
            this.timer = new Timer(delay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LocoIOData.this.timeout();
                }
            });
        }
        this.timer.stop();
        this.timer.setInitialDelay(delay);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    void sendReadCommand(int locoIOAddress, int locoIOSubAddress, int cv) {
        this.reading = true;
        log.debug("sendReadCommand(to {}/{} SV {}", new Object[]{Integer.toHexString(locoIOAddress), Integer.toHexString(locoIOSubAddress), cv});
        this.tc.sendLocoNetMessage(LocoIO.readSV(locoIOAddress, locoIOSubAddress, cv));
        this.startTimer();
    }

    void sendWriteCommand(int locoIOAddress, int locoIOSubAddress, int cv, int data) {
        this.reading = false;
        this.tc.sendLocoNetMessage(LocoIO.writeSV(locoIOAddress, locoIOSubAddress, cv, data));
        this.startTimer();
    }

    public void dispose() {
        log.debug("dispose");
        this.stopTimer();
        this.tc.removeLocoNetListener(-1, this);
        this.addr = null;
        this.mode = null;
        this.sv = null;
        this.v1 = null;
        this.v2 = null;
        this.lim = null;
    }
}

