/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locomon;

import jmri.InstanceManager;
import jmri.TurnoutManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locomon.Bundle;
import jmri.jmrix.loconet.swing.LnPanelInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoMonPane
extends AbstractMonPane
implements LocoNetListener,
LnPanelInterface {
    private String systemConnectionPrefix = InstanceManager.getDefault(TurnoutManager.class).getSystemPrefix();
    LocoNetSystemConnectionMemo memo;
    private static final Logger log = LoggerFactory.getLogger(LocoMonPane.class);

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.locomon.LocoMonFrame";
    }

    @Override
    public String getTitle() {
        Object uName = "";
        if (this.memo != null) {
            uName = this.memo.getUserName();
            uName = !"LocoNet".equals(uName) ? (String)uName + ": " : "";
        }
        return (String)uName + Bundle.getMessage("MenuItemLocoNetMonitor");
    }

    @Override
    public void dispose() {
        if (this.memo != null && this.memo.getLnTrafficController() != null) {
            this.memo.getLnTrafficController().removeLocoNetListener(-1, this);
        }
        super.dispose();
    }

    @Override
    public void init() {
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof LocoNetSystemConnectionMemo) {
            this.initComponents((LocoNetSystemConnectionMemo)context);
        }
    }

    @Override
    public synchronized void initComponents(LocoNetSystemConnectionMemo memo) {
        this.memo = memo;
        if (memo.getLnTrafficController() == null) {
            log.error("No traffic controller is available");
            return;
        }
        memo.getLnTrafficController().addLocoNetListener(-1, this);
        this.systemConnectionPrefix = memo.getSystemPrefix();
    }

    @Override
    public synchronized void message(LocoNetMessage l) {
        String raw = l.toString();
        log.debug("message received");
        String formatted = l.toMonitorString(this.systemConnectionPrefix);
        this.nextLine(formatted, raw);
        if (log.isTraceEnabled()) {
            log.trace("message: {}", (Object)formatted.substring(0, formatted.length() - 1));
        }
    }

    @Override
    protected String getOpCodeForFilter(String raw) {
        if (raw != null && raw.length() >= 2) {
            return raw.substring(0, 2);
        }
        return null;
    }
}

