/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.loconetovertcp;

import java.io.EOFException;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import jmri.jmrix.loconet.LnNetworkPortController;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetMessageException;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnOverTcpPacketizer
extends LnPacketizer {
    static final String RECEIVE_PREFIX = "RECEIVE";
    static final String SEND_PREFIX = "SEND";
    public LnNetworkPortController networkController = null;
    private static final Logger log = LoggerFactory.getLogger(LnOverTcpPacketizer.class);

    public LnOverTcpPacketizer(LocoNetSystemConnectionMemo m) {
        super(m);
        this.xmtHandler = new XmtHandler();
        this.rcvHandler = new RcvHandler(this);
    }

    @Override
    public boolean isXmtBusy() {
        return this.networkController != null;
    }

    public void connectPort(LnNetworkPortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.networkController != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.networkController = p;
    }

    public void disconnectPort(LnNetworkPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.networkController != p) {
            log.warn("disconnectPort: disconnect called from non-connected LnPortnetworkController");
        }
        this.networkController = null;
    }

    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        log.debug("check for input");
                        byte[] msg = (byte[])LnOverTcpPacketizer.this.xmtList.take();
                        try {
                            if (LnOverTcpPacketizer.this.ostream != null) {
                                log.debug("start write to stream");
                                StringBuffer packet = new StringBuffer(msg.length * 3 + LnOverTcpPacketizer.SEND_PREFIX.length() + 2);
                                packet.append(LnOverTcpPacketizer.SEND_PREFIX);
                                for (int Index = 0; Index < msg.length; ++Index) {
                                    packet.append(' ');
                                    String hexString = Integer.toHexString(msg[Index] & 0xFF).toUpperCase();
                                    if (hexString.length() == 1) {
                                        packet.append('0');
                                    }
                                    packet.append(hexString);
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug("Write to LbServer: {}", (Object)packet.toString());
                                }
                                packet.append("\r\n");
                                LnOverTcpPacketizer.this.ostream.write(packet.toString().getBytes());
                                LnOverTcpPacketizer.this.ostream.flush();
                                log.debug("end write to stream");
                                continue block4;
                            }
                            log.warn("sendLocoNetMessage: no connection established");
                            continue block4;
                        }
                        catch (IOException e) {
                            log.warn("sendLocoNetMessage: IOException: {}", (Object)e.toString());
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    class RcvHandler
    implements Runnable {
        LnOverTcpPacketizer trafficController;

        public RcvHandler(LnOverTcpPacketizer lt) {
            this.trafficController = lt;
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    String rxLine = LnOverTcpPacketizer.this.istream.readLine();
                    if (Thread.interrupted()) {
                        return;
                    }
                    if (rxLine == null) {
                        log.warn("run: input stream returned null, exiting loop");
                        return;
                    }
                    log.debug("Received: {}", (Object)rxLine);
                    StringTokenizer st = new StringTokenizer(rxLine);
                    if (!st.nextToken().equals(LnOverTcpPacketizer.RECEIVE_PREFIX)) continue;
                    LocoNetMessage msg = null;
                    int opCode = Integer.parseInt(st.nextToken(), 16);
                    int byte2 = Integer.parseInt(st.nextToken(), 16);
                    switch ((opCode & 0x60) >> 5) {
                        default: {
                            msg = new LocoNetMessage(2);
                            break;
                        }
                        case 1: {
                            msg = new LocoNetMessage(4);
                            break;
                        }
                        case 2: {
                            msg = new LocoNetMessage(6);
                            break;
                        }
                        case 3: {
                            if (byte2 < 2) {
                                log.error("LocoNet message length invalid: {} opcode: {}", (Object)byte2, (Object)Integer.toHexString(opCode));
                            }
                            msg = new LocoNetMessage(byte2);
                        }
                    }
                    msg.setOpCode(opCode);
                    msg.setElement(1, byte2);
                    int len = msg.getNumDataElements();
                    for (int i = 2; i < len; ++i) {
                        int b = Integer.parseInt(st.nextToken(), 16);
                        if ((b & 0x80) != 0) {
                            log.warn("LocoNet message with opCode: {} ended early. Expected length: {} seen length: {} unexpected byte: {}", new Object[]{Integer.toHexString(opCode), len, i, Integer.toHexString(b)});
                            throw new LocoNetMessageException();
                        }
                        msg.setElement(i, b);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("queue message for notification");
                    }
                    final LocoNetMessage thisMsg = msg;
                    final LnOverTcpPacketizer thisTc = this.trafficController;
                    Runnable r = new Runnable(){
                        LocoNetMessage msgForLater;
                        LnPacketizer myTc;
                        {
                            this.msgForLater = thisMsg;
                            this.myTc = thisTc;
                        }

                        @Override
                        public void run() {
                            this.myTc.notify(this.msgForLater);
                        }
                    };
                    SwingUtilities.invokeLater(r);
                }
                catch (LocoNetMessageException e) {
                    log.warn("run: unexpected LocoNetMessageException: ", (Throwable)e);
                }
                catch (EOFException e) {
                    log.debug("EOFException, is LocoNet serial I/O using timeouts?");
                }
                catch (IOException e) {
                    log.debug("IOException, should only happen with HexFile: ", (Throwable)e);
                    log.info("End of file");
                    return;
                }
                catch (RuntimeException e) {
                    log.warn("run: unexpected Exception: ", (Throwable)e);
                }
            }
        }
    }
}

