/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.loconetovertcp;

import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.jmrix.loconet.loconetovertcp.Bundle;
import jmri.jmrix.loconet.loconetovertcp.LnTcpServer;
import jmri.jmrix.loconet.loconetovertcp.LnTcpServerListener;
import jmri.util.JmriJFrame;

public class LnTcpServerFrame
extends JmriJFrame {
    private final JLabel portNumberLabel = new JLabel(Bundle.getMessage("PortLabel", 1234));
    private final JLabel statusLabel = new JLabel(Bundle.getMessage("StatusLabel", Bundle.getMessage("Stopped"), 0));
    private final JButton startButton = new JButton(Bundle.getMessage("StartServer"));
    private final JButton stopButton = new JButton(Bundle.getMessage("StopServer"));
    private final LnTcpServer server;
    private final LnTcpServerListener listener;

    public LnTcpServerFrame(LnTcpServer server) {
        super(Bundle.getMessage("ServerAction"));
        this.server = server;
        super.getContentPane().setLayout(new BoxLayout(super.getContentPane(), 1));
        this.portNumberLabel.setAlignmentX(0.5f);
        super.getContentPane().add(this.portNumberLabel);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.startButton);
        panel.add(this.stopButton);
        panel.setAlignmentX(0.5f);
        super.getContentPane().add(panel);
        this.statusLabel.setAlignmentX(0.5f);
        super.getContentPane().add(this.statusLabel);
        this.startButton.addActionListener(a -> server.enable());
        this.stopButton.addActionListener(a -> server.disable());
        this.listener = new LnTcpServerListener(){

            @Override
            public void notifyServerStateChanged(LnTcpServer s) {
                if (s.equals(LnTcpServerFrame.this.server)) {
                    SwingUtilities.invokeLater(() -> LnTcpServerFrame.this.updateServerStatus(s));
                }
            }

            @Override
            public void notifyClientStateChanged(LnTcpServer s) {
                if (s.equals(LnTcpServerFrame.this.server)) {
                    SwingUtilities.invokeLater(() -> LnTcpServerFrame.this.updateClientStatus(s));
                }
            }
        };
        server.addStateListener(this.listener);
        this.updateServerStatus(server);
        super.pack();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.server.removeStateListener(this.listener);
        this.dispose();
        super.windowClosing(e);
        InstanceManager.deregister(this, LnTcpServerFrame.class);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public static synchronized LnTcpServerFrame getDefault() {
        return InstanceManager.getOptionalDefault(LnTcpServerFrame.class).orElseGet(() -> InstanceManager.setDefault(LnTcpServerFrame.class, new LnTcpServerFrame(LnTcpServer.getDefault())));
    }

    private void updateServerStatus(LnTcpServer s) {
        this.portNumberLabel.setText(Bundle.getMessage("PortLabel", s.getPort()));
        this.startButton.setEnabled(!s.isEnabled());
        this.stopButton.setEnabled(s.isEnabled());
        this.updateClientStatus(s);
    }

    private void updateClientStatus(LnTcpServer s) {
        this.statusLabel.setText(Bundle.getMessage("StatusLabel", s.isEnabled() ? Bundle.getMessage("Running") : Bundle.getMessage("Stopped"), s.getClientCount()));
    }
}

