/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locostats;

import java.util.Objects;
import java.util.Vector;
import javax.annotation.Nonnull;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locostats.LocoBufferIIStatus;
import jmri.jmrix.loconet.locostats.LocoNetInterfaceStatsListener;
import jmri.jmrix.loconet.locostats.PR2Status;
import jmri.jmrix.loconet.locostats.PR3MS100ModeStatus;
import jmri.jmrix.loconet.locostats.RawStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoStatsFunc
implements LocoNetListener {
    private LocoNetSystemConnectionMemo memo;
    private boolean updatePending;
    private boolean need2ndUpdate;
    private Object ifaceStatus;
    protected Vector<LocoNetInterfaceStatsListener> listeners = new Vector();
    private static final Logger log = LoggerFactory.getLogger(LocoStatsFunc.class);

    public LocoStatsFunc(LocoNetSystemConnectionMemo memo) {
        this.memo = memo;
        this.updatePending = false;
        this.need2ndUpdate = false;
        this.ifaceStatus = null;
        if (memo != null) {
            this.memo.getLnTrafficController().addLocoNetListener(0, this);
        }
    }

    public void sendLocoNetInterfaceStatusQueryMessage() {
        this.updatePending = true;
        this.need2ndUpdate = false;
        log.debug("Sent a LocoNet interface status query");
        this.sendQuery();
    }

    private void sendQuery() {
        if (this.memo == null) {
            return;
        }
        LocoNetMessage l = new LocoNetMessage(new int[]{129, 127});
        this.memo.getLnTrafficController().sendLocoNetMessage(l);
    }

    @Override
    public void message(LocoNetMessage msg) {
        if (msg.getOpCode() == 229 && msg.getElement(1) == 16 && msg.getElement(2) == 80 && msg.getElement(3) == 80 && msg.getElement(4) == 1 && (msg.getElement(5) & 0xF0) == 0 && (msg.getElement(10) & 0xF0) == 0 && this.updatePending) {
            int[] data = msg.getPeerXfrData();
            this.ifaceStatus = new LocoBufferIIStatus(data[0] * 256 + data[4], (data[5] << 16) + (data[6] << 8) + data[7], (data[1] << 16) + (data[2] << 8) + data[3]);
            this.updatePending = false;
            this.updateListeners();
            log.debug("Got a LocoNet interface status reply: LocoBufferII");
        } else if (msg.getOpCode() == 229 && msg.getElement(1) == 16 && msg.getElement(2) == 34 && msg.getElement(3) == 34 && msg.getElement(4) == 1 && (msg.getElement(5) & 0x70) == 0 && (msg.getElement(10) & 0x70) == 0 && this.updatePending) {
            if ((msg.getElement(8) & 0x20) == 0) {
                int[] data = msg.getPeerXfrData();
                this.ifaceStatus = new PR2Status(data[1] * 256 + data[0], data[2], data[3], data[4], data[5]);
                log.debug("Got a LocoNet interface status reply: PR2 mode");
                if (this.updatePending) {
                    if (!this.need2ndUpdate) {
                        this.need2ndUpdate = true;
                        this.sendQuery();
                    } else {
                        this.need2ndUpdate = false;
                        this.updatePending = false;
                    }
                }
            } else {
                int[] data = msg.getPeerXfrData();
                this.ifaceStatus = new PR3MS100ModeStatus(data[1] * 256 + data[0], data[5] * 256 + data[4], data[2]);
                log.debug("Got a LocoNet interface status reply: PR3 MS100 mode");
                if (this.updatePending) {
                    if (!this.need2ndUpdate) {
                        this.need2ndUpdate = true;
                        this.sendQuery();
                    } else {
                        this.need2ndUpdate = false;
                        this.updatePending = false;
                    }
                }
            }
            this.updateListeners();
        } else if (msg.getOpCode() == 229 && msg.getElement(1) == 16 && this.updatePending) {
            int[] data = msg.getPeerXfrData();
            this.ifaceStatus = new RawStatus(data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7]);
            this.updatePending = false;
            this.updateListeners();
            log.debug("Got a LocoNet interface status reply: Raw mode");
        }
    }

    private void updateListeners() {
        this.listeners.stream().forEach(l -> l.notifyChangedInterfaceStatus(this.ifaceStatus));
    }

    public Object getInterfaceStatus() {
        return this.ifaceStatus;
    }

    public void dispose() {
        this.listeners.removeAllElements();
        this.listeners = null;
    }

    public synchronized void addLocoNetInterfaceStatsListener(@Nonnull LocoNetInterfaceStatsListener l) {
        Objects.requireNonNull(l);
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public synchronized void removeLocoNetInterfaceStatsListener(@Nonnull LocoNetInterfaceStatsListener l) {
        Objects.requireNonNull(l);
        if (this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }
}

