/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.logixng;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.logixng.Bundle;
import jmri.jmrix.loconet.logixng.CategoryLocoNet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetSpeedZero
extends AbstractDigitalAction {
    private static final int NUM_LOCO_SLOTS_TO_CHECK = 119;
    private LocoNetSystemConnectionMemo _memo;
    private static final Logger log = LoggerFactory.getLogger(SetSpeedZero.class);

    public SetSpeedZero(String sys, String user, LocoNetSystemConnectionMemo memo) {
        super(sys, user);
        this._memo = memo;
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        SetSpeedZero copy = new SetSpeedZero(sysName, userName, this._memo);
        copy.setComment(this.getComment());
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return CategoryLocoNet.LOCONET;
    }

    public void setMemo(LocoNetSystemConnectionMemo memo) {
        this.assertListenersAreNotRegistered(log, "setMemo");
        this._memo = memo;
    }

    public LocoNetSystemConnectionMemo getMemo() {
        return this._memo;
    }

    private void setSlotSpeedZero(LocoNetSlot slot) {
        boolean upLinkConsist;
        boolean inUse = slot.slotStatus() == 48 || slot.slotStatus() == 16;
        boolean bl = upLinkConsist = slot.consistStatus() == 72 || slot.consistStatus() == 64;
        if (inUse && !upLinkConsist && slot.speed() != 0) {
            LocoNetMessage msg = new LocoNetMessage(4);
            msg.setOpCode(160);
            msg.setElement(1, slot.getSlot());
            msg.setElement(2, 0);
            this._memo.getLnTrafficController().sendLocoNetMessage(msg);
        }
    }

    @Override
    public void execute() {
        for (int i = 1; i <= 119; ++i) {
            this.setSlotSpeedZero(this._memo.getSlotManager().slot(i));
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "SetSpeedZero_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "SetSpeedZero_Long", this._memo != null ? this._memo.getUserName() : Bundle.getMessage("MemoNotSet"));
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._listenersAreRegistered = false;
    }

    @Override
    public void disposeMe() {
    }
}

