/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.logixng.configurexml;

import java.util.HashSet;
import java.util.List;
import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.logixng.ExpressionSlotUsage;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExpressionSlotUsageXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        ExpressionSlotUsage p = (ExpressionSlotUsage)o;
        Element element = new Element("ExpressionLoconetSlotUsage");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        if (p.getMemo() != null) {
            element.addContent((Content)new Element("systemConnection").addContent(p.getMemo().getSystemPrefix()));
        }
        element.addContent((Content)new Element("advanced").addContent(p.getAdvanced() ? "yes" : "no"));
        element.addContent((Content)new Element("has_hasNot").addContent(p.get_Has_HasNot().name()));
        element.addContent((Content)new Element("simpleState").addContent(p.getSimpleState().name()));
        Element advancedStatesElement = new Element("advancedStates");
        for (ExpressionSlotUsage.AdvancedState state : p.getAdvancedStates()) {
            advancedStatesElement.addContent((Content)new Element("state").addContent(state.name()));
        }
        element.addContent((Content)advancedStatesElement);
        element.addContent((Content)new Element("compare").addContent(p.getCompare().name()));
        element.addContent((Content)new Element("number").addContent(Integer.toString(p.getNumber())));
        element.addContent((Content)new Element("percentPieces").addContent(p.getPercentPieces().name()));
        element.addContent((Content)new Element("totalSlots").addContent(Integer.toString(p.getTotalSlots())));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        Element totalNumber;
        Element percentPieces;
        Element number;
        Element simpleState;
        Element advanced;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ExpressionSlotUsage h = new ExpressionSlotUsage(sys, uname, null);
        this.loadCommon(h, shared);
        Element systemConnection = shared.getChild("systemConnection");
        if (systemConnection != null) {
            String systemConnectionName = systemConnection.getTextTrim();
            List<LocoNetSystemConnectionMemo> systemConnections = InstanceManager.getList(LocoNetSystemConnectionMemo.class);
            for (LocoNetSystemConnectionMemo memo : systemConnections) {
                if (!memo.getSystemPrefix().equals(systemConnectionName)) continue;
                h.setMemo(memo);
                break;
            }
        }
        if ((advanced = shared.getChild("advanced")) != null) {
            h.setAdvanced("yes".equals(advanced.getTextTrim()));
        } else {
            h.setAdvanced(false);
        }
        Element has_hasNot = shared.getChild("has_hasNot");
        if (has_hasNot != null) {
            h.set_Has_HasNot(ExpressionSlotUsage.Has_HasNot.valueOf(has_hasNot.getTextTrim()));
        }
        if ((simpleState = shared.getChild("simpleState")) != null) {
            h.setSimpleState(ExpressionSlotUsage.SimpleState.valueOf(simpleState.getTextTrim()));
        }
        HashSet<ExpressionSlotUsage.AdvancedState> stateSet = new HashSet<ExpressionSlotUsage.AdvancedState>();
        Element advancedStates = shared.getChild("advancedStates");
        for (Element state : advancedStates.getChildren()) {
            stateSet.add(ExpressionSlotUsage.AdvancedState.valueOf(state.getTextTrim()));
        }
        h.setAdvancedStates(stateSet);
        Element compare = shared.getChild("compare");
        if (compare != null) {
            h.setCompare(ExpressionSlotUsage.Compare.valueOf(compare.getTextTrim()));
        }
        if ((number = shared.getChild("number")) != null) {
            h.setNumber(Integer.parseInt(number.getText()));
        }
        if ((percentPieces = shared.getChild("percentPieces")) != null) {
            h.setPercentPieces(ExpressionSlotUsage.PercentPieces.valueOf(percentPieces.getTextTrim()));
        }
        if ((totalNumber = shared.getChild("totalSlots")) != null) {
            h.setTotalSlots(Integer.parseInt(totalNumber.getText()));
        }
        InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(h);
        return true;
    }
}

