/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.logixng.swing;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.ThrottleListener;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotListener;
import jmri.jmrix.loconet.SlotManager;
import jmri.jmrix.loconet.logixng.swing.Bundle;
import jmri.util.ThreadingUtil;

public class GetNumSlotsDialog
extends JDialog
implements ThrottleListener,
SlotListener {
    private static final int NUM_LOCO_TO_REQUEST = 119;
    private final LocoNetSystemConnectionMemo _memo;
    private JTextField _numEnginesField;
    private JTextField _requestLocoField;
    private JLabel _status;
    private int _maxNumLocos = 0;
    private boolean _freeSlots = false;
    private final JTextField _textField;
    private volatile boolean _abort = false;

    public GetNumSlotsDialog(LocoNetSystemConnectionMemo memo, JTextField textField) {
        super((Frame)null, true);
        this._memo = memo;
        this._textField = textField;
    }

    public void initComponents() {
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GetNumSlotsDialog.this._abort = true;
                GetNumSlotsDialog.this.releaseThrottles();
            }
        });
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel numEnginesPanel = new JPanel();
        numEnginesPanel.add(new JLabel("Current number of engines: "));
        this._numEnginesField = new JTextField("0");
        this._numEnginesField.setColumns(5);
        this._numEnginesField.setEnabled(false);
        numEnginesPanel.add(this._numEnginesField);
        JPanel requestLocoPanel = new JPanel();
        this._requestLocoField = new JTextField("0");
        this._requestLocoField.setColumns(5);
        this._requestLocoField.setEnabled(false);
        JButton cancelRequestLocoField = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelRequestLocoField.addActionListener(e -> {});
        requestLocoPanel.add(new JLabel("Request loco: "));
        requestLocoPanel.add(this._requestLocoField);
        requestLocoPanel.add(cancelRequestLocoField);
        this.getContentPane().add(numEnginesPanel);
        this.getContentPane().add(requestLocoPanel);
        this._status = new JLabel("aaa");
        this.getContentPane().add(this._status);
        JButton buttonOK = new JButton(Bundle.getMessage("ButtonOK"));
        buttonOK.addActionListener(e -> {
            this._abort = true;
            this.releaseThrottles();
            this.dispose();
        });
        this.getContentPane().add(buttonOK);
        this.pack();
        this.setLocationRelativeTo(null);
        this._memo.getSlotManager().addSlotListener(this);
        ThreadingUtil.runOnGUIEventually(() -> {
            this._freeSlots = true;
            this._memo.getSlotManager().update();
        });
        ThreadingUtil.runOnGUIDelayed(() -> {
            this._freeSlots = false;
            this.requestThrottle(1);
        }, 10000);
        this.setVisible(true);
    }

    private void requestThrottle(int address) {
        ThreadingUtil.runOnGUI(() -> this._requestLocoField.setText(Integer.toString(address)));
        boolean result = this._memo.getThrottleManager().requestThrottle(address, this);
        if (!result && address < 119) {
            this.requestThrottle(address + 1);
        }
    }

    private void updateNumLocos() {
        int numLocos = 0;
        SlotManager slotManager = this._memo.getSlotManager();
        for (int i = 1; i <= 119; ++i) {
            LocoNetSlot slot = slotManager.slot(i);
            if ((slot.slotStatus() & 0x30) == 0) continue;
            ++numLocos;
        }
        if (numLocos > this._maxNumLocos) {
            this._maxNumLocos = numLocos;
            ThreadingUtil.runOnGUI(() -> {
                this._numEnginesField.setText(Integer.toString(this._maxNumLocos));
                this._textField.setText(Integer.toString(this._maxNumLocos));
            });
        }
    }

    private void releaseThrottles() {
        for (int i = 1; i < 120; ++i) {
            LocoNetSlot slot = this._memo.getSlotManager().slot(i);
            if ((slot.slotStatus() & 0x30) == 0) continue;
            this._memo.getLnTrafficController().sendLocoNetMessage(slot.writeStatus(0));
        }
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        this.updateNumLocos();
        ThreadingUtil.runOnGUI(() -> this._status.setText("Throttle was added"));
        if (!this._abort && t.getLocoAddress().getNumber() < 119) {
            ThreadingUtil.runOnGUIDelayed(() -> this.requestThrottle(t.getLocoAddress().getNumber() + 1), 200);
        }
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        ThreadingUtil.runOnGUI(() -> this._status.setText(reason));
        if (!this._abort && address.getNumber() < 119) {
            ThreadingUtil.runOnGUIDelayed(() -> this.requestThrottle(address.getNumber() + 1), 200);
        }
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
    }

    @Override
    public void notifyChangedSlot(LocoNetSlot s) {
        if (this._freeSlots && s.getSlot() != 0 && s.slotStatus() != 0 && s.slotStatus() != 16) {
            this._memo.getLnTrafficController().sendLocoNetMessage(s.releaseSlot());
        }
    }
}

