/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.logixng.swing;

import java.awt.Color;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.logixng.SetSpeedZero;
import jmri.jmrix.loconet.logixng.swing.Bundle;

public class SetSpeedZeroSwing
extends AbstractDigitalActionSwing {
    private JComboBox<LocoNetConnection> _locoNetConnection;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        if (object != null && !(object instanceof SetSpeedZero)) {
            throw new IllegalArgumentException("object must be an SetSpeedZero but is a: " + object.getClass().getName());
        }
        SetSpeedZero action = (SetSpeedZero)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(new JLabel(Bundle.getMessage("SetSpeedZeroInfo1")));
        this.panel.add(new JLabel(Bundle.getMessage("SetSpeedZeroInfo2")));
        this.panel.add(new JLabel(Bundle.getMessage("SetSpeedZeroInfo3")));
        this.panel.add(new JLabel(Bundle.getMessage("SetSpeedZeroInfo4")));
        this.panel.add(new JLabel(Bundle.getMessage("SetSpeedZeroInfo5")));
        JPanel queryPanel = new JPanel();
        queryPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel locoNetPanel = new JPanel();
        locoNetPanel.add(new JLabel(Bundle.getMessage("LocoNetConnection")));
        this._locoNetConnection = new JComboBox();
        List<LocoNetSystemConnectionMemo> systemConnections = InstanceManager.getList(LocoNetSystemConnectionMemo.class);
        for (LocoNetSystemConnectionMemo connection : systemConnections) {
            LocoNetConnection c = new LocoNetConnection(connection);
            this._locoNetConnection.addItem(c);
            if (action == null || action.getMemo() != connection) continue;
            this._locoNetConnection.setSelectedItem(c);
        }
        locoNetPanel.add(this._locoNetConnection);
        this.panel.add(locoNetPanel);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        LocoNetSystemConnectionMemo memo = this._locoNetConnection.getItemAt((int)this._locoNetConnection.getSelectedIndex())._memo;
        SetSpeedZero action = new SetSpeedZero(systemName, userName, memo);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof SetSpeedZero)) {
            throw new IllegalArgumentException("object must be an ExpressionTurnout but is a: " + object.getClass().getName());
        }
        SetSpeedZero action = (SetSpeedZero)object;
        action.setMemo(this._locoNetConnection.getItemAt((int)this._locoNetConnection.getSelectedIndex())._memo);
    }

    @Override
    public String toString() {
        return Bundle.getMessage("SetSpeedZero_Short");
    }

    @Override
    public void dispose() {
    }

    private static class LocoNetConnection {
        private LocoNetSystemConnectionMemo _memo;

        public LocoNetConnection(LocoNetSystemConnectionMemo memo) {
            this._memo = memo;
        }

        public String toString() {
            return this._memo.getUserName();
        }
    }
}

